/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.services.Services;
import tr.swing.StyledString;
import tr.swing.StyledStringRenderer;
import tr.util.LazyNotifier;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.actions.RAProjectsTreeTopComponent;
import tr.view.actions.RASingleActionsTopComponent;
import tr.view.actions.prefs.ActionsPrefs;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.ItemCountShower;
import tr.view.actions.screens.ReviewActionsFilters;
import tr.view.actions.screens.ReviewActionsTableFormat;
import tr.view.actions.screens.ReviewActionsTopComponent;
import tr.view.actions.screens.columns.ActionsColumn;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.actions.screens.filters.FilterDone;
import tr.view.collect.AddThoughtsAction;
import tr.view.projects.ProjectsTreeTopComponent;
import tr.view.projects.actions.SingleActionsTopComponent;

public class ReviewActionsPanel
extends JPanel
implements ListSelectionListener,
Observer {
    private JTable table;
    private JScrollPane tableScrollPane;
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    public static final byte SORT_ASCENDING = 1;
    public static final byte SORT_DESCENDING = 2;
    private static SingleActionsTopComponent tcSingleActions;
    private static ProjectsTreeTopComponent tcProjectsTree;
    private final ReviewActionsTopComponent tcReviewActions;
    private final ActionsScreen screen;
    private final Data data;
    private final ItemCountShower itemCountShower;
    private final ReviewActionsFilters filters;
    private final LazyNotifier selectionNotifier;
    public JXTable actionsTable;
    private ReviewActionsTableFormat actionsTableFormat;
    private EventTableModel<Action> actionsTableModel;
    private Collection<Action> actionsList;
    private EventList<Action> actionsEventList;
    private FilterList<Action> actionsFilterList;
    public SortedList<Action> actionsSortedList;
    private EventSelectionModel<Action> selectionModel;
    private TableComparatorChooser<Action> tableSorter;

    public ReviewActionsPanel(ActionsScreen screen, ItemCountShower itemCountShower, ReviewActionsFilters filters, ReviewActionsTopComponent tcReviewActions) {
        this.screen = screen;
        this.itemCountShower = itemCountShower;
        this.filters = filters;
        this.tcReviewActions = tcReviewActions;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        tcSingleActions = RASingleActionsTopComponent.findInstance();
        tcProjectsTree = RAProjectsTreeTopComponent.findInstance();
        this.initComponents();
        this.selectionNotifier = new LazyNotifier(ActionsPrefs.getViewDelay()){

            public void changed() {
                ReviewActionsPanel.this.view();
            }
        };
    }

    public void takeFocus() {
        if (this.table != null) {
            this.table.requestFocusInWindow();
        }
    }

    private void initTable() {
        if (this.data == null) {
            return;
        }
        this.actionsList = Services.instance.getAllActions();
        this.actionsEventList = new BasicEventList();
        this.actionsEventList.addAll(this.actionsList);
        this.actionsFilterList = new FilterList(this.actionsEventList, this.filters.getMatcherEditor());
        this.actionsFilterList.addListEventListener(new ListEventListener(){

            public void listChanged(ListEvent e) {
                ReviewActionsPanel.this.itemCountShower.showItemCount(e.getSourceList().size());
            }
        });
        this.itemCountShower.showItemCount(this.actionsFilterList.size());
        Services.instance.addActionsObserver((Observer)this);
        this.actionsSortedList = new SortedList(this.actionsFilterList);
        this.actionsTableFormat = new ReviewActionsTableFormat(this.screen);
        this.actionsTableModel = new EventTableModel(this.actionsSortedList, (TableFormat)this.actionsTableFormat);
        this.actionsTable = new JXTable(this.actionsTableModel);
        this.actionsTable.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
        this.actionsTable.getSelectionMapper().setEnabled(false);
        this.actionsTable.setSortable(false);
        this.actionsTable.setSelectionMode(0);
        this.actionsTable.setColumnControlVisible(false);
        this.actionsTable.setColumnSelectionAllowed(false);
        this.actionsTable.setCellSelectionEnabled(false);
        this.actionsTable.setRowSelectionAllowed(true);
        this.actionsTable.setShowGrid(false);
        this.actionsTable.setShowHorizontalLines(false);
        this.actionsTable.setShowVerticalLines(false);
        this.selectionModel = new EventSelectionModel(this.actionsSortedList);
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
        this.selectionModel.setSelectionMode(0);
        this.selectionModel.setEnabled(true);
        this.actionsTable.setSelectionModel(this.selectionModel);
        for (int c = 0; c < this.actionsTableFormat.getColumnCount(); ++c) {
            TableColumn tc = this.actionsTable.getColumnModel().getColumn(c);
            tc.setIdentifier(this.actionsTableFormat.getID(c));
            tc.setResizable(this.actionsTableFormat.isResizable(c));
            tc.setMinWidth(this.actionsTableFormat.getMinWidth(c));
            tc.setMaxWidth(this.actionsTableFormat.getMaxWidth(c));
            tc.setPreferredWidth(this.actionsTableFormat.getWidth(c));
        }
        for (TableColumn tc : this.actionsTable.getColumns(true)) {
            Byte id = (Byte)tc.getIdentifier();
            ActionsColumn column = (ActionsColumn)this.screen.getColumns().get(tc.getModelIndex());
            this.actionsTable.getColumnExt((Object)id).setVisible(column.isVisible());
        }
        this.actionsTable.setDefaultRenderer(StyledString.class, (TableCellRenderer)new StyledStringRenderer());
        this.tableSorter = new TableComparatorChooser((JTable)this.actionsTable, this.actionsSortedList, true);
        this.actionsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getModifiers() != 0) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ReviewActionsPanel.this.edit();
                } else if (e.getKeyCode() == 117) {
                    e.consume();
                    ReviewActionsPanel.this.addThoughts();
                }
            }
        });
        this.actionsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReviewActionsPanel.this.edit();
                }
            }
        });
        this.orderColumns();
        this.sortColumns();
    }

    private void addThoughts() {
        AddThoughtsAction action = (AddThoughtsAction)SystemAction.get(AddThoughtsAction.class);
        if (action != null) {
            action.performAction();
        }
    }

    private FilterDone getDoneFilter() {
        MatcherEditor matcherEditor = this.filters.getMatcherEditor();
        if (matcherEditor instanceof CompositeMatcherEditor) {
            CompositeMatcherEditor cme = (CompositeMatcherEditor)matcherEditor;
            for (Object filter : cme.getMatcherEditors().toArray()) {
                if (!(filter instanceof FilterDone)) continue;
                return (FilterDone)filter;
            }
        }
        return null;
    }

    private boolean isShowDone() {
        FilterDone doneFilter = this.getDoneFilter();
        return doneFilter == null ? true : doneFilter.isShowDone();
    }

    public JTable getTable() {
        this.initTable();
        return this.actionsTable;
    }

    public TableFormat getTableFormat() {
        return this.actionsTableFormat;
    }

    private Action getSelectedAction() {
        EventList selected = this.selectionModel.getSelected();
        if (selected.size() > 0) {
            return (Action)selected.get(0);
        }
        return null;
    }

    private void edit() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Action action = ReviewActionsPanel.this.getSelectedAction();
                if (action == null) {
                    return;
                }
                if (action.isSingleAction()) {
                    if (tcSingleActions != null) {
                        tcSingleActions.setShowDone(ReviewActionsPanel.this.isShowDone());
                        tcSingleActions.edit(action);
                    }
                } else if (tcProjectsTree != null) {
                    tcProjectsTree.setShowDone(ReviewActionsPanel.this.isShowDone());
                    tcProjectsTree.edit(action);
                }
            }
        });
    }

    public void view() {
        Action action = this.getSelectedAction();
        if (action == null) {
            return;
        }
        if (action.isSingleAction()) {
            if (tcSingleActions != null) {
                tcSingleActions.setShowDone(this.isShowDone());
                tcSingleActions.select(action);
            }
        } else if (tcProjectsTree != null) {
            tcProjectsTree.setShowDone(this.isShowDone());
            tcProjectsTree.select(action);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ReviewActionsPanel.this.table.requestFocusInWindow();
            }
        });
    }

    private void orderColumns() {
        assert (this.actionsTable != null);
        byte[] order = this.screen.getColumnOrder();
        assert (order != null);
        TableColumnModel tcm = this.actionsTable.getColumnModel();
        for (int i = 0; i < order.length; ++i) {
            Byte id = new Byte(order[i]);
            int p = tcm.getColumnIndex(id);
            if (p <= -1) continue;
            tcm.moveColumn(p, i);
        }
    }

    private void sortColumns() {
        byte[] columns = this.screen.getSortColumns();
        byte[] status = this.screen.getSortStates();
        if (columns == null || status == null || columns.length != status.length) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            try {
                this.tableSorter.appendComparator((int)columns[i], 0, status[i] == 2);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void save() {
        for (TableColumn tc : this.actionsTable.getColumns(true)) {
            Byte id = (Byte)tc.getIdentifier();
            ActionsColumn column = (ActionsColumn)this.screen.getColumns().get(tc.getModelIndex());
            column.setVisible(this.actionsTable.getColumnExt((Object)id).isVisible());
        }
        TableColumnModel tcm = this.table.getColumnModel();
        byte[] order = new byte[tcm.getColumnCount()];
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc;
            tc = tcm.getColumn(i);
            order[i] = (byte)tc.getModelIndex();
            ((ActionsColumn)this.screen.getColumns().get(tc.getModelIndex())).setWidth(tc.getWidth());
        }
        this.screen.setColumnOrder(order);
        List sortColumnsList = this.tableSorter.getSortingColumns();
        byte[] sortColumns = new byte[sortColumnsList.size()];
        byte[] sortStatus = new byte[sortColumnsList.size()];
        for (int i = 0; i < sortColumnsList.size(); ++i) {
            sortColumns[i] = ActionsColumn.COLUMN_INDICES[(Integer)sortColumnsList.get(i)];
            sortStatus[i] = this.tableSorter.isColumnReverse(((Integer)sortColumnsList.get(i)).intValue()) ? 2 : 1;
        }
        this.screen.setSortColumns(sortColumns);
        this.screen.setSortStatus(sortStatus);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        TopComponent tc = (TopComponent)this.itemCountShower;
        if (!tc.isShowing()) {
            return;
        }
        this.selectionNotifier.fire();
    }

    private void clearSelection() {
        this.selectionModel.removeListSelectionListener((ListSelectionListener)this);
        this.selectionModel.clearSelection();
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
    }

    public void update(final Observable observable, final Object argument) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (observable instanceof Action) {
                    Action selectedAction = ReviewActionsPanel.this.getSelectedAction();
                    if (selectedAction != null) {
                        Action observedAction = (Action)observable;
                        if (selectedAction.getID() != observedAction.getID()) {
                            ReviewActionsPanel.this.clearSelection();
                        }
                    }
                    ReviewActionsPanel.this.refresh();
                    return;
                }
                if (observable instanceof Project) {
                    Project obsProject = (Project)observable;
                    ReviewActionsPanel.this.clearSelection();
                    if (argument == null) {
                        ReviewActionsPanel.this.actionsTable.validate();
                        ReviewActionsPanel.this.actionsTable.repaint();
                        ReviewActionsPanel.this.refresh();
                    } else if (argument instanceof Action) {
                        Action action = (Action)argument;
                        Lock lock = ReviewActionsPanel.this.actionsEventList.getReadWriteLock().writeLock();
                        lock.lock();
                        if (obsProject.contains((Item)action)) {
                            ReviewActionsPanel.this.actionsEventList.add((Object)action);
                        } else {
                            ReviewActionsPanel.this.actionsEventList.remove((Object)action);
                        }
                        lock.unlock();
                    } else if (argument instanceof Project) {
                        Project argProject = (Project)argument;
                        List actions = Services.instance.getActionDecendants(argProject);
                        if (actions == null || actions.isEmpty()) {
                            return;
                        }
                        Lock lock = ReviewActionsPanel.this.actionsEventList.getReadWriteLock().writeLock();
                        lock.lock();
                        if (obsProject.contains((Item)argProject)) {
                            ReviewActionsPanel.this.actionsEventList.addAll((Collection)actions);
                        } else {
                            ReviewActionsPanel.this.actionsEventList.removeAll((Collection)actions);
                        }
                        lock.unlock();
                    }
                }
            }
        });
    }

    public void refresh() {
        final ReviewActionsPanel lsl = this;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ReviewActionsPanel.this.selectionModel.removeListSelectionListener(lsl);
                ReviewActionsPanel.this.actionsSortedList.setComparator(ReviewActionsPanel.this.actionsSortedList.getComparator());
                for (ActionsFilter filter : ReviewActionsPanel.this.screen.getFilters()) {
                    filter.getFilterCombo().fireValueChange();
                }
                ReviewActionsPanel.this.selectionModel.addListSelectionListener(lsl);
            }
        });
    }

    public void refreshColumns() {
        if (this.actionsTable == null) {
            return;
        }
        for (TableColumn tc : this.actionsTable.getColumns(true)) {
            Byte id = (Byte)tc.getIdentifier();
            ActionsColumn column = (ActionsColumn)this.screen.getColumns().get(tc.getModelIndex());
            this.actionsTable.getColumnExt((Object)id).setVisible(column.isVisible());
        }
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.table = this.getTable();
        this.setLayout(new BorderLayout());
        this.tableScrollPane.setViewportView(this.table);
        this.add((Component)this.tableScrollPane, "Center");
    }
}

