/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.view.actions.screens.ActionsScreen;
import tr.view.actions.screens.filters.ActionsFilter;
import tr.view.actions.screens.filters.FilterCriterion;
import tr.view.actions.screens.filters.FilterDate;
import tr.view.actions.screens.filters.FilterFactory;
import tr.view.filters.FilterCombo;

public class FiltersDialog
extends JDialog {
    private static final Dimension P_SIZE = new Dimension(520, 620);
    private static final Dimension H_SIZE = new Dimension(500, 21);
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel panel;
    private JScrollPane scrollPane;
    private final ActionsScreen screen;
    private JPanel filtersPanel;
    private boolean ok;

    public FiltersDialog(ActionsScreen screen) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.screen = screen;
        this.setMaximumSize(P_SIZE);
        this.initComponents();
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.panel = this.getPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getText("FiltersDialog.title"));
        this.setModal(true);
        this.bottomPanel.setLayout(new FlowLayout(2, 10, 5));
        this.bottomPanel.setFocusable(false);
        this.cancelButton.setText(NbBundle.getMessage(FiltersDialog.class, (String)"FiltersDialog.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.cancelActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.cancelButton);
        this.okButton.setText(this.getText("FiltersDialog.ok"));
        this.okButton.setFocusCycleRoot(true);
        this.okButton.setSelected(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersDialog.this.okActionPerformed(evt);
            }
        });
        this.bottomPanel.add(this.okButton);
        this.getContentPane().add((Component)this.bottomPanel, "Last");
        this.scrollPane.setViewportView(this.panel);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getPanel() {
        this.filtersPanel = new JPanel();
        this.filtersPanel.setBackground(Color.white);
        this.filtersPanel.setLayout(new BoxLayout(this.filtersPanel, 3));
        this.filtersPanel.setMaximumSize(P_SIZE);
        this.filtersPanel.setMinimumSize(P_SIZE);
        this.filtersPanel.setPreferredSize(P_SIZE);
        JPanel headPanel = new JPanel();
        headPanel.setLayout(new BoxLayout(headPanel, 2));
        headPanel.setMaximumSize(H_SIZE);
        headPanel.setMinimumSize(H_SIZE);
        headPanel.setPreferredSize(H_SIZE);
        headPanel.add(new HeadLabel("FiltersDialog.column.name", 140));
        headPanel.add(new HeadLabel("FiltersDialog.column.used", 40));
        headPanel.add(new HeadLabel("FiltersDialog.column.visible", 40));
        headPanel.add(new HeadLabel("FiltersDialog.column.values", 140));
        headPanel.add(new HeadLabel("FiltersDialog.column.nulls", 120));
        this.filtersPanel.add(headPanel);
        HashMap<Byte, ActionsFilter> actionsFilterMap = new HashMap<Byte, ActionsFilter>();
        for (ActionsFilter af : this.screen.getFilters()) {
            actionsFilterMap.put(af.getIndex(), af);
        }
        for (int i = 0; i < FilterFactory.INDICES.length; ++i) {
            byte index = FilterFactory.INDICES[i];
            if (!actionsFilterMap.containsKey(index)) {
                ActionsFilter af = FilterFactory.instance.createFilter(index);
                actionsFilterMap.put(af.getIndex(), af);
                this.screen.getFilters().add(af);
            }
            this.filtersPanel.add(new FilterPanel((ActionsFilter)((Object)actionsFilterMap.get(index))));
        }
        return this.filtersPanel;
    }

    public int showDialog() {
        this.ok = false;
        this.setVisible(true);
        return this.ok ? 0 : 2;
    }

    private void okActionPerformed(ActionEvent evt) {
        for (Component component : this.filtersPanel.getComponents()) {
            if (!(component instanceof FilterPanel)) continue;
            FilterPanel filterPanel = (FilterPanel)component;
            filterPanel.commit();
        }
        this.ok = true;
        this.setVisible(false);
        this.dispose();
    }

    private String getText(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private static class FilterPanel
    extends JPanel {
        private static final Dimension MAX_SIZE = new Dimension(500, 27);
        private static final Dimension MIN_SIZE = new Dimension(500, 27);
        private static final Dimension PRF_SIZE = new Dimension(500, 27);
        private static final Dimension SIZE_LBL = new Dimension(140, 27);
        private static final Dimension SIZE_USE = new Dimension(40, 27);
        private static final Dimension SIZE_SEE = new Dimension(40, 27);
        private static final Dimension SIZE_VAL = new Dimension(140, 27);
        private static final Dimension SIZE_F01 = new Dimension(10, 27);
        private static final Dimension SIZE_NUL = new Dimension(90, 27);
        private static final Dimension SIZE_F02 = new Dimension(100, 27);
        private final ActionsFilter filter;
        private JLabel label;
        private JCheckBox useCheckBox;
        private JCheckBox seeCheckBox;
        private JCheckBox nullsCheckBox;
        private FilterCombo valFilterCombo;
        private ActionsFilter tempFilter;

        FilterPanel(ActionsFilter filter) {
            this.filter = filter;
            this.init();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 2));
            this.setMaximumSize(MAX_SIZE);
            this.setMinimumSize(MIN_SIZE);
            this.setPreferredSize(PRF_SIZE);
            this.setBackground(Color.white);
            this.label = new JLabel(this.filter.getLabel());
            this.label.setBackground(Color.white);
            this.label.setPreferredSize(SIZE_LBL);
            this.label.setMaximumSize(SIZE_LBL);
            this.label.setMinimumSize(SIZE_LBL);
            this.add(this.label);
            this.useCheckBox = new JCheckBox();
            this.useCheckBox.setBackground(Color.white);
            this.useCheckBox.setSelected(this.filter.isUsed());
            this.useCheckBox.setPreferredSize(SIZE_USE);
            this.useCheckBox.setMaximumSize(SIZE_USE);
            this.useCheckBox.setMinimumSize(SIZE_USE);
            this.useCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FilterPanel.this.enableDisableComponents(FilterPanel.this.useCheckBox.isSelected());
                }
            });
            this.add(this.useCheckBox);
            this.seeCheckBox = new JCheckBox();
            this.seeCheckBox.setBackground(Color.white);
            this.seeCheckBox.setSelected(this.filter.isShown());
            this.seeCheckBox.setPreferredSize(SIZE_SEE);
            this.seeCheckBox.setMaximumSize(SIZE_SEE);
            this.seeCheckBox.setMinimumSize(SIZE_SEE);
            this.add(this.seeCheckBox);
            this.tempFilter = FilterFactory.instance.createFilter(this.filter.getIndex());
            this.tempFilter.setSerialValues(this.filter.getSerialValues());
            this.valFilterCombo = this.tempFilter.getFilterCombo();
            this.valFilterCombo.getJComboBox().setPreferredSize(SIZE_VAL);
            this.valFilterCombo.getJComboBox().setMaximumSize(SIZE_VAL);
            this.valFilterCombo.getJComboBox().setMinimumSize(SIZE_VAL);
            this.add(this.valFilterCombo.getJComboBox());
            if (this.filter instanceof FilterDate) {
                JLabel filler1 = new JLabel();
                filler1.setBackground(Color.white);
                filler1.setPreferredSize(SIZE_F01);
                filler1.setMaximumSize(SIZE_F01);
                filler1.setMinimumSize(SIZE_F01);
                this.add(filler1);
                FilterDate dateFilter = (FilterDate)this.filter;
                this.nullsCheckBox = new JCheckBox();
                this.nullsCheckBox.setBackground(Color.white);
                this.nullsCheckBox.setSelected(dateFilter.isExcludeNulls());
                this.nullsCheckBox.setPreferredSize(SIZE_NUL);
                this.nullsCheckBox.setMaximumSize(SIZE_NUL);
                this.nullsCheckBox.setMinimumSize(SIZE_NUL);
                this.add(this.nullsCheckBox);
            } else if (this.filter instanceof FilterCriterion) {
                FilterCriterion criterionFilter = (FilterCriterion)this.filter;
                JLabel filler1 = new JLabel();
                filler1.setBackground(Color.white);
                filler1.setPreferredSize(SIZE_F01);
                filler1.setMaximumSize(SIZE_F01);
                filler1.setMinimumSize(SIZE_F01);
                this.add(filler1);
                this.nullsCheckBox = new JCheckBox();
                this.nullsCheckBox.setBackground(Color.white);
                this.nullsCheckBox.setSelected(criterionFilter.isExcludeNulls());
                this.nullsCheckBox.setPreferredSize(SIZE_NUL);
                this.nullsCheckBox.setMaximumSize(SIZE_NUL);
                this.nullsCheckBox.setMinimumSize(SIZE_NUL);
                this.add(this.nullsCheckBox);
            } else {
                JLabel filler2 = new JLabel();
                filler2.setBackground(Color.white);
                filler2.setPreferredSize(SIZE_F02);
                filler2.setMaximumSize(SIZE_F02);
                filler2.setMinimumSize(SIZE_F02);
                this.add(filler2);
            }
            this.enableDisableComponents(this.useCheckBox.isSelected());
        }

        private void enableDisableComponents(boolean used) {
            if (!used) {
                this.seeCheckBox.setSelected(false);
                this.valFilterCombo.getJComboBox().setSelectedItem(null);
                if (this.nullsCheckBox != null) {
                    this.nullsCheckBox.setSelected(false);
                }
            }
            this.seeCheckBox.setEnabled(used);
            this.valFilterCombo.getJComboBox().setEnabled(used);
            if (this.nullsCheckBox != null) {
                this.nullsCheckBox.setEnabled(used);
            }
        }

        public void commit() {
            this.filter.setUsed(this.useCheckBox.isSelected());
            this.filter.setShown(this.seeCheckBox.isSelected());
            this.filter.setSerialValues(this.tempFilter.getSerialValues());
            if (this.filter instanceof FilterDate) {
                ((FilterDate)this.filter).setExcludeNulls(this.nullsCheckBox.isSelected());
            } else if (this.filter instanceof FilterCriterion) {
                ((FilterCriterion)this.filter).setExcludeNulls(this.nullsCheckBox.isSelected());
            }
            this.filter.getFilterCombo().fireValueChange();
        }
    }

    private static class HeadLabel
    extends JLabel {
        public HeadLabel(String key, int width) {
            this.setText(" " + NbBundle.getMessage(FiltersDialog.class, (String)key));
            this.setFont(this.getFont().deriveFont(1));
            this.setMaximumSize(new Dimension(width, 21));
            this.setMinimumSize(new Dimension(width, 21));
            this.setPreferredSize(new Dimension(width, 21));
        }
    }
}

