/*
 * Decompiled with CFR 0.152.
 */
package tr.appl.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.appl.prefs.ApplicationOptionsPanelController;
import tr.appl.prefs.ApplicationPrefs;

final class ApplicationPanel
extends JPanel {
    private final ApplicationOptionsPanelController controller;
    private static final String[] periods = new String[]{ApplicationPanel.loc("CTL_Update_every_startup"), ApplicationPanel.loc("CTL_Update_every_day"), ApplicationPanel.loc("CTL_Update_every_week"), ApplicationPanel.loc("CTL_Update_every_fortnight"), ApplicationPanel.loc("CTL_Update_every_month"), ApplicationPanel.loc("CTL_Update_never")};
    private JComboBox checkPeriodComboBox;
    private JLabel checkPeriodLabel;

    private static String loc(String key) {
        return NbBundle.getMessage(ApplicationPanel.class, (String)key);
    }

    ApplicationPanel(ApplicationOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    void load() {
        this.checkPeriodComboBox.setModel(new DefaultComboBoxModel<String>(periods));
        this.checkPeriodComboBox.setMaximumRowCount(periods.length);
        this.checkPeriodComboBox.setSelectedIndex(ApplicationPrefs.getVersionCheckPeriod());
    }

    void store() {
        ApplicationPrefs.setVersionCheckPeriod(this.checkPeriodComboBox.getSelectedIndex());
    }

    boolean valid() {
        return true;
    }

    private void initComponents() {
        this.checkPeriodLabel = new JLabel();
        this.checkPeriodComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.checkPeriodLabel, (String)NbBundle.getMessage(ApplicationPanel.class, (String)"prefs.version.label"));
        this.checkPeriodLabel.setMaximumSize(new Dimension(270, 23));
        this.checkPeriodLabel.setMinimumSize(new Dimension(270, 23));
        this.checkPeriodLabel.setPreferredSize(new Dimension(270, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.checkPeriodLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.checkPeriodComboBox, 0, 221, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.checkPeriodLabel, -2, -1, -2).add((Component)this.checkPeriodComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

