/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.action.Action;
import tr.swing.TextArea;
import tr.swing.document.LazyDocumentListener;

public class PanelSuccess
extends JPanel {
    private JScrollPane jScrollPane;
    private TextArea successText;
    private Action action;
    private DocumentListener docListenerSuccess;
    private boolean updating;

    public PanelSuccess() {
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private void addListeners() {
        this.docListenerSuccess = new LazyDocumentListener(){

            public void update() {
                PanelSuccess.this.changedSuccess();
            }
        };
        this.successText.getDocument().addDocumentListener(this.docListenerSuccess);
    }

    private void removeListeners() {
        this.successText.getDocument().removeDocumentListener(this.docListenerSuccess);
        this.docListenerSuccess = null;
    }

    private void changedSuccess() {
        if (this.updating || this.action == null) {
            return;
        }
        this.action.setSuccess(this.successText.getText());
    }

    public void initModel(Action action) {
        this.action = action;
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.action == null) {
            this.successText.setText("");
        } else {
            this.successText.setText(this.action.getSuccess());
        }
        this.updating = false;
        this.setEnabled(this.action != null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.successText.setEnabled(enabled);
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.successText = new TextArea();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelSuccess.class, (String)"PanelSuccess.title")));
        this.successText.setColumns(20);
        this.successText.setRows(2);
        this.jScrollPane.setViewportView((Component)this.successText);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane, -1, 272, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jScrollPane, -2, 36, -2).add(20, 20, 20)));
    }
}

