/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence;

import java.awt.Dialog;
import java.text.MessageFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.view.action.recurrence.NewRecurrenceWizardIterator;

public class NewRecurrenceWizard {
    public void start(Action action) {
        boolean cancelled;
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        if (action == null) {
            return;
        }
        if (!action.isStateScheduled()) {
            return;
        }
        Recurrence recurrence = new Recurrence(data.getNextID(), action);
        NewRecurrenceWizardIterator iterator = new NewRecurrenceWizardIterator(recurrence, action);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle("Create Recurrence");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        wizardDescriptor.putProperty("dialog", (Object)dialog);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (cancelled) {
            return;
        }
        ActionStateScheduled state = (ActionStateScheduled)action.getState();
        state.setRecurrence(recurrence);
        if (recurrence.getBasis() == Recurrence.Basis.START_DATE) {
            recurrence.generateFromStartDate(action);
        }
    }
}

