/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.clean;

import java.io.File;
import java.io.FileFilter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.modules.ModuleInstall;
import tr.appl.Constants;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.extract.clean.ExtractCleanPrefs;
import tr.extract.prefs.ExtractPrefs;
import tr.util.UtilsFile;

public class ExtractCleanInstall
extends ModuleInstall {
    private static final Logger log = Logger.getLogger("tr.extract.clean");

    public void restored() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                log.finest("Begin");
                ExtractCleanInstall.this.checkCleanup();
                log.finest("End");
            }
        });
    }

    private void checkCleanup() {
        int interval = ExtractCleanPrefs.getCleanIntervalDays();
        if (interval == Integer.MAX_VALUE) {
            log.fine("Interval set to NEVER.");
            return;
        }
        if (interval != 0) {
            Calendar nextCheckDate = Calendar.getInstance();
            nextCheckDate.setTimeInMillis(ExtractCleanPrefs.getCleanLastDateMS());
            nextCheckDate.add(6, interval);
            Calendar now = Calendar.getInstance();
            if (now.before(nextCheckDate)) {
                log.fine("Interval has not passed.");
                return;
            }
        }
        this.cleanExtractFolder();
        ExtractCleanPrefs.setCleanLastDateMS(Calendar.getInstance().getTimeInMillis());
    }

    private File getExtractFolder() {
        File dataFile;
        String path = ExtractPrefs.getPath();
        if (path.trim().length() > 0) {
            return new File(path);
        }
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds != null && (dataFile = new File(ds.getPath())).isFile()) {
            return dataFile.getParentFile();
        }
        return null;
    }

    private void cleanExtractFolder() {
        File folder = this.getExtractFolder();
        if (folder == null || !folder.isDirectory()) {
            log.severe("Extract path is not a directory.");
            return;
        }
        if (!folder.canRead() || !folder.canWrite()) {
            log.severe("Insifficient permissions on extract directory.");
            return;
        }
        final Calendar ageDate = Calendar.getInstance();
        ageDate.add(6, ExtractCleanPrefs.getCleanAgeDays() * -1);
        log.fine("Deleting files older than: " + ageDate.getTime());
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String extn = UtilsFile.getExtension((String)file.getPath());
                if (extn == null) {
                    return false;
                }
                if (!(extn.equalsIgnoreCase("txt") || extn.equalsIgnoreCase("pdf") || extn.equalsIgnoreCase("xml"))) {
                    return false;
                }
                String name = UtilsFile.removeExtension((String)file.getName());
                if (name.length() < 15) {
                    return false;
                }
                try {
                    String timestamp = name.substring(name.length() - 14);
                    Long.parseLong(timestamp);
                    Date date = Constants.DF_TIMESTAMP.parse(timestamp);
                    if (date.before(ageDate.getTime())) {
                        return true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return false;
            }
        };
        for (File file : folder.listFiles(filter)) {
            log.fine("Deleting: " + file.getPath());
            if (file.delete()) continue;
            log.warning("Could not delete: " + file.getPath());
        }
    }
}

