/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.Util;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.layers.LocalFileSystemEx;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.spi.autoupdate.AutoupdateClusterCreator;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public class InstallManager
extends InstalledFileLocator {
    static final String NBM_LIB = "lib";
    static final String NBM_CORE = "core";
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.services.InstallManager");
    private static List<File> clusters = new ArrayList<File>();

    static File findTargetDirectory(UpdateElement updateElement, UpdateElementImpl updateElementImpl, boolean bl) {
        File file = null;
        if (updateElement != null) {
            file = InstallManager.getInstallDir(updateElement, updateElementImpl);
        } else {
            bl |= updateElementImpl.isFixed();
            String string = updateElementImpl.getInstallInfo().getTargetCluster();
            if (string != null && string.length() > 0 || (bl |= updateElementImpl.getInstallInfo().isGlobal() != null && updateElementImpl.getInstallInfo().isGlobal() != false)) {
                file = InstallManager.checkTargetCluster(updateElementImpl, string);
                if (file == null && string != null) {
                    file = InstallManager.createNonExistingCluster(string);
                    file = InstallManager.checkTargetCluster(updateElementImpl, string);
                }
                if (file == null) {
                    file = InstallManager.createNonExistingCluster("extra");
                    file = InstallManager.checkTargetCluster(updateElementImpl, "extra");
                    File file2 = file = file == null ? InstallManager.getUserDir() : file;
                    if (ERR.isLoggable(Level.INFO) && string != null) {
                        ERR.log(Level.INFO, "Declared target cluster " + string + " in " + updateElementImpl.getUpdateElement() + " wasn't found. Will be used " + file);
                    }
                }
                if (ERR.isLoggable(Level.INFO) && (file == null || !Utilities.canWriteInCluster(file))) {
                    ERR.log(Level.INFO, "Declared target cluster " + string + " in " + updateElementImpl.getUpdateElement() + " is not writable. Will be used " + file);
                }
                file = file == null || !Utilities.canWriteInCluster(file) ? InstallManager.getUserDir() : file;
            } else {
                file = InstallManager.getUserDir();
            }
        }
        ERR.log(Level.FINEST, "UpdateElement " + updateElementImpl.getUpdateElement() + " has the target cluster " + file);
        return file;
    }

    private static File checkTargetCluster(UpdateElementImpl updateElementImpl, String string) {
        File file = null;
        for (File file2 : UpdateTracking.clusters(true)) {
            if (string == null || !string.equals(file2.getName())) continue;
            if (!file2.exists()) {
                file2.mkdirs();
                InstallManager.extendSystemFileSystem(file2);
            }
            if (Utilities.canWriteInCluster(file2)) {
                file = file2;
                break;
            }
            ERR.log(Level.WARNING, "It's forbidden to write in target cluster " + string + " for " + updateElementImpl.getUpdateElement());
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createNonExistingCluster(String string) {
        File file = null;
        for (AutoupdateClusterCreator autoupdateClusterCreator : Lookup.getDefault().lookupAll(AutoupdateClusterCreator.class)) {
            File file2 = Trampoline.SPI.findCluster(string, autoupdateClusterCreator);
            if (file2 == null) continue;
            try {
                ERR.log(Level.FINE, "Found cluster candidate " + file2 + " for declared target cluster " + string);
                File[] fileArray = Trampoline.SPI.registerCluster(string, file2, autoupdateClusterCreator);
                file = file2;
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "";
                for (int i = 0; i < fileArray.length; ++i) {
                    stringBuffer.append(string2);
                    stringBuffer.append(fileArray[i].getPath());
                    string2 = File.pathSeparator;
                }
                System.setProperty("netbeans.dirs", stringBuffer.toString());
                File file3 = new File(new File(InstallManager.getUserDir(), InstallSupportImpl.DOWNLOAD_DIR), "netbeans.dirs");
                if (!file3.exists()) {
                    file3.getParentFile().mkdirs();
                    file3.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                try {
                    ((OutputStream)fileOutputStream).write(stringBuffer.toString().getBytes());
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                ERR.log(Level.FINE, "Was written new netbeans.dirs " + stringBuffer);
                break;
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extendSystemFileSystem(File file) {
        try {
            File file2 = new File(file, "config");
            file2.mkdir();
            LocalFileSystemEx localFileSystemEx = new LocalFileSystemEx();
            localFileSystemEx.setRootDirectory(file2);
            MainLookup.register((Object)localFileSystemEx);
            Class<InstallManager> clazz = InstallManager.class;
            synchronized (InstallManager.class) {
                clusters.add(file);
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            ERR.log(Level.INFO, propertyVetoException.getMessage(), propertyVetoException);
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        {
            return;
        }
    }

    private static File getInstallDir(UpdateElement updateElement, UpdateElementImpl updateElementImpl) {
        File file;
        block6: {
            File file2;
            block5: {
                file = null;
                UpdateElementImpl updateElementImpl2 = Trampoline.API.impl(updateElement);
                assert (updateElementImpl2 instanceof ModuleUpdateElementImpl) : "Impl of " + updateElement + " instanceof ModuleUpdateElementImpl";
                Module module = Utilities.toModule(((ModuleUpdateElementImpl)updateElementImpl2).getModuleInfo());
                File file3 = file2 = module == null ? null : module.getJarFile();
                if (file2 != null) break block5;
                ERR.log(Level.FINE, "No install dir for " + updateElement + " (It's ok for fixed). Is fixed? " + Trampoline.API.impl(updateElement).isFixed());
                String string = updateElementImpl.getInstallInfo().getTargetCluster();
                if (string != null) {
                    for (File file4 : UpdateTracking.clusters(false)) {
                        if (!string.equals(file4.getName())) continue;
                        file = file4;
                        break;
                    }
                }
                if (file != null) break block6;
                file = UpdateTracking.getPlatformDir();
                break block6;
            }
            for (File file5 : UpdateTracking.clusters(true)) {
                if (!InstallManager.isParentOf(file5 = FileUtil.normalizeFile((File)file5), file2)) continue;
                file = file5;
                break;
            }
        }
        if (file == null || !Utilities.canWriteInCluster(file)) {
            ERR.log(Level.WARNING, "It's forbidden to write in target cluster " + file + " for " + updateElementImpl.getUpdateElement());
            file = UpdateTracking.getUserDir();
        }
        ERR.log(Level.FINEST, "Install dir of " + updateElement + " is " + file);
        return file;
    }

    private static boolean isParentOf(File file, File file2) {
        File file3;
        for (file3 = file2.getParentFile(); file3 != null && !file.equals(file3); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    static File getUserDir() {
        return UpdateTracking.getUserDir();
    }

    static boolean needsRestart(boolean bl, UpdateElementImpl updateElementImpl, File file) {
        boolean bl2;
        assert (updateElementImpl.getInstallInfo() != null) : "Each UpdateElement must know own InstallInfo but " + updateElementImpl;
        boolean bl3 = updateElementImpl.getInstallInfo().needsRestart() != null && updateElementImpl.getInstallInfo().needsRestart() != false;
        boolean bl4 = bl2 = bl3 || bl;
        if (!bl2) {
            bl2 = InstallManager.willInstallInSystem(file);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean willInstallInSystem(File file) {
        boolean bl = false;
        try {
            JarFile jarFile = new JarFile(file);
            try {
                for (JarEntry jarEntry : Collections.list(jarFile.entries())) {
                    String string = jarEntry.getName();
                    if (!string.startsWith("core/") && !string.startsWith("lib/")) continue;
                    bl = true;
                    break;
                }
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        return bl;
    }

    public File locate(String string, String string2, boolean bl) {
        String string3;
        String string4;
        if (string.length() == 0) {
            throw new IllegalArgumentException("Cannot look up \"\" in InstalledFileLocator.locate");
        }
        if (string.charAt(0) == '/') {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not start with '/': " + string);
        }
        int n = string.lastIndexOf(47);
        if (n == string.length() - 1) {
            throw new IllegalArgumentException("Paths passed to InstalledFileLocator.locate should not end in '/': " + string);
        }
        if (n != -1) {
            string4 = string.substring(0, n + 1);
            string3 = string.substring(n + 1);
            assert (string3.length() > 0);
        } else {
            string4 = "";
            string3 = string;
        }
        if (bl) {
            String string5;
            String string6;
            int n2 = string3.lastIndexOf(46);
            if (n2 == -1) {
                string6 = string3;
                string5 = "";
            } else {
                string6 = string3.substring(0, n2);
                string5 = string3.substring(n2);
            }
            String[] stringArray = Util.getLocalizingSuffixesFast();
            for (int i = 0; i < stringArray.length; ++i) {
                String string7 = string6 + stringArray[i] + string5;
                File file = InstallManager.locateExactPath(string4, string7);
                if (file == null) continue;
                return file;
            }
            return null;
        }
        return InstallManager.locateExactPath(string4, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File locateExactPath(String string, String string2) {
        Class<InstallManager> clazz = InstallManager.class;
        synchronized (InstallManager.class) {
            File[] fileArray = clusters.toArray(new File[clusters.size()]);
            for (int i = 0; i < fileArray.length; ++i) {
                File file = InstallManager.makeFile(fileArray[i], string, string2);
                if (!file.exists()) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return file;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private static File makeFile(File file, String string, String string2) {
        return FileUtil.normalizeFile((File)new File(file, string.replace('/', File.separatorChar) + string2));
    }
}

