/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference;

import java.awt.EventQueue;
import java.util.logging.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.appl.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.reference.screen.ReferenceTopComponent;
import tr.view.reference.screen.ReferencesTopComponent;

public class ReferencesAction
extends CallableSystemAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.view.reference");

    public ReferencesAction() {
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ReferencesAction.this.enableDisable();
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ReferenceAction");
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/References.png";
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public String getID() {
        return "reference";
    }

    public void performAction() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowUtils.closeWindows();
                ReferencesTopComponent tcReferences = ReferencesTopComponent.findInstance();
                ReferenceTopComponent tcReference = ReferenceTopComponent.findInstance();
                Mode mode = WindowManager.getDefault().findMode("references");
                if (mode == null) {
                    LOG.severe("References mode was not found.");
                } else {
                    mode.dockInto((TopComponent)tcReferences);
                }
                mode = WindowManager.getDefault().findMode("reference");
                if (mode == null) {
                    LOG.severe("Reference mode was not found.");
                } else {
                    mode.dockInto((TopComponent)tcReference);
                }
                tcReferences.open();
                tcReference.open();
                tcReferences.requestActive();
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.reference");
    }
}

