/*
 * Decompiled with CFR 0.152.
 */
package tr.archive;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.Frame;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.archive.ArchiveDialog;
import tr.archive.ArchivePrefs;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamWrapper;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.RecurrenceRemover;
import tr.model.project.Project;
import tr.model.project.ProjectSingleActions;
import tr.model.thought.Thought;
import tr.model.util.Manager;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.UtilsFile;

public final class ArchiveAction
extends CallableSystemAction
implements LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.archive");
    private static final DateFormat DATESTAMP = new SimpleDateFormat("yyyyMMdd");
    private static final DateFormat TIMESTAMP = new SimpleDateFormat("HHmmssSSS");

    public ArchiveAction() {
        this.setIcon(Icons.Archive);
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener((LookupListener)this);
        r.allInstances();
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ArchiveAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.archive");
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        File archiveFolder;
        Date date = ArchivePrefs.getDate();
        String path = ArchivePrefs.getPath();
        Frame frame = WindowManager.getDefault().getMainWindow();
        ArchiveDialog dialog = new ArchiveDialog(frame, true, date, path);
        dialog.setVisible(true);
        if (!dialog.archive) {
            LOG.fine("User did not select archive");
            return;
        }
        StatusDisplayer.getDefault().setStatusText("Archiving ...");
        Date archiveDate = DateUtils.getEnd((Date)dialog.getArchiveDate());
        String archivePath = dialog.getArchivePath();
        DataStore datastore = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (datastore == null) {
            LOG.severe("Data store could not be obtained.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        File dataFile = new File(datastore.getPath());
        if (!dataFile.isFile()) {
            LOG.severe("Data file path error.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        File file = archiveFolder = archivePath == null || archivePath.equals("") ? dataFile.getParentFile() : new File(archivePath);
        if (!archiveFolder.isDirectory()) {
            LOG.severe("Archive directory error.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        String filename = UtilsFile.removeExtension((String)dataFile.getName());
        String extension = UtilsFile.getExtension((String)dataFile.getName());
        Date currentDate = Calendar.getInstance().getTime();
        String currentDateStamp = DATESTAMP.format(currentDate);
        String currentTimeStamp = TIMESTAMP.format(currentDate);
        File backupFile = new File(archiveFolder, filename + "-" + currentDateStamp + "-" + currentTimeStamp + ".backup." + extension);
        try {
            UtilsFile.copyFile((File)dataFile, (File)backupFile);
        }
        catch (Exception ex) {
            LOG.severe("Error creating archive backup of datafile. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        String archiveDateStamp = DATESTAMP.format(archiveDate);
        File archiveFile = new File(archiveFolder, filename + "-" + archiveDateStamp + "-" + currentTimeStamp + ".archive." + extension);
        try {
            UtilsFile.copyFile((File)dataFile, (File)archiveFile);
        }
        catch (Exception ex) {
            LOG.severe("Error creating archive copy of datafile. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        Vector<Action> archiveActions = new Vector<Action>();
        Vector<Project> archiveProjects = new Vector<Project>();
        Data archiveData = null;
        try {
            archiveData = XStreamWrapper.instance().load(archiveFile);
        }
        catch (Exception ex) {
            LOG.severe("Error loading data from archive file. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        Iterator i = archiveData.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            Action action = (Action)i.next();
            if (action.isDone() && action.getDoneDate().before(archiveDate)) {
                archiveActions.add(action);
                continue;
            }
            LOG.fine("Removing from archive - action: " + action.getDescription());
            action.removeFromParent();
        }
        i = archiveData.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            Project project = (Project)i.next();
            if (project.isDone() && project.getDoneDate().before(archiveDate)) {
                archiveProjects.add(project);
                continue;
            }
            LOG.fine("Removing from archive - project: " + project.getDescription());
            project.removeFromParent();
        }
        Manager archiveThoughtManager = archiveData.getThoughtManager();
        for (Thought thought : archiveThoughtManager.list()) {
            if (thought.isProcessed()) continue;
            archiveThoughtManager.remove((Observable)thought);
        }
        Iterator i2 = archiveData.getRootFutures().iterator(Project.class);
        while (i2.hasNext()) {
            ((Project)i2.next()).removeFromParent();
        }
        i2 = archiveData.getRootTemplates().iterator(Project.class);
        while (i2.hasNext()) {
            ((Project)i2.next()).removeFromParent();
        }
        archiveData.getFutureManager().removeAll();
        archiveData.getInformationManager().removeAll();
        RecurrenceRemover.removeAll((Data)archiveData);
        try {
            XStreamWrapper.instance().store(archiveData, archiveFile);
        }
        catch (Exception ex) {
            LOG.severe("Error storing archive. " + ex.getMessage());
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data could not be obtained.");
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        ProjectSingleActions singleActions = data.getRootActions();
        for (Action archiveAction : archiveActions) {
            LOG.fine("Removing from data - action: " + archiveAction.getDescription());
            singleActions.remove((Item)archiveAction);
        }
        Project projects = data.getRootProjects();
        for (Project archiveProject : archiveProjects) {
            LOG.fine("Removing from data - project: " + archiveProject.getDescription());
            projects.remove((Item)archiveProject);
        }
        this.saveData(datastore);
        ArchivePrefs.setDate(archiveDate);
        ArchivePrefs.setPath(archivePath);
        StatusDisplayer.getDefault().setStatusText("");
        String t = "ThinkingRock Data Archive";
        String m = "Archiving completed. \n\nArchive date: " + archiveDate + "\n\n" + "Backup file : " + backupFile.getPath() + "\n" + "Archive file: " + archiveFile.getPath() + "\n\n" + archiveActions.size() + "  Single Actions\n" + archiveProjects.size() + "  Projects\n\n";
        JOptionPane.showMessageDialog(frame, m, t, 1);
    }

    private void saveData(DataStore ds) {
        try {
            ds.store();
        }
        catch (Exception ex) {
            LOG.severe("Could not save data. " + ex.getMessage());
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }
}

