/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: res_record.h,v 3.7 2000/09/06 20:28:38 dillema Exp $>
 */

#ifndef RES_RECORD_H
#define RES_RECORD_H

#define rr_free(rr) (free(rr))

/*
 * data structure for a RR
 */
#define RR_HEAD_LEN (sizeof(u_int16_t)+sizeof(u_int32_t))
/* ... variable length r_data */
#define rr_rdata(rr) (((u_char*)(rr))+(sizeof(u_int16_t)+sizeof(u_int32_t)))

typedef struct rr {
	u_int32_t ttl;		/* time to live -- expire data if RR is cache */
	u_int16_t rd_len;	/* length of rdata -- exclusive */
}   RR;

/*
 * list of RR to be used for RRset construction.
 */
typedef struct rr_list {
	struct rr_list *next;
	int cnt;
	int offset;
	RR *rrp;
}   RR_List;

/*
 * RRset key...
 */
#define KEYINFO_HEAD_LEN 6
#define rrset_key_info_owner(rrset) (((u_char*)(rrset)->key.info)\
				     +sizeof(u_int16_t)*3)
typedef struct key_info {
	u_int16_t r_type;	/* resource type */
	u_int16_t r_class;	/* resource class */
	u_int16_t owner_len;	/* owner length / terminator included */
}   Key_Info;

typedef union u_key {
	Key_Info *info;		/* structure */
	u_char *p;		/* a pointer */
}   U_Key;

/*
 * RRset data section...
 */
#define DATADATA_HEAD_LEN sizeof(Data_Data)
/* variable length offsets... */
#define data_offset(n, d) (*((u_int16_t*)(((u_char*)(d))+\
					  (sizeof(u_int16_t)*((n)+1)))))
typedef struct data_data {
	u_int16_t data_cnt;	/* number of the datas */
}   Data_Data;

typedef union u_data {
	Data_Data *d;		/* data structure */
	u_int16_t *rt_list;	/* resource type list */
	u_char *p;		/* a pointer */
}   U_Data;

/*
 * structure for an RR set
 */
typedef struct rr_set {
	int links;		/* number of pointers which points this RR */

	size_t key_len;		/* length of the key -- exclusive */
	U_Key key;		/* key itself */

	size_t data_len;	/* length of the all datas */
	U_Data data;		/* data itself */
}   RRset;

#endif				/* RES_RECORD_H */
