/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: res_record.c,v 3.17 2001/03/13 11:14:43 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: res_record.c,v 3.17 2001/03/13 11:14:43 dillema Exp $");

RR *rr_alloc (u_int32_t ttl, int rd_len, u_char * rdata) {
	RR *ret;

	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "rr_alloc(): start ttl = %d, rd_len = %d", ttl, rd_len));
	}

	ret = (RR *) malloc (rd_len + RR_HEAD_LEN);
	if (!ret)
		return NULL;

	ret->ttl = ttl;
	ret->rd_len = rd_len;

	if (rdata) 
		memcpy (rr_rdata (ret), rdata, ret->rd_len);

	return ret;
}

RR_List *rr_list_alloc (void) {
	RR_List *ret;

	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "start: rr_list_alloc(void)"));
	}

	ret = (RR_List *) malloc (sizeof (RR_List));
	if (!ret)
		return NULL;

	ret->next = NULL;
	ret->rrp = NULL;
	ret->cnt = -1;

	return ret;
}

void rr_list_free (RR_List * rrl) {
        DX(char *fn = "rr_list_free()";)
	RR_List *rrl_tmp;

	if (!rrl) {
		if (T.debug > 4) {
			DX (syslog (LOG_DEBUG, "%s start: NULL: immediate return", fn));
		}
		return;
	}
	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "%s start: (%p)", fn, rrl));
	}

	for ( /* void */ ; rrl->next; rrl = rrl_tmp) {
		if (rrl->rrp) {
			if (T.debug > 4) {
				DX (syslog (LOG_DEBUG, "%s: free %p\n", fn, rrl->rrp));
			}
			rr_free (rrl->rrp);
		}
		rrl_tmp = rrl->next;
		free (rrl);
	}
	free (rrl);		/* last watchdog */

	return;
}

RR_List *rr_list_add (RR_List * rrl, u_int32_t ttl, int rd_len, u_char * rdata) {
	RR_List *rrl_tmp;

	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "start: rr_list_add(....,ttl=%d,rd_len=%d...)", ttl, rd_len));
	}

	rrl_tmp = (RR_List *) malloc (sizeof (RR_List));
	if (!rrl_tmp)
		return NULL;

	rrl_tmp->rrp = rr_alloc (ttl, rd_len, rdata);
	if (!rrl_tmp->rrp) {
		free (rrl_tmp);
		return NULL;
	}
	rrl_tmp->next = rrl;
	rrl_tmp->cnt = rrl->cnt + 1;

	return rrl_tmp;
}

RR *rrset_get_rr_f (int n, RRset * rrset) {
	u_int16_t offset;

	offset = *(u_int16_t *) ((u_char *) rrset->data.p + DATADATA_HEAD_LEN +
				 +sizeof (u_int16_t) * n);
	return (RR *) (((u_char *) rrset->data.p) + offset);
}

RR_List *rr_list_of_rrset (RRset *rrsp) {
	RR_List *rrl, *rrl_tmp;
	RR *rrp;
	int i;

	rrl = rr_list_alloc();
	if (!rrl) 
		return NULL;

	if (!rrsp->data.p) 
		return rrl;	/* no record -- empty list */

	for (i = 0; i < rrsp->data.d->data_cnt; i++) {
		rrp = (RR *) (rrsp->data.p + data_offset (i, rrsp->data.d));
		rrl_tmp = rr_list_add (rrl, rrp->ttl, rrp->rd_len, rr_rdata (rrp));
		if (!rrl_tmp) {
			rr_list_free (rrl);
			return NULL;
		}
		rrl = rrl_tmp;
	}

	return rrl;
}

RRset *rrset_alloc (void) {
	RRset *ret;

	ret = (RRset *) malloc (sizeof (RRset));
	if (!ret)
		return NULL;

	ret->key_len = 0;
	ret->key.p = NULL;

	ret->data_len = 0;
	ret->data.p = NULL;

	ret->links = 1;
	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "rrset_alloc(): allocated %p\n", ret));
	}

	return ret;
}

RRset *rrset_create (u_int16_t r_type, u_int16_t r_class,
		         u_int16_t owner_len, u_char *owner, RR_List *rrl) {
	RRset *rrs;
	int len_tmp;
	RR_List *rrl_tmp;

	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "start: rrset_create(%s,%s,....)\n",
			    string_rtype (r_type), string_rclass (r_class)));
	}

	rrs = rrset_alloc();
	if (!rrs)
		return NULL;

	/** make key */
	len_tmp = owner_len + KEYINFO_HEAD_LEN;
	rrs->key.p = malloc (len_tmp);
	if (!rrs->key.p) {
		rrset_free (rrs);
		return NULL;
	}
	rrs->key_len = len_tmp;
	rrs->key.info->r_type = r_type;
	rrs->key.info->r_class = r_class;
	rrs->key.info->owner_len = owner_len;
	memcpy (rrset_key_info_owner (rrs), owner, owner_len);

	if (rrl) {
		/** make data */
		/** calculate sum of data_cnt and variable length offsets. */
		/* XXX BUG XXX */
		/*
		 * len_tmp = (rrl->cnt+2+((rrl->cnt+2)%2 padding
		 * ))*sizeof(u_int16_t);
		 */
		len_tmp = ((rrl->cnt + 1 /* zero origin */ ) * sizeof (u_int16_t)
			   + DATADATA_HEAD_LEN);
		len_tmp += (len_tmp % 4 == 0) ? 0 : (4 - len_tmp % 4);	/* padding */
		for (rrl_tmp = rrl; rrl_tmp->next; rrl_tmp = rrl_tmp->next) {
			rrl_tmp->offset = len_tmp;	/* store current data offset */

			len_tmp += RR_HEAD_LEN + rrl_tmp->rrp->rd_len;
			len_tmp += (len_tmp % 4 == 0) ? 0 : (4 - len_tmp % 4);	/* padding */
		}
		if (T.debug > 4) {
			DX (syslog (LOG_DEBUG, "rrset_create: finally length %d\n", len_tmp));
		}

		if ((rrs->data.p = malloc (len_tmp)) == NULL) {
			rrset_free (rrs);
			return NULL;
		}
		rrs->data_len = len_tmp;

		/* write RRs */
		rrs->data.d->data_cnt = rrl->cnt + 1;	/* because zero origin */
		for (rrl_tmp = rrl; rrl_tmp->next; rrl_tmp = rrl_tmp->next) {
			data_offset (rrl_tmp->cnt, rrs->data.p) = rrl_tmp->offset;
			memcpy (rrs->data.p + rrl_tmp->offset, (u_char *) rrl_tmp->rrp, rrl_tmp->rrp->rd_len + RR_HEAD_LEN);
		}
	} else {
		rrs->data.p = NULL;
	}

	return rrs;
}

RRset *rrset_create_single (u_char * dname, int dname_len, u_int16_t rtype,
		          u_int16_t rclass, u_int32_t ttl, u_int16_t rd_len,
			        u_char * rd)
{
	RR_List *rrlp;
	RR_List *rrlp_tmp;
	RRset *rrsp;

	if ((rrlp = rr_list_alloc ()) == NULL) {
		return NULL;
	}
	if ((rrlp_tmp = rr_list_add (rrlp, ttl, rd_len, rd))
	    == NULL) {
		rr_list_free (rrlp);
		return NULL;
	}
	rrlp = rrlp_tmp;
	rrsp = rrset_create (rtype, rclass, dname_len, dname, rrlp);
	if (!rrsp) {
		rr_list_free (rrlp);
		return NULL;
	}
	rr_list_free (rrlp);

	return rrsp;
}

void rrset_freev (void *p) {
	rrset_free ((RRset *) p);
	return;
};

void rrset_free (RRset * rrset) {

	if (rrset->links <= 1) {
		if (T.debug > 4) {
			DX (syslog (LOG_DEBUG, "rrset_free(%p): link %d -> destroyed\n",
				    rrset, rrset->links));
		}
		if (rrset->key.p)
			free (rrset->key.p);

		if (rrset->data.p)
			free (rrset->data.p);

		free (rrset);
	} else {
		if (T.debug > 4) {
			DX (syslog (LOG_DEBUG, "rrset_free(%p): link %d -> %d\n", rrset, rrset->links,
				    rrset->links - 1));
		}
		rrset->links--;
	}
}

RRset *rrset_copy (RRset * rrset) {
	if (T.debug > 4) {
		DX (syslog (LOG_DEBUG, "rrset_copy(%p): link %d -> %d\n", rrset,
			    rrset->links, rrset->links + 1));
	}

	rrset->links++;
	return rrset;
}

void *rrset_copyv (void *rrsetv) {
	return (void *) rrset_copy ((RRset *) rrsetv);
}

RRset *rrset_dup (RRset * rrset) {
	RRset *rrsp_new = NULL;

	if ((rrsp_new = rrset_alloc ()) == NULL) {
		goto error;
	}
	rrsp_new->key.p = NULL;
	rrsp_new->data.p = NULL;

	if (rrset->key.p) {
		rrsp_new->key.p = malloc (rrset->key_len);
		if (!rrsp_new->key.p)
			goto error;

		memcpy (rrsp_new->key.p, rrset->key.p, rrset->key_len);
		rrsp_new->key_len = rrset->key_len;
	}
	if (rrset->data.p) {
		rrsp_new->data.p = malloc (rrset->data_len);
		if (!rrsp_new->data.p)
			goto error;

		memcpy (rrsp_new->data.p, rrset->data.p, rrset->data_len);
		rrsp_new->data_len = rrset->data_len;
	}
	return rrsp_new;

error:
	if (rrsp_new) {
		if (rrsp_new->data.p) {
			free (rrsp_new->data.p);
		}
		if (rrsp_new->key.p) {
			free (rrsp_new->key.p);
		}
		free (rrsp_new);
	}
	return NULL;
}

u_char *conv_dname_decompress (u_char * buf, int buflen, u_char * c_dname,
			     u_char * m_head, u_char * m_tail, int *written) {
	u_int16_t ui;
	int token_len;
	int written_len = 0;
	u_char *cp;
	u_char *next = NULL;

	cp = c_dname;

	while (*cp) {
		if ((*cp & DNCMP_MASK) == DNCMP_MASK) {
			if (!m_head || !m_tail) {
				/** irregular redirect */
				return NULL;
			} else {
				/** redirect */
				next = cp + 2;
				GETSHORT (ui, cp);
				ui = ui & ~DNCMP_MASK_INT16T;
				cp = m_head + ui;
				if (cp < m_head || m_tail < cp) {
					/** out of bounds */
					return NULL;
				}
			}
		}
		token_len = mesg_labellen(cp) + 1;
		if ((written_len += token_len) >= buflen) {
			/** buffer overrun */
			return NULL;
		}
		if (!written) {	/* XXX: bitlabel case (TODO). */
			memcpy (buf, cp + 1, token_len - 1);
			*(buf + (token_len - 1)) = '.';	/* <- domain name
							 * delimiter */
		} else {
			memcpy (buf, cp, token_len);
		}

		cp += token_len;
		buf += token_len;
	}
	*buf = '\0';
	written_len++;
	cp++;
	buf++;			/* <- for null terminator */

	if (written) {
		*written = written_len;
	}
	if (!next) {
		next = cp;
	}
	return next;
}


char *string_rclass (u_int16_t rclass) {
	switch (rclass) {
		case C_IN:
		return "IN";
	case C_NONE:
		return "NONE";
	case C_ANY:
		return "ANY";
	default:
		syslog (LOG_NOTICE, "Unknown resource class(%d)\n", rclass);
		return "UNKNOWN";
	}
}

char *string_rtype (u_int16_t rtype) {
	switch (rtype) {
		case RT_VOID:
		return "(void)";
	case RT_A:
		return "A";
	case RT_NS:
		return "NS";
	case RT_MD:
		return "MD";
	case RT_MF:
		return "MF";
	case RT_CNAME:
		return "CNAME";
	case RT_SOA:
		return "SOA";
	case RT_MB:
		return "MB";
	case RT_MG:
		return "MG";
	case RT_MR:
		return "MR";
	case RT_NULL:
		return "NULL";
	case RT_WKS:
		return "WKS";
	case RT_PTR:
		return "PTR";
	case RT_HINFO:
		return "HINFO";
	case RT_MINFO:
		return "MINFO";
	case RT_MX:
		return "MX";
	case RT_TXT:
		return "TXT";
	case RT_RP:
		return "RP";
	case RT_AAAA:
		return "AAAA";
	case RT_SRV:
		return "SRV";
	case RT_UINFO:
		return "UINFO";
	case RT_TSIG:
		return "TSIG";
	case RT_IXFR:
		return "IXFR";
	case RT_AXFR:
		return "AXFR";
	case RT_ALL:
		return "ANY";
	default:
		syslog (LOG_NOTICE, "Unknown resource type(%d)\n", rtype);
		return "UNKNOWN";
	}
}
