/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: read_config.c,v 3.23 2000/09/28 11:52:35 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: read_config.c,v 3.23 2000/09/28 11:52:35 dillema Exp $");

int read_config (char *config_file) {
	char buf[512];
	char *cp;
	struct sockaddr *sa_p = NULL;
	int sa_p_len;
	FILE *config_fp;
	char *args[SEARCH_CONFIG_ARGLEN];
	int argcnt, errcnt, linenum;

	config_fp = fopen (config_file, "r");
	if (!config_fp) {
		syslog (LOG_ERR, "can't open config file: %s", config_file);
		return -1;
	}
	linenum = errcnt = 0;
	while (fgets (buf, sizeof (buf), config_fp)) {
		linenum++;

		cp = strchr (buf, '\n');
		if (cp)
			*cp = '\0';
		cp = strchr (buf, '\n');
		if (cp)
			*cp = '\0';
		cp = strchr (buf, '#'); /* strip comment */
		if (cp)
			*cp = '\0';
		cp = strchr (buf, ';'); /* strip comment */
		if (cp)
			*cp = '\0';

		args[argcnt = 0] = strtok (buf, " \t");
		while (args[argcnt] && ++argcnt < SEARCH_CONFIG_ARGLEN)
			args[argcnt] = strtok (NULL, " \t");

		if (!args[0]) /* empty line (or only comment) */
			continue;

		if (!strcasecmp (args[0], "forwarder")) {
			if (argcnt < 2 || argcnt > 4 ) {
				syslog (LOG_ERR, "line %d: invalid format: forwarder <IPaddr> [port <port>]", linenum);
				errcnt++;
			} else {
				int port = PORT_TO, i;

				i = 2;
				if (argcnt > i) {
					if (!strcasecmp (args[i], "port")) {
						if (argcnt >= ++i) {
							port = atoi (args[i++]);
						}
						else {
							syslog (LOG_ERR, "line %d: invalid format, missing <port> after port attribute", linenum);
							errcnt++;
							continue;
						}
					}
					else {
						syslog (LOG_ERR, "line %d: invalid format, cannot parse unknown attribute: %s", linenum, args[i]);
						errcnt++;
						continue;
					}	
				}
				sa_p = net_parse_alloc_addr (args[1], port, &sa_p_len);
				if (sa_p && !fwd_add (sa_p, sa_p_len)) {
					syslog (LOG_INFO, "forwarder %s added, port %d", args[1], port);
				}
				else {
					syslog (LOG_ERR, "can't read forwarder address or add forwarder %s", args[1]);
					errcnt++;
				}
			}
		} else if (!strcasecmp (args[0], "prefix")) {
			if (argcnt != 2) {
				syslog (LOG_ERR, "line %d: invalid format: prefix <IPv6prefix>", linenum);
				errcnt++;
			} else {
				if (conv_trick_conf (args[1])) {
					errcnt++;
				} else {
					T.prefixnum++;
					syslog (LOG_INFO, "prefix %d added: %s", T.prefixnum, args[1]);
				}
			}
		} else if (!strcasecmp (args[0], "retry")) {
			if (argcnt != 2) {
				syslog (LOG_ERR, "line %d: invalid format: retry <seconds>", linenum);
				errcnt++;
			} else {
				T.retry_interval = atoi(args[1]);
			}
		}
#ifdef SCOPED_REWRITE
		else if (!strcasecmp(args[0], "scoped")) {
			if (argcnt != 4) {
				syslog (LOG_ERR, "line %d: invalid format: scoped <from> <to> <plen>", linenum);
				errcnt++;
			} else {
				if (conv_scoped_conf(args[1], args[2], atoi(args[3])))
					errcnt++;
				else {
					T.scoped_prefixes++;
					syslog(LOG_INFO, "scoped %d added: %s %s %d", T.scoped_prefixes, args[1], args[2], atoi(args[3]));
				}
			}
		}
#endif
#ifdef STF
		else if  (!strcasecmp(args[0], "stf")) {
			if (argcnt != 1) {
				syslog (LOG_ERR, "line %d: invalid format: stf", linenum);
				errcnt++;
			} else {
				T.stf = 1;
			}
		}
#endif
		else {
			syslog (LOG_WARNING, "line %d: unknown keyword in config file: %s",
				linenum, args[0]);
			errcnt++;
		}
	}

	fclose (config_fp);

	if (errcnt) {
	    syslog (LOG_ERR, "errors found in config file. errcnt = %d", errcnt);
	    return -1;
	}
	else
	    syslog (LOG_INFO, "configuration file loaded.");

	/* there has to be at least one forwarder */
	if (T.Fwd_list == T.Fwd_list->next) {
	    syslog (LOG_ERR, "no forwarder in config file");
	    return -1;
	}

	return 0;
}
