/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/
/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/
/*
 * <$Id: ns_const.h,v 3.12 2001/03/13 11:14:43 dillema Exp $>
 */

#ifndef NS_CONST_H
#define NS_CONST_H

/* ======== some constant values. ======== */
#define PORT_TO 53		/* port number for both sockets */
#define PORT_SRV 53		/* port number to receive (for debug use) */
#define DNAME_DELIM '.'		/* domain name delimiter */
#define MAX_PACKET 512		/* max UDP packet size */
#define MAX_STREAM 65535	/* max TCP stream size */
#define MAX_DNAME 256		/* max domain name length */
#define MAX_LABEL 63		/* max label length */

#define IPV4_ADDR_LEN 4
#define IPV6_ADDR_LEN 16

#define SEARCH_REMOTE_TIMEOUT 3	/* timeout in seconds */
#define SEARCH_REMOTE_RETRY   3	/* retry */
#define SEARCH_CNAME_LEVEL   16	/* maximum levels of cname links */

#define QUERY_HEADER_LEN 12	/* query header length */
#define RR_HEADER_LEN 10	/* RR header length */
#define QUESTION_TRAILER_LEN 4	/* question section trailer length */

/*** OPCODE in the message ***/
#define OP_QUERY 0		/* standard query */
#define OP_INVQ 1		/* inverse query -- not supported */
#define OP_STATUS 2		/* server status request -- not supported */
#define OP_NOTIFY 4		/* notify  -- not yet implemented */
#define OP_UPDATE 5		/* <- rfc2136: update */
/* #define OP_UDPHOSTNAME 14 * <- tot experimental -- not yet */

/*** RCODE in the message ***/
#define RC_OK 0			/* no error */
#define RC_FMTERR 1		/* format error */
#define RC_SERVERERR 2		/* server error */
#define RC_NAMEERR 3		/* name does not exist error */
#define RC_NXDOMAIN 3		/* alias for NAMEERR */
#define RC_NIMP 4		/* not implimented error */
#define RC_REF 5		/* refused error */
#define RC_YXDOMAIN 6		/* <- rfc2136: request domain exists */
#define RC_YXRRSET 7		/* <- rfc2136: request rrset exists */
#define RC_NXRRSET 8		/* <- rfc2136: request rrset not exist */
#define RC_NOTAUTH 9		/* <- rfc2136: non-authority zone */
#define RC_NOTZONE 10		/* <- rfc2136: not-zone error */

/*** RR type and query type (RT means Resource Type) ***/
/* this is a least list */
#define RT_VOID 0
#define RT_A 1
#define RT_NS 2
#define RT_MD 3			/* not implemented */
#define RT_MF 4			/* not implemented */
#define RT_CNAME 5
#define RT_SOA 6
#define RT_MB 7			/* not implemented */
#define RT_MG 8			/* not implemented */
#define RT_MR 9			/* not implemented */
#define RT_NULL 10		/* not implemented */
#define RT_WKS 11		/* not implemented */
#define RT_PTR 12
#define RT_HINFO 13
#define RT_MINFO 14		/* not implemented */
#define RT_MX 15
#define RT_TXT 16
#define RT_RP 17		/* rfc1183: responsible person */
#define RT_AAAA 28		/* rfc1886: for IPv6 :) */
#define RT_SRV 33		/* rfc2052: SRV : not implemented well */
#define RT_A6 38		/* rfc2874: for IPv6, too */
/* non standard */
#define RT_UINFO 100		/* partially implemented */
/* these are only for query */
#define RT_TSIG 250		/* not yet supported */
#define RT_IXFR 251		/* not yet supported */
#define RT_AXFR 252		/* zone transfer */
#define RT_ALL 255

/*** Class values ***/
/* this is a least list */
#define C_IN 1
#define C_NONE 254		/* <- rfc2136 */
/* this is only for query */
#define C_ANY 255

/*** Bit mask ***/
/* for domain name compression */
#define DNCMP_MASK 0xc0
#define DNCMP_MASK_INT16T 0xc000
#define DNCMP_REDIRECT_LIMIT (0x3000-1)

/* for bit string label */
#define EDNS0_MASK 0x40
#define EDNS0_ELT_BITLABEL 0x41

/*** TIME VALUE ***/
#define TV_MIN 60
#define TV_HOUR 3600
#define TV_DAY 86400
#define TV_WEEK 604800
#define TV_MONTH 2592000	/* 30 day-period */
#define TV_YEAR 31536000	/* 365 day-period */


#endif				/* NS_CONST_H */
