/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ev_dup.c,v 3.10 2000/09/06 20:28:35 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: ev_dup.c,v 3.10 2000/09/06 20:28:35 dillema Exp $");

/*
 * there is no reason to select these value..
 */
#define EV_DUP_TABLE_SIZE 1000
#define EV_DUP_CMP_LEN 16

/* hash table */
static struct {
	union {
		u_char d[16];
		struct sockaddr sa;
	}   data;
	u_int16_t data_len;
	u_int16_t id;
	time_t expire;
}   Ev_dup_table[EV_DUP_TABLE_SIZE];

static int Ev_dup_timeout;

void ev_dup_init (int timeout) {
	int i;

	for (i = 0; i < EV_DUP_TABLE_SIZE; i++) {
		memset (Ev_dup_table[i].data.d, 0, EV_DUP_CMP_LEN);
		Ev_dup_table[i].data_len = 0;
		Ev_dup_table[i].id = 0;
	}
	Ev_dup_timeout = timeout;
	return;
}

int ev_dup_hashval (struct sockaddr * sa, u_int16_t sa_len, u_int16_t id) {
	int hashval;
	u_char *cp;
	u_char *cp_tail;

	hashval = 0;
	for (cp = (u_char *) sa, cp_tail = cp + sa_len; cp < cp_tail; cp++)
		hashval += *cp;

	hashval += id;
	return hashval % EV_DUP_TABLE_SIZE;
}

int ev_dup (struct sockaddr * sa, u_int16_t sa_len, u_int16_t id) {
	int index;
	time_t now;

	index = ev_dup_hashval (sa, sa_len, id);
	if (T.debug > 2) {
		DX (syslog (LOG_DEBUG, "ev_dup(): index = %d\n", index));
	}
	now = time (NULL);
	sa_len = MINNUM (sa_len, EV_DUP_CMP_LEN);

	if (Ev_dup_table[index].id == id
	    && Ev_dup_table[index].data_len == sa_len
	&& memcmp (&(Ev_dup_table[index].data.d), (u_char *) sa, sa_len) == 0
	    && now < Ev_dup_table[index].expire) {
		syslog (LOG_INFO, "duplicate detected.\n");
		return -1;
	} else {
		/* overwrite table */
		Ev_dup_table[index].id = id;
		Ev_dup_table[index].data_len = sa_len;
		memcpy (Ev_dup_table[index].data.d, (u_char *) sa, sa_len);
		Ev_dup_table[index].expire = time (NULL) + Ev_dup_timeout;
		return 0;
	}
}
