/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: conv_trick.c,v 3.24 2001/03/13 11:14:43 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: conv_trick.c,v 3.24 2001/03/13 11:14:43 dillema Exp $");

static RRset *conv_trick_rrset (RRset *, u_int16_t, int);

static RRset *conv_trick_rrset (RRset * rrs_a, u_int16_t qtype, int pref) {
        const char *fn = "conv_trick_rrset()";
	RR_List *rrl = NULL, *rrl_tmp;
	RRset *rrs_new = NULL;
	RR *rr_a = NULL, *rr_new = NULL;
	u_char *rd, *rd_new = NULL;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start\n", fn));
	}

	if (T.prefixnum && rrs_a->key.info->r_type == RT_A) {
		/* parse A resource record set */
		rrl = rr_list_of_rrset (rrs_a);
		if (rrl) {
			/* convert each RR_List data */
			for (rrl_tmp = rrl; rrl_tmp->next; rrl_tmp = rrl_tmp->next) {
				int rdlen;
				u_char *rd_addr;

				rr_a = rrl_tmp->rrp;
				rrl_tmp->rrp = NULL;	/* kept in rr_a */
				rd = rr_rdata (rr_a);

				rdlen = sizeof(struct in6_addr);
				if (qtype == RT_A6)
					rdlen++; /* size of prefix length */
				rd_new = malloc (rdlen);
				if (rd_new) {
					rd_addr = (qtype == RT_AAAA) ?
						rd_new : (rd_new + 1);

					memcpy (rd_addr,
						T.tot_prefix[pref], 12);
					memcpy (rd_addr + 12, rd, 4);

					if (qtype == RT_A6)
						*rd_new = 0; /* plen is 0 */

					rr_new = rr_alloc (rr_a->ttl, rdlen,
							   rd_new);
					if (rr_new) {
						free (rd_new);
						rd_new = NULL;	/* kept in rr_new */
						rrl_tmp->rrp = rr_new;
						rr_new = NULL;	/* kept in rrl_tmp->rrp */

						rr_free (rr_a);
						rr_a = NULL;
					}
					else
						break;
				}
				else {
			                syslog (EM_F (EM_F_MEMEX), fn);
					break;
				}
			}

			/* assemble A6/AAAA rrset */
			rrs_new = rrset_create (qtype,
						rrs_a->key.info->r_class,
						rrs_a->key.info->owner_len,
						rrset_key_info_owner (rrs_a),
						rrl);
		}
	}

	if (rr_a)
		rr_free (rr_a);
	if (rr_new)
		rr_free (rr_new);
	if (rrl)
		rr_list_free (rrl);
	if (rd_new)
		free (rd_new);

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	}

	return rrs_new;
}

void conv_trick_list (G_List * rrsl) {
        const char *fn = "conv_trick_list()";
        RRset *rrsp, *rrsp_aaaa;
	G_List *gl_tmp;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start.\n", fn));
	}

	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrsp = (RRset *) gl_tmp->list_data;
		if (rrsp->key.info->r_type == RT_A) {
		    	/* convert A record into faked AAAA record */
			rrsp_aaaa = conv_trick_rrset (rrsp, RT_AAAA,
						      T.current_prefix);
			if (rrsp_aaaa) {
				rrset_free (rrsp);
				gl_tmp->list_data = rrsp_aaaa;
			}
			else
				syslog (LOG_ERR, "%s: Can't convert A to AAAA\n", fn);
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	}

	return;
}

/* XXX: should be merged into conv_trick_list(). */
void conv_trick_list_a6 (G_List * rrsl) {
        const char *fn = "conv_trick_list()";
        RRset *rrsp, *rrsp_a6;
	G_List *gl_tmp;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start.\n", fn));
	}

	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrsp = (RRset *) gl_tmp->list_data;
		if (rrsp->key.info->r_type == RT_A) {
		    	/* convert A record into faked A6 record */
			rrsp_a6 = conv_trick_rrset (rrsp, RT_A6,
						    T.current_prefix);
			if (rrsp_a6) {
				rrset_free (rrsp);
				gl_tmp->list_data = rrsp_a6;
			}
			else
				syslog (LOG_ERR, "%s: Can't convert A to A6\n", fn);
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	}

	return;
}

void conv_trick_ptr (G_List * rrsl, u_char *qname) {
        const char *fn = "conv_trick_ptr()";
	G_List *gl_tmp;
	U_Key rk, rk_new;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start.\n", fn));
	}

	if (!T.prefixnum)
	    syslog (LOG_ERR, "%s: No tot prefix configured!\n", fn);
	else {
		rrsl->list_data = NULL;
		for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
			rk = ((RRset *) gl_tmp->list_data)->key;
			if (rk.info->r_type == RT_PTR) {
			    	/* convert PTR record from in-addr.arpa to ip6.int */
			    	rk_new.p = malloc (KEYINFO_HEAD_LEN + strlen(qname) + 1);
			    	if (rk_new.p) {
					rk_new.info->r_type = RT_PTR;
					rk_new.info->r_class = C_IN;
					strcpy(rk_new.p+KEYINFO_HEAD_LEN, qname);
					free (rk.p);
					((RRset *) gl_tmp->list_data)->key= rk_new;
			    	}
			    	else
			                syslog (EM_F (EM_F_MEMEX), fn);
			}
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	}
	return;
}

void conv_trick_newptr (G_List * rrsl, u_char *qname, int qlen) {
        const char *fn = "conv_trick_newptr()";
	G_List *gl_tmp;
	U_Key rk, rk_new;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start.\n", fn));
	}

	if (!T.prefixnum)
	    syslog (LOG_ERR, "%s: No tot prefix configured!\n", fn);
	else {
		rrsl->list_data = NULL;
		for (gl_tmp = rrsl->next; gl_tmp->list_data;
		     gl_tmp = gl_tmp->next) {
			rk = ((RRset *) gl_tmp->list_data)->key;
			if (rk.info->r_type == RT_PTR) {
			    	/*
				 * convert PTR record from in-addr.arpa to
				 * ip6.arpa.
				 */
			    	rk_new.p = malloc (KEYINFO_HEAD_LEN + qlen);
			    	if (rk_new.p) {
					rk_new.info->r_type = RT_PTR;
					rk_new.info->r_class = C_IN;
					memcpy(rk_new.p + KEYINFO_HEAD_LEN,
					       qname, qlen);
					free (rk.p);
					((RRset *) gl_tmp->list_data)->key =
						rk_new;
			    	}
			    	else
			                syslog (EM_F (EM_F_MEMEX), fn);
			}
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	}
	return;
}

int conv_trick_conf (u_char * v6addr) {
        const char *fn = "conv_trick_conf()";
	u_char prefix_tmp[TOTPREFIXLEN + 1];
	int i, j;
	const int off = sizeof(struct in6_addr) - sizeof(struct in_addr);
	char x[3];

	if (T.prefixnum < MAXPREFIXES) {
		if (inet_pton (AF_INET6, v6addr, T.tot_prefix[T.prefixnum]) == 1) {
			memset(prefix_tmp, 0, sizeof(prefix_tmp));
			for (i = 0; i < off; i++) {
				j = (off - 1) - i;
				snprintf(x, sizeof(x), "%02x", T.tot_prefix[T.prefixnum][i] & 0xff);
				prefix_tmp[j * 2 + 0] = x[1];
				prefix_tmp[j * 2 + 1] = x[0];
			}

			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: %s\n", fn, v6addr));
			}

			/* SUCCESS */
			return (0);
		}
		else
                	syslog (LOG_ERR, "%s: invalid format: prefix %s", fn, v6addr);
	}
	else 
		syslog (LOG_ERR, "%s: max number of %d prefixes exceeded", fn, MAXPREFIXES);

	/* FAILURE */
	return (-1);
}

/* 
 * returns 1 if netprefix of qname equals one of tot prefixes, else returns 0
 */
int conv_trick_is_tot_ptr (u_char *qname) {
	u_char *qname6, *q6;
	int i;
	struct in6_addr a6;
	char *p;
	unsigned int val;
	char buf[3];
	const int cmpsiz = sizeof(struct in6_addr) - sizeof(struct in_addr);

	if (!T.prefixnum)
		return 0;

	if (!(strstr(qname, "INT") || strstr(qname, "int")))
		return 0;

	qname6 = strstr(qname, "IP6");
	if (!qname6)
		qname6 = strstr(qname, "ip6");
	if (!qname6)
		return 0;

	memset(&a6, 0, sizeof(a6));
	qname6--;
	if (qname6 - qname != 64)
		return 0;
	qname6--;
	q6 = qname6;
	p = &a6.s6_addr[0];
	while (q6 - 4 >= qname) {
		buf[0] = *q6--;
		if (*q6-- != 1)
			return 0;
		buf[1] = *q6--;
		if (*q6-- != 1)
			return 0;
		buf[2] = '\0';
		sscanf(buf, "%x", &val);
		*p++ = val & 0xff;
	}

	for (i = 0; i < T.prefixnum; i++) {
		if (memcmp(&a6, &T.tot_prefix[i], cmpsiz) == 0)
			return 1; /* got a match */
	}
	return 0;
}


void conv_trick_ptr_rq (u_char * qname) {
    u_char *qname6, tmpaddr[8];
    int len, i, tmp;

    len = 0;
    qname6 = qname;
    while (len < 8) {
	strncpy (tmpaddr + len, qname6 + 1, (int) *qname6);
	len += (int) *qname6;
	qname6 += ((int) *qname6) + 1;
    }
    for (i = 0; i < 8; i++) {
	if (isdigit (tmpaddr[i]))
	    tmpaddr[i] -= '0';
	else if (isalpha (tmpaddr[i]))
	    tmpaddr[i] -= isupper (tmpaddr[i]) ? 'A' - 10 : 'a' - 10;
    }
    for (qname6 = qname, i = 0; i < 8; i += 2) {
	tmp = tmpaddr[i] + 16 * tmpaddr[i + 1];
	len = snprintf (qname6 + 1, 4, "%d", tmp);
	*qname6 = len;
	qname6 += len + 1;
    }
    strcpy (qname6, "\007in-addr\004arpa\0");

    return;
}

/*
 * same routines as above, but for bitstring label + ip6.arpa cases.
 * We assume qname has already been validated.
 */
int conv_trick_is_tot_newptr (u_char *qname, struct in6_addr *a6p) {
	int i;
	const int cmpsiz = sizeof(struct in6_addr) - sizeof(struct in_addr);
	static int ip6len = 0, arpalen = 0;

	if (ip6len == 0)
		ip6len = strlen("IP6");
	if (arpalen == 0)
		arpalen = strlen("ARPA");

	if (!T.prefixnum)
		return 0;

	/* we cosider "\[x.../128].ip6.arpa." only */
	if (*qname != EDNS0_ELT_BITLABEL || *(qname + 1) != 128)
		return(0);
	memcpy(a6p, qname + 2, sizeof(*a6p));
	qname += (2 + sizeof(struct in6_addr)); /* ELT + bitlen + address */
	if (*qname != ip6len || strncasecmp(qname + 1, "IP6", ip6len) != 0)
		return(0);
	qname += 4;
	if (*qname != arpalen || strncasecmp(qname + 1, "ARPA", arpalen) != 0)
		return(0);
	qname += (sizeof("ARPA") + 1);
	if (*qname != '\0')
		return(0);

	/* name is OK. */
	for (i = 0; i < T.prefixnum; i++) {
		if (memcmp(a6p, &T.tot_prefix[i], cmpsiz) == 0)
			return 1; /* got a match */
	}
	return 0;
}

void conv_trick_newptr_rq (u_char * qname, struct in6_addr *a6) {
    int len, i;

    /* since the size of qname6 is MAX_DNAME, we have enough size to copy. */
    for (i = 0; i < 4; i++) {
	    len = snprintf(qname + 1, 4, "%d", a6->s6_addr[15 - i]);
	    *qname = len;
	    qname += len + 1;
    }
    strcpy (qname, "\007in-addr\004arpa\0");

    return;
}
