/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: conv_stf.c,v 3.6 2000/12/12 20:44:49 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: conv_stf.c,v 3.6 2000/12/12 20:44:49 dillema Exp $");

RRset *conv_stf_owner_rrset (RRset *rrs) {
        const char *fn = "conv_stf_owner_rrset()";
	char owner[MAX_DNAME], *own, *ostop, *op;
	int owner_len, i, val;
	RRset *rrs_new;
	RR_List *rrl = NULL;
	char buf[4];

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	if (rrs->key.info->r_type == RT_SOA || rrs->key.info->r_type == RT_NS) {
		/* parse resource record set */
		rrl = rr_list_of_rrset (rrs);
		if (rrl) {
			own = rrset_key_info_owner (rrs);
			ostop = strstr(own, "\007IN-ADDR\004ARPA");
			if (!ostop)
				ostop = strstr(own, "\007in-addr\004arpa");
			if (!ostop) {
				/* not something we can handle here, so don't modify just copy */
				owner_len = rrs->key.info->owner_len;
				memcpy(owner, own, owner_len);
				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: not a v4 PTR name %s", fn, owner));
				}
			} else {
				op = owner;
				while (own < ostop) {
					for (i = 0; i < *own; i++)
			                	buf[i] = *(own + i + 1);
                			buf[i] = '\0';
                			sscanf(buf, "%u", &val);
					snprintf(buf, sizeof(buf), "%02x", val & 0xff);
					*op = *(op+2) = '\1'; 	/* length: one nybble is one character */
					*(op+1) = buf[1]; /* least sign. nybble first */
					*(op+3) = buf[0]; /* most sig. nybble */
					op += 4;
					own += *own + 1; 
				}
				sprintf(op, "%s", "\0012\0010\0010\0012\003ip6\003int");
				op += 17; /* point to end (after null char) */
				owner_len = op - owner;

				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: converted PTR %s", fn, owner));
				}
			}
			
			/* assemble new rrset */
			rrs_new = rrset_create (rrs->key.info->r_type, rrs->key.info->r_class, owner_len, owner, rrl);
		}
	}

	if (rrl)
		rr_list_free (rrl);

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return", fn));
	}
	return (rrs_new);
}

void conv_stf_ns_list (G_List *rrsl) {
        const char *fn = "conv_stf_ns_list()";
        RRset *rrsp, *rrsp_tmp;
	G_List *gl_tmp;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start.\n", fn));
	}

	rrsp_tmp = NULL;
	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrsp = (RRset *) gl_tmp->list_data;
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: type %d\n", fn, rrsp->key.info->r_type));
		}
		if (rrsp->key.info->r_type == RT_SOA) 
			rrsp_tmp = conv_stf_owner_rrset (rrsp);
		if (rrsp->key.info->r_type == RT_NS)
			rrsp_tmp = conv_stf_owner_rrset (rrsp);
		if (rrsp_tmp) {
			rrset_free (rrsp);
			gl_tmp->list_data = rrsp_tmp;
			rrsp_tmp = NULL;
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	}

	return;
}

int conv_stf_ptr (u_char *qname, int qname_len) {
        const char *fn = "conv_stf_ptr()";
	u_char qname4[MAX_DNAME];
	u_char *qn6, *qn4;
	int val;
#define STF_PREFIX "2002"
#define STF_BYTES 2
        const int off = sizeof(struct in_addr) + STF_BYTES; 

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start.\n", fn));
	}

	if (qname_len < 8 || qname_len > MAX_DNAME) 
		return -1;

	qn4 = qname4;
	qn6 = qname + qname_len - off*4 - 8;
	if (qn6 < qname)
		qn6 = qname + 1;

	while (qn6 < qname + qname_len - STF_BYTES*4 - 8) {
                if (isdigit(*qn6))
			val = *qn6 - '0';
                else if (isalpha(*qn6))
                        val = *qn6 - (isupper(*qn6) ? 'A' - 10 : 'a' - 10);
		qn6++;

		if (*qn6 != 1) return -1;
		qn6++;

                if (isdigit(*qn6))
			val += 16 * (*qn6 - '0');
                else if (isalpha(*qn6))
                        val += 16 * (*qn6 - (isupper(*qn6) ? 'A' - 10 : 'a' - 10));
		qn6++;

		if (*qn6 != 1) return -1;
		qn6++;
 
		*qn4 = snprintf(qn4 + 1, 4, "%u", val & 0xff);
		qn4 = qn4 + *qn4 + 1;
	}
	sprintf(qn4, "%s", "\7in-addr\4arpa");
	memcpy(qname, qname4, MAX_DNAME);

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: converted name %s", fn, qname));
		DX (syslog (LOG_DEBUG, "%s: return", fn));
	}

	return 0;
}

/* 
 * returns 1 if netprefix of qname equals stf prefix, else returns 0
 */
int conv_stf_is_stf_ptr (u_char *qname) {
	u_char *qname6;

	/* first check it's a PTR name, if not return 0 */
	if (!(strstr(qname, "INT") || strstr(qname, "int")))
		return 0;

	qname6 = strstr(qname, "IP6");
	if (!qname6)
		qname6 = strstr(qname, "ip6");
	if (!qname6)
		return 0;

	qname6 = qname6 - 2;

	if (*qname6-- != '2')
		return 0;
	if (*qname6-- != 1)
		return 0;
	if (*qname6-- != '0')
		return 0;
	if (*qname6-- != 1)
		return 0;
	if (*qname6-- != '0')
		return 0;
	if (*qname6-- != 1)
		return 0;
	if (*qname6-- != '2')
		return 0;
	if (*qname6-- != 1)
		return 0;
	return 1; /* we matched 0x2002 */
}

