/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/
/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: context_var.h,v 3.12 2000/09/06 20:28:35 dillema Exp $>
 */

#ifndef CONTEXT_VAR_H
#define CONTEXT_VAR_H

/* transaction types */
#define CTYPE_NULL 0
#define CTYPE_TCP_REQUEST 1
#define CTYPE_TCP_RESPONSE 2
#define CTYPE_UDP_REQUEST 3
#define CTYPE_UDP_RESPONSE 4

typedef struct cons_query {
	jmp_buf jb;
}   Cos_Query;

/* structure to hold context */
typedef struct context {
	struct context *parent;	/* <- paernt context */
	struct context *child;	/* <- child context */
	int type;		/* <- transaction type */
	int current_state;	/* <- state in the transaction */
        int current_ns;
        int current_glue;
        RRset *ns;
        RRset *ns_glue;
	union {
		void *p;
		Cos_Query *cq;
		Cos_TCP_Response *t_res;
		Cos_UDP_Response *u_res;
		Cos_Request *request;
	}   param;		/* <- paramaters for each transaction type */
	union {
		Mesg_Hdr *hdr;	/* <- message header */
		u_char *p;	/* <- buffer pointer */
	} mesg;
	u_char *wp;		/* <- writing pointer */
	int mesg_len;		/* <- length of the buffer */
	u_char *qname;		/* <- alloc'ed */
	int qname_len;		/* <- length of qname */
	u_int16_t q_class;	/* <- class of query */
	u_int16_t q_type;	/* <- type of query */
	u_int32_t q_id;		/* <- id for this transaction */
	G_List *an_list;	/* <- answer list */
	G_List *ns_list;	/* <- nameserver list */
	G_List *ar_list;	/* <- additional record list */
	struct ev_to_data *tout;/* <- timeout pointer (XXXwhy can't be
				 * typedef'ed?) */
	int (*process) (struct context *ctx);	/* proceed the state */
	int (*retry) (struct context *ctx);	/* timeout and retry */

	int cname_links;	/* number of cname links (limits by config.h) */
}   Context;

#endif				/* CONTEXT_VAR_H */
