/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_udp_response.c,v 3.31 2001/03/13 11:14:43 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_udp_response.c,v 3.31 2001/03/13 11:14:43 dillema Exp $");

int cos_udp_response_start (u_char *mesg_buf, int mesg_len, struct sockaddr *sa_p, int sa_len, NI_List *inif) {
	const char *fn = "cos_udp_response_start()";
	Context *cont;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* create context */
	cont = context_create(CTYPE_UDP_RESPONSE);
	if (!cont)
		return (cos_udp_response_abort (cont, -1));

	cont->mesg.p = mesg_buf;
	cont->mesg_len = mesg_len;
	cont->wp = mesg_buf + mesg_len;	/* just after the answer section */
	cont->q_id = cont->mesg.hdr->id;
	cont->param.u_res->inif = ni_copy (inif);
	memcpy (cont->param.u_res->sa_p, sa_p, sa_len);
	cont->param.u_res->sa_len = sa_len;

	if (cont->mesg.hdr->opcode == OP_QUERY) {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: OPCODE = OP_QUERY", fn));
		}

		/* query-response specific variables */
		cont->process = cos_udp_response_waiting_recursive_process;
		cont->retry = cos_udp_response_waiting_recursive_retry;

		switch (cos_common_start_rq (cont, QUERY_TCP)) {
		case 0:
			/* We got a response */
			return (0);
		case 1:
			/* Something wrong with the query */
			cont->mesg.hdr->rcode = RC_FMTERR;
			return (cos_udp_response_finish (cont));
		default:
			/* We failed ourselves somehow */
			cont->mesg.hdr->rcode = RC_SERVERERR;
			return (cos_udp_response_finish (cont));
		}
	} else {
		syslog (LOG_NOTICE, "%s: OPCODE = unknown(%d)", fn, cont->mesg.hdr->opcode);
		cont->mesg.hdr->rcode = RC_NIMP;
		return cos_udp_response_finish (cont);
	}

	/* NOTREACHED */
	return 0;
}

int cos_udp_response_waiting_recursive_process (Context *cont) {
	switch (cos_common_waiting_recursive_process (cont)) {
	case 0:
		/* continue */
		return 0;
	case 1:
		/* finished */
		return cos_udp_response_finish (cont);
	default:
		/* failed */
		return cos_udp_response_abort (cont, 0);
	}
}

int cos_udp_response_waiting_recursive_retry (Context *cont) {
	printf ("cos_udp_response_waiting_recursive_retry(): should not be called.");
	return cos_udp_response_abort (cont, 0);
}

int cos_udp_response_abort (Context * cont, int status) {
        DX(const char *fn = "cos_udp_response_abort()";)

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s", fn));
	}

	context_destroy (cont);
	return status;
}

int cos_udp_response_finish (Context * cont) {
        DX(const char *fn = "cos_udp_response_finish()";)
	int len, qlen;
	u_char *ucp, *qname;
	u_int16_t us;
	struct in6_addr a6;
	
	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* assemble the answer */
	if (cont->mesg.hdr->rcode == RC_OK && cont->an_list && cont->ns_list && cont->ar_list) {
                ucp = qname = cont->mesg.p + sizeof (Mesg_Hdr);
		ucp = mesg_skip_dname (ucp, cont->mesg.p + cont->mesg_len);
		qlen = ucp - qname;
		GETSHORT (us, ucp);

		if (us == RT_AAAA && cont->q_type == RT_A) {
			conv_trick_list (cont->an_list);
			conv_trick_list (cont->ns_list);
			conv_trick_list (cont->ar_list);
                        T.current_prefix = (T.current_prefix + 1) % T.prefixnum; /* circulate through prefixes */
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: query for AAAA changed into query for A", fn));
			}
		}
		else if (us == RT_A6 && cont->q_type == RT_A) {
			conv_trick_list_a6(cont->an_list);
			conv_trick_list_a6(cont->ns_list);
			conv_trick_list_a6(cont->ar_list);
			/* circulate through prefixes */
                        T.current_prefix =
				(T.current_prefix + 1) % T.prefixnum;
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: query for A6 changed into query for A", fn));
			}
		}
		else if (us == RT_PTR && conv_trick_is_tot_ptr (qname)) {
			conv_trick_ptr (cont->an_list, qname);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted PTR response", fn));
			}
		}
		else if (us == RT_PTR && conv_trick_is_tot_newptr(qname,
								  &a6)) {
			conv_trick_newptr(cont->an_list, qname, qlen);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted PTR response", fn));
			}
		}
		else if (us == RT_MX) {
			/* rewrite the additional section (if necessary) */
			conv_trick_list(cont->ar_list);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted MX response", fn));
			}
			/* circulate through prefixes */
			T.current_prefix =
				(T.current_prefix + 1) % T.prefixnum;
		}
#ifdef SCOPED_REWRITE
		else if (us == RT_AAAA && T.scoped_prefixes &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
			conv_scoped_list(cont->an_list);
			conv_scoped_list(cont->ns_list);
			conv_scoped_list(cont->ar_list);
			if (T.debug > 1) {
                        	DX (syslog (LOG_DEBUG, "%s: checked whether to rewrite global into scoped address", fn));
			}
		}
		else if (us == RT_PTR && conv_is_scoped_ptr(qname, 1) != -1 &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
			conv_scoped_ptr(cont->an_list, qname);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted query name: %s", fn, qname));
			}
		}
#endif
#ifdef STF
		else if (T.stf && cont->child->q_type == RT_NS && us == RT_NS && conv_stf_is_stf_ptr (qname)) {
			/* 
		  	 * If the original request was for a nameserver record, the 
		 	 * query-name was a 6to4 address, and finally what we got 
		 	 * here in response is a nameserver record for the
		 	 * corresponding IPv4 address instead, then we transform it
		 	 * into a nameserver pseudo-record here for the 6to4 address.
		 	 * This pseudo-record is marked non-authorative. 
			*/

			/* mark non-authorative */
			cont->child->mesg.hdr->aa = 0;
			conv_stf_ns_list(cont->an_list);
			conv_stf_ns_list(cont->ns_list);
			conv_stf_ns_list(cont->ar_list);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: Converted NS record for 6to4 NS query: %s", fn, qname));
			}
		}
#endif

		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: assemble response message to send", fn));
		}
		len = mesg_assemble (NULL, cont->an_list, cont->ns_list, cont->ar_list,
			       cont->mesg.p, MAX_PACKET, cont->mesg_len);
		if (len < 0) {
			syslog (LOG_WARNING, "failed to make up a response message.");
			return (cos_udp_response_abort (cont, 1));
		}
	} else
		len = cont->mesg_len;

	/* failsafe */
	cont->mesg.hdr->qr = 1; /* this is a response (not a query) */
	cont->mesg.hdr->ra = 1; /* recursion is available, right? */

	/* copy AA and RCODE from child context */
	if (cont->mesg.hdr->rcode == RC_OK && cont->child) {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: We did OK, and a child response exists", fn));
		}
		cont->mesg.hdr->rcode = cont->child->mesg.hdr->rcode;
		cont->mesg.hdr->aa = cont->child->mesg.hdr->aa;
	}

	/* send the answer */
	if (net_mesg_send (cont->param.u_res->inif, cont->mesg.p, len,
			   cont->param.u_res->sa_p) < len) {
		syslog (LOG_NOTICE, "failed to send message.");
		return (cos_udp_response_abort (cont, -1));
	}

        /* free all resources */
        context_destroy (cont);

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: reply has been sent; request completed", fn));
	}
	/* SUCCESS */
	return 0;
}
