/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * forward.c
 * <$Id: forward.c,v 3.16 1999/11/22 18:29:11 feico Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: forward.c,v 3.16 1999/11/22 18:29:11 feico Exp $");

void fwd_free (Fwd * fwd_ptr)
{
    if (fwd_ptr) {
	if (fwd_ptr->sa)
	    free (fwd_ptr->sa);
	
	free (fwd_ptr);
    }
    return;
}

void fwd_freev (void *fwd_p)
{
	fwd_free ((Fwd *) fwd_p);
	return;
}

Fwd *fwd_alloc (struct sockaddr * sa, int sa_len)
{
	Fwd *fwd_p = NULL;	/* alloc'ed */
	char *fn = "fwd_alloc()";

	fwd_p = malloc (sizeof (Fwd));
	if (!fwd_p) {
		syslog (EM_F (EM_F_MEMEX), fn);
		goto error;
	}
	fwd_p->sa = malloc (sa_len);
	if (!fwd_p->sa) {
		syslog (EM_F (EM_F_MEMEX), fn);
		goto error;
	}
	memcpy (fwd_p->sa, sa, sa_len);
	fwd_p->sa_len = sa_len;
	fwd_p->xretry = 1;
	fwd_p->went_down_at = 0;

	return fwd_p;

error:
	fwd_free (fwd_p);
	return NULL;
}

void fwd_init (void)
{
	char *fn = "fwd_init()";
	DX (syslog (LOG_DEBUG, "%s: start()\n", fn));

	if (T.Fwd_list) {
		syslog (LOG_ERR, "%s: already initialized (maybe program error)\n", fn);
		return;
	}
	T.Fwd_list = list_init ();
	if (!T.Fwd_list) {
		syslog (EM_F (EM_F_MEMEX), fn);
		return;
	}
	T.Fwd_list->list_data = NULL;

	return;
}

void fwd_finish (void)
{

	DX (syslog (LOG_DEBUG, "fwd_finish(): start\n"));

	/* free all resources */
	if (T.Fwd_list)
		list_destroy (T.Fwd_list, fwd_freev);

	T.Fwd_list = NULL;
	return;
}

int fwd_add (struct sockaddr * sa, int sa_len)
{
	Fwd *fwd_p;

	DX (syslog (LOG_DEBUG, "fwd_add(): start\n"));

	/* XXX #warning fwd_add(): does not care duplicated registration */

	if (!T.Fwd_list)
		return -1;


	fwd_p = fwd_alloc (sa, sa_len);
	if (!fwd_p)
		return -1;

	if (list_add_tail (T.Fwd_list, fwd_p) < 0) {
		fwd_free (fwd_p);
		return -1;
	}
	return 0;
}

int fwd_del (struct sockaddr * sa, int sa_len)
{
	DX (char *fn = "fwd_del()";)
	G_List *gl_tmp;
	Fwd *fwd_tmp;
	int found = 0;

	DX (syslog (LOG_DEBUG, "%s: start.\n", fn));

	if (!T.Fwd_list) {
		DX (syslog (LOG_DEBUG, "%s: not initialized.\n", fn));
		return -1;
	}
	for (gl_tmp = T.Fwd_list->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		fwd_tmp = (Fwd *) (gl_tmp->list_data);
		if ((fwd_tmp->sa_len == sa_len)
		    && (memcmp (fwd_tmp->sa, sa, sa_len) == 0)) {
			/* matched record */
			fwd_freev (list_delete (gl_tmp));
			found++;
		}
	}

	if (found > 0) {
		if (T.Fwd_list->next == T.Fwd_list) {
			/* no other records */
			DX (syslog (LOG_ERR, "%s: no forwarders, automatically stopping.\n", fn));
			return -1;
		}
		return 0;
	} else {
		DX (syslog (LOG_INFO, "%s: not found.\n", fn));
		return -1;
	}
}

void fwd_select (void)
{
	DX (char *fn = "fwd_select";)
	DX (syslog (LOG_DEBUG, "%s: start()\n", fn));

	if (!T.Fwd_list)
		return;

	if (!T.current_fwd) {
	    /* No forwarder selected yet, just pick first one */
	    T.current_fwd = T.Fwd_list->next;
            if (T.debug)	
	    	fprintf(stderr, "Current forwarder %s.\n", sprint_inet(((Fwd *)T.current_fwd->list_data)->sa));
	}
	else if (T.current_fwd != T.Fwd_list->next) {
	    /* 
	     * We're not using the first nameserver listed 
	     * Let's check, whether it's time to try to switch 
	     * back to an earlier nameserver.
	     */
	    time_t current_time = time(NULL);
	    G_List *fwd_tmp = T.current_fwd->prev;
	    while (fwd_tmp->list_data) {
		time_t waittime = (current_time - ((Fwd *)fwd_tmp->list_data)->went_down_at);
		time_t downtime = (time_t) (((Fwd *)fwd_tmp->list_data)->xretry * T.retry_interval);
		if (waittime > downtime) {
		    /* waited long enough, let's try again! */
		    if (T.debug)
			fprintf(stderr, "Switching back to earlier forwarder %s.\n",
                        	sprint_inet(((Fwd *)fwd_tmp->list_data)->sa));	
		    syslog (LOG_INFO, "Switching back to earlier forwarder %s.",
			    sprint_inet(((Fwd *)fwd_tmp->list_data)->sa));
		    T.current_fwd = fwd_tmp;
		    ((Fwd *)fwd_tmp->list_data)->xretry++;
		}
		fwd_tmp = fwd_tmp->prev;
	    }
	}

	DX (syslog (LOG_DEBUG, "%s: end()\n", fn));
	return;
}

int fwd_select_next (void)
{
	DX(char *fn = "fwd_select_next";)
	DX (syslog (LOG_DEBUG, "%s: start()\n", fn));

	if (!T.Fwd_list)
		return -1;

	if (!T.current_fwd) {
		/* No forwarder selected yet, just pick first one */
		T.current_fwd = T.Fwd_list->next;
	}
	else if (T.current_fwd->next->list_data) {

		/* first record that the current NS is down at this point in time */
		((Fwd *)T.current_fwd->list_data)->went_down_at = time(NULL);
		syslog (LOG_WARNING, "Switching from forwarder %s to %s.", 
			sprint_inet(((Fwd *)T.current_fwd->list_data)->sa), 
			sprint_inet(((Fwd *)T.current_fwd->next->list_data)->sa));
		T.current_fwd = T.current_fwd->next;
	}
	else { 	/* No more left to try, go and try from the start again then */
		if (T.current_fwd == T.current_fwd->next->next) {
			syslog (LOG_ERR, "Forwarder %s down or unreachable, no backup.",
				sprint_inet(((Fwd *)T.current_fwd->list_data)->sa));
			((Fwd *)T.current_fwd->list_data)->went_down_at = 0;
			return 1;
		}
		else {
		        G_List *fwd_tmp = T.Fwd_list->next;
			/* mark all forwarders alive again */
			while (fwd_tmp->list_data) {
			        ((Fwd *) fwd_tmp->list_data)->went_down_at = 0;
				fwd_tmp = fwd_tmp->next;
			}
			syslog (LOG_ERR, "No forwarders seem to be alive and responding.");
			return 1;
		}
	}
	if (T.debug)
		fprintf(stderr, "Current forwarder %s.\n", sprint_inet(((Fwd *)T.current_fwd->list_data)->sa));
	DX (syslog (LOG_DEBUG, "%s: end()\n", fn));
	return 0;
}

char *sprint_inet(struct sockaddr *sa) 
{
    static char address_str[MAXHOSTNAMELEN];
#ifdef USE_INET4
    if (sa->sa_family == AF_INET) {
	struct sockaddr_in *sin_p = (struct sockaddr_in *) sa;
	inet_ntop(sin_p->sin_family, (void *) &sin_p->sin_addr, address_str, MAXHOSTNAMELEN);
    }
#endif
#ifdef USE_INET6
    if (sa->sa_family == AF_INET6) {
	struct sockaddr_in6 *sin6_p = (struct sockaddr_in6 *) sa;
	inet_ntop(sin6_p->sin6_family, (void *) &sin6_p->sin6_addr, address_str, MAXHOSTNAMELEN);
    }
#endif
    return address_str;
}
