/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: conv_trick.c,v 3.18 2000/04/02 12:35:26 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: conv_trick.c,v 3.18 2000/04/02 12:35:26 dillema Exp $");

RRset *conv_trick_rrset (RRset * rrs_a, int pref)
{
	RR_List *rrl, *rrl_tmp;
	RRset *ret_val, *rrs_aaaa;
	RR *rr_a, *rr_aaaa;
	u_char *rd, *rd_aaaa;

	DX (syslog (LOG_DEBUG, "conv_trick_rrset: start\n"));
	if (!T.prefixnum) {
	    ret_val = NULL;
	    goto finish;
	}

	if (rrs_a->key.info->r_type != RT_A) {
		ret_val = NULL;
		goto finish;
	}
	/* parse A rrset */
	rrl = rr_list_of_rrset (rrs_a);
	if (!rrl) {
		ret_val = NULL;
		goto finish;
	}
	/* convert each RR_List data */
	for (rrl_tmp = rrl; rrl_tmp->next; rrl_tmp = rrl_tmp->next) {
		rr_a = rrl_tmp->rrp;
		rrl_tmp->rrp = NULL;	/* kept in rr_a */
		rd = rr_rdata (rr_a);

		rd_aaaa = malloc (16);
		if (!rd_aaaa) {
			ret_val = NULL;
			goto finish;
		}
		memcpy (rd_aaaa, T.tot_prefix[pref], 12);
		memcpy (rd_aaaa + 12, rd, 4);

		rr_aaaa = rr_alloc (rr_a->ttl, 16, rd_aaaa);
		if (!rr_aaaa) {
			ret_val = NULL;
			goto finish;
		}
		free (rd_aaaa);
		rd_aaaa = NULL;	/* kept in rr_aaaa */
		rrl_tmp->rrp = rr_aaaa;
		rr_aaaa = NULL;	/* kept in rrl_tmp->rrp */

		rr_free (rr_a);
		rr_a = NULL;
	}

	/* assemble AAAA rrset */
	rrs_aaaa = rrset_create (RT_AAAA, rrs_a->key.info->r_class,
				 rrs_a->key.info->owner_len,
				 rrset_key_info_owner (rrs_a), rrl);
	if (!rrs_aaaa) {
		ret_val = NULL;
		goto finish;
	}
	/* set return value */
	ret_val = rrs_aaaa;
	rrs_aaaa = NULL;	/* kept in ret_val */
finish:

	if (rrs_aaaa)
		rrset_free (rrs_aaaa);
	if (rr_a)
		rr_free (rr_a);
	if (rr_aaaa)
		rr_free (rr_a);
	if (rrl)
		rr_list_free (rrl);
	if (rd_aaaa)
		free (rd_aaaa);

	DX (syslog (LOG_DEBUG, "conv_trick_rrset: return\n"));
	return ret_val;
}

void conv_trick_list (G_List * rrsl)
{
        RRset *rrsp, *rrsp_aaaa;
	G_List *gl_tmp;

	DX (syslog (LOG_DEBUG, "conv_trick_list: start.\n"));

	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrsp = (RRset *) gl_tmp->list_data;
		if (rrsp->key.info->r_type == RT_A) {
		    /* convert A record into faked AAAA record */
			rrsp_aaaa = conv_trick_rrset (rrsp, T.current_prefix);
			if (!rrsp_aaaa) {
				syslog (LOG_ERR, "Can't convert A to AAAA\n");
			} else {
				rrset_free (rrsp);
				gl_tmp->list_data = rrsp_aaaa;
				rrsp_aaaa = NULL;
			}
		}
	}

	DX (syslog (LOG_DEBUG, "conv_trick_list: return\n"));
	return;
}

void conv_trick_ptr (G_List * rrsl, u_char *qname)
{
	G_List *gl_tmp;
	U_Key rk, rk_new;

	DX (syslog (LOG_DEBUG, "conv_trick_ptr: start.\n"));

	if (!T.prefixnum) {
	    syslog (LOG_ERR, "No tot prefix configured!\n");
	    return;
	}

	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rk = ((RRset *) gl_tmp->list_data)->key;
		if (rk.info->r_type == RT_PTR) {
		    /* convert PTR record from in-addr.arpa to ip6.int */
		    rk_new.p = malloc (KEYINFO_HEAD_LEN + strlen(qname) + 1);
		    if (!rk_new.p) {
			syslog (LOG_ERR, "Out of memory!\n");
		    }
		    else {
			rk_new.info->r_type = RT_PTR;
			rk_new.info->r_class = C_IN;
			strcpy(rk_new.p+KEYINFO_HEAD_LEN, qname);
			free (rk.p);
			((RRset *) gl_tmp->list_data)->key= rk_new;
		    }
		}
	}

	DX (syslog (LOG_DEBUG, "conv_trick_ptr: return\n"));
	return;
}

int conv_trick_conf (u_char * v6addr)
{
	u_char prefix_tmp[TOTPREFIXLEN + 1];
	int i, j;
	const int off = sizeof(struct in6_addr) - sizeof(struct in_addr);
	char x[3];

	if (T.prefixnum < MAXPREFIXES) {
		if (inet_pton (AF_INET6, v6addr, T.tot_prefix[T.prefixnum]) != 1) {
                	syslog (LOG_ERR, "invalid format: prefix %s", v6addr);
			return (-1);
		}

		memset(prefix_tmp, 0, sizeof(prefix_tmp));
		for (i = 0; i < off; i++) {
			j = (off - 1) - i;
			snprintf(x, sizeof(x), "%02x",
			    T.tot_prefix[T.prefixnum][i] & 0xff);
			prefix_tmp[j * 2 + 0] = x[1];
			prefix_tmp[j * 2 + 1] = x[0];
		}

		DX (syslog (LOG_DEBUG, "conv_trick_conf: %s\n", v6addr));
		return (0);
	}
	else {
		syslog (LOG_ERR, "conv_trick_conf: max number of %d prefixes exceeded", MAXPREFIXES);
		return (-1);
	}
}

/* 
 * returns 0 if netprefix of qname equals one of tot prefixes, else returns 1
 */
int
conv_trick_is_tot_ptr(qname)
	u_char *qname;
{
	u_char *qname6, *q6;
	int i;
	struct in6_addr a6;
	char *p;
	unsigned int val;
	char buf[3];
	const int cmpsiz = sizeof(struct in6_addr) - sizeof(struct in_addr);

	if (T.prefixnum == 0)
		return 1;

	if (!(strstr(qname, "INT") || strstr(qname, "int")))
		return 1;
	qname6 = strstr(qname, "IP6");
	if (!qname6)
		qname6 = strstr(qname, "ip6");
	if (!qname6)
		return 1;

	memset(&a6, 0, sizeof(a6));
	qname6--;
	if (qname6 - qname != 64)
		return 1;
	qname6--;
	q6 = qname6;
	p = &a6.s6_addr[0];
	while (q6 - 4 >= qname) {
		buf[0] = *q6--;
		if (*q6-- != 1)
			return 1;
		buf[1] = *q6--;
		if (*q6-- != 1)
			return 1;
		buf[2] = '\0';
		sscanf(buf, "%x", &val);
		*p++ = val & 0xff;
	}

	for (i = 0; i < T.prefixnum; i++) {
		if (memcmp(&a6, &T.tot_prefix[i], cmpsiz) == 0)
			return 0;
	}
	return 1;
}


void conv_trick_ptr_rq (u_char * qname)
{
    u_char *qname6, tmpaddr[8];
    int len, i, tmp;

    len = 0;
    qname6 = qname;
    while (len < 8) {
	strncpy (tmpaddr + len, qname6 + 1, (int) *qname6);
	len += (int) *qname6;
	qname6 += ((int) *qname6) + 1;
    }
    for (i = 0; i < 8; i++) {
	if (isdigit (tmpaddr[i]))
	    tmpaddr[i] -= '0';
	else if (isalpha (tmpaddr[i]))
	    tmpaddr[i] -= isupper (tmpaddr[i]) ? 'A' - 10 : 'a' - 10;
    }
    for (qname6 = qname, i = 0; i < 8; i += 2) {
	tmp = tmpaddr[i] + 16 * tmpaddr[i + 1];
	len = snprintf (qname6 + 1, 4, "%d", tmp);
	*qname6 = len;
	qname6 += len + 1;
    }
    strcpy (qname6, "\007in-addr\004arpa\0");

    return;
}
