/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: context.c,v 3.8 1999/08/17 16:52:08 feico Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: context.c,v 3.8 1999/08/17 16:52:08 feico Exp $");

int context_timeout_handler (Ev_TO_Data * td)
{

	if (td->type != EV_TIMEOUT_CONTEXT) {
		return -1;
	}
	td->data.cont->tout = NULL;
	return td->data.cont->retry (td->data.cont);	/* call retry routine */
}

Ev_TO_Data *
    context_timeout_register (Context * cont, int timeout)
{
	const char *fn = "context_timeout_register()";
	Ev_TO_Data *edtp;


	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	if (cont->tout && cont->tout->handler) {
		syslog (LOG_INFO, "%s: duplicated timeout registration. ignore.\n", fn);
		return NULL;
	}
	edtp = malloc (sizeof (Ev_TO_Data));
	if (!edtp) {
		syslog (EM_F (EM_F_MEMEX), fn);
		return NULL;
	}
	edtp->at = time (NULL) + timeout;
	edtp->handler = context_timeout_handler;
	edtp->type = EV_TIMEOUT_CONTEXT;
	edtp->data.cont = cont;
	if (ev_to_register (edtp) < 0) {
		free (edtp);
		return NULL;
	}
	cont->tout = edtp;

	DX (syslog (LOG_DEBUG, "%s: scheduled in %d", fn, (int) edtp->at));

	return edtp;
}

void context_destroy (Context * cont)
{
	if (cont) {
		if (cont->parent)
			cont->parent->child = NULL;
		if (cont->child)
			cont->child->parent = NULL;
		if (cont->qname)
			free (cont->qname);

		if (cont->an_list)
			list_destroy (cont->an_list, rrset_freev);

		if (cont->ns_list)
			list_destroy (cont->ns_list, rrset_freev);
		if (cont->ar_list)
			list_destroy (cont->ar_list, rrset_freev);

		if (cont->mesg.p)
			free (cont->mesg.p);
		if (cont->tout)
			cont->tout->handler = NULL;

		switch (cont->type) {
		case CTYPE_TCP_REQUEST:
			cos_tcp_request_destroy (cont);
			break;
		case CTYPE_UDP_REQUEST:
			cos_udp_request_destroy (cont);
			break;
		case CTYPE_UDP_RESPONSE:
			cos_udp_response_destroy (cont);
			break;
		case CTYPE_TCP_RESPONSE:
			cos_tcp_response_destroy (cont);
			break;
		default:
			syslog (LOG_WARNING, "unknown context type %d on context_destroy()",
				cont->type);
			break;
		}

		free (cont);
	}
}
