/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_udp_request.c,v 3.17 2000/01/20 18:36:16 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_udp_request.c,v 3.17 2000/01/20 18:36:16 dillema Exp $");

int cos_udp_request_start (struct context *parent, u_char * qname,
		         int qname_len, u_int16_t r_class, u_int16_t r_type)
{
	char *fn = "cos_udp_request_start()";
	int len, status, sa_len;
	struct sockaddr *sa;
	Context *cont;

	DX (syslog (LOG_DEBUG, "%s: start", fn));
	status = 0;

	/* create new context */
	cont = malloc (sizeof (Context));
	if (!cont) {
		syslog (LOG_ERR, "%s: out of memory.", fn);
		status = -1;
		goto error;
	}
	memset (cont, 0, sizeof (Context));

	cont->an_list = list_init ();
	cont->qname = malloc (qname_len);
	cont->param.req = malloc (sizeof (Cos_Request));
	if (!cont->param.req || !cont->qname || !cont->an_list) {
		syslog (LOG_ERR, "%s: out of memory.", fn);
		status = -1;
		goto error;
	}
	cont->parent = parent;
	cont->parent->child = cont;
	cont->type = CTYPE_UDP_REQUEST;
	cont->current_state = COS_UDP_REQUEST_START;
	cont->param.req->retry = 0;
	cont->param.req->timeout = SEARCH_REMOTE_TIMEOUT;
	cont->param.req->p.u.peer.p = NULL;
	memcpy (cont->qname, qname, qname_len);
	cont->qname_len = qname_len;
	cont->q_class = r_class;
	cont->q_type = r_type;
	cont->q_id = mesg_id ();
	cont->process = cos_udp_request_sended_process;
	cont->retry = cos_udp_request_sended_retry;

	DX (syslog (LOG_DEBUG, "%s: constructing query.\n", fn));
	cont->mesg.p = malloc (MAX_PACKET);
	if (!cont->mesg.p) {
		syslog (LOG_ERR, "%s: out of memory.", fn);
		status = -1;
		goto error;
	}
	cont->wp = cont->mesg.p;
	cont->buf_len = MAX_PACKET;
	cont->mesg_len = mesg_make_query (qname, r_type, r_class, cont->q_id,
					  1, cont->mesg.p, cont->buf_len);
	if (cont->mesg_len < 0) {
		syslog (LOG_WARNING, "%s: cannot make query within a UDP datagram.", fn);
		status = 1;
		goto error;
	}
	DX (syslog (LOG_DEBUG, "%s: do forwarding.\n", fn));

	sa = ((Fwd *) T.current_fwd->list_data)->sa;
	sa_len = ((Fwd *) T.current_fwd->list_data)->sa_len;
	if (!sa) {
		syslog (LOG_ERR, "%s: no forwarders configured!", fn);
		status = -1;
		goto error;
	}
	cont->param.req->p.u.peer.sa = malloc (sa_len);
	if (!cont->param.req->p.u.peer.sa) {
		syslog (LOG_ERR, "%s: out of memory.", fn);
		status = -1;
		goto error;
	}
	memcpy (cont->param.req->p.u.peer.sa, sa, sa_len);

	DX (syslog (LOG_DEBUG, "%s: send query to selected forwarder.\n", fn));
	len = net_mesg_send (NULL, cont->mesg.p, cont->mesg_len, cont->param.req->p.u.peer.sa);
	if (len < cont->mesg_len) {
		if (len < 0)
			syslog (LOG_NOTICE, "%s: send failed(default / addrfam = %d): %m\n",
				fn, cont->param.req->p.u.peer.sa->sa_family);
		else
			syslog (LOG_NOTICE, "%s: can't send datagram.", fn);

		/* force retry routine */
		if (cont->param.req->p.u.peer.sa) {
			free (cont->param.req->p.u.peer.sa);
			cont->param.req->p.u.peer.sa = NULL;
		}
		/* put me to timeout list */
		if (context_timeout_register (cont, 0) < 0) {
			status = -1;
			goto error;
		}
		/* change state to sended */
		cont->current_state = COS_UDP_REQUEST_SENDED;

		DX (syslog (LOG_DEBUG, "%s: return 0(force retry);", fn));
		return 0;
	}
	/* put me to input list */
	status = ev_udp_in_register (cont, cont->param.req->p.u.peer.sa,
			  SOCKADDR_SIZEOF (*(cont->param.req->p.u.peer.sa)),
				     cont->q_id);
	if (status < 0)
		goto error;

	/* put me on timeout list */
	if (T.debug) 
	    fprintf (stderr, "Query will time out in %d seconds.\n", cont->param.req->timeout);
	if (!context_timeout_register (cont, cont->param.req->timeout)) {
		status = -1;
		goto error;
	}
	/* change state to sended */
	cont->current_state = COS_UDP_REQUEST_SENDED;

	DX (syslog (LOG_DEBUG, "%s: end", fn));
	return 0;
	/* NOTREACHED */

error:
	cos_udp_request_abort (cont);
	DX (syslog (LOG_DEBUG, "%s: end with error %d", fn, status));
	return status;
}

int cos_udp_request_sended_process (Context * cont)
{
	DX (char *fn = "cos_udp_request_sended_process()";)
	int status = 0;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* don't renew timeout, it automatically finish */
	if (cont->tout)
		cont->tout->handler = NULL;

	/* remove me from I/O list */
	status = ev_udp_in_remove (cont->param.req->p.u.peer.sa, cont->q_id);
	if (status < 0)
		goto error;

	/* no read -- assume ev_udp_in already put it in cont->mesg.p */

	DX (syslog (LOG_DEBUG, "%s: end by calling request_finish", fn));
	return cos_udp_request_finish (cont);

error:
	cos_udp_request_abort (cont);
	DX (syslog (LOG_DEBUG, "%s: end with error %d", fn, status));
	return status;
}

int cos_udp_request_sended_retry (Context * cont)
{
	DX (char *fn = "cos_udp_request_sended_retry()";)
	struct sockaddr *sa;
	int status, len, sa_len;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* remove old I/O List */
	if (cont->param.req->p.u.peer.sa) {
		status = ev_udp_in_remove (cont->param.req->p.u.peer.sa, cont->q_id);
		if (status < 0)
			goto error;
	}

	cont->param.req->retry++;
	cont->param.req->timeout = cont->param.req->timeout * 2;
	if (cont->param.req->retry >= SEARCH_REMOTE_RETRY) {
	    /* pick another forwarder, if no backup keep on trying for while but not to long */
	    if (fwd_select_next() && cont->param.req->retry < SEARCH_REMOTE_RETRY*2) {
		syslog (LOG_INFO, "Retry limit exceeded, and out of backup forwarders.");
		status = 1;
		goto error;
	    }
	    /* Note that we keep timout time high, even when we switched to backup */
	}

	if (T.debug) 
	    fprintf (stderr, "Retry %d of %d+%d will time out in %d seconds.\n", cont->param.req->retry + 1, SEARCH_REMOTE_RETRY, SEARCH_REMOTE_RETRY, cont->param.req->timeout);

	status = 0;
	do {
	        sa = ((Fwd *) T.current_fwd->list_data)->sa;
	        sa_len = ((Fwd *) T.current_fwd->list_data)->sa_len;
		if (!sa) {
			status = -1;
			goto error;
		}
		if (cont->param.req->p.u.peer.sa)
			free (cont->param.req->p.u.peer.sa);

		cont->param.req->p.u.peer.sa = malloc (sa_len);
		if (!cont->param.req->p.u.peer.sa) {
			status = -1;
			goto error;
		}
		memcpy (cont->param.req->p.u.peer.sa, sa, sa_len);

		status = 0;	/* important to avoid infinite loop */
		if (!cont->param.req->p.u.peer.sa) {
			syslog (LOG_INFO, "failed to send retry -- no more address left\n");
			status = 1;
		} else {
			/* retry sending */
			len = net_mesg_send (NULL, cont->mesg.p, cont->mesg_len, cont->param.req->p.u.peer.sa);
			if (len < cont->mesg_len) {
				if (len < 0)
					syslog (LOG_NOTICE, "retry failed(default socket): %m");
				else
					syslog (LOG_NOTICE, "can't send detagram.");
				status = -1;
			}
		}
	} while (status != 0);

	/* put me to input list */
	status = ev_udp_in_register (cont, cont->param.req->p.u.peer.sa,
			  SOCKADDR_SIZEOF (*(cont->param.req->p.u.peer.sa)),
				     cont->q_id);
	if (status < 0)
		goto error;

	/* put me to timeout list */
	if (!context_timeout_register (cont, cont->param.req->timeout)) {
		status = -1;
		goto error;
	}
	/* no state change... */

	DX (syslog (LOG_DEBUG, "%s: end", fn));
	return 0;

	/* NOTREACHED */

error:
	DX (syslog (LOG_DEBUG, "%s: error %d", fn, status));
	cos_udp_request_abort (cont);
	return status;
}


void cos_udp_request_destroy (Context * cont)
{
	DX (char *fn = "cos_udp_request_destroy";)
	DX (syslog (LOG_DEBUG, "%s: start", fn));

	if (cont)
		if (cont->param.req) {
			if (cont->param.req->p.u.peer.sa
			    && cont->param.req->p.u.peer.sa->sa_family)
				ev_udp_in_remove (cont->param.req->p.u.peer.sa, cont->q_id);
			if (cont->param.req->p.u.peer.p)
				free (cont->param.req->p.u.peer.p);

			free (cont->param.req);
		}
	DX (syslog (LOG_DEBUG, "%s: end", fn));
}

int cos_udp_request_abort (Context * cont)
{

	/*
	 * if parent exists, and the process is started successfully, process
	 * parent
	 */
	if (cont->current_state != COS_UDP_REQUEST_START && cont->parent) {
		cont->parent->child = NULL;	/* means child failed */
		cont->parent->process (cont->parent);
		cont->parent = NULL;
	}
	context_destroy (cont);
	return 0;
}

int cos_udp_request_finish (Context * cont)
{
	char *fn = "cos_udp_request_finish()";
	int status;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* parse answers */
	list_destroy (cont->an_list, rrset_freev);
	list_destroy (cont->ns_list, rrset_freev);
	list_destroy (cont->ar_list, rrset_freev);

	cont->an_list = list_init ();
	cont->ns_list = list_init ();
	cont->ar_list = list_init ();
	if (!cont->an_list || !cont->ns_list || !cont->ar_list) {
		syslog (LOG_ERR, "%s: can't recreate lists for parse answer data.", fn);
		status = -1;
		goto finish;
	}
	status = mesg_parse (cont->mesg.p, cont->mesg_len, cont->an_list,
			     cont->ns_list, cont->ar_list);
	if (status) {
		syslog (LOG_WARNING, "%s: can't parse answer data.", fn);
		goto finish;
	}
	/* if parent exists, process parent */
	/* --> acutually udp_request without parent is meaningless */
	if (cont->parent) {
		DX (syslog (LOG_DEBUG, "%s: process parent context", fn));
		cont->parent->process (cont->parent);
	}
finish:
	context_destroy (cont);
	DX (syslog (LOG_DEBUG, "%s: return %d", fn, status));
	return status;
}
