/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_tcp_response.c,v 3.16 2000/04/02 12:35:26 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_tcp_response.c,v 3.16 2000/04/02 12:35:26 dillema Exp $");

int cos_tcp_response_start (int sock, struct sockaddr * sa_p, int sa_len)
{
	const char *fn = "cos_tcp_response_start()";
	Context *cont = NULL;	/* alloc'ed */
	int status = 0;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	/* create context */
	cont = malloc (sizeof (Context));
	if (!cont) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	memset (cont, 0, sizeof (Context));

	cont->param.t_res = malloc (sizeof (Cos_TCP_Response));
	if (!cont) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	cont->type = CTYPE_TCP_RESPONSE;
	cont->current_state = COS_TCP_RESPONSE_READLEN;
	cont->process = cos_tcp_response_readlen_process;
	cont->retry = cos_tcp_response_readlen_retry;
	cont->mesg.p = NULL;
	cont->mesg_len = 0;
	cont->buf_len = 0;

	if (sa_p) {
		cont->param.t_res->sa_p = malloc (sa_len);
		if (!cont) {
			syslog (EM_F (EM_F_MEMEX), fn);
			status = -1;
			goto error;
		}
		memcpy (cont->param.t_res->sa_p, sa_p, sa_len);
		cont->param.t_res->sa_len = sa_len;
	} else {
		cont->param.t_res->sa_p = NULL;
		cont->param.t_res->sa_len = 0;
	}
	cont->param.t_res->conn_sock = sock;
	cont->param.t_res->timeout = COS_TCP_SRV_TIMEOUT;	/* good value? */

	if (context_timeout_register (cont, cont->param.t_res->timeout) < 0) {
		status = -1;
		goto error;
	}
	if (ev_tcp_conn_in_register (cont->param.t_res->conn_sock, cont) < 0) {
		status = -1;
		goto error;
	}
	return 0;

error:
	DX (syslog (LOG_DEBUG, "%s: return error(status = %d)\n", fn, status));

	cos_tcp_response_abort (cont);
	return status;
}

int cos_tcp_sub_assemble (Context * cont)
{
	const char *fn = "cos_tcp_sub_assemble()";
	int len;
	u_char *ucp, *qname;
	u_int16_t us;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	if (cont->an_list && cont->ns_list && cont->ar_list) {
		/* question section */
		ucp = qname = cont->mesg.p + sizeof (Mesg_Hdr);
		SKIP_DNAME (ucp);
		GETSHORT (us, ucp);

		if (us == RT_AAAA && cont->q_type == RT_A) {
			conv_trick_list (cont->an_list);
			conv_trick_list (cont->ns_list);
			conv_trick_list (cont->ar_list);
		        T.current_prefix = (T.current_prefix + 1) % T.prefixnum; /* circulate through prefixes */
			DX (syslog (LOG_DEBUG, "%s: query for AAAA changed into query for A", fn));
		}
		else if (us == RT_PTR && !conv_trick_is_tot_ptr (qname)) {
			conv_trick_ptr (cont->an_list, qname);
			DX (syslog (LOG_DEBUG, "%s: converted PTR response", fn));
		}
#ifdef SCOPED_REWRITE
                else if (us == RT_AAAA && T.scoped_prefixes &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
                        conv_scoped_list(cont->an_list);
                        conv_scoped_list(cont->ns_list);
                        conv_scoped_list(cont->ar_list);
			DX (syslog (LOG_DEBUG, "%s: checked whether to rewrite global into scoped address", fn));
                }
		else if (us == RT_PTR && conv_is_scoped_ptr(qname, 1) != -1 &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
			conv_scoped_ptr(cont->an_list, qname);
			DX (syslog (LOG_DEBUG, "%s: converted query name: %s", fn, qname));
		}
#endif /* SCOPED_REWRITE */
		len = mesg_assemble (cont->mesg.hdr, cont->an_list, cont->ns_list,
			   cont->ar_list, Cos_TCP_Buf, sizeof (Cos_TCP_Buf),
				     cont->mesg_len);
		if (len < 0) {
			syslog (LOG_WARNING, "failed to make up message(TCP response)\n");
			return -1;
		}
		if (cont->mesg.p)
			free (cont->mesg.p);
		cont->mesg.p = malloc (len);
		if (!cont->mesg.p) {
			syslog (EM_F (EM_F_MEMEX), fn);
			return -1;
		}
		memcpy (cont->mesg.p, Cos_TCP_Buf, len);
		cont->mesg_len = len;
	} else
		len = cont->mesg_len;

	DX (syslog (LOG_DEBUG, "%s: end\n", fn));
	return len;
}

int cos_tcp_response_readlen_process (Context * cont)
{
	const char *fn = "cos_tcp_response_readlen_process()";
	u_int16_t length_buf;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (context_timeout_register (cont, cont->param.t_res->timeout) < 0) {
		cos_tcp_response_abort (cont);
		return -1;
	}
	/* still use old input list -- data following */

	/* read length buffer */
	if (read (cont->param.t_res->conn_sock, (u_char *) (&length_buf),
		  sizeof (u_int16_t)) < sizeof (u_int16_t)) {
		syslog (LOG_NOTICE, "failed to read the length of TCP connection.\n");
		cos_tcp_response_abort (cont);
		return -1;
	}
	length_buf = ntohs (length_buf);
	DX (syslog (LOG_DEBUG, "%s: data length = %d\n", fn, length_buf));
	if (cont->mesg.p)
		free (cont->mesg.p);

	cont->buf_len = 0;
	cont->mesg_len = 0;
	cont->mesg.p = malloc (length_buf);
	if (!cont->mesg.p) {
		syslog (EM_F (EM_F_MEMEX), fn);
		cos_tcp_response_abort (cont);
		return -1;
	}
	cont->mesg_len = cont->buf_len = length_buf;
	cont->wp = cont->mesg.p;

	/* go next state */
	cont->process = cos_tcp_response_reading_process;
	cont->retry = cos_tcp_response_reading_retry;
	cont->current_state = COS_TCP_RESPONSE_READING;

	DX (syslog (LOG_DEBUG, "%s: return 0\n", fn));
	return 0;
}

/* readlen - retry */
int cos_tcp_response_readlen_retry (Context * cont)
{
	const char *fn = "cos_tcp_response_readlen_retry()";
	syslog (LOG_NOTICE, "%s: connection does not respond. closeing.\n",
		fn);
	cos_tcp_response_abort (cont);
	return -1;
}

int cos_tcp_response_reading_process (Context * cont)
{
	const char *fn = "cos_tcp_response_reading_process()";
	int status, len;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;
	if (context_timeout_register (cont, cont->param.t_res->timeout) < 0) {
		status = -1;
		goto error;
	}
	cont->an_list = list_init ();
	cont->ns_list = list_init ();
	cont->ar_list = list_init ();
	if (!cont->an_list || !cont->ns_list || !cont->ar_list) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	len = read (cont->param.t_res->conn_sock, cont->wp,
		    cont->buf_len - (cont->wp - cont->mesg.p));
	if (len <= 0) {
		syslog (LOG_NOTICE, "%s: read failed on TCP connection: %m", fn);
		status = -1;
		goto error;
	}
	cont->wp += len;

	if (cont->wp < (cont->mesg.p + cont->buf_len)) {
		DX (syslog (LOG_DEBUG, "%s: left %d bytes -- continue.",
			    fn, (cont->mesg.p + cont->buf_len) -cont->wp));
		return 0;	/* the processing continues ... */
	} else {
		/* all data has been read now */
		ev_tcp_conn_in_remove (cont->param.t_res->conn_sock);

		if (cont->mesg.hdr->opcode == OP_QUERY) {
			DX (syslog (LOG_DEBUG, "%s: OPCODE = OP_QUERY\n", fn));
			if (cont->tout)
				cont->tout->handler = NULL;
			/*
			 * don't register input list
			 * child context takes input
			 */

			if (cos_common_start_rq (cont, QUERY_TCP))
				goto writing;	/* can't go recursive, do
						 * return answer */
			goto waiting_recursive;	/* to continue recursive
						 * query */
		} else {
			syslog (LOG_NOTICE, "%s: OPCODE = unknown(%d)", fn, cont->mesg.hdr->opcode);
			cont->mesg.hdr->rcode = RC_NIMP;
			goto writing;
		}
	}

	/* NOTREACHED */
	abort ();		/* failsafe */

waiting_recursive:
	/* to go waiting_recursive state */
	/* clear events -- child process will call me then */
	if (cont->tout)
		cont->tout->handler = NULL;

	cont->process = cos_tcp_response_waiting_recursive_process;
	cont->retry = cos_tcp_response_waiting_recursive_retry;
	cont->current_state = COS_TCP_RESPONSE_WAITING_RECURSIVE;
	DX (syslog (LOG_DEBUG, "%s: end (waiting_recursive:) \n", fn));
	return 0;

writing:
	/* to go writing state */
	/* timeout already done in this func */
	/* register new output event */
	if (ev_tcp_out_register (cont->param.t_res->conn_sock, cont) < 0) {
		status = -1;
		goto error;
	}
	/* assemble the answers */
	cos_tcp_sub_assemble (cont);

	/* state change */
	cont->process = cos_tcp_response_writing_process;
	cont->retry = cos_tcp_response_writing_retry;
	cont->current_state = COS_TCP_RESPONSE_WRITING;
	cont->wp = NULL;	/* to write it from the first byte,
				 * initialize wp */
	DX (syslog (LOG_DEBUG, "%s: end (writing:) \n", fn));
	return 0;

error:
	cos_tcp_response_abort (cont);
	DX (syslog (LOG_DEBUG, "%s: end (error: %d) \n", fn, status));
	return status;
}

int cos_tcp_response_reading_retry (Context * cont)
{
	cos_tcp_response_abort (cont);
	return -1;
}

int cos_tcp_response_waiting_recursive_process (Context * cont)
{
	int status = 0;
	int len;

	switch (cos_common_waiting_recursive_process (cont)) {
	case 1:
		/* finished */

		/* copy query header to TCP_Buf */
		memcpy (Cos_TCP_Buf, cont->mesg.p, cont->mesg_len);

		/* assemble the answer */
		len = cos_tcp_sub_assemble (cont);

		/* register timeout */
		if (cont->tout)
			cont->tout->handler = NULL;
		if (context_timeout_register (cont, cont->param.t_res->timeout) < 0) {
			status = -1;
			goto error;
		}
		/* register output */
		if (ev_tcp_out_register (cont->param.t_res->conn_sock, cont) < 0) {
			status = -1;
			goto error;
		}
		/* copy child RCODE and AA */
		if (cont->mesg.hdr->rcode == RC_OK && cont->child != NULL) {
			cont->mesg.hdr->rcode = cont->child->mesg.hdr->rcode;
			cont->mesg.hdr->aa = cont->child->mesg.hdr->aa;
		}
		/* change the state */
		cont->current_state = COS_TCP_RESPONSE_WRITING;
		cont->process = cos_tcp_response_writing_process;
		cont->retry = cos_tcp_response_writing_retry;

		/* reset cont->wp to write it from the very first byte! */
		cont->wp = NULL;
		return 0;

	case 0:
		/* continue */
		return 0;
	default:
		/* failed */
		goto error;
	}

	/* NOTREACHED */

error:
	cos_tcp_response_abort (cont);

	return -1;
}

int cos_tcp_response_waiting_recursive_retry (Context * cont)
{
	cos_tcp_response_abort (cont);
	return -1;
}

int cos_tcp_response_writing_process (Context * cont)
{
#ifndef NDEBUG
	const char *fn = "cos_tcp_response_writing_process()";
#endif
	int status;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;
	if (context_timeout_register (cont, cont->param.t_res->timeout) < 0) {
		status = -1;
		goto error;
	}
	switch (cos_common_tcp_writemesg (cont, cont->param.t_res->conn_sock)) {
	case 0:
		/* continue this process */
		return 0;
	case 1:
		/* all data written */
		cont->current_state = COS_TCP_RESPONSE_WAITING_CLIENT_CLOSE;
		cont->process = cos_tcp_response_waiting_client_close_process;
		cont->retry = cos_tcp_response_waiting_client_close_retry;

		/* stop output and waiting for input */
		ev_tcp_out_remove (cont->param.t_res->conn_sock);
		ev_tcp_conn_in_register (cont->param.t_res->conn_sock, cont);

		return 0;
	default:
		status = -1;
		goto error;
	}

	/* NOTREACHED */

error:
	cos_tcp_response_abort (cont);
	return status;
}

int cos_tcp_response_writing_retry (Context * cont)
{
	cos_tcp_response_abort (cont);
	return -1;
}

int cos_tcp_response_waiting_client_close_process (Context * cont)
{
	const char *fn = "cos_tcp_response_waiting_client_close_process()";
	u_int16_t length_buf;
	int i;

	DX (syslog (LOG_DEBUG, "%s: start.\n", fn));

	i = read (cont->param.t_res->conn_sock, (u_char *) (&length_buf),
		  sizeof (u_int16_t));
	if (!i) {
		/* end of file .. */
		DX (syslog (LOG_DEBUG, "%s: read() EOF: finish the session.\n", fn));
		return cos_tcp_response_finish (cont);
	} else if (i < 0) {
		/* read error */
		syslog (LOG_INFO, "%s: read(): %m\n", fn);
		cos_tcp_response_abort (cont);
		return -1;
	} else if (i < sizeof (u_int16_t)) {
		/* error -- insufficient read */
		DX (syslog (LOG_DEBUG, "%s: read() == %d -- abort!\n", fn, i));
		cos_tcp_response_abort (cont);
		return -1;
	} else {
		/* redo query processing */
		length_buf = ntohs (length_buf);
		DX (syslog (LOG_DEBUG, "%s: find next upcoming buffer (length %d)\n",
			    fn, length_buf));

		/* re-initialize */
		if (cont->mesg.p)
			free (cont->mesg.p);

		cont->mesg_len = cont->buf_len = 0;
		cont->mesg.p = malloc (length_buf);
		if (!cont->mesg.p) {
			syslog (EM_F (EM_F_MEMEX), fn);
			cos_tcp_response_abort (cont);
			return -1;
		}
		cont->mesg_len = cont->buf_len = length_buf;
		cont->wp = cont->mesg.p;
		cont->param.t_res->timeout = COS_TCP_SRV_TIMEOUT;

		/* renew timeout */
		if (cont->tout)
			cont->tout->handler = NULL;
		if (context_timeout_register (cont, cont->param.t_res->timeout) < 0) {
			cos_tcp_response_abort (cont);
			return -1;
		}
		/* I/O event is not changed -- tcp_conn_in */
		/* go back to reading */
		cont->process = cos_tcp_response_reading_process;
		cont->retry = cos_tcp_response_reading_retry;
		cont->current_state = COS_TCP_RESPONSE_READING;

		DX (syslog (LOG_DEBUG, "%s: return 0\n", fn));
		return 0;
	}
}

int cos_tcp_response_waiting_client_close_retry (Context * cont)
{
#ifndef NDEBUG
	const char *fn = "cos_tcp_response_waiting_client_close_retry()";
#endif
	DX (syslog (LOG_DEBUG, "%s: start\n", fn));
	cos_tcp_response_abort (cont);
	DX (syslog (LOG_DEBUG, "%s: return\n", fn));
	return 0;
}

void cos_tcp_response_destroy (Context * cont)
{
	const char *fn = "cos_tcp_response_destroy()";

	if (cont) {
		if (cont->param.t_res) {
			if (cont->param.t_res->sa_p) {
				free (cont->param.t_res->sa_p);
				cont->param.t_res->sa_p = NULL;
			}
			if (cont->param.t_res->conn_sock >= 0) {
				shutdown (cont->param.t_res->conn_sock, 2);
				close (cont->param.t_res->conn_sock);

				switch (cont->current_state) {
				case COS_TCP_RESPONSE_READLEN:
				case COS_TCP_RESPONSE_READING:
				case COS_TCP_RESPONSE_WAITING_CLIENT_CLOSE:
					/*
					 * remove connected input socket event
					 */
					ev_tcp_conn_in_remove (cont->param.t_res->conn_sock);
					break;
				case COS_TCP_RESPONSE_WAITING_RECURSIVE:
					/*
					 * no registered input should exist...
					 */
					break;
				case COS_TCP_RESPONSE_WRITING:
					/*
					 * remove connected output socket event
					 */
					ev_tcp_out_remove (cont->param.t_res->conn_sock);
					break;
				default:
					syslog (LOG_ERR, "%s: unknown stat to destroy.\n", fn);
					break;
				}	/* switch */

			}	/* if(...conn_sock >= 0) */
			free (cont->param.t_res);
		}		/* if(t_res) */
	}
	return;
}

void cos_tcp_response_abort (Context * cont)
{
	DX (syslog (LOG_DEBUG, "cos_tcp_response_abort(): start.\n"));
	context_destroy (cont);
	return;
}

int cos_tcp_response_finish (Context * cont)
{
	context_destroy (cont);
	DX (syslog (LOG_DEBUG, "cos_tcp_response_finish(): context finished.\n"));
	return 0;
}
