/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_tcp_request.c,v 3.20 2000/01/20 18:36:16 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_tcp_request.c,v 3.20 2000/01/20 18:36:16 dillema Exp $");

int cos_tcp_request_start (struct context *parent, u_char * qname,
		         int qname_len, u_int16_t r_class, u_int16_t r_type)
{
	const char *fn = "cos_tcp_request_start()";
	Context *cont;
	int i, status;
        const int on = 1;
	int sock;
	struct sockaddr *sa;
	int sa_len;

	DX (syslog (LOG_DEBUG, "%s: start", fn));
	status = 0;

	cont = malloc (sizeof (Context));
	if (!cont) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto finish;
	}
	cont->param.req = malloc (sizeof (Cos_TCP_Request));
	if (!cont) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto finish;
	}
	cont->qname = malloc (qname_len);
	if (!cont) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto finish;
	}
	cont->an_list = list_init ();
	if (!cont->an_list) {
		status = -1;
		goto finish;
	}
	cont->parent = parent;
	cont->parent->child = cont;
	cont->child = NULL;
	cont->type = CTYPE_TCP_REQUEST;
	cont->current_state = COS_TCP_REQUEST_START;
	cont->param.req->retry = 0;
	cont->param.req->timeout = SEARCH_REMOTE_TIMEOUT;
	memcpy (cont->qname, qname, qname_len);
	cont->qname_len = qname_len;
	cont->q_class = r_class;
	cont->q_type = r_type;
	cont->q_id = mesg_id ();
	cont->param.req->p.t.conn_sock = -1;
	cont->mesg.p = NULL;
	cont->buf_len = 0;
	cont->mesg_len = 0;
	cont->tout = NULL;
	cont->process = cos_tcp_request_wait_connect_process;
	cont->retry = cos_tcp_request_wait_connect_retry;

	/* make up query */
	/* #warning XXX strange method -- use Cos_TCP_Buf! */
	for (i = 1; i * BASE_TCP_REQ_SIZE < MAX_STREAM; i++) {
		cont->mesg.p = malloc (i * BASE_TCP_REQ_SIZE);
		if (!cont->mesg.p) {
			syslog (EM_F (EM_F_MEMEX), fn);
			status = -1;
			goto finish;
		}
		cont->wp = cont->mesg.p;
		cont->buf_len = i * BASE_TCP_REQ_SIZE;
		cont->mesg_len = mesg_make_query (qname, r_type, r_class, cont->q_id,
					    1, cont->mesg.p, cont->buf_len);
		if (cont->mesg_len > 0)
			break;

		free (cont->mesg.p);
		cont->mesg.p = NULL;
		cont->buf_len = 0;
		cont->mesg_len = 0;
	}

	if (!cont->mesg.p) {
		syslog (LOG_ERR, "failed to make up query in 65535 bytes.");
		status = -1;
		goto finish;
	}

	DX (syslog (LOG_DEBUG, "%s: do forwarding.\n", fn));
	sa = ((Fwd *) T.current_fwd->list_data)->sa;
	sa_len = ((Fwd *) T.current_fwd->list_data)->sa_len;
	if (!sa) {
		syslog (LOG_ERR, "no forwarders configured!");
		status = -1;
		goto finish;
	}

        /* create socket */
        sock = socket (sa->sa_family, SOCK_STREAM, 0);
        if (sock < 0) {
                syslog (LOG_WARNING, "%s: can't open socket: %m", fn);
                status = -1;
		goto finish;
        }
        if (ioctl (sock, FIONBIO, (char *) &on) < 0) {
                syslog (LOG_WARNING, "%s: can't ioctl on service socket: %m", fn);
                status = -1;
		goto finish;
        }
        /* start connection */
        if (connect (sock, sa, sa_len)) {
		if (errno != EINPROGRESS) {
			syslog (LOG_WARNING, "%s: can't connect: %m", fn);
			status = -1;
			goto finish;
		}
        }

	cont->param.req->p.t.conn_sock = sock;
	DX (syslog (LOG_DEBUG, "%s(): socket = %d", fn, cont->param.req->p.t.conn_sock));

	/* put me to input list */
	if (ev_tcp_out_register (cont->param.req->p.t.conn_sock, cont) < 0) {
		status = -1;
		goto finish;
	}
	/* put me to timeout list */
	if (context_timeout_register (cont, cont->param.req->timeout) < 0) {
		status = -1;
		goto finish;
	}

	if (T.debug) 
	    fprintf (stderr, "Query will time out in %d seconds.\n", cont->param.req->timeout);
	cont->current_state = COS_TCP_REQUEST_WAIT_CONNECT;

finish:
	DX (syslog (LOG_DEBUG, "%s: return %d", fn, status));
	if (status)
		cos_tcp_request_abort (cont);

	return status;
}

int cos_tcp_request_wait_connect_process (Context * cont)
{
	DX (char *fn = "cos_tcp_request_wait_connect_process()";)
	int status, sockerr;
	socklen_t errlen;
	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (context_timeout_register (cont, cont->param.req->timeout) < 0) {
		status = -1;
		goto finish;
	}
	/* check whether connect() actually succeeded or not. */
	errlen = sizeof (sockerr);
	if (getsockopt (cont->param.req->p.t.conn_sock, SOL_SOCKET, SO_ERROR, (void *) &sockerr, &errlen)) {
		/* something terrible must be going on */
		status = -1;
		goto finish;
	}
	switch (sockerr) {
	case 0:
		DX(syslog (LOG_DEBUG, "%s: TCP connect succeeded.", fn));
		/* change state to writing */
		cont->process = cos_tcp_request_writing_process;
		cont->retry = cos_tcp_request_writing_retry;
		cont->current_state = COS_TCP_REQUEST_WRITING;
		
		/* reset wp to make sure writing process begins from first byte */
		cont->wp = NULL;
		status = 0;
		break;
	case ETIMEDOUT:
		syslog (LOG_DEBUG, "TCP forwarder connect timed out.");
		cos_tcp_request_wait_connect_retry(cont);
		status = 0;
		break;
	case ECONNREFUSED:
		syslog (LOG_ERR, "forwarder refused connection.");
		cos_tcp_request_wait_connect_retry(cont);
		status = 0;
		break;
	case ENETUNREACH:
		syslog (LOG_WARNING, "TCP forwarder unreachable.");
		cos_tcp_request_wait_connect_retry(cont);
		status = 0;
		break;
	default:
		status = -1;
	}

finish:
	if (status) {
		DX (syslog (LOG_DEBUG, "%s: abort %d", fn, status));
		cos_tcp_request_abort (cont);
	} else
		DX (syslog (LOG_DEBUG, "%s: end", fn));
	return status;
}

int cos_tcp_request_wait_connect_retry (Context * cont)
{
	DX (char *fn = "cos_tcp_request_wait_connect_retry";)
	int status, sa_len;
	struct sockaddr *sa;
        const int on = 1;
	int sock;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* remove old I/O List */
	if (cont->param.req->p.t.conn_sock) {
		ev_tcp_out_remove (cont->param.req->p.t.conn_sock);
		/* stop current connection */
		close (cont->param.req->p.t.conn_sock);
		cont->param.req->p.t.conn_sock = -1;
	}

	do {
	        sa = ((Fwd *) T.current_fwd->list_data)->sa;
	        sa_len = ((Fwd *) T.current_fwd->list_data)->sa_len;
		if (!sa) {
			status = -1;
			goto finish;
		}
		cont->param.req->retry++;
		cont->param.req->timeout = cont->param.req->timeout * 2;
		if (cont->param.req->retry >= SEARCH_REMOTE_RETRY) {
		    /* pick another forwarder, if no backup keep on trying for while */
		    if (fwd_select_next() && cont->param.req->retry >= SEARCH_REMOTE_RETRY*2) {
	                syslog (LOG_INFO, "Retry limit exceeded, and out of backup forwarders.");
			status = 1;
			goto finish;
		    }
		    /* Note that we keep timout time high, even when we switched to backup */
		}

		if (T.debug) 
  			fprintf (stderr, "Retry %d of %d+%d will time out in %d seconds.\n", cont->param.req->retry + 1, SEARCH_REMOTE_RETRY, SEARCH_REMOTE_RETRY, cont->param.req->timeout);

		status = 0;	/* to avoid infinite loop */

		/* create tcp socket */
		sock = socket (sa->sa_family, SOCK_STREAM, 0);
		if (sock < 0) {
			status = 1;
			syslog (LOG_WARNING, "can't open socket: %m");
		}
		if (ioctl (sock, FIONBIO, (char *) &on) < 0) {
			syslog (LOG_WARNING, "can't ioctl on service socket: %m");
			status = -1;
			goto finish;
		}
		/* start connection */
		if (connect (sock, sa, sa_len)) {
			if (errno != EINPROGRESS) {
				syslog (LOG_WARNING, "can't connect: %m");
				status = -1;
			}
		}

		cont->param.req->p.t.conn_sock = sock;
	} while (status != 0);

	/* put me to outgoing list */
	if (ev_tcp_out_register (cont->param.req->p.t.conn_sock, cont) < 0) {
		status = -1;
		goto finish;
	}
	/* put me to timeout list */
	if (context_timeout_register (cont, cont->param.req->timeout) < 0) {
		status = -1;
		goto finish;
	}
finish:
	DX (syslog (LOG_DEBUG, "%s: return %d", fn, status));

	if (status)
		cos_tcp_request_abort (cont);

	return status;
}

int cos_tcp_request_writing_process (Context * cont)
{
        DX (char *fn = "cos_tcp_request_writing_process";)
        int status;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* renew timeout */
	if (cont->tout) {
		cont->tout->handler = NULL;
	}
	if (context_timeout_register (cont, cont->param.req->timeout) < 0) {
		status = -1;
		goto error;
	}

	switch (cos_common_tcp_writemesg (cont, cont->param.req->p.t.conn_sock)) {
	case 0:
		/* continue this process */
		return 0;
	case 1:
		/* all data written */

		/* add to new I/O list */
		if (ev_tcp_conn_in_register (cont->param.req->p.t.conn_sock, cont) < 0) {
			status = -1;
			goto error;
		}
		/* delete old I/O list */
		ev_tcp_out_remove (cont->param.req->p.t.conn_sock);
		/* go to readlen context */
		cont->process = cos_tcp_request_readlen_process;
		cont->retry = cos_tcp_request_readlen_retry;
		cont->current_state = COS_TCP_REQUEST_READLEN;
		DX (syslog (LOG_DEBUG, "%s: goto readlen", fn));
		DX (syslog (LOG_DEBUG, "%s: return 0", fn));
		return 0;
	default:
		status = -1;
		goto error;
	}
	/* NOTREACHED */

error:
	DX (syslog (LOG_DEBUG, "%s: error %d", fn, status));
	cos_tcp_request_abort (cont);
	return status;

}

int cos_tcp_request_writing_retry (Context * cont)
{
	syslog (LOG_NOTICE, "cos_tcp_request_writing_retry(): connection not responding.... closed");
	cos_tcp_request_abort (cont);
	return -1;
}

int cos_tcp_request_readlen_process (Context * cont)
{
	char *fn = "cos_tcp_request_readlen_process()";
	u_int16_t length_buf;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (context_timeout_register (cont, cont->param.req->timeout) < 0) {
		cos_tcp_request_abort (cont);
		return -1;
	}
	/* read length buffer */
	if (read (cont->param.req->p.t.conn_sock, (u_char *) (&length_buf), sizeof (u_int16_t))
	    < sizeof (u_int16_t)) {
		syslog (LOG_NOTICE, "failed to read the length buffer on TCP connection.");
		cos_tcp_request_abort (cont);
		return -1;
	}
	length_buf = ntohs (length_buf);
	DX (syslog (LOG_DEBUG, "%s: data length = %d", fn, length_buf));
	free (cont->mesg.p);
	cont->buf_len = 0;
	cont->mesg_len = 0;
	cont->mesg.p = malloc (length_buf);
	if (!cont->mesg.p) {
		syslog (EM_F (EM_F_MEMEX), fn);
		cos_tcp_request_abort (cont);
		return -1;
	}
	cont->mesg_len = cont->buf_len = length_buf;
	cont->wp = cont->mesg.p;

	/* next state */
	cont->process = cos_tcp_request_reading_process;
	cont->retry = cos_tcp_request_reading_retry;
	cont->current_state = COS_TCP_REQUEST_READING;

	DX (syslog (LOG_DEBUG, "%s: return 0", fn));
	return 0;
}

int cos_tcp_request_readlen_retry (Context * cont)
{
	syslog (LOG_NOTICE, "cos_tcp_request_readlen_retry(): connection not respond.... closed");
	cos_tcp_request_abort (cont);
	return -1;
}

int cos_tcp_request_reading_process (Context * cont)
{
	DX (char *fn = "cos_tcp_request_reading_process()";)
	int status, len;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (context_timeout_register (cont, cont->param.req->timeout) < 0) {
		status = -1;
		goto error;
	}
	/* read data */
	len = read (cont->param.req->p.t.conn_sock, cont->wp,
		    cont->buf_len - (cont->wp - cont->mesg.p));
	if (len <= 0) {
		syslog (LOG_NOTICE, "read failed on TCP connection: %m");
		status = -1;
		goto error;
	}
	cont->wp += len;

	DX (syslog (LOG_DEBUG, "%s: return 0", fn));

	if (cont->wp < (cont->mesg.p + cont->buf_len)) {
		/* continue this process */
		DX (syslog (LOG_DEBUG, "%s: left %d bytes -- continue.",
			    fn, (cont->mesg.p + cont->buf_len) -cont->wp));
		return 0;
	} else {
		/* finish */
		DX (syslog (LOG_DEBUG, "%s: finish.", fn));
		return cos_tcp_request_finish (cont);
	}

error:
	cos_tcp_request_abort (cont);
	return status;
}

int cos_tcp_request_reading_retry (Context * cont)
{
	syslog (LOG_NOTICE, "cos_tcp_request_reading_retry(): connection not respond... closed");
	cos_tcp_request_abort (cont);
	return -1;
}

/* destroy them all! */
void cos_tcp_request_destroy (Context * cont)
{
	DX (syslog (LOG_DEBUG, "cos_tcp_request_destroy(): start"));

	if (cont) {
		if (cont->param.req) {
			if (cont->param.req->p.t.conn_sock >= 0) {
				shutdown (cont->param.req->p.t.conn_sock, 2);
				close (cont->param.req->p.t.conn_sock);
				switch (cont->current_state) {
				case COS_TCP_REQUEST_START:
				case COS_TCP_REQUEST_WAIT_CONNECT:
				case COS_TCP_REQUEST_WRITING:
					ev_tcp_out_remove (cont->param.req->p.t.conn_sock);
					break;
				case COS_TCP_REQUEST_READLEN:
				case COS_TCP_REQUEST_READING:
					ev_tcp_conn_in_remove (cont->param.req->p.t.conn_sock);
					break;
				default:
					syslog (LOG_ERR, "unknown state on destruction.");
					break;
				}	/* switch */
				free (cont->param.req);
			}	/* if(...conn_sock > 0) */
		}		/* if(param.req) */
	}			/* if(cont) */
	return;
}

void cos_tcp_request_abort (Context * cont)
{

	/* if parent exists, process parent */
	if (cont->current_state != COS_TCP_REQUEST_START && cont->parent) {
		cont->parent->child = NULL;	/* <- mean child fail */
		cont->parent->process (cont->parent);
	}
	/* free all resources */
	context_destroy (cont);

	return;
}

int cos_tcp_request_finish (Context * cont)
{
	const char *fn = "cos_tcp_request_finish";
	int status = 0;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* parse answers */
	list_destroy (cont->an_list, rrset_freev);

	cont->an_list = list_init ();
	cont->ns_list = list_init ();
	cont->ar_list = list_init ();
	if (!cont->an_list || !cont->ns_list || !cont->ar_list) {
		syslog (LOG_ERR, "%s: can't recreate lists for parse answer data.", fn);
		status = -1;
		goto finish;
	}
	status = mesg_parse (cont->mesg.p, cont->mesg_len, cont->an_list,
			     cont->ns_list, cont->ar_list);
	if (status < 0) {
		syslog (LOG_NOTICE, "%s: can't parse answer data.", fn);
		status = -1;
		goto finish;
	}
	/* if parent exists, process parent */
	/* --> acutually tcp_request without parent is meanless */
	if (cont->parent)
		cont->parent->process (cont->parent);

finish:
	/* free all resources */
	context_destroy (cont);

	DX (syslog (LOG_DEBUG, "%s: return %d", fn, status));
	return status;
}
