/*
 *   toscsi.h
 *
 *   SCSI access functions for tosha.
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: toscsi.h,v 1.2 1999/01/01 23:32:02 olli Exp $
 */

static const char cvsid_toscsi_h[]
    = "@(#)$Id: toscsi.h,v 1.2 1999/01/01 23:32:02 olli Exp $";

#ifdef CAM
#	include <cam/cam.h>
#	include <cam/cam_ccb.h>
#	include <cam/scsi/scsi_all.h>
#	include <cam/scsi/scsi_da.h>
#	include <cam/scsi/scsi_pass.h>
#	include <cam/scsi/scsi_message.h>
#	include <camlib.h>
#else
#	include <sys/scsiio.h>
#	include <scsi.h>
#endif

/*
 *   The controller returns a non-zero code sometimes, even
 *   though everything seems to be alright (at least with my
 *   hardware and software), therefore we redefine the SCSIREQ-
 *   ERROR macro here without that conroller return code.
 *   I'm aware of the fact that this is a dirty hack, but I
 *   wasn't able to find a better solution.
 */

#ifndef CAM
#	undef SCSIREQ_ERROR
#	define SCSIREQ_ERROR(SR) (\
		0 \
		|| SR->senselen_used	/* Sent sense */ \
		|| SR->retsts      	/* SCSI transfer status */ \
		|| SR->error       	/* copy of errno */ \
	)
#endif

#ifdef CAM
#	define TOSCSI_READ  CAM_DIR_IN  | CAM_DEV_QFRZDIS
#	define TOSCSI_WRITE CAM_DIR_OUT | CAM_DEV_QFRZDIS
	typedef struct {
		union ccb *ccb;
		struct cam_device *cam_dev;
	} toscsi_handle;
#else
#	define TOSCSI_READ  SCCMD_READ
#	define TOSCSI_WRITE SCCMD_WRITE
	typedef struct {
		struct scsireq *sreq;	/* SCSI device request structure */
		int scsifd;		/* SCSI device file descriptor */
	} toscsi_handle;
#endif


toscsi_handle *toscsi_open (const char *devname);
int toscsi_request    (toscsi_handle *hdl, ulong size, ulong flags, char *cmd);
int toscsi_readsectors(toscsi_handle *hdl, int start, int endpp, int outfd);
int toscsi_readmode   (toscsi_handle *hdl, int sector);
void toscsi_close     (toscsi_handle *hdl);

/* EOF */
