/*
 *   toform.h
 *
 *   Support for various output formats for tosha.
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: toform.h,v 1.2 1999/01/01 23:31:59 olli Exp $
 */

static const char cvsid_toform_h[]
    = "@(#)$Id: toform.h,v 1.2 1999/01/01 23:31:59 olli Exp $";

typedef int (*writeheaderfunc) (ulong, int);

typedef struct {
	char *name1, *name2;
	char *ext;
	writeheaderfunc writeheader;
	bool swapbytes;
} formspec;

int raw_writeheader  (ulong, int);
int war_writeheader  (ulong, int);
int aiff_writeheader (ulong, int);
int wav_writeheader  (ulong, int);
int au_writeheader   (ulong, int);

#define RAW_SWAPBYTES   FALSE	/* RAW/PCM with little-endian byte order */
#define WAR_SWAPBYTES   TRUE	/* RAW/PCM with little-endian byte order */
#define AIFF_SWAPBYTES  TRUE	/* AIFF uses big-endian byte order */
#define WAV_SWAPBYTES   FALSE	/* WAV uses little-endian byte order */
#define AU_SWAPBYTES    TRUE	/* Sun's AU uses big-endian byte order */

extern const formspec format[];

/* EOF */
