/*
 *   getlopt.h
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: getlopt.h,v 1.3 1999/01/01 23:31:49 olli Exp $
 */

static const char cvsid_getlopt_h[]
    = "@(#)$Id: getlopt.h,v 1.3 1999/01/01 23:31:49 olli Exp $";

#include <stdlib.h>
#include <string.h>

extern int loptind;	/* index in argv[] */
extern int loptchr;	/* index in argv[loptind] */
extern char *loptarg;	/* points to argument if present, else to option */

typedef struct {
	char sname;	/* short option name, can be 0 */
	char *lname;	/* long option name, can be 0 */
	int flags;	/* see below */
	int (*func)(char *);	/* called if != 0 (after setting of var) */
	void *var;	/* type is *int, *char or **char, see below */
	int value;
} topt;

#define GLO_NONE 0
#define GLO_NUM  1
#define GLO_CHAR 3

/* flags:
 *	bit 0 = 0 - no argument
 *		if var != NULL
 *			*var := value or (char)value [see bit 1]
 *		else
 *			loptarg = &option
 *			return ((value != 0) ? value : sname)
 *	bit 0 = 1 - argument required
 *		if var != NULL
 *			*var := atoi(arg) or strdup(arg) [see bit 1]
 *		else
 *			loptarg = &arg
 *			return ((value != 0) ? value : sname)
 *
 *	bit 1 = 0 - var is a pointer to an int
 *	bit 1 = 1 - var is a pointer to a char (or string),
 *			and value is interpreted as char
 *
 * Note: The options definition is terminated by a topt
 *	 containing only zeroes.
 */

#define GLO_END		0
#define GLO_UNKNOWN	-1
#define GLO_NOARG	-2
#define GLO_CONTINUE	-3
#define GLO_USERERR	-4

int getlopt (int argc, char *argv[], const topt *opts);

/* return values:
 *	GLO_END		(0)	end of options
 *	GLO_UNKNOWN	(-1)	unknown option *loptarg
 *	GLO_NOARG	(-2)	missing argument
 *	GLO_CONTINUE	(-3)	(reserved for internal use)
 *	GLO_USERERR	(-4)	error returned by user handler
 *	else - return value according to flags (see above)
 */

int parselopts (int argc, char *argv[], const topt *opts, char *progname);

/*
 * No return value, handles GLO_UNKNOWN and GLO_NOARG internally,
 * uses "progname" for error messages.  For each opts[i], .var or
 * .func should be != zero (otherwise that option wouldn't have an
 * effect, since parselopts() doesn't handle return values).
 */

/* EOF */
