/*
 *   global.h
 *
 *   Global declarations/definitions for tosha.
 *
 *   Oliver Fromme  <olli@fromme.com>
 *
 *   Copyright (C) 1997,1998,1999
 *        Oliver Fromme.  All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. Neither the name of the author nor the names of any co-contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY OLIVER FROMME AND CONTRIBUTORS ``AS IS'' AND
 *   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *   ARE DISCLAIMED.  IN NO EVENT SHALL OLIVER FROMME OR CONTRIBUTORS BE LIABLE
 *   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *   SUCH DAMAGE.
 *
 *   @(#)$Id: global.h,v 1.3 1999/01/01 23:31:50 olli Exp $
 */

static const char cvsid_global_h[]
    = "@(#)$Id: global.h,v 1.3 1999/01/01 23:31:50 olli Exp $";

#include <stdio.h>
#include <string.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>

typedef unsigned char byte;
typedef unsigned long ulong;

/*
 *   Uncommenting this define will cause a LOT of output.
 *   Don't do that unless you need it and you know what you
 *   are doing (and what all the output means).
 */
/* #define DEBUG 1 */

/*
 *   The maximum number of sectors that we can read with a
 *   single access is 26.  I found this number by experimenting
 *   with my old Toshiba drive; other drives may differ.
 *   (N.B.:  the maximum of 26 is probably caused by a 64 Kb
 *   limit of the drive:  64 Kb / 2450 = 26.7 [2450 is the size
 *   of one raw sector including subchannel data].)
 *   However, the default is 10 which should work with any
 *   reasonable drive.  Also see the -b option.
 */

#define MAX_SECTORSPERBUF 26
#define SECTORSIZE 2352
#define READBUFSIZE ((MAX_SECTORSPERBUF) * (SECTORSIZE))
extern byte buf[READBUFSIZE];

extern int readcmd;		/* read command to use for DA reading */
extern int byteswap;		/* do we have to swap byte order? */

extern long long starttime;	/* for estimating the remaining time */
extern ulong totalsectors;	/* total number of sectors to read */
extern int tracklistsize;	/* number of tracks to read */

extern int verbose;
extern int sectorsperbuf;

void get_time (long long *tm);

/* EOF */
