#  Copyright (c) 1994-1997 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: sendBatch.t,v 1.2 1996/12/28 00:55:56 andy Exp $
#

#
# Send all the files to each batch entry.
#

proc sendBatch { args } {

    global Th_Info

    # Start at the end since we may delete entries
    # in the batch recipients listbox. This list is in the
    # same order as shown in the list box.
    set end [expr [llength $Th_Info(batchDest)] - 1]
    for {set i $end} {$i >= 0} {incr i -1} {

	set entry [lindex $Th_Info(batchDest) $i]

	set Th_Info(name) [extractName $entry] 
	set Th_Info(company) [extractCompany $entry] 
	set Th_Info(phone) [extractPhone $entry] 

	# Force display of current destination
	update idletasks

	# Fax the files
    	faxIt true

	# Update the batch listbox
	if {[info exists Th_Info(viewBatch)] &&
	    [winfo exists $Th_Info(viewBatch)]} {
	    $Th_Info(viewBatch) delete $i
	}

	# Remove this entry in the batch recipients list in case
	# user decides to view batch list. 
	set Th_Info(batchDest) [lreplace $Th_Info(batchDest) $i $i] 

    }

    # Reset batch destination list to empty
    set Th_Info(batchDest) {}
}
