#
#  Copyright (c) 1994-1997 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: mkCover.t,v 1.3 1996/12/31 01:49:40 andy Exp $
#

#
# Generate fax cover sheet command string.
#

proc mkCover { args } {

    global env
    global Th_Info
    global Comments

    # Make command.
    append faxcmd "faxcover "

    foreach ln [lsort [array name Comments]] {
        append comments "$Comments($ln) "
    }

    set comments [string trim $comments]
    if {[string length $comments]} {
	append faxcmd " -c \"$comments\""
    }

    if {[string length $Th_Info(regard)]} {
	append faxcmd " -r \"$Th_Info(regard)\""
    }

    if {[string length $Th_Info(company)]} {
	append faxcmd " -x \"$Th_Info(company)\""
    }

    if {[string length $Th_Info(location)]} {
	append faxcmd " -l \"$Th_Info(location)\""
    }

    if {[string length $Th_Info(name)]} {
	append faxcmd " -t \"$Th_Info(name)\""
    } else {
	append faxcmd " -t \"Unknown\""  
    }

    if {[string length $Th_Info(phone)]} {
	append faxcmd " -n \"$Th_Info(phone)\""
    } else {
	append faxcmd " -n \"Unknown\""
    }

    if {[info exists Th_Info(coverPage)] && 
        [string trim $Th_Info(coverPage)] != "-n"} {
	append faxcmd $Th_Info(coverPage)
    }

    # If automatic from feature is enabled find the user,
    # otherwise pick up sender's name in "From" field.
    if {$Th_Info(autoFrom)} {
	# We try to determine the full user's name looking:
	#  - into the NIS maps 
	#  - then into the NIS+ tables
	#  - then into the local /etc/passwd file.
	set username {}
	if {[info exists env(USER)]} {
	    set username $env(USER)
	} else {
	    catch {exec whoami} username 
	}

	# Look into the NIS map.
	if {[catch {exec ypmatch $username passwd} res]} {
	    # User's name not found in NIS map.
	    # Try to find the user's name in the NIS+ table.
	    if {[catch "exec nismatch $username passwd" res]} {
		# User's name not found in NIS+ table.
		# Try to find the user's name in the /etc/passwd file.
		if {[catch {exec grep $username /etc/passwd} res]} {
		    # No equivalent name found 
		    set res {}
		}
	    }
	}

	if {$res != ""} {
	    # Some passwd files have subfields delimited by commas. Use the
	    # first subfield as the username.
	    append faxcmd \
	       " -f \"[lindex [split [lindex [split $res ":"] 4] ","] 0]\""
	} else {
	    append faxcmd " -f \"Unknown\""
	}
    } else {
	if {[string length $Th_Info(from)]} {
	    append faxcmd " -f \"$Th_Info(from)\""
	} else {
	    append faxcmd " -f \"Unknown\""
	}
    }
    return $faxcmd
}
