#    Copyright 2003,2007 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

proc advanced_options_window {} {
	global burn_type v_create_iso dvd_size option_auto_refresh_space burn_speed langage tristatecompatibility option_tao_dao_cd cd_session_type
	#i18n variables
	global i18n_filesystem_extensions i18n_add_joliet_extensions i18n_rock_ridge_extensions i18n_off i18n_rr_extensions i18n_anonymous_rr_extensions i18n_udf_extensions i18n_udf_extensions_radiobutton i18n_dvd_video_compliant_udf_filesystem i18n_dvd_size i18n_other_options i18n_burning_speed i18n_overburn i18n_pad i18n_add_session_to_disc i18n_maximum_media_compatibility i18n_automaticaly_refresh_used_space i18n_close i18n_advanced_options_t i18n_eject_cd_after_burning i18n_monosession_cd i18n_multisession_cd
if { ! [winfo exists .advanced_options_window] } {
	toplevel .advanced_options_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
	wm title .advanced_options_window "$i18n_advanced_options_t"
	
	#create frame for options buttons
	frame .advanced_options_window.f_fs_ext -background #f5f5f5
	frame .advanced_options_window.options_fs -background #f5f5f5
	frame .advanced_options_window.f_options_rr -background #f5f5f5
	frame .advanced_options_window.f_options_udf -background #f5f5f5
	frame .advanced_options_window.rr_radiobuttons -background #f5f5f5
	frame .advanced_options_window.udf_radiobuttons -background #f5f5f5
	frame .advanced_options_window.f_opts_dvd_size -background #f5f5f5
	frame .advanced_options_window.f_dvd_size -background #f5f5f5
	frame .advanced_options_window.f_opts_dvd -background #f5f5f5
	frame .advanced_options_window.f_opts_cd -background #f5f5f5
	frame .advanced_options_window.f_opts_cd.f_cd_burn_type -background #f5f5f5
	frame .advanced_options_window.f_oth_opts -background #f5f5f5
	frame .advanced_options_window.options_oth -background #f5f5f5
	frame .advanced_options_window.f_langage -background #f5f5f5
	
	label .advanced_options_window.f_fs_ext.label_fs_ext -bg #f5f5f5 -text "$i18n_filesystem_extensions"
	label .advanced_options_window.f_options_rr.label_fs_rr -bg #f5f5f5 -text "$i18n_rock_ridge_extensions"
	label .advanced_options_window.f_options_udf.label_fs_udf -bg #f5f5f5 -text "$i18n_udf_extensions"
	label .advanced_options_window.f_opts_dvd_size.label_dvd_size -bg #f5f5f5 -text "$i18n_dvd_size"
	label .advanced_options_window.f_oth_opts.label_oth_opts -bg #f5f5f5 -text "$i18n_other_options"
	label .advanced_options_window.f_langage.label_langage -bg #f5f5f5 -text "Langage:"

	label .advanced_options_window.f_opts_dvd.label_dvd -bg #f5f5f5 -text "DVD:"
	label .advanced_options_window.f_opts_cd.label_cd -bg #f5f5f5 -text "CD:"
	
	checkbutton .advanced_options_window.options_fs.joliet_ext -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_add_joliet_extensions" -variable option_joliet_ext -offvalue "" -onvalue "-J" -command refresh_cmd_line
	
	checkbutton .advanced_options_window.options_oth.pad -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_pad" -variable option_pad -offvalue "" -onvalue "-pad"  -command refresh_cmd_line

	radiobutton .advanced_options_window.rr_radiobuttons.rr_ext_off -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_off" -variable option_rr_ext -value "" -command refresh_cmd_line

	radiobutton .advanced_options_window.rr_radiobuttons.rr_ext -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_rr_extensions" -variable option_rr_ext -value "-R"  -command refresh_cmd_line
	
	radiobutton .advanced_options_window.rr_radiobuttons.rra_ext -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_anonymous_rr_extensions" -variable option_rr_ext -value "-r" -command refresh_cmd_line
	
	radiobutton .advanced_options_window.udf_radiobuttons.udf_ext_off -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_off" -variable option_udf_ext -value "" -command refresh_cmd_line
	
	radiobutton .advanced_options_window.udf_radiobuttons.udf_ext -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_udf_extensions_radiobutton" -variable option_udf_ext -value "-udf" -command refresh_cmd_line
	
	radiobutton .advanced_options_window.udf_radiobuttons.dvd_video_ext -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_dvd_video_compliant_udf_filesystem" -variable option_udf_ext -value "-dvd-video" -command refresh_cmd_line
	
	label .advanced_options_window.options_oth.label_burn_speed -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_burning_speed"

	entry .advanced_options_window.options_oth.entry_burn_speed -relief flat -bg white -highlightbackground blue -highlightcolor blue -disabledbackground #f5f5f5 -state normal -textvariable burn_speed -width 3

	checkbutton .advanced_options_window.options_oth.overburn -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_overburn" -variable option_overburn -offvalue "" -onvalue "-overburn" -command refresh_cmd_line
	
	checkbutton .advanced_options_window.f_opts_dvd.multisession -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_add_session_to_disc" -variable t_session -offvalue "-use-the-force-luke=tty -Z" -onvalue "-use-the-force-luke=tty -M"  -command refresh_cmd_line
	
	checkbutton .advanced_options_window.f_opts_dvd.monosession -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_maximum_media_compatibility" -variable option_dvd_compat -offvalue "" -onvalue "-dvd-compat"  -command refresh_cmd_line
	
	radiobutton .advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_cmd_line } -text "Track at once (-tao)" -variable option_tao_dao_cd  -value "-tao"

	radiobutton .advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_cmd_line } -text "Disk/Session at once (-dao)" -variable option_tao_dao_cd  -value "-dao"

	radiobutton .advanced_options_window.f_opts_cd.monosession  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_cmd_line } -text $i18n_monosession_cd -variable cd_session_type  -value ""

	radiobutton .advanced_options_window.f_opts_cd.multisession  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_cmd_line } -text $i18n_multisession_cd -variable cd_session_type  -value "-multi"

	checkbutton .advanced_options_window.f_opts_cd.eject_cd -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_eject_cd_after_burning" -variable option_eject_cd -offvalue "" -onvalue "-eject"  -command refresh_cmd_line

	checkbutton .advanced_options_window.options_oth.auto_refresh_space -bg #f5f5f5 -activebackground #f5f5f5 -highlightbackground #f5f5f5 -text "$i18n_automaticaly_refresh_used_space" -variable option_auto_refresh_space -offvalue "0" -onvalue "1" -command {if { $option_auto_refresh_space == "1" } { pack forget .f_upper_file_list.b_update }  else { pack .f_upper_file_list.b_update -side left } }
	
	radiobutton .advanced_options_window.f_dvd_size.cd6  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_total_file_size; refresh_cmd_line } -text "650 MB" -variable dvd_size -value 665600

	radiobutton .advanced_options_window.f_dvd_size.cd7 -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_total_file_size; refresh_cmd_line } -text "700 MB" -variable dvd_size -value 716800

	radiobutton .advanced_options_window.f_dvd_size.single_layer  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_total_file_size; refresh_cmd_line } -text "4.7 GB" -variable dvd_size -value 4589850
	
	radiobutton .advanced_options_window.f_dvd_size.dual_layer  -activebackground #f5f5f5 -background #f5f5f5 -highlightbackground #f5f5f5 -command { refresh_total_file_size; refresh_cmd_line }  -text "8.5 GB (DL)" -variable dvd_size -value 8300790

	::combobox::combobox .advanced_options_window.f_langage.langage_list -listvar i18n_language_list -editable false -textvariable language
	
	
	#button .advanced_options_window.f_dvd_size.b_save -highlightbackground red -text "Save" -command { save_options }
	
	button .advanced_options_window.b_close -highlightbackground red -text "$i18n_close" -command { destroy .advanced_options_window; refresh_cmd_line }
	
	#see TkDVD.sh comments about Tk 8.4/8.5 compatibility and tristate option
	if { $tristatecompatibility == yes } {
	  #checkbuttons
	  .advanced_options_window.options_fs.joliet_ext configure -tristatevalue "tristate"
	  .advanced_options_window.options_oth.pad configure -tristatevalue "tristate"
	  .advanced_options_window.options_oth.overburn configure -tristatevalue "tristate"
	  .advanced_options_window.f_opts_dvd.multisession configure -tristatevalue "tristate"
	  .advanced_options_window.f_opts_dvd.monosession configure -tristatevalue "tristate"
	  .advanced_options_window.f_opts_cd.eject_cd configure -tristatevalue "tristate"
	  .advanced_options_window.options_oth.auto_refresh_space configure -tristatevalue "tristate"
	  #radiobuttons
	  .advanced_options_window.rr_radiobuttons.rr_ext_off configure -tristatevalue "tristate"
	  .advanced_options_window.rr_radiobuttons.rr_ext configure -tristatevalue "tristate"
	  .advanced_options_window.rr_radiobuttons.rra_ext configure -tristatevalue "tristate"
	  .advanced_options_window.udf_radiobuttons.udf_ext_off configure -tristatevalue "tristate"
	  .advanced_options_window.udf_radiobuttons.udf_ext configure -tristatevalue "tristate"
	  .advanced_options_window.udf_radiobuttons.dvd_video_ext configure -tristatevalue "tristate"
	  .advanced_options_window.f_opts_cd.monosession configure -tristatevalue "tristate"
	  .advanced_options_window.f_opts_cd.multisession configure -tristatevalue "tristate"
	}

	set_visible_options
	
	
	#pack buttons and labels
	pack .advanced_options_window.f_fs_ext.label_fs_ext -side left
	pack .advanced_options_window.f_options_rr.label_fs_rr -side left
	pack .advanced_options_window.f_options_udf.label_fs_udf -side left
	pack .advanced_options_window.f_opts_dvd_size.label_dvd_size -side left
	pack .advanced_options_window.f_oth_opts.label_oth_opts -side left
	pack .advanced_options_window.options_fs.joliet_ext -side top -anchor w -padx {12 0}
	pack .advanced_options_window.f_dvd_size.cd6 .advanced_options_window.f_dvd_size.cd7 .advanced_options_window.f_dvd_size.single_layer .advanced_options_window.f_dvd_size.dual_layer -side left -anchor w -padx {12 0}
	#DVD section
	pack .advanced_options_window.f_opts_dvd.label_dvd -side top -anchor w
	pack .advanced_options_window.f_opts_dvd.multisession .advanced_options_window.f_opts_dvd.monosession -side top -anchor w -padx {12 0}
	#CD section
	pack .advanced_options_window.f_opts_cd.label_cd -side top -anchor w
	pack .advanced_options_window.f_opts_cd.eject_cd -side top -anchor w -padx {12 0}
	pack .advanced_options_window.f_opts_cd.f_cd_burn_type.radio_tao .advanced_options_window.f_opts_cd.f_cd_burn_type.radio_dao -side left -anchor w -padx {12 0}
	pack .advanced_options_window.f_opts_cd.f_cd_burn_type -side top -anchor w
	pack .advanced_options_window.f_opts_cd.monosession .advanced_options_window.f_opts_cd.multisession -side left -anchor w -padx {12 0}
	#other options
	pack .advanced_options_window.options_oth.overburn .advanced_options_window.options_oth.pad -side top -anchor w -padx {12 0}
	pack .advanced_options_window.options_oth.auto_refresh_space  -side top -anchor w -padx {12 0}
	pack .advanced_options_window.options_oth.label_burn_speed .advanced_options_window.options_oth.entry_burn_speed -side left -anchor w -padx {12 0}
	#langage
	pack .advanced_options_window.f_langage.label_langage -side top -anchor w
	pack .advanced_options_window.f_langage.langage_list -side top -anchor w -padx {12 0}  -pady {6 0}
	#pack .advanced_options_window.f_dvd_size.b_save -side right -padx {0 12}
	pack .advanced_options_window.rr_radiobuttons.rr_ext_off -side left -padx {24 0}
	pack .advanced_options_window.rr_radiobuttons.rr_ext .advanced_options_window.rr_radiobuttons.rra_ext  -side left
	pack .advanced_options_window.udf_radiobuttons.udf_ext_off .advanced_options_window.udf_radiobuttons.udf_ext .advanced_options_window.udf_radiobuttons.dvd_video_ext -side left -padx {24 0}
	#packing frames
	pack .advanced_options_window.f_fs_ext -fill x
	pack .advanced_options_window.options_fs -fill x
	pack .advanced_options_window.f_options_rr -fill x -padx {12 0}
	pack .advanced_options_window.rr_radiobuttons -fill x
	pack .advanced_options_window.f_options_udf -fill x -padx {12 0}
	pack .advanced_options_window.udf_radiobuttons -fill x
	pack .advanced_options_window.f_opts_dvd_size -fill x -pady {6 0}
	pack .advanced_options_window.f_dvd_size -fill x
	pack .advanced_options_window.f_opts_dvd -fill x -pady {6 0}
	pack .advanced_options_window.f_opts_cd -fill x -pady {6 0}
	pack .advanced_options_window.f_oth_opts -fill x -pady {6 0}
	pack .advanced_options_window.options_oth -fill x
	pack .advanced_options_window.f_langage -fill x -pady {6 0}
	pack .advanced_options_window.b_close -side right -padx {0 12} -pady {0 6}
}
}
