/* tircproxy.h
** 
** This file defines what features get compiled into your proxy.  The 
** default is everything - you can then disable features you don't like at 
** runtime.
**
** Features that aren't available get disabled by autoconf (I hope).
** 
** Check the end of this file for some interesting messages you might 
** want to redefine.
** 
**************************************************************************/

/* Define this if you want to be able to request debugging info.
*/
#define DEBUG

/* This is the prefix to the file to look for when changing uid/gid.  If 
** this is defined, and the specified file is found (the default is 
** /var/run/user-<ipaddress>), the proxy server will attempt to change 
** uid/gid to the username found in the file.
*/
#define IP_TO_UID_PREFIX	"/var/run/user-"

/* Set the location of the broadcast & MOTD files.  Undef these to disable
** the broadcasting feature.
*/
#define BROADCAST_FILE		"/tmp/ircbroadcast"
#define IRC_MOTD_FILE		"/etc/motd.irc"

/* Enable this if you want to use the IPF code for tranparency.
*/
#define IPF 1

/* Enable this if you want to use the Linux code for tranparency.
*/
#define LINUX 1

/* Enable this if you want to ask proxy users for passwords.
*/
#define QUIZ_MODE 1

/* Some messages you might want to redefine.
*/
#define QUIZ_NICK "tIRCproxy"
#define QUIZ_PASSWD_WAIT "Waiting for a valid username and password."
#define QUIZ_PASSWD_BAD "Wrong!  Type '/msg tIRCproxy username password' to try again."
#define QUIZ_ANSWER_BAD "Wrong!"
#define QUIZ_PASSWD_OK "Correct.  Welcome to IRC!"

/* Kludge to make DCC work with mIRC - some recent versions of mIRC have 
** really stupid ideas about what IP address to send in DCC requests.. :-/
** 
** This should always be a safe kludge though, unless you are connecting to 
** tircproxy through *another* proxy which doesn't know about DCC.  But that
** would be silly, wouldn't it?
*/
#define MIRC_DCC_KLUDGE

/* Log to syslog when the user changes nicks.
*/
#define NICK_LOG

/* This makes the server exit if it cannot find a valid user-id for the
** connection (when running in transparent mode, as root).  If not enabled
** the server will continue to operate with full privaleges (which could be 
** a tad dangerous if I made any mistakes coding this thing).
** 
** PARANOID implies MIRC_DCC_KLUDGE and NICK_LOG.
*/
#define PARANOID

/* This makes the proxy use the libwrap library (hosts.allow & hosts.deny) 
** for access control..
** 
** The following tokens are recognized in hosts.allow and hosts.deny:
** 
**	tircproxy		Who can(not) use the proxy.  The username 
** 				is not fetched from identd, but from the
** 				/var/run/user-<ipaddr> file.
**	tircproxy_dcc_in	Internal user@hosts who can(not) use DCC.
**	tircproxy_dcc_out	External user@hosts who can(not) initiate DCC.
** 	tircproxy_dcc_files	Filenames to accept/block (replace usernames)
**
** Note that tircproxy_dcc_out is less strict than tircproxy_dcc_in - even
** if a host is banned from**initiating* connections by a tircproxy_dcc_out 
** directive, an internal client may still request a DCC connection to the 
** it, and the proxy will allow the connection.  Maybe this doesn't make sense.. 
*/
#define TCP_WRAPPERS

/* Cooperate with oidentd-1.4+cdir.
**
** This makes tircproxy check for a user-<ip> file in the CDIR directory 
** instead of checking for the IP_TO_UID_PREFIX file, and adds information
** to /var/oidentd/ident:<port>-<ip>:<port> for each active connection.
**
** This means the proxy does NOT need to run as root for ident responses to
** be correct (so go get oidentd-1.4+cdir !!).
*/
#define CDIR		"/var/oidentd/"
#define CDIR_IDENT	"ident"
#define CDIR_MAP       	"user"


/* The following table defines a list of filenames that are not
** to be handled transparently by the DCC code.. if replace points to
** a valid string the filename is overwritten by it (the file names must
** be of equal length!).  If replace is NULL the DCC request is silently 
** dropped.
*/
struct dcc_mangle_struct {
   	char 	*offered;
   	char	*replace;
};

/* See http://www.irchelp.org/irchelp/security/ for more info.
** It's a Good Idea (tm) to keep this list up-to-date!
*/
static struct dcc_mangle_struct dcc_mangle[] = {
	{"script.ini",		NULL},		/* Trojan. */
	{"dmsetup.exe",		NULL},		/* Trojan. */
	{"dmsetup2.exe",	NULL},		/* Trojan. */
	{"winhelper.exe",	NULL},		/* Trojan. */
	{"mschv32.exe",		NULL},		/* Trojan. */
	{"mirc.ini",		"mirc.in-"},	/* Mangle mirc.ini */
     	{NULL,			NULL}		/* End of table marker */
};

/* This is what the victim sees if some sends him a DCC request which you
** have banned or mangled!  All of the messages are optional - if any are
** undefed, then the connections will be dropped silently.
**
** Note:  For security reasons, it's important to use %.Ns instead of %s - 
**        where N is a relatively small integer.
*/
#define MANGLE_DCC_SEND   "Trojan (DCC %.25s %.25s) from me blocked, see http://www.mmedia.is/~bre/tircproxy/trojans.html for information."
#define DISALLOW_DCC_SEND "oOoOo Paranoia turned 'DCC %.25s %.25s' into a turnip! oOoOo"
#define DISALLOW_DCC_CHAT "oOoOo Paranoia turned 'DCC %.25s %.25s' into a turnip! oOoOo"
#define DISALLOW_DCC_FUNK "oOoOo Paranoia turned 'DCC %.25s %.25s' into a turnip! oOoOo"

/* When running in anonymizing mode, USERINFO, CLIENTINFO, VERSION and FINGER
** replies from our client are replaced by this string:
*/
#define CTCP_NOT_ALLOWED  "ERROR Hey, I'm anonymous.  Cut it out."

/* IRCNAME string for anonymous users, and formula for generating a userID.
*/
#define ANON_IRCNAME      "Anonymous IRC user"
#define ANON_USERID	   ((clients_ip ^ anon_notval) + visible_ip_o + (clients_ip >> 15)) & 0x0FFFFFF;
