#!/bin/sh
# $Header: /cvsroot/tikiwiki/tiki/setup.sh,v 1.28.2.14 2007/03/17 20:47:55 mose Exp $

# Copyright (c) 2002-2007, Luis Argerich, Garland Foster, Eduardo Polidor, et. al.
# All Rights Reserved. See copyright.txt for details and a complete list of authors.
# Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.

DIRS="backups db dump files img/wiki img/wiki_up img/trackers modules/cache temp temp/cache templates_c templates styles maps whelp mods"

if [ -d 'lib/Galaxia' ]; then
	DIRS=$DIRS" lib/Galaxia/processes"
fi

echo $DIRS

AUSER=nobody
AGROUP=nobody
RIGHTS=02775
VIRTUALS=""

UNAME=`uname | cut -c 1-6`

if [ -f /etc/debian_version ]; then
	AUSER=www-data
	AGROUP=www-data
fi

if [ -f /etc/redhat-release ]; then
	AUSER=apache
	AGROUP=apache
fi

if [ -f /etc/gentoo-release ]; then
	AUSER=apache
	AGROUP=apache
fi

if [ -f /etc/SuSE-release ]; then
        AUSER=wwwrun
        AGROUP=www
fi

if [ "$UNAME" = "CYGWIN" ]; then
	AUSER=SYSTEM
	AGROUP=SYSTEM
fi

if [ -z "$1" ]; then
	cat <<EOF
This script assigns necessary permissions for the directories that the
webserver writes files to. It also creates the (initially empty) cache 
directories.

Usage $0 user [group] [rights] [list of virtual host domains]

For example, if apache is running as user $AUSER and group $AGROUP (can be found in phpinfo),
 and if you are running as user $USER, type:

  su -c '$0 $USER $AGROUP'
 
This will allow you to delete certain files/directories without becoming root.
  
Or, if you can't become root, but are a member of the group apache runs under
(for example: $AGROUP), you can type:

  $0 $USER $AGROUP

Be aware, that you probably have to do a 

  chown -R $USER *

if your tiki runs in a PHP-safe-mode environment.

If you can't become root, and are not a member of the apache group, but if
your system uses ACL's (check with "mount | grep acl"), then type:

  $0 -acl $USER $AGROUP

If you can't become root, and are not a member of the apache group, and
your system does not support ACL's then type:

  $0 $USER yourgroup 02777

Replace yourgroup with your default group.

NOTE: If you do execute on of the two last commands, you will not be able 
to delete certain files created by apache, and will need to ask your system
administrator to delete them for you if needed.

To use Tiki's multi-site capability (virtual hosts from a single DocumentRoot)
add a list of domains to the command to create all the needed directories.
For example:

  su -c '$0 $USER $AGROUP $RIGHTS domain1 domain2 domain3'

or, if you can't become root:

  $0 $USER $AGROUP 02777 domain1 domain2 domain3

---------
special for mods installer

  $0 $AUSER all

will change perms on all tiki files so you can use the tikimods power.
Remember to run the perms setup again when mods installer use if done.
  
	$0 $USER $AGROUP 

EOF
	exit 1
fi

if [ "$1" = "-acl" ]; then
	ACL=1
	shift
else
	ACL=0
fi

if [ -n "$1" ]; then
	AUSER=$1
	shift
fi
if [ -n "$1" ]; then
	if [ $1 = "all" ]; then
		chown -R $AUSER *
		exit 0
	fi
	AGROUP=$1
	shift
fi
if [ -n "$1" ]; then
	RIGHTS=$1
	shift
fi

if [ -n "$1" ]; then
	VIRTUALS=$@
	touch db/virtuals.inc
fi

# Create directories as needed
for dir in $DIRS; do
	if [ ! -d $dir ]; then
		echo Creating directory "$dir"
		mkdir -p $dir
	fi
	for vdir in $VIRTUALS; do
		if [ ! -d "$dir/$vdir" ]; then
			echo Creating directory "$dir/$vdir"
			mkdir -p "$dir/$vdir"
		fi
		echo $vdir >> db/virtuals.inc
		cat db/virtuals.inc | sort | uniq > db/virtuals.inc_new
		rm -f db/virtuals.inc && mv db/virtuals.inc_new db/virtuals.inc
	done
done

# Set ownerships of the directories
chown -R $AUSER *

if [ -n "$AGROUP" ]; then
	if [ $ACL = 1 ] ; then
		setfacl -R -m g:${AGROUP}:rwx $DIRS
		setfacl -m g:${AGROUP}:rwx robots.txt
	else
		chgrp -R $AGROUP $DIRS
        	chgrp $AGROUP robots.txt
	fi
fi

if [ $ACL = 0 ] ; then
	chmod -R $RIGHTS $DIRS
	chmod $RIGHTS robots.txt
	chmod $RIGHTS tiki-install.php
fi

chown $AUSER robots.txt

# by setting the rights to tiki-install.php tiki-installer can be used in most cases to disable the file.
chown $AUSER tiki-install.php

exit 0

