<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Security check failed!" => "Sigurnosna provera nije uspela!",
"You are not permitted to edit someone else\\'s post!" => "Nije vam dozvoljeno da menjate tuđe poruke!",
"Only an admin can remove a thread." => "Samo administrator može da ukloni temu.",
"note: those parameters are exclusive" => "napomena: sledeću parametri su ekskluzivni",
"Reply to parent comment" => "Odgovori na komentare roditelja",
"compose message tpl" => "Sastavi šablon poruke",
"messages tpl" => "šabloni poruka",
"Reduce area width" => "Smanji širinu prostora",
"Enlarge area width" => "Povećaj širinu prostora",
"Email Encoding" => "Kodna strana za e-mail",
"Meta Tag Settings" => "Podešavanja Meta taga",
"Strict allows page names with only letters, numbers, underscore, dash, period and semicolon (dash, period and semicolon not allowed at the beginning and the end)." => "Striktno dozvoljava imena samo sa slovima, brojevima donjom crtom, crtom, tačkom i dvotačkom (crta, tačka i dvotačka nisu dozvoljeni na početku ili kraju).",
"Full adds accented characters." => "Potpuno dodaje akcentovane karaktere.",
"Complete allows <em>anything at all</em>.  I (<a\n    href=\"http://tikiwiki.org/tiki-index.php?page=UserPagerlpowell\">rlpowell</a>)\n    cannot guarantee that it is bug-free or secure." => "Kompletno dozvoljava <em>bilo šta</em> u njima.  Ja (<a\n    href=\"http://tikiwiki.org/tiki-index.php?page=UserPagerlpowell\">rlpowell</a>)\n    ne mogu da garantujem da je to sigurno ili bez bagova.",
"Note that this does not affect WikiWord recognition, only page names surrounded by (( and ))." => "Primetite da ovo ne utiče na WikiWord prepoznavanje, samo na nazive okružene sa (( i )).",
"admin charts tpl" => "admin grafici tpl",
"ChatAdmin tpl" => "ChatAdmin tpl",
"admin content templates tpl" => "admin šablona sadržaja tpl",
"tiki admin external wikis tpl" => "tiki admin eksterni wiki tpl",
"admin forums tpl" => "admin forumi tpl",
"admin hotwords tpl" => "admin aktivne reči tpl",
"admin HtmlPages tpl" => "admin HtmlPages tpl",
"Is this regular expression or simpel search/replacer" => "Da li je ovo regularan izraz (regex) ili jednostavna pretraga/zamena",
"<span title=\"{tr}subset of chars: imsxeADSXUu, which is regex modifiers" => "<span title=\"{tr}podskup karaktera: imsxeADSXUu, koji su regex modifikatori",
"admin featured links tpl" => "admin prikazujemo vam sajtove tpl",
"admin mailin tpl" => "admin mailin tpl",
"Edit tpl" => "Izmeni tpl",
"admin modules tpl" => "admin moduli tpl",
"admin newsletters tpl" => "admin novine tpl",
"admin notifications tpl" => "admin notifikacije tpl",
"admin polls tpl" => "admin polls tpl",
"tiki admin quicktags tpl" => "tiki admin quicktags tpl",
"admin RSSmodules tpl" => "admin RSSmoduli tpl",
"admin structures tpl" => "admin strukture tpl",
"admin surveys tpl" => "admin surveys tpl",
"admin topics tpl" => "admin teme tpl",
"(Dropdown options : list of items separated with commas)" => "(Opcije u padajućoj listi : lista opcija razdvojenih zarezom)",
"(Image options : xSize,ySize indicated in pixels)" => "(Opcije slika : xVeličina,yVeličina u pikselima)",
"admin groups tpl" => "admin grupe tpl",
"admin users tpl" => "admin korisnici tpl",
"Events Panel" => "Panel događaja",
"Hide" => "Sakrij",
"For more information, please see <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\non <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>." => "Za više informacija vidite <a\nhref=\"http://www.tikiwiki.org/tiki-index.php?page=WikiSyntax\">WikiSyntax</a>\nna <a href=\"http://www.tikiwiki.org\">Tikiwiki.org</a>.",
"file galleries tpl" => "fajl galerije tpl",
"MyTikiDoc" => "MojTikiDoc",
"Attachements" => "Dodaci",
"Webmail Doc tpl" => "Webmail Doc tpl",
"Are you sure you want to delete this directory?" => "Da li ste sigurni da želite da obrišete ovaj direktorijum?",
"Are you sure you want to delete this file?" => "Da li ste sigurni da želite da obrišete ovaj fajl?",
"Top `\$module_rws` topics" => "Naj `\$module_rws` tema",
"Skip to Content" => "Preskoči na sadržaj",
"PHPOpenTracker" => "PHPOpenTracker",
"Comm" => "Comm",
"-1m" => "-1m",
"-7d" => "-7d",
"-1d" => "-1d",
"+1d" => "+1d",
"+7d" => "+7d",
"+1m" => "+1m",
"op" => "op",
"The cord" => "The cord",
"Mus enter a name to add a site" => "Morate uneti naziv za unos sajta",
"updated by the phpwiki import process" => "obnovio phpwiki uvozni proces",
"created from phpwiki import" => "napravljeno iz phpwiki uvoza",
"Wiki page" => "Wiki strane",
"pageviews" => "pogleda strana",
"Your Tiki account information for" => "Vaše informacije o Tiki nalogu za",
"A password reminder email has been sent " => "Email za podsećanje lozinke vam je poslat",
"A new password has been sent " => "Nova lozinka je poslata",
"Upload was not successful (maybe a duplicate file)" => "Upload nije uspešan (možda već postoji fajl sa istim imenom)",
"Invalid password.  You current password is required to change your email address." => "Pogrešna lozinka. Vaša trenutna lozinka je potrebna da bi promenili vašu email adresu.",
" new topic:" => " nova tema:",
"topic:" => "tema:",
"forum topic" => "tema na forumu",
"New article submitted at " => "Novi članak objavljen na ",
"New message arrived from " => "Nova poruka je stigla od ",
"Welcome to " => "Dobrodošli na ",
"Bye bye from " => "Zdravo od ",
" at " => " na ",
"Posted comments" => "Napisani komentari",
"reply to this" => "odgovori na ovo",
"parent" => "roditelj",
"Return to messages" => "Vrati se na poruke",
"Unflagg" => "Odmarkiraj",
"Admin structures" => "Administriraj uloge",
"In blog listing show user as" => "U blog listi pokaži korisnika kao",
"creation date" => "datum pravljenja",
"last modification time" => "vreme zadnje izmene",
"CMS settings" => "CMS podešavanja",
"Time Zone" => "Vremenske zone",
"Server time zone" => "Vremenska zona na serveru",
"Time Zone Map" => "Mapa vremenskih zona",
"Wiki Page Names" => "Wiki Nazivi Stranica",
"strict" => "striktni",
"Ranking" => "Rangiranje",
"Warn on edit" => "Upozori o izmeni",
"Enable watch by default for author" => "Omogući podrazumevano nadgledanje za autore",
"Enable watches when I am the editor" => "Omogući nadgledanje kada sam ja editor",
"Users can vote only one item from this chart per period" => "Korisnici mogu da glasaju samo za jednu stvar na ovom grafiku u toku jednog perioda",
"Prevent users from voting same item more than one time" => "Spreči korisnike da ne glasaju za istu stvar više od jednom",
"ChatAdmin" => "Chat Administracija",
"half a second" => "pola sekunde",
"AdminDSN" => "Administriraj DSN",
"admin ExternalWiki" => "administriraj eksterni Wiki",
"Threads can be voted" => "Niti mogu da budu izglasavane",
"Directory (include trailing slash)" => "Direktorijum (sa pratećom kosom crtom)",
"admin HtmlPages" => "administriraj HTML strane",
"WebMail accounts" => "Webmail nalozi",
"Add all your site users to this newsletter (broadcast)" => "Dodaj sve korisnike sajta ovim novinama (globalno)",
"Add users" => "Dodaj korisnike",
"Create New Survey:" => "Napravi novu anketu:",
"stat" => "stat.",
"Show status when listing tracker items?" => "Prikaži status na spisku zapisa trakera?",
"Add New Group" => "Dodaj novu grupu",
"Edit this group:" => "Izmeni ovu grupu:",
"assign_perms" => "dodeli_dozvole",
"assign group" => "dodeli grupu",
"view info" => "vidi informacije",
"File gals" => "Galerije fajlova",
"Image gals" => "Galerije slika",
"Cms" => "CMS",
"Content Templates" => "Šabloni sadržaja",
"ExtWikis" => "ExtWiki",
"assgn" => "dodeli",
"Klick to enlarge" => "Klikni da povećaš",
"You can include the image in an HTML or Tiki page using" => "Možete da uključite sliku u HTML ili Tiki koristeći",
"Calendars Panel" => "Kalendari",
"Url" => "URL",
"today" => "danas",
"save a custom copy" => "snimi promenjenu kopiju",
"use square brackets for an" => "koristi uglaste zagrade za",
"link_description" => "opis_linka",
"Prevents parsing data" => "Sprečava parsiranje podataka",
"Reuse question" => "Koristi stara pitanja",
"act status" => "status uloge",
"running" => "pokretanje",
"Add scaled images size X x Y" => "Dodaj skalirane slike veličine X x Y",
"Import pages from a PHPWiki Dump" => "Uvezi strane iz PHPWiki ostave",
"Path to where the dumped files are (relative to tiki basedir with trailing slash ex: dump/)" => "Put do mesta gde je skladište fajlova (relativno u odnosu na tiki osnovni direktorijum sa pratećom kosom crtom mpr: dump/)",
"ver" => "verzija",
"Newss from" => "Novosti sa",
"Received Pages" => "Primljene strane",
"Send Objects" => "Pošalji objekte",
"Show chart for the last " => "Pokaži grafik za zadnjih ",
"days (0=all)" => "dana (0=svi)",
"Control by Object" => "Kontrola po objektima",
"Control by category" => "Kontrola po kategoriji",
"use filename" => "koristi ime fajla",
"remove bookmark" => "obriši omiljenu stranu",
"Use dbl click to edit pages" => "Koristi dupli klik za menjanje strana",
"Change your email" => "Promeni email",
"change email" => "promeni email",
"Change your password" => "Promeni lozinku",
"change password" => "promeni lozinku",
"Configure this page" => "Promeni ovu stranu",
"All tasks" => "Svi poslovi",
"mark as done" => "označi kao urađeno",
"open tasks" => "otvori poslove",
"Add or edit a task" => "Dodaj ili promeni posao",
"Start date" => "Datum početka",
"Completed" => "Završeno",
"FAQ Questions" => "FAQ pitanja",
"FAQ Answers" => "FAQ odgovori",
"Show suggested questions/suggest a question" => "Prikaži predložena pitanja/predloži pitanje",
"Hide suggested questions" => "Sakrij predložena pitanja",
"Tiki forums" => "Tiki forumi",
"this post was reported" => "ova poruka je prijavljena",
"report this post" => "prijavi ovu poruku",
"Tracker Items" => "Zapisi trakera",
"Filters" => "Filteri",
"checked" => "uključen",
"unchecked" => "isključen",
"Mark as Flagged" => "Označi",
"someone from" => "neko sa",
"You can edit the page following this link:" => "Možete izmeniti stranicu koristeći sledeći link:",
"Diff:" => "Razlika:",
"The new page content is:" => "Novi sadržaj strane je:",
"MyTiki (click!)" => "MojTiki",
"Admin (click!)" => "Administracija",
"More info about" => "Više informacija o",
"idle" => "pauziran",
"LDAP Host" => "LDAP Host",
"LDAP Port" => "LDAP Port",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::primeni: razlika u broju linija: %s != %s",
"WikiDiff::_check: failed" => "WikiDigg::_provera: neuspeo",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_provera: sekvenca izmene nije optimalna",
"WikiDiff Okay: LCS = %s" => "WikiDiff u redu: LCS = %s",
"no description" => "nema opisa",
"requested a reminder of the password for the" => "zahtevao podsećanje lozinke za",
"since this is your registered email address we inform that the" => "pošto je ovo vaša registrovana email adresa obaveštavamo vas da",
"password for this account is" => "lozinka za ovaj nalog je",
"Information:" => "Informacije:",
"The page {\$mail_page} was changed by {\$mail_user} at\n{\$mail_date|tiki_short_datetime}" => "Stranu {\$mail_page} je promenio {\$mail_user} dana\n{\$mail_date|tiki_short_datetime}",
"You can view the page by following this link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}" => "Stranu možete videti ako pratite sledeći link:\n    {\$mail_machine}/tiki-index.php?page={\$mail_page|escape:\"url\"}",
"You can edit the page by following this link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}" => "Stranu možete izmeniti ako odete na sledeći link:\n    {\$mail_machine}/tiki-editpage.php?page={\$mail_page|escape:\"url\"}",
"You can view a diff back to the previous version by following\nthis link:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}" => "Razliku u odnosu na prošlu verziju možete videti na\novom linku:\n    {\$mail_machine}/tiki-pagehistory.php?page={\$mail_page|escape:\"url\"}&diff2={\$mail_last_version}",
"Please" => "Molimo",
"log in" => "login",
"to access full functionalities" => "da bi iskoristili sve mogućnosti",
"Blog settings" => "Podešavanja blogova",
"FAQs settings" => "Podešavanja FAQ",
"FAQ comments" => "FAQ komentari",
"Remind passwords by email" => "Šalji zaboravljenu lozinku email-om",
"Poll settings" => "Podešavanja upitnika",
"Append CSS file to feed urls" => "Dodaj CSS fajl izvornim URL",
"Publisher" => "Objavio",
"Create a tag for the current wiki" => "Napravi tag za trenutni wiki",
"Tag Name" => "Ime Taga",
"Restore the wiki" => "Vrati wiki u prošlo stanje",
"Remove a tag" => "Ukloni tag",
"Wiki comments settings" => "Wiki podešavanja komentara",
"Wiki page list configuration" => "Podešavanje liste Wiki strana",
"Like pages" => "Slične strane",
"Set" => "Podesi",
"Administration" => "Administracija",
"List Calendars" => "Lista kalendara",
"admin Drawings" => "administriraj crteže",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Koristite {literal}{{/literal}ed id=name} ili {literal}{{/literal}ted id=name} da bi ubacili dinamičke zone",
"Batch upload (CSV file)" => "Grupni upload (CSV fajl)",
"Add Calendar Item" => "Dodaj u kalendar",
"Emphasis" => "Naglasak",
"italics" => "italik",
"both" => "oba",
"use ...page... to separate pages" => "koristite ...page... da bi razdvojili strane",
"make_headings" => "napravi_zaglavlje",
"underlines text" => "podvlači tekst",
"Simple box" => "Jednostavan okvir",
"Will display using the indicated HTML color" => "Biće prikazan koristeći odabranu HTML boju",
"Center" => "Centrirano",
"Will display the text centered" => "Prikazaće tekst centrirano",
"Edit Submissions" => "Izmeni priloge",
"Activs" => "Aktivn.",
"Ins" => "Ubaci",
"time" => "vreme",
"Wiki quick help" => "Wiki brza pomoć",
"Quicklinks" => "Brzi linkovi",
"Comparing versions" => "Upoređivanje verzija",
"Actual_version" => "Stvarna_verzija",
"Diff to version" => "Razlike u odnosu na verziju",
"admin DynamicContent" => "administriraj Dinamički sadržaj",
"You have to create a gallery first!" => "Prvo morate da napravite galeriju!",
"perm" => "dozvola",
"Editing tracker item" => "Menjanje zapisa trakera",
"You do not have permission to write the template" => "Nemate dozvolu da pravite šablone",
"You have to type a searchword" => "Morate da napišete reč za pretraživanje",
"You have to provide a name to the image" => "Morate napisati ime slike",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "This script cannot be called directly" => "This script cannot be called directly",
// "The text in RED is" => "The text in RED is",
// "character(s) too long - please edit it." => "character(s) too long - please edit it.",
// "Algeria" => "Algeria",
// "American_Samoa" => "American_Samoa",
// "Angola" => "Angola",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Bermuda" => "Bermuda",
// "Bolivia" => "Bolivia",
// "Brazil" => "Brazil",
// "Brunei" => "Brunei",
// "Canada" => "Canada",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Colombia" => "Colombia",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech_Republic" => "Czech_Republic",
// "Denmark" => "Denmark",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El_Salvador" => "El_Salvador",
// "Estonia" => "Estonia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French_Polynesia" => "French_Polynesia",
// "Germany" => "Germany",
// "Greece" => "Greece",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Haiti" => "Haiti",
// "Honduras" => "Honduras",
// "Hungary" => "Hungary",
// "Chile" => "Chile",
// "China" => "China",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Malta" => "Malta",
// "Marshall_Islands" => "Marshall_Islands",
// "Mauritius" => "Mauritius",
// "Mexico" => "Mexico",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Nicaragua" => "Nicaragua",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norway" => "Norway",
// "Other" => "Other",
// "Pakistan" => "Pakistan",
// "Panama" => "Panama",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Phillippines" => "Phillippines",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Samoa" => "Samoa",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South_Africa" => "South_Africa",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Surinam" => "Surinam",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Taiwan" => "Taiwan",
// "Thailand" => "Thailand",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Turkey" => "Turkey",
// "Tuvalu" => "Tuvalu",
// "Ukraine" => "Ukraine",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_States" => "United_States",
// "Uruguay" => "Uruguay",
// "Vanuatu" => "Vanuatu",
// "Venezuela" => "Venezuela",
// "Wales" => "Wales",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Bulgaria" => "Bulgaria",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "Chinese" => "Chinese",
// "Czech" => "Czech",
// "Danish" => "Danish",
// "German" => "German",
// "English" => "English",
// "English British" => "English British",
// "Spanish" => "Spanish",
// "Greek" => "Greek",
// "Finnish" => "Finnish",
// "French" => "French",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Italian" => "Italian",
// "Japanese" => "Japanese",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Dutch" => "Dutch",
// "Norwegian" => "Norwegian",
// "Polish" => "Polish",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Russian" => "Russian",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Swedish" => "Swedish",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Administration:" => "Administration:",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "Line:" => "Line:",
// "Lines:" => "Lines:",
// "There was a problem with your upload." => "There was a problem with your upload.",
// "The file you are trying to upload is too big." => "The file you are trying to upload is too big.",
// "The file you are trying to upload was only partially uploaded." => "The file you are trying to upload was only partially uploaded.",
// "You must select a file for upload." => "You must select a file for upload.",
// "Continue" => "Continue",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "%s is an empty archive file" => "%s is an empty archive file",
// "Invalid remote file on url %s" => "Invalid remote file on url %s",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "This poll is closed." => "This poll is closed.",
// "Forums last posts" => "Forums last posts",
// "tikiwiki logo" => "tikiwiki logo",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Trackeritem" => "Trackeritem",
// "Tracker item" => "Tracker item",
// "The text is" => "The text is",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "Start date:" => "Start date:",
// "End date:" => "End date:",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on " => "Last seen on ",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "An error occured in a database query!" => "An error occured in a database query!",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "arts" => "arts",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "Removed" => "Removed",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Create page:" => "Create page:",
// "index" => "index",
// "show" => "show",
// "hide" => "hide",
// "Updated" => "Updated",
// "Click here to confirm your action" => "Click here to confirm your action",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "Status:" => "Status:",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "field is not numeric" => "field is not numeric",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "Checkbox options: put 1 if you need that next field is on the same row." => "Checkbox options: put 1 if you need that next field is on the same row.",
// "numeric field" => "numeric field",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login.",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "country selector" => "country selector",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
// "jscalendar" => "jscalendar",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "header" => "header",
// "Category options: parentId" => "Category options: parentId",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "system" => "system",
// "pending" => "pending",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "Include all post in a blog" => "Include all post in a blog",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "no such attachment on this page" => "no such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link.",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "and" => "and",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays a map" => "Displays a map",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "List wiki pages" => "List wiki pages",
// "Last modified by" => "Last modified by",
// "Clickable Skype link" => "Clickable Skype link",
// "Displays text in subscript." => "Displays text in subscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "Fields marked with a * are mandatory." => "Fields marked with a * are mandatory.",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "missing tracker ID for plugin TRACKER" => "missing tracker ID for plugin TRACKER",
// "missing fields list" => "missing fields list",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Plugin " => "Plugin ",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "move %s in %s" => "move %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "Changes" => "Changes",
// "Changes since" => "Changes since",
// "new posts" => "new posts",
// "new articles" => "new articles",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Tip: hold down CTRL to select multiple categories" => "Tip: hold down CTRL to select multiple categories",
// "Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: uncheck the above checkbox to uncategorize this page/object",
// "browse category" => "browse category",
// "Posted messages" => "Posted messages",
// "Plain" => "Plain",
// "Threaded" => "Threaded",
// "Headers Only" => "Headers Only",
// "below your current threshold" => "below your current threshold",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "Reply to parent post" => "Reply to parent post",
// "Post new reply" => "Post new reply",
// "Reply" => "Reply",
// "Posting replies" => "Posting replies",
// "HTML tags are not allowed inside posts" => "HTML tags are not allowed inside posts",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Last update from CVS" => "Last update from CVS",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Information" => "Information",
// "New topic:" => "New topic:",
// "Topic:" => "Topic:",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "Page not found:" => "Page not found:",
// "New message arrived from %s" => "New message arrived from %s",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link:" => "To validate that account, please follow the link:",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "Tiki User Registration Request" => "Tiki User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Your Tiki account information for %s" => "Your Tiki account information for %s",
// "New article submitted at %s" => "New article submitted at %s",
// "View the tracker item at:" => "View the tracker item at:",
// "Tracker was modified at" => "Tracker was modified at",
// "Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request have been stored and will be activated by the admin as soon as possible.",
// "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the article at:" => "View the article at:",
// "New article post at %s" => "New article post at %s",
// "New blog post at %s" => "New blog post at %s",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "Removed by" => "Removed by",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the page by following this link:" => "You can view the page by following this link:",
// "You can view a diff back to the previous version by following this link:" => "You can view a diff back to the previous version by following this link:",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "Wiki page %s changed" => "Wiki page %s changed",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Zoom out x4" => "Zoom out x4",
// "Zoom out x3" => "Zoom out x3",
// "Zoom out x2" => "Zoom out x2",
// "Pan" => "Pan",
// "Zoom in x2" => "Zoom in x2",
// "Zoom in x3" => "Zoom in x3",
// "Zoom in x4" => "Zoom in x4",
// "Go" => "Go",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Layer" => "Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "hits last 7 days" => "hits last 7 days",
// "Reload" => "Reload",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Version:" => "Version:",
// "Legend:" => "Legend:",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "older version" => "older version",
// "back to" => "back to",
// "Message Archive" => "Message Archive",
// "Edit template" => "Edit template",
// "messages" => "messages",
// "Archive is full!" => "Archive is full!",
// "download" => "download",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "move to archive" => "move to archive",
// "reply to" => "reply to",
// "find replied message" => "find replied message",
// "Sent" => "Sent",
// "Archive" => "Archive",
// "Auto-archive age for read messages:" => "Auto-archive age for read messages:",
// "Return to mailbox" => "Return to mailbox",
// "Unflag" => "Unflag",
// "Return to archive" => "Return to archive",
// "Return to outbox" => "Return to outbox",
// "Sent Messages" => "Sent Messages",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "receiver" => "receiver",
// "Hide module contents" => "Hide module contents",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module?" => "Are you sure you want to unassign this module?",
// "Shoutbox Words" => "Shoutbox Words",
// "System Admin" => "System Admin",
// "Security Admin" => "Security Admin",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "MyTiki home" => "MyTiki home",
// "FriendsMenu" => "FriendsMenu",
// "Community" => "Community",
// "User list" => "User list",
// "Friendship Network" => "Friendship Network",
// "ShtMenu" => "ShtMenu",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "Ephemerides Admin" => "Ephemerides Admin",
// "Charts Admin" => "Charts Admin",
// "Admin home" => "Admin home",
// "Mods Admin" => "Mods Admin",
// "Tikiwiki Assistant" => "Tikiwiki Assistant",
// "Thank you for installing Tikiwiki" => "Thank you for installing Tikiwiki",
// "Click the :: options in the Menu for more options." => "Click the :: options in the Menu for more options.",
// "Please, also see" => "Please, also see",
// "for more setup details." => "for more setup details.",
// "Note 1:" => "Note 1:",
// "You can remove this module in" => "You can remove this module in",
// "as well as assign or edit many others." => "as well as assign or edit many others.",
// "Note 2:" => "Note 2:",
// "The menu module installed by default is named" => "The menu module installed by default is named",
// "it is a \"custom module\" which includes menu ID " => "it is a \"custom module\" which includes menu ID ",
// "That menu is stored in database and it can be edited from " => "That menu is stored in database and it can be edited from ",
// "Do not mix this with the original <em>application_menu</em> module" => "Do not mix this with the original <em>application_menu</em> module",
// "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"",
// "January" => "January",
// "February" => "February",
// "March" => "March",
// "April" => "April",
// "May" => "May",
// "June" => "June",
// "July" => "July",
// "August" => "August",
// "September" => "September",
// "October" => "October",
// "November" => "November",
// "December" => "December",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last visitors" => "Last visitors",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "on host" => "on host",
// " on page " => " on page ",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "Manage structures" => "Manage structures",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "page id" => "page id",
// "3d browser" => "3d browser",
// "Child" => "Child",
// "Add Page" => "Add Page",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Page last modified on" => "Page last modified on",
// "Contributors to this page" => "Contributors to this page",
// "translation" => "translation",
// "User List" => "User List",
// "Homework" => "Homework",
// "Assignments" => "Assignments",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Member list" => "Member list",
// "logout" => "logout",
// "Edit Summary" => "Edit Summary",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "RSS Trackers" => "RSS Trackers",
// "Location : " => "Location : ",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "Welcome to" => "Welcome to",
// "Click here to create it" => "Click here to create it",
// "Meta Tags" => "Meta Tags",
// "Site Identity" => "Site Identity",
// "Site Calendar" => "Site Calendar",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "i18n" => "i18n",
// "Tip" => "Tip",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "Post level trackback pings" => "Post level trackback pings",
// "Not Installed" => "Not Installed",
// "Creation date" => "Creation date",
// "Last modification time" => "Last modification time",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "Change settings" => "Change settings",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Print article" => "Print article",
// "Settings for page articles home" => "Settings for page articles home",
// "User identity features" => "User identity features",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Picture" => "Picture",
// "Number of friends" => "Number of friends",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "tikiwiki.org help" => "tikiwiki.org help",
// "Multilingual" => "Multilingual",
// "Best language" => "Best language",
// "Template Viewing" => "Template Viewing",
// "PHPLayers" => "PHPLayers",
// "Use Tabs" => "Use Tabs",
// "Tiki Sheet" => "Tiki Sheet",
// "Site Logo and Identity" => "Site Logo and Identity",
// "Mobile" => "Mobile",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;>&rdquo; for quoting",
// "Contact Us (Anonymous)" => "Contact Us (Anonymous)",
// "Redirect On Error" => "Redirect On Error",
// "always" => "always",
// "module decides" => "module decides",
// "never" => "never",
// "Users can Shade Modules" => "Users can Shade Modules",
// "User Watches Translations" => "User Watches Translations",
// "Users can Flip Columns" => "Users can Flip Columns",
// "user decides" => "user decides",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "Home Gallery" => "Home Gallery",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Storing files in a directory" => "Storing files in a directory",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Change configuration" => "Change configuration",
// "File galleries search indexing" => "File galleries search indexing",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
// "Enable auto indexing on file upload or change" => "Enable auto indexing on file upload or change",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum" => "Home Forum",
// "Forums features" => "Forums features",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Enable cache images to all galleries" => "Enable cache images to all galleries",
// "Images cache directory" => "Images cache directory",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change style only" => "Change style only",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Detect browser language" => "Detect browser language",
// "PHP error reporting level for non-admin:" => "PHP error reporting level for non-admin:",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Report PHP errors only for admin" => "Report PHP errors only for admin",
// "Default charset for sending mail:" => "Default charset for sending mail:",
// "Mail end of line:" => "Mail end of line:",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "output compression is active." => "output compression is active.",
// "compression is handled by" => "compression is handled by",
// "HTTPS Server" => "HTTPS Server",
// "Automatic (uses HTTPS variable)" => "Automatic (uses HTTPS variable)",
// "Allow anonymous users to \"Contact Us\"" => "Allow anonymous users to \"Contact Us\"",
// "Help URL" => "Help URL",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Favicon icon file name:" => "Favicon icon file name:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Locations separator" => "Locations separator",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Restrict available languages" => "Restrict available languages",
// "Available languages:" => "Available languages:",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "IP" => "IP",
// "New" => "New",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// "Admin->Features" => "Admin->Features",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Users &amp; groups" => "Users &amp; groups",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "... but need admin validation" => "... but need admin validation",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
// " - Php GD library required" => " - Php GD library required",
// "Validate email address (may not work)" => "Validate email address (may not work)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Reg users can change password" => "Reg users can change password",
// "Restrict available themes" => "Restrict available themes",
// "Available styles:" => "Available styles:",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "year" => "year",
// "Remember me name" => "Remember me name",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
// "choose a group ..." => "choose a group ...",
// "LDAP" => "LDAP",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "<b>Item</b>" => "<b>Item</b>",
// "<b>Value</b>" => "<b>Value</b>",
// "Meta Keywords" => "Meta Keywords",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "Geourl" => "Geourl",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "meta robots" => "meta robots",
// "revisit after" => "revisit after",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Allow Anonymous Poll Voting" => "Allow Anonymous Poll Voting",
// "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or",
// "Feed for directories" => "Feed for directories",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for tracker items" => "Feed for tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "Search features" => "Search features",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Performance issues" => "Performance issues",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Settings for searching content" => "Settings for searching content",
// "Search refresh rate" => "Search refresh rate",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Don't forget: to use feature you will need to enable it on" => "Don't forget: to use feature you will need to enable it on",
// "Custom Code" => "Custom Code",
// "Custom code" => "Custom code",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site breadcrumbs" => "Site breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description:" => "Use page description:",
// "Site Search" => "Site Search",
// "Site search bar" => "Site search bar",
// "Site Logo" => "Site Logo",
// "Site logo" => "Site logo",
// "Site logo source" => "Site logo source",
// "Site logo background color" => "Site logo background color",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site Ads and Banners" => "Site Ads and Banners",
// "Site ads and banners" => "Site ads and banners",
// "Site Menu" => "Site Menu",
// "Site menu bar" => "Site menu bar",
// "Note: This feature also requires phplayers to be turned on in Admin->Features" => "Note: This feature also requires phplayers to be turned on in Admin->Features",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Trackers attachments" => "Trackers attachments",
// "Storage" => "Storage",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Unlimited" => "Unlimited",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name" => "Tag name",
// "Restore the Wiki" => "Restore the Wiki",
// "Remove a Tag" => "Remove a Tag",
// "Wiki Comments Settings" => "Wiki Comments Settings",
// "Wiki Administration" => "Wiki Administration",
// "Manage attachment preferences" => "Manage attachment preferences",
// "Wiki Link Format" => "Wiki Link Format",
// "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>.",
// "latin" => "latin",
// "english" => "english",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "HTML in Wiki Pages" => "HTML in Wiki Pages",
// "Wiki syntax used when a page contains HTML" => "Wiki syntax used when a page contains HTML",
// "partial" => "partial",
// "Wysiwyg editor" => "Wysiwyg editor",
// "default" => "default",
// "optional" => "optional",
// "Anonymous editors must input anti-bot code" => "Anonymous editors must input anti-bot code",
// "Similar" => "Similar",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Show page ID" => "Show page ID",
// "Footnotes" => "Footnotes",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Use Wiki paragraph formatting" => "Use Wiki paragraph formatting",
// "Open page as structure" => "Open page as structure",
// "Use external link icons" => "Use external link icons",
// "User's Page" => "User's Page",
// "UserPage prefix" => "UserPage prefix",
// "List authors" => "List authors",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "Print Page" => "Print Page",
// "Search and replace" => "Search and replace",
// "unlimited" => "unlimited",
// "IP not displayed in history" => "IP not displayed in history",
// "Diff style" => "Diff style",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Wiki attachments preferences" => "Wiki attachments preferences",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Help on Banning System" => "Help on Banning System",
// "Configure/Options" => "Configure/Options",
// "participants" => "participants",
// "subscription" => "subscription",
// "perso" => "perso",
// "Custom Participants" => "Custom Participants",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "browse the category system" => "browse the category system",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Assign permissions automatically" => "Assign permissions automatically",
// "recommended for best performance" => "recommended for best performance",
// "Edit permissions for this category" => "Edit permissions for this category",
// "View template" => "View template",
// "admin charts template" => "admin charts template",
// "Users can vote for only one item from this chart per period" => "Users can vote for only one item from this chart per period",
// "Prevent users from voting for the same item more than once" => "Prevent users from voting for the same item more than once",
// "Chat Admin" => "Chat Admin",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Half a second" => "Half a second",
// "admin content templates template" => "admin content templates template",
// "use in events" => "use in events",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Help on Drawings" => "Help on Drawings",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Admin DSN" => "Admin DSN",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "admin External Wikis" => "admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "admin forums template" => "admin forums template",
// "Edit existing forums" => "Edit existing forums",
// "Posts can be rated" => "Posts can be rated",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Edit Existing Forums" => "Edit Existing Forums",
// "Assign Permissions (Active)" => "Assign Permissions (Active)",
// "Assign Permissions" => "Assign Permissions",
// "Click here to delete this forum" => "Click here to delete this forum",
// "admin hotwords template" => "admin hotwords template",
// "admin Html Pages" => "admin Html Pages",
// "admin Html Pages template" => "admin Html Pages template",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Regex modifiers" => "Regex modifiers",
// "admin featured links template" => "admin featured links template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Mail-in accounts" => "Mail-in accounts",
// "admin mailin template" => "admin mailin template",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "Frequency" => "Frequency",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "sorted section" => "sorted section",
// "separator" => "separator",
// "admin menus template" => "admin menus template",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "admin modules template" => "admin modules template",
// "parameters" => "parameters",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "use phplayermenu" => "use phplayermenu",
// "structure" => "structure",
// "Add email:" => "Add email:",
// "Add user:" => "Add user:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "admin newsletters template" => "admin newsletters template",
// "send newsletter" => "send newsletter",
// "archives" => "archives",
// "admin notifications template" => "admin notifications template",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "PHP error" => "PHP error",
// "No records found." => "No records found.",
// "admin polls template" => "admin polls template",
// "configure polls" => "configure polls",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "admin RSSmodules template" => "admin RSSmodules template",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "Score System" => "Score System",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "edit tpl" => "edit tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Setting" => "Setting",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "Tikiwiki settings" => "Tikiwiki settings",
// "Tiki variable" => "Tiki variable",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "File checks" => "File checks",
// "State" => "State",
// "Admin Shoutbox Words" => "Admin Shoutbox Words",
// "admin shoutbox words" => "admin shoutbox words",
// "admin shoutbox words template" => "admin shoutbox words template",
// "Add Banned Word" => "Add Banned Word",
// "Are you sure you want to delete this word?" => "Are you sure you want to delete this word?",
// "admin structures template" => "admin structures template",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "administer surveys template" => "administer surveys template",
// "Create New Survey" => "Create New Survey",
// "active perms" => "active perms",
// "system admin" => "system admin",
// "system admin tpl" => "system admin tpl",
// "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be)." => "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be).",
// "Empty" => "Empty",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function!" => "Warning: Make a backup of your Database before using this function!",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Table" => "Table",
// "Field" => "Field",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "admin topics template" => "admin topics template",
// "Remove with articles" => "Remove with articles",
// "Column is searchable?" => "Column is searchable?",
// "Field is public? (for use thru trackerlist plugin)" => "Field is public? (for use thru trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Field is mandatory?" => "Field is mandatory?",
// "Searchable" => "Searchable",
// "Public" => "Public",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/export trackers fields" => "Import/export trackers fields",
// "Edit fields for tracker" => "Edit fields for tracker",
// "Edit tracker" => "Edit tracker",
// "Create trackers" => "Create trackers",
// "Import/export" => "Import/export",
// "active permissions" => "active permissions",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker needs a text field named Subject" => "The tracker needs a text field named Subject",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items?" => "Item creator can modify his items?",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Member of the default group of creator can modify items?" => "Member of the default group of creator can modify items?",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "What field is used for default sort?" => "What field is used for default sort?",
// "What is default sort order in list?" => "What is default sort order in list?",
// "ascending" => "ascending",
// "descending" => "descending",
// "Tracker items allow ratings?" => "Tracker items allow ratings?",
// "with values" => "with values",
// "and display rating results in listing?" => "and display rating results in listing?",
// "and display comments in listing?" => "and display comments in listing?",
// "and display attachments in listing?" => "and display attachments in listing?",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "filename" => "filename",
// "filesize" => "filesize",
// "filetype" => "filetype",
// "longdesc" => "longdesc",
// "Import/export trackers" => "Import/export trackers",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "admin groups template" => "admin groups template",
// "Edit group" => "Edit group",
// "Members" => "Members",
// "Add a new group" => "Add a new group",
// "assign permissions" => "assign permissions",
// "Group Homepage" => "Group Homepage",
// "Use wiki page name or full URL" => "Use wiki page name or full URL",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "Members List" => "Members List",
// "remove from group" => "remove from group",
// "users in group" => "users in group",
// "List all members" => "List all members",
// "admin users template" => "admin users template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Edit user" => "Edit user",
// "Change user preferences" => "Change user preferences",
// "edit account settings" => "edit account settings",
// "Assign Group" => "Assign Group",
// "edit included group" => "edit included group",
// "select all" => "select all",
// "Perform action with checked:" => "Perform action with checked:",
// "remove users and their userpages" => "remove users and their userpages",
// "manage group assignments" => "manage group assignments",
// "set default groups" => "set default groups",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups:" => "the following groups:",
// "Tip: hold down CTRL to select multiple" => "Tip: hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "assign to groups" => "assign to groups",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "Registration" => "Registration",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Allow ratings by the author" => "Allow ratings by the author",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show topic or own image" => "Show topic or own image",
// "Show author's avatar" => "Show author's avatar",
// "Show author name" => "Show author name",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Delete this type" => "Delete this type",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Available groups" => "Available groups",
// "assign perms to this group" => "assign perms to this group",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP.",
// "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP.",
// "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP.",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "width" => "width",
// "height" => "height",
// "remove file extension from image name" => "remove file extension from image name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert sub directories to sub galleries" => "convert sub directories to sub galleries",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created",
// "use sub directory names as description" => "use sub directory names as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created",
// "Select a Gallery" => "Select a Gallery",
// "Mark entry as private:" => "Mark entry as private:",
// "admin the category system" => "admin the category system",
// "admin category" => "admin category",
// "Browse in" => "Browse in",
// "Wiki pages" => "Wiki pages",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "list galleries" => "list galleries",
// "Directory batch" => "Directory batch",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "hit" => "hit",
// "slideshow forward" => "slideshow forward",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Latitude (WGS84/decimal degrees)" => "Latitude (WGS84/decimal degrees)",
// "Longitude (WGS84/decimal degrees)" => "Longitude (WGS84/decimal degrees)",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "add item" => "add item",
// "Edit/Create" => "Edit/Create",
// "Focus:" => "Focus:",
// "change focus" => "change focus",
// "quarter" => "quarter",
// "semester" => "semester",
// "calendar view" => "calendar view",
// "list view" => "list view",
// "zoom" => "zoom",
// "Subscription List" => "Subscription List",
// "Syntax error" => "Syntax error",
// "Format: mm/dd/yyyy hh:mm<br />..." => "Format: mm/dd/yyyy hh:mm<br />...",
// "See strtotime php function" => "See strtotime php function",
// "Format: mm/dd/yyy hh:mm<br />..." => "Format: mm/dd/yyy hh:mm<br />...",
// "save_to" => "save_to",
// "close" => "close",
// "click to view" => "click to view",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "CSV File" => "CSV File",
// "Assign permissions to category" => "Assign permissions to category",
// "Current permissions for this category" => "Current permissions for this category",
// "remove from this category &amp; all its children" => "remove from this category &amp; all its children",
// "remove from this category only" => "remove from this category only",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance." => "Assigning permissions for <b>all children</b> is recommended for best performance.",
// "There are no channels setup, please contact a site admin" => "There are no channels setup, please contact a site admin",
// "click here to send us an email" => "click here to send us an email",
// "You cannot add sites until Directory Categories are setup." => "You cannot add sites until Directory Categories are setup.",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "add a category" => "add a category",
// "Topline" => "Topline",
// "Subtitle" => "Subtitle",
// "Source" => "Source",
// "pixels" => "pixels",
// "Image caption" => "Image caption",
// "Create Blog" => "Create Blog",
// "Allow trackback pings" => "Allow trackback pings",
// "Show user avatar" => "Show user avatar",
// "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "row" => "row",
// "col" => "col",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Horizontal rule" => "Horizontal rule",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "Preformated sections" => "Preformated sections",
// "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]." => "Use [[foo] to show [foo].",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Table of contents" => "Table of contents",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Quicktags" => "Quicktags",
// "italic" => "italic",
// "underline" => "underline",
// "table" => "table",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "heading1" => "heading1",
// "title bar" => "title bar",
// "box" => "box",
// "rss feed" => "rss feed",
// "dynamic content" => "dynamic content",
// "tagline" => "tagline",
// "hr" => "hr",
// "center text" => "center text",
// "colored text" => "colored text",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "admin quicktags" => "admin quicktags",
// "browse image" => "browse image",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "edit quiz questions" => "edit quiz questions",
// "edit quiz questions tpl" => "edit quiz questions tpl",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "Help on Articles" => "Help on Articles",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "save only in the theme:" => "save only in the theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Edit Translation:" => "Edit Translation:",
// "edit translations" => "edit translations",
// "edit translations template" => "edit translations template",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "Use this section to set the language of the version you are currently working on." => "Use this section to set the language of the version you are currently working on.",
// "Set of Translations" => "Set of Translations",
// "detach" => "detach",
// "add to the set" => "add to the set",
// "Select the article for which the current article is the translation." => "Select the article for which the current article is the translation.",
// "Translation of:" => "Translation of:",
// "Enter the name of the page for which the current page is the translation." => "Enter the name of the page for which the current page is the translation.",
// "Use rating" => "Use rating",
// "disable" => "disable",
// "There is no available poll template." => "There is no available poll template.",
// "You should ask an admin to create them." => "You should ask an admin to create them.",
// "an existing poll" => "an existing poll",
// "Search " => "Search ",
// "Case Insensitivity" => "Case Insensitivity",
// "replace" => "replace",
// "File Galleries tpl" => "File Galleries tpl",
// "configure forum" => "configure forum",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "refuse" => "refuse",
// "Waiting requests" => "Waiting requests",
// "Your friends" => "Your friends",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Days" => "Days",
// "Minutes" => "Minutes",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Not ended" => "Not ended",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Not defined" => "Not defined",
// "rebuild cache" => "rebuild cache",
// "Geographic" => "Geographic",
// "Default sort order" => "Default sort order",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Parent gallery" => "Parent gallery",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Owner of the gallery" => "Owner of the gallery",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Left" => "Left",
// "Right" => "Right",
// "Series" => "Series",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "reload" => "reload",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Install" => "Install",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "v" => "v",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "Future vers" => "Future vers",
// "monitor this gallery" => "monitor this gallery",
// "stop monitoring this gallery" => "stop monitoring this gallery",
// "games tpl" => "games tpl",
// "/" => "/",
// "list quizzes tpl" => "list quizzes tpl",
// "edit quiz stats tpl" => "edit quiz stats tpl",
// "actions" => "actions",
// "take survey" => "take survey",
// "list trackers tpl" => "list trackers tpl",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "operator" => "operator",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\").",
// "all types" => "all types",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "install" => "install",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "Last editor" => "Last editor",
// "Last modification" => "Last modification",
// "y" => "y",
// "subscribe" => "subscribe",
// "Sent edition" => "Sent edition",
// "Available Newsletters" => "Available Newsletters",
// "News from" => "News from",
// "Read the news" => "Read the news",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "rollback to this version" => "rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "No individual permissions; category or global permissions apply" => "No individual permissions; category or global permissions apply",
// "this structure" => "this structure",
// "Current permissions for categories that this page belongs to" => "Current permissions for categories that this page belongs to",
// "No category permissions; global permissions apply" => "No category permissions; global permissions apply",
// "no avatar" => "no avatar",
// "icons" => "icons",
// "Any" => "Any",
// "atts" => "atts",
// "Number of voices" => "Number of voices",
// "List Attachments" => "List Attachments",
// "Note: Remember that this is only a preview, and has not yet been saved!" => "Note: Remember that this is only a preview, and has not yet been saved!",
// "add structure" => "add structure",
// "Edit quiz" => "Edit quiz",
// "Current Version" => "Current Version",
// "General Options" => "General Options",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "P" => "P",
// "F" => "F",
// "Help on Communication Center" => "Help on Communication Center",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
// "You don't have permission to use this feature." => "You don't have permission to use this feature.",
// "Please register." => "Please register.",
// "last version" => "last version",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Change" => "Change",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "entire site" => "entire site",
// "wiki pages" => "wiki pages",
// "Apply content template" => "Apply content template",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "create new sheet" => "create new sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Graph" => "Graph",
// "first" => "first",
// "santa" => "santa",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Daily Usage" => "Daily Usage",
// "SysLog" => "SysLog",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Thank you for your submission" => "Thank you for your submission",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Control by Objects" => "Control by Objects",
// "Edit File:" => "Edit File:",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Create page" => "Create page",
// "This user is your friend" => "This user is your friend",
// "Request friendship from this user" => "Request friendship from this user",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "Personal Information" => "Personal Information",
// "General preferences" => "General preferences",
// "Other preferences" => "Other preferences",
// "use google map locator" => "use google map locator",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Change information" => "Change information",
// "Unavailable - please set your e-mail below" => "Unavailable - please set your e-mail below",
// "Does your mail reader need a special charset" => "Does your mail reader need a special charset",
// "Use double-click to edit pages" => "Use double-click to edit pages",
// "Account Information" => "Account Information",
// "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Leave \"New password\" and \"Confirm new password\" fields blank to keep current password",
// "Email address" => "Email address",
// "Confirm new password" => "Confirm new password",
// "Current password (required)" => "Current password (required)",
// "Change administrative info" => "Change administrative info",
// "Note author when reading his mail" => "Note author when reading his mail",
// "Auto-archive read messages after x days" => "Auto-archive read messages after x days",
// "My workflow" => "My workflow",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "accepted by task user and creator" => "accepted by task user and creator",
// "accepted user and creator" => "accepted user and creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "not accepted by one user" => "not accepted by one user",
// "not accepted user" => "not accepted user",
// "Task is rejected by one user" => "Task is rejected by one user",
// "waiting for me" => "waiting for me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "waiting for other user" => "waiting for other user",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "admin mode" => "admin mode",
// "trash" => "trash",
// "empty trash" => "empty trash",
// "Edit task" => "Edit task",
// "red" => "red",
// "NOT accept" => "NOT accept",
// "remove from trash" => "remove from trash",
// "move into trash" => "move into trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "use start date and time" => "use start date and time",
// "use end date and time" => "use end date and time",
// "open / in process" => "open / in process",
// "waiting / not started" => "waiting / not started",
// "waiting" => "waiting",
// "shared for group" => "shared for group",
// "accepted by user" => "accepted by user",
// "no / rejected" => "no / rejected",
// "accepted by creator" => "accepted by creator",
// "Info" => "Info",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "select one" => "select one",
// "undo trash" => "undo trash",
// "show:" => "show:",
// "received" => "received",
// "submitted" => "submitted",
// "shared" => "shared",
// "all shared tasks" => "all shared tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Add Watch" => "Add Watch",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "edit user files" => "edit user files",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "permanency" => "permanency",
// "Answers" => "Answers",
// "add suggestion" => "add suggestion",
// "1 suggestion" => "1 suggestion",
// "suggestions" => "suggestions",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "posts:" => "posts:",
// "Edit fields" => "Edit fields",
// " item found" => " item found",
// " items found" => " items found",
// "list attachments" => "list attachments",
// "View inserted item" => "View inserted item",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Tracker item:" => "Tracker item:",
// "Filter Tracker Items" => "Filter Tracker Items",
// "more info" => "more info",
// "remove image" => "remove image",
// "Special Operations" => "Special Operations",
// "Details" => "Details",
// "Webmail Doc template" => "Webmail Doc template",
// "Edit mail account" => "Edit mail account",
// "%s enabled" => "%s enabled",
// "%s disabled" => "%s disabled",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Projects" => "Projects",
// "Projects configuration" => "Projects configuration",
// "Community settings" => "Community settings",
// "Site Identity features" => "Site Identity features",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Click here to delete this category" => "Click here to delete this category",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
// "You cannot have a blank password" => "You cannot have a blank password",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details." => "register_globals should be off by default. See the php manual for details.",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid should be off by default. See the php manual for details.",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config.",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check." => "File is not readable. Unable to check.",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// " or " => " or ",
// "You have to provide a word" => "You have to provide a word",
// "You don't have permission to use this feature" => "You don't have permission to use this feature",
// "No Errors detected" => "No Errors detected",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "New %s created with %s %s." => "New %s created with %s %s.",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "%s %s successfully deleted." => "%s %s successfully deleted.",
// "%s %s removed from %s %s." => "%s %s removed from %s %s.",
// "%s <b>%s</b> successfully deleted." => "%s <b>%s</b> successfully deleted.",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "%s modified successfully." => "%s modified successfully.",
// "%s modification failed." => "%s modification failed.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "rss feed disabled" => "rss feed disabled",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles." => "Last articles.",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs." => "Last posts to weblogs.",
// "Please login" => "Please login",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "%m/%d" => "%m/%d",
// "Access Denied" => "Access Denied",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "Start:" => "Start:",
// "End:" => "End:",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "The passwords didn't match" => "The passwords didn't match",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites." => "Last sites.",
// "Site No validated yet" => "Site No validated yet",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "No object indicated" => "No object indicated",
// "No type indicated" => "No type indicated",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "unknown error" => "unknown error",
// "cannot be found" => "cannot be found",
// "No permission to view the page" => "No permission to view the page",
// "No questions group indicated" => "No questions group indicated",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries." => "Last files uploaded to the file galleries.",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums." => "Last topics in forums.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request!" => "I have refused your friendship request!",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Account validated successfully." => "Account validated successfully.",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Sorry, you can't use this feature." => "Sorry, you can't use this feature.",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "Please create a directory named \$map_path to hold your map files." => "Please create a directory named \$map_path to hold your map files.",
// "I could not make a copy" => "I could not make a copy",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available." => "List of maps available.",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled." => "Your PHP installation does not have zlib enabled.",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "Registered" => "Registered",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "A new (and temporary) password and your IP address has been sent " => "A new (and temporary) password and your IP address has been sent ",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "No newsletters available." => "No newsletters available.",
// "Error: " => "Error: ",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "This feature is for admins only" => "This feature is for admins only",
// "empty" => "empty",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "File update was successful" => "File update was successful",
// "Could not find the file requested" => "Could not find the file requested",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "Usage" => "Usage",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Changes:" => "Changes:",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// "A SheetId is required." => "A SheetId is required.",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki." => "Last modifications to the Wiki.",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"blog" => "blog",
"forum" => "forum",
"Blog" => "Blog",
"Login" => "Login",
"Wiki" => "Wiki",
"FAQ" => "FAQ",
"Forum" => "Forum",
"Link" => "Link",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"%H:%M %Z" => "%H:%M %Z",
"wiki" => "wiki",
"email" => "email",
"sql query" => "sql query",
"debug" => "debug",
"On" => "On",
"Ip" => "Ip",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"filter" => "filter",
"To" => "To",
"CC" => "CC",
"BCC" => "BCC",
"Cc" => "Cc",
"QuickTags" => "QuickTags",
"Chat" => "Chat",
"Mail-in" => "Mail-in",
"phpinfo" => "phpinfo",
"Webmail" => "Webmail",
"Admin" => "Admin",
"Integrator" => "Integrator",
"DSN" => "DSN",
"Filter" => "Filter",
"Logout" => "Logout",
"login" => "login",
"Tiki Logo" => "Tiki Logo",
"Email" => "Email",
"pdf" => "pdf",
"chat" => "chat",
"Permalink" => "Permalink",
"RSS" => "RSS",
"ok" => "ok",
"JsCalendar" => "JsCalendar",
"XMLRPC API" => "XMLRPC API",
"OS" => "OS",
"Unix" => "Unix",
"Windows" => "Windows",
"Proxy Host" => "Proxy Host",
"Proxy port" => "Proxy port",
"port" => "port",
"Web Server" => "Web Server",
"HTTP port" => "HTTP port",
"HTTPS port" => "HTTPS port",
"PEAR::Auth" => "PEAR::Auth",
"Editor" => "Editor",
"Webmaster" => "Webmaster",
"Status" => "Status",
"x" => "x",
"ID" => "ID",
"loc" => "loc",
"prio" => "prio",
"URL" => "URL",
"admin FortuneCookie tpl" => "admin FortuneCookie tpl",
"upload" => "upload",
"tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
"dsn" => "dsn",
"POP3 server" => "POP3 server",
"avatar" => "avatar",
"coms" => "coms",
"Zone" => "Zone",
"zone" => "zone",
"Regex" => "Regex",
"Case" => "Case",
"url" => "url",
"POP server" => "POP server",
"Port" => "Port",
"SMTP server" => "SMTP server",
"status" => "status",
"Id" => "Id",
"admin" => "admin",
"admin admin tpl" => "admin admin tpl",
"popup" => "popup",
"stop" => "stop",
"h" => "h",
"+" => "+",
"Font" => "Font",
"URL:" => "URL:",
"Original" => "Original",
"admin Ephemerides tpl" => "admin Ephemerides tpl",
"id" => "id",
"mad" => "mad",
"Int" => "Int",
"#" => "#",
"inter" => "inter",
"val" => "val",
"If:SetNextact" => "If:SetNextact",
"proc" => "proc",
"auto" => "auto",
"int" => "int",
"tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
"Program" => "Program",
"list faqs tpl" => "list faqs tpl",
"adm" => "adm",
"Com" => "Com",
"Operator" => "Operator",
"Operator:" => "Operator:",
"Email:" => "Email:",
"server" => "server",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"tikiwiki.org" => "tikiwiki.org",
"Tiki Shoutbox" => "Tiki Shoutbox",
"admin Tiki Shoutbox tpl" => "admin Tiki Shoutbox tpl",
"cool" => "cool",
"eek" => "eek",
"razz" => "razz",
"CMS" => "CMS",
"pvs" => "pvs",
"Mb" => "Mb",
"Avatar" => "Avatar",
"HomePage" => "HomePage",
"UTC" => "UTC",
"pos" => "pos",
"pre" => "pre",
"chg" => "chg",
"Q" => "Q",
"A" => "A",
"emot" => "emot",
"IRC log" => "IRC log",
"pop" => "pop",
"cc" => "cc",
"bcc" => "bcc",
"tiki-mobile.php" => "tiki-mobile.php",
"unicode" => "unicode",
// ###
// ### end of possibly untranslated words
// ###

"Missing title or body when trying to post a comment" => "Fali naslov ili tekst poruke pri pisanju komentara",
"The copyright management feature is not enabled." => "Menadžment autorskih prava nije uključen",
"You do not have permission to use this feature." => "Nemate dozvolu da koristite ovu mogućnost",
"You must supply all the information, including title and year." => "Morate upisati sve podatke, uključujući naslov i godinu",
"You do not have permission to use this feature" => "Nemate dozvolu da koristite ovu osobinu",
"This feature is disabled" => "Ova osobina je isključena",
"None" => "Nijedan",
"Fatal error: cannot execute automatic activity \$activityId" => "Fatalna greška: automatska aktivnost \$activityId ne može da se pokrene",
"Fatal error: setting next activity to an unexisting activity" => "Fatalna greška: podešavanje sledeće aktivnosti na nepostojeću aktivnost",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatalna greška: nextActivity ne odgovara nijednom kandidatu u autorouting preklopnoj aktivnosti",
"Fatal error: non-deterministic decision for autorouting activity" => "Fatalna greška: ne-deterministička odluka za autorouting aktivnost",
"Fatal error: trying to send an instance to an activity but no transition found" => "Fatalna greška: pokušavate da pošaljete instancu na aktivnost ali tranzicija nije pronađena",
"Cannot add transition only split activities can have more than one outbound transition" => "Nemožete dodati tranziciju, samo razdvojne aktivnosti mogu imati više od jedne izlatne tranzicije",
"Circular reference found some activity has a transition leading to itself" => "Circularna referenca pronađena, neka aktivnost ima tranziciju koja vodi samoj sebi",
"Process does not have a start activity" => "Proces nema početnu aktivnost",
"Process does not have exactly one end activity" => "Proces nema tačno jednu krajnju aktivnost",
"End activity is not reachable from start activity" => "Krajnja aktivnost ne može biti postignuta od startne aktivnosti",
"Activity" => "Aktivnost",
" is interactive but has no role assigned" => " je interaktivan ali nema dodeljene uloge",
" is non-interactive and non-autorouted but has no role assigned" => " je ne-interaktivan i ne-autorutiran ali nema dodeljenu ulogu",
" is standalone but has transitions" => " je samostojeći ali nema tranzicije",
"Role" => "Uloga",
" is not mapped" => " nije mapiran",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Aktivnost '.\$res['name'].' je samostojeća i koristi \$instance objekat",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Aktivnost '.\$res['name'].' je interaktivna i zato mora koristiti \$instance->complete() metod",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Aktivnost '.\$res['name'].' je ne-interaktivna i zato ne sme da koristi \$instance->complete() metod",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Aktivnost '.\$res['name'].' je preklopnik i zato mora da koristi \$instance->setNextActivity(\$actname) metod",
"Process %d has been activated" => "Proces %d je uključen",
"Process %d has been deactivated" => "Proces %d je isključen",
"Process %s %s imported" => "Proces %s %s je uvežen",
"Process %s removed" => "Proces %s je obrišan",
"Process %s has been updated" => "Proces %s je obnovljen",
"Process %s has been created" => "Proces %s je napravljen",
"by" => "od",
"refresh" => "osvežavanje",
"locked" => "zaključano",
"locked by" => "zaključao",
"continued" => "nastavljen",
"in" => "u",
"new image uploaded by" => "novu sliku je dodao",
"uploaded by" => "uploadovao",
"new item in tracker" => "nov zapis u trakeru",
"new subscriptions" => "nove pretplate",
"not specified" => "nije odabrano",
"The file is not a CSV file or has not a correct syntax" => "Fajl nije CSV fajl ili nema odgovarajuću sintaksu",
"article" => "članak",
"directory" => "direktorijum",
"faq" => "FAQ",
"poll" => "upitnik",
"quiz" => "kviz",
"tracker" => "traker",
"image" => "slika",
"calendar" => "Kalendar",
"Cannot upload this file maximum upload size exceeded" => "Fajl ne može da se prihvati jer je prevelik",
"Anonymous" => "Anonimni",
"Newsletter subscription information at " => "Informacije o pretplatama na novine na ",
"Cannot write to this file:" => "Ne mogu da pišem u ovaj fajl:",
"Wiki Home" => "Glavna Wiki strana",
"Home" => "Glavna strana",
"Blogs" => "Blogovi",
"previous page" => "prošla strana",
"next page" => "sledeća strana",
"posted on" => "napisan",
"Articles" => "Članci",
"By:" => "Od:",
"Read" => "Čitaj",
"List articles" => "Lista članaka",
"Forums" => "Forumi",
"Last post" => "zadnja poruka",
"Invalid imagename (using filters for filenames)" => "Neispravno ime slike (koristeći filtere za imena fajlova)",
"Errors detected" => "Nađene su greške",
"Upload was not successful" => "Upload nije uspešan",
"No image yet, sorry." => "Još nema slike.",
"unknown" => "nepoznato",
"NONE" => "NIŠTA",
"Wiki top pages" => "Wiki naj strane",
"Hits" => "Pogodaka",
"Most relevant pages" => "Stranice koje najviše odgovaraju",
"Relevance" => "Važnost",
"Wiki last pages" => "Wiki zadnje strane",
"Modified" => "Promenjen",
"Forums last topics" => "Najnovije teme na forumima",
"Topic date" => "Datum teme",
"Forums most read topics" => "Najčitanije teme na forumima",
"Reads" => "Čitanja",
"Forums best topics" => "Naj teme na forumima",
"Score" => "Ocena",
"Forums most visited forums" => "Najposećeniji forumi",
"Visits" => "Posete",
"Forums with most posts" => "Forumi sa najviše tema",
"Posts" => "Poruka",
"Wiki top galleries" => "Wiki naj galerije",
"Wiki top file galleries" => "Wiki naj galerije fajlova",
"Wiki top images" => "Wiki naj slike",
"Wiki top files" => "Wiki naj fajlovi",
"Downloads" => "Preuzimanja",
"Wiki last images" => "Wiki zadnje slike",
"Upload date" => "Datum uploadovanja",
"Wiki last files" => "Wiki zadnji fajlovi",
"Wiki top articles" => "Wiki naj članci",
"Most visited blogs" => "Najposećeniji blogovi",
"Most active blogs" => "Najaktivniji blogovi",
"Blogs last posts" => "Blogovi: zadnje poruke",
"Post date" => "Datum pisanja",
"Wiki top authors" => "Wiki naj autori",
"Pages" => "Strana",
"Top article authors" => "Top autori članaka",
"Send message" => "Pošalji poruku",
"Attach file" => "Dodaj fajl",
"Tracker" => "Traker",
"Unknown" => "Nepoznato",
"Image Gallery" => "Galerija slika",
"Image" => "Slika",
"Article" => "Članak",
"Directory category" => "Kategorija direktorijuma",
"Directory" => "Direktorijum",
"File Gallery" => "Galerija fajlova",
"Gallery" => "Galerija",
"File" => "Fajl",
"Blog post" => "Blog poruka",
"help" => "pomoć",
"from" => "od",
"for" => "za",
"Priority" => "Prioritet",
"%A %d of %B, %Y" => "%A %d %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d %b, %Y[%H:%M %Z]",
"unlocked" => "odključan",
"created from structure" => "napravljeno od strukture",
"Help" => "Pomoć",
"You are banned from" => "Zabranjen vam je pristup",
"faqs" => "FAQ",
"quizzes" => "kvizovi",
"blogs" => "blogovi",
"forums" => "forumi",
"games" => "igre",
"picture not found" => "slika nije nađena",
"drawing not found" => "crtež nije nađen",
"Click to edit dynamic variable" => "Kliknite da bi izmenili dinamičke promenjive",
"Update variables" => "Obnovi promenjive",
"Created" => "Napravljeno",
"new" => "novo",
"Unknown language" => "Nepoznat jezik",
"Item" => "Zapis",
"Tracker was modified at " => "Traker je modifikovan dana ",
"text field" => "linija teksta",
"size" => "veličina",
"textarea" => "tekstualno polje",
"checkbox" => "polje za čekiranje",
"drop down" => "lista",
"user selector" => "odabir korisnika",
"group selector" => "odabir grupe",
"date and time" => "datum i vreme",
"action" => "akcija",
"category" => "kategorija",
"open" => "otvorena",
"closed" => "zatvoren",
"message" => "poruka",
"child categories" => "podkategorije",
"objects in category" => "objekata u kategoriji",
"(AT)" => "(NA)",
"(DOT)" => "(TAČKA)",
"Date" => "Datum",
"Title" => "Naslov",
"Author" => "Autor",
"Include a page" => "Ubaci stranu",
"data" => "podaci",
"one data per line" => "jedan podatak po liniji",
"Include an article" => "Dodaj članak",
"comment" => "komentar",
"Displays the user Avatar" => "Prikazuje korisnički avatar",
"username" => "korisničko ime",
"List all pages which link to specific pages" => "Izlistaj sve strane koje pokazuju na određenu stranu",
"Page cannot be found" => "Strana ne može da se nađe",
"No pages links to" => "Nijedna strana ne pokazuje na",
"One page links to" => "Jedna strana pokazuje na",
"pages link to" => "strana pokazuje na",
"Insert theme styled box on wiki page" => "Ubaci stilizovan okvir na wiki stranu",
"text" => "tekst",
"Insert list of items for the current/given category into wiki page" => "Ubaci listu stvari za trenutnu/datu kategoriju u wiki stranu",
"Categories are disabled" => "Kategorije su isključene",
"Display Tiki objects that have not been categorized" => "Prikaži Tiki objekte koji nisu kategorisani",
"Insert the full category path for each category that this wiki page belongs to" => "Upišite pun put do kategorije za svaku kategoriju kojoj ova strana pripada",
"Centers the plugin content in the wiki page" => "Centrira sadržaj plugina u wiki strani",
"Displays a snippet of code" => "Prikaži isečak koda",
"code" => "kod",
"Insert copyright notices" => "Ubaci obaveštenje o autoskim pravima",
"Example" => "Primer",
"days" => "dana",
"hours" => "sati",
"minutes" => "minuta",
"seconds" => "sekundi",
"Creates a definition list" => "Pravi listu definicija",
"term" => "termin",
"definition" => "definicija",
"one definition per line" => "jedna definicija po liniji",
"Displays the data using the Tikiwiki odd/even table style" => "Prikazuje podatke koristeći Tikiwiki par/nepar stil tabele",
"cells" => "ćelija",
"heads and cells separated by ~|~" => "glave i ćelije se odvajaju sa ~|~",
"Displays a graphical GAUGE" => "Prikaži grafički GAUGE",
"description" => "opis",
"Displays the text only if the language matchs" => "Prikazuje tekst samo ako je odgovarajući jezik",
"Feature disabled" => "Osobina je isključena",
"Please choose a module" => "Odaberite modul",
"to be used as argument" => "da bi se koristilo kao argument",
"Displays a module inlined in page" => "Prikaži modul ubačen u stranu",
"Sorry no such module" => "Žao nam je ali nema takvog modula",
"Displays the data using a monospace font" => "Prikazuje podatke koristeći font sa fiksnom širinom karaktera",
"Provides a list of plugins on this wiki." => "Prikazuje listu wiki plugin-ova.",
"No version indicated" => "Nema podataka o verziji",
"No arguments indicated" => "Argument nije odabran",
"Automatically creates a link to the appropriate SourceForge object" => "Automatski pravi link do odgovarajućeg SourceForge objekta",
"Sorts the plugin content in the wiki page" => "Sortira sadržaj plugina u wiki strani",
"Split a page into rows and columns" => "Podeli stranu na redove i kolone",
"row1col1" => "red1kol1",
"row1col2" => "red1kol2",
"row2col1" => "red2kol1",
"row2col2" => "red2kol2",
"Missing db param" => "Fali db parametar",
"Run a sql query" => "Pokreni sql query",
"Search the titles of all pages in this wiki" => "Pretraži naslove svih strana u ovom wikiju",
"No pages found for title search" => "Nijedna strana nije pronađena koja odgovara pretrazi naslova",
"One page found for title search" => "Jedna strana pronađena koja odgovara pretrazi naslova",
" pages found for title search" => " strana pronađeno koje odgovaraju pretrazi naslova",
"Save" => "Snimi",
"at" => "na",
"Links to a translated content" => "Linkovi do prevedenog sadržaja",
"External Wiki" => "Eksterni Wiki",
"valid" => "ispravan",
"failed" => "neuspeo",
"You are not logged in" => "Niste loginovani",
"Permission denied" => "Zabranjeno",
"ERROR: Either the subject or body must be non-empty" => "GREŠKA: Morate upisati ili naslov ili poruku",
"ERROR: No valid users to send the message" => "GREŠKA: Nema ispravnih korisnika kojima bi poslali poruku",
"Invalid user" => "Neispravan korisnik",
"Message will be sent to: " => "Poruke će biti poslate na:",
"No more messages" => "Nema više poruka",
"edit" => "izmeni",
"Quick edit a Wiki page" => "Brzo izmeni Wiki stranu",
"Since your last visit" => "Od vaše poslednje posete",
"since" => "od",
"new comments" => "novi komentari",
"wiki pages changed" => "promenjene wiki strane",
"new images" => "nove slike",
"new files" => "novi fajlovi",
"new users" => "novi korisnici",
"no such file" => "nema takvog fajla",
"Error" => "Greška",
"Invalid username or password" => "Pogrešno korisničko ime ili lozinka",
"List of attached files" => "Lista prikačenih fajlova",
"name" => "Naslov",
"desc" => "opis",
"uploaded" => "uploadovano",
"delete" => "obriši",
"Remove" => "Izbaci",
"Upload file" => "Dodaj fajl",
"attach" => "priloži",
"Fatal error" => "Fatalna greška",
"Description:" => "Opis:",
"Created by" => "Napravio",
" on " => " dana ",
"Last modified" => "Zadnji put promenjeno",
"Post" => "Poruke",
"post" => "poalji",
"RSS feed" => "RSS izvor",
"Edit blog" => "Izmeni blog",
"monitor this blog" => "nadgledaj ovaj blog",
"stop monitoring this blog" => "prestani sa nadgledanjem ovog bloga",
"posts" => "poruka",
"visits" => "poseta",
"Activity=" => "Aktivnost=",
"Categorize" => "Kategorizuj",
"show categories" => "prikaži kategorije",
"hide categories" => "sakrij kategorije",
"categorize this object" => "kategorizuj ovaj objekat",
"No categories defined" => "Kategorije nisu definisane",
"Admin categories" => "Administriraj kategorije",
"author" => "autor",
"stars" => "zvezde",
"user level" => "Korisnički nivo",
"private message" => "privatna poruka",
"send email to user" => "pošalji email korisniku",
"user online" => "korisnik je online",
"user offline" => "korisnik je offline",
"on" => "u",
"score" => "ocena",
"Vote" => "Glasaj",
"Edit" => "Izmeni",
"reply" => "odgovori",
"attachment" => "prikačeni fajl",
"Moderator actions" => "Moderatorske akcije",
"delete selected" => "obriši odabrano",
"Move to topic:" => "Pomeri na temu:",
"move" => "pomeri",
"reported:" => "prijavljeno:",
"queued:" => "na listi čekanja:",
"Messages" => "Poruke",
"All" => "Svi",
"Style" => "Stil",
"Sort" => "Sortiraj",
"Newest first" => "Prvo najnovije",
"Oldest first" => "Prvo najstarije",
"Threshold" => "Granica",
"Find" => "Nađi",
"set" => "postavi",
"Top" => "Početak",
"Hide all" => "Sakrij sve",
"replies" => "odgovora",
"prev" => "prošli",
"Page" => "Strana",
"next" => "sledeći",
"new reply" => "nov odgovor",
"Editing comment" => "Menjanje komentara",
"Post new comment" => "Dodaj novi komentar",
"Preview" => "Pregled",
"preview" => "pregled",
"cancel" => "obustavi",
"Required" => "Obavezno",
"Rating" => "Ocena",
"Smileys" => "Smajliji",
"Comment" => "Komentar",
"Posting comments" => "Slanje komentara",
"Use" => "Koristi",
"or" => "ili",
"for links" => "za linkove",
"Go back" => "Idi nazad",
"Return to home page" => "Povratak na glavnu stranu",
"Copyrights" => "Autorska prava",
"Year" => "Godina",
"Authors" => "Autori",
"up" => "gore",
"down" => "dole",
"add" => "dodaj",
"Syntax" => "Sintaksa",
"Page generation debugging log" => "Debag log generisanja strane",
"Features state" => "Stanje osobine",
"Total" => "Ukupno",
"features matched" => "Osobine pronađene",
"Watchlist" => "Lista nadgledanja",
"Create this page" => "Napravi ovu stranu",
"Hi {\$mail_user} has sent you this link:" => "Zdravo {\$mail_user} vam je poslao ovaj link",
"Blog post:" => "Blog poruka:",
"at:" => "na:",
"Somebody or you tried to subscribe this email address at our site:" => "Neko ili vi je pokušao da pretplati ovu email adresu na našem sajtu:",
"To the newsletter:" => "Na novine:",
"In order to confirm your subscription you must access the following URL:" => "Da bi potvrdili vašu pretplatu morate pratiti sledeći URL:",
"A new message was posted to forum" => "Nova poruka je poslata na forum",
"Message" => "Poruka",
"Tiki mail-in instructions" => "Tiki instrukcije za mail-in",
"Hi," => "Zdravo,",
"A new message was posted to you at {\$mail_machine}" => "Nova poruka vam je poslata na {\$mail_machine}",
"From" => "Od",
"Subject" => "Naslov",
"Hi" => "Zdravo",
"Enjoy the site!" => "Uživajte u sajtu!",
"The user" => "Korisnik",
"registered at your site" => "registrovan na tvom sajtu",
"New user registration" => "Registracija novog korisnika",
"Bye bye!" => "Zdravo!",
"This email address has been removed to the list of subscriptors of:" => " Ova email adresa je obrisana sa liste pretplatnika od:",
"Newsletter:" => "Novine:",
"You can unsubscribe from this newsletter following this link" => "Možete da prekinete vašu pretplatu na ove novine prateći ovaj link",
"Welcome to our newsletter!" => "Dobrodošli na naše novine!",
"This email address has been added to the list of subscriptors of:" => "Ova email adresa je dodata listi pretplatnika od:",
"You can always cancel your subscription using:" => "Uvek možete prekinuti vašu pretplatu koristeći:",
"Tiki email notification" => "Tiki email obaveštenja",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Nov članak je poslao {\$mail_user} na {\$mail_site} dana {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "Možete izmeniti vaš predlog preko sledećeg linka:",
"Title:" => "Naslov:",
"Heading:" => "Zaglavlje:",
"Body:" => "Telo poruke:",
"you or someone registered this email address at" => "vi ili neko drugi je registrovao ovu email adresu na",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Ako želite da budete registrovani korisnik na ovom sajtu morate da koristite ovaj link da bi se loginovali po prvi put:",
"Your Tiki information registration" => "Registracija vaših Tiki informacija",
"You will receive an email with information to login for the first time into this site" => "Primićete email sa informacijama za loginovanje po prvi put na ovaj sajt",
"If you don't want to receive these notifications follow this link:" => "Ako neželite da primate ova obaveštenja pratite ovaj link:",
"New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nova blog poruka {\$mail_title}, \"{\$mail_post_title}\", od {\$mail_user} dana {\$mail_date|tiki_short_datetime}",
"View the blog at:" => "Vidi blog na:",
"Name" => "Ime",
"File Description" => "Opis fajla",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Mapu {\$mail_page} je promenio {\$mail_user} dana {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "Obnovljenu mapu možete videti ako pratite sledeći link:",
"You can edit the map following this link:" => "Mapu možete izmeniti ako pratite sledeći link:",
"Type" => "Tip",
"Size" => "Veličina",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Strana {\$mail_page} je promenjena od strane korisnika {\$mail_user} dana {\$mail_date|tiki_short_datetime}",
"Comment:" => "Komentar:",
"The new page content follows below." => "Novi sadržaj stranice sledi.",
"New name" => "Novo ime",
"Thank you for you registration. You may log in now." => "Hvala vam na vašoj registraciji. Sada možete da se loginujete",
"click on the map to zoom or pan, do not drag" => "kliknite na mapu da bi zumirali ili pomerali centar, nemojte da vučete",
"Scale" => "Skala",
"Query" => "Upit",
"Redraw" => "Ponovo iscrtaj",
"select zoom/pan/query and image size" => "odaberite zum/centriranje/upit i veličinu slike",
"Click on the map or click redraw" => "Kliknite na mapu ili kliknite na ponovo iscrtaj",
"Comments" => "Komentari",
"Last modification date" => "Datum zadnje promene",
"Overview" => "Pregled",
"Legend" => "Legenda",
"Layer Manager" => "Menadžer slojeva",
"Label" => "Naslov",
"Download" => "Preuzimanja",
"Download Layer" => "Sloj preuzimanja",
"you have requested to download the layer:" => "odabrali ste preuzimanje sloja:",
"from\nthe mapfile:" => "iz\nmap fajla:",
"Here are the files to download, do not forget to rename them:" => "Ovde se nalaze faljovi za preuzimanje, nemojte zaboraviti da im promenite imena:",
"Mapfiles" => "Map fajlovi",
"Mapfile" => "Map fajl",
"Available mapfiles" => "Raspoloživi map fajlovi",
"Actions" => "Akcije",
"hits" => "pogodaka",
"monitor this map" => "prati promene ove mape",
"stop monitoring this map" => "prekini praćenje ove mape",
"No records found" => "Nijedan zapis nije pronađen",
"Create a new mapfile" => "Napravi novi fajl mape",
"create" => "napravi",
"Mapfile listing" => "Lista map fajlova",
"History" => "Istorija",
"save" => "snimi",
"You can view this map in your browser using" => "Ovu mapu možete videti u vašem browseru pomoću",
"of" => "od",
"Version" => "Verzije",
"compare" => "uporedi",
"current" => "trenutni",
"Versions are identical" => "Verzije su identične",
"User" => "Korisnik",
"Action" => "Akcija",
"view" => "vidi",
"diff" => "razlika",
"Directories" => "Direktorijumi",
"Files" => "Fajlovi",
"Upload From Disk:" => "Dodavanje sa diska:",
"Upload Files" => "Dodaj fajlove",
"Bytes maximum" => "Maksimum bajtova",
"Create Directory:" => "Napravi direktorijum:",
"Create" => "Napravi",
"index file (.shp):" => "indeksni fajl (.shp):",
"files to index (regexp):" => "fajlovi za indeksiranje (regexp):",
"Unread" => "Nepročitan",
"Flagged" => "Označen",
"Unflagged" => "Nemarkirana",
"Containing" => "Sadrži",
"sender" => "pošiljaoc",
"subject" => "naslov",
"date" => "datum",
"flagged" => "označeno",
"No messages to display" => "Nema poruka za prikaz",
"Broadcast message" => "Pošalji svima poruku",
"Message Broadcast" => "Pošalji svima poruku",
"edit template" => "izmeni šablon",
"Group" => "Grupa",
"All users" => "Svi korisnici",
"Lowest" => "Najniži",
"Low" => "Nizak",
"Normal" => "Normalan",
"High" => "Visok",
"Very High" => "Vrlo visok",
"send" => "pošalji",
"Compose message" => "Sastavi email",
"Compose Message" => "Sastavi poruku",
"Mark as read" => "Obeleži kao pročitano",
"Mark as unread" => "Obeleži kao nepročitano",
"Mark as flagged" => "Markiraj",
"Mark as unflagged" => "Isključi oznaku",
"mark" => "obeleži",
"Mailbox" => "Poštansko sanduče",
"Compose" => "Sastavi",
"Broadcast" => "Pošalji svima",
"Read message" => "Čitaj poruku",
"Prev" => "Prošla",
"Next" => "Sledeća",
"replyall" => "odgovori na sve",
"Flag this message" => "Markiraj ovu poruku",
"no" => "ne",
"replied" => "odgovoreno",
"'name' parameter for tikimodule missed" => "'ime' parametar za tikimodule je promašen",
"Move module up" => "Pomeri modul gore",
"Move module down" => "Pomeri modul dole",
"Move module to opposite side" => "Pomeri modul na obrnutu stranu",
"remove" => "obriši",
"Admin Menu" => "Administracioni meni",
"Live support" => "Podrška uživo",
"Banning" => "Zabrana pristupa",
"Users" => "Korisnici",
"Groups" => "Grupe",
"Cache" => "Skladište",
"Modules" => "Moduli",
"Links" => "Linkovi",
"Hotwords" => "Aktivne reči",
"RSS modules" => "RSS moduli",
"Menus" => "Meniji",
"Polls" => "Upitnici",
"Backups" => "Bekapovi",
"Mail notifications" => "Obaveštenje email-om",
"Search stats" => "Pretražuj statistike",
"Categories" => "Kategorije",
"Banners" => "Oglasi",
"Edit templates" => "Izmeni šablone",
"Admin drawings" => "Administriraj crteže",
"Dynamic content" => "Dinamički sadržaj",
"Cookies" => "Kolačići",
"Content templates" => "Šabloni sadržaja",
"HTML pages" => "HTML strane",
"Shoutbox" => "ShoutBox",
"Referer stats" => "Statistike referenata",
"Import PHPWiki Dump" => "Uvezi PHPWiki ostavu",
"Admin dsn" => "Administracija dsn",
"External wikis" => "Spoljni Wiki",
"Syntax highlighting" => "Obeležavanje sintakse",
"Menu" => "Meni",
"Contact us" => "Kontaktirajte nas",
"Stats" => "Statistike",
"Games" => "Igre",
"Calendar" => "Kalendar",
"MyMenu" => "MojMeni",
"MyTiki" => "Moj Tiki",
"Preferences" => "Podešavanja",
"Tasks" => "Poslovi",
"Bookmarks" => "Omiljeni linkovi",
"Newsreader" => "Čitač novina",
"Notepad" => "Notes",
"My files" => "Moji fajlovi",
"User menu" => "Korisnički meni",
"Mini calendar" => "Mini kalendar",
"My watches" => "Moja nadgledanja",
"WfMenu" => "WfMeni",
"Workflow" => "",
"Admin processes" => "Administriraj procese",
"Monitor processes" => "Nadgledaj procese",
"Monitor activities" => "Nadgledaj aktivnosti",
"Monitor instances" => "Nadgledaj instance",
"User processes" => "Korisnički procesi",
"User activities" => "Korisničke aktivnosti",
"User instances" => "Korisničke instance",
"WikiMenu" => "WikiMeni",
"Last changes" => "Zadnje promene",
"Dump" => "Ostava",
"Rankings" => "Rangiranja",
"List pages" => "Lista stranica",
"Orphan pages" => "Strane bez roditelja",
"Sandbox" => "Igraonica",
"Print" => "Štampaj",
"Send pages" => "Pošalji strane",
"Received pages" => "Primljene strane",
"Structures" => "Strukture",
"GalMenu" => "GalMeni",
"Image Galleries" => "Galerije slika",
"Galleries" => "Galerije",
"Upload image" => "Uploaduj sliku",
"System gallery" => "Sistemska galerija",
"Articles home" => "Glavna strana članaka",
"Submit article" => "Priloži članak",
"View submissions" => "Vidi priloge",
"Edit article" => "Izmeni članak",
"Send articles" => "Pošalji članke",
"Received articles" => "Primljeni članci",
"Admin topics" => "Administriraj teme",
"Admin types" => "Administriraj tipove",
"List blogs" => "Lista blogova",
"Create/Edit blog" => "Napravi/Izmeni blog",
"Admin posts" => "Administriraj poruke",
"ForMenu" => "ForMeni",
"List forums" => "Lista foruma",
"Admin forums" => "Admin forume",
"DirMenu" => "DirMeni",
"Submit a new link" => "Predloži novi link",
"Browse directory" => "Pregledaj direktorijum",
"Admin directory" => "Administriraj direktorijum",
"FileGalMenu" => "FileGalMeni",
"File Galleries" => "Fajl galerije",
"List galleries" => "Lista galerija",
"FAQs" => "FAQ",
"List FAQs" => "Lista FAQ",
"Admin FAQs" => "Admin FAQ",
"Maps" => "Mape",
"Layer management" => "Menadžment slojeva",
"QuizMenu" => "QuizMeni",
"Quizzes" => "Kvizovi",
"List quizzes" => "Lista kvizova",
"Quiz stats" => "Statistike kvizova",
"Admin quiz" => "Administriraj kviz",
"TrkMenu" => "TrkMeni",
"Trackers" => "Trakeri",
"List trackers" => "Lista trakera",
"Admin trackers" => "Administracija trakera",
"SrvMenu" => "SrvMeni",
"Surveys" => "Ankete",
"List surveys" => "Lista anketa",
"Admin surveys" => "Administriraj anketu",
"Newsletters" => "Novine",
"Send newsletters" => "Pošalji novine",
"Admin newsletters" => "Administriraj novine",
"Events" => "Događaji",
"EphMenu" => "EphMeni",
"Ephemerides" => "Efemeride",
"ChartMenu" => "ChartMeni",
"Charts" => "Grafikoni",
"AdmMenu" => "AdmMeni",
"Debugger console" => "Debager konzola",
"Theme control" => "Kontrola tema",
"Drawings" => "Crteži",
"Edit languages" => "Izmeni jezike",
"UsrMenu" => "UsrMeni",
"Click here to manage your personal menu" => "Klikni ovde da izmeniš svoj meni",
"User Menu" => "Korisnički meni",
"Recently visited pages" => "Skoro posećene stranice",
"Monday" => "Ponedeljak",
"Tuesday" => "Utorak",
"Wednesday" => "Sreda",
"Thursday" => "Četvrtak",
"Friday" => "Petak",
"Saturday" => "Subota",
"Sunday" => "Nedelja",
"Today" => "Danas",
"top" => "vrh",
"Received objects" => "Primljeni objekti",
"Pages:" => "Strana:",
"Last `\$module_rows` Sites" => "Zadnjih `\$module_rows` sajtova",
"Last Sites" => "Zadnji sajtovi",
"Directory Stats" => "Statistike direktorijuma",
"Sites" => "Sajtovi",
"Sites to validate" => "Sajtovi za proveru",
"Searches" => "Pretrage",
"Visited links" => "Posećeni linkovi",
"Top \$module_rows Sites" => "Naj \$module_rows sajtova",
"Top Sites" => "Top sajtovi",
"Featured links" => "Prikazujemo vam sajtove",
"Top topics" => "Top poruke",
"Last `\$module_rows` forum topics" => "Zadnjih `\$module_rows` tema u forumu",
"Last forum topics" => "Zadnje poruke na forumu",
"Most commented forums" => "Naj iskomentirani forumi",
"Most read topics" => "Najčitanije poruke",
"Most visited forums" => "Najposećeniji forumi",
"Google Search" => "pretraga na Google",
"Last `\$module_rows` articles" => "Zadnjih `\$module_rows` članaka",
"Last articles" => "Zadnjih članaka",
"Last `\$module_rows` blog posts" => "Zadnjih `\$module_rows` blog poruka",
"Last blog posts" => "Zadnje blog poruka",
"Last" => "Zadnjih",
"Last `\$module_rows` Created blogs" => "Zadnjih `\$module_rows` napravljenih blogova",
"Last Created blogs" => "Zadnji napravljeni blogovi",
"Last `\$module_rows` Created FAQs" => "Zadnjih `\$module_rows` napravljenih  FAQs",
"Last Created FAQs" => "Zadnji napravljeni FAQ-ovi",
"Last `\$module_rows` Created Quizzes" => "Zadnjih `\$module_rows` napravljenih kvizova",
"Last Created Quizzes" => "Zadnji napravljeni kvizovi",
"Last `\$module_rows` modified file galleries" => "Zadnjih `\$module_rows` promenjenih fajl galerija",
"Last modified file galleries" => "Zadnje promenjene galerije fajlova",
"Last `\$module_rows` Files" => "Zadnjih `\$module_rows` fajlova",
"Last Files" => "Zadnji fajlovi",
"Last `\$module_rows` galleries" => "Zadnjih `\$module_rows` galerija",
"Last galleries" => "Zadnje galerije",
"Last `\$module_rows` changes" => "Zadnjih `\$module_rows` izmena",
"Last `\$module_rows` Modified Items" => "Zadnjih `\$module_rows` promenjenih stvari",
"Last Modified Items" => "Zadnje promenjene stvari",
"Last `\$module_rows` Modified blogs" => "Zadnjih `\$module_rows` promenjenih blogova",
"Last Modified blogs" => "Zadnji promenjeni blogovi",
"Last `\$module_rows` submissions" => "Zadnjih `\$module_rows` priloga",
"Last submissions" => "Zadnji prilozi",
"Last `\$module_rows` Items" => "Zadnjih `\$module_rows` stvari",
"Last Items" => "Zadnje stvari",
"Open operator console" => "Otvori operatorsku konzolu",
"Online users" => "Onlajn korisnici",
"We have" => "Mi imamo",
"online users" => "onlajn korisnika",
"logged as" => "Ulogovan kao",
"user" => "Korisnik",
"pass" => "lozinka",
"Remember me" => "Zapamti me",
"register" => "Registruj se",
"I forgot my pass" => "Zaboravio sam svoju lozinku",
"standard" => "standardan",
"secure" => "siguran",
"stay in ssl mode" => "ostani u ssl modu",
"You have" => "Imate",
"new messages" => "novih poruka",
"new message" => "novu poruku",
"You have 0 new messages" => "Imate 0 novih poruka",
"Waiting Submissions" => "Prilozi na čekanju",
"submissions waiting to be examined" => "priloga koji čekaju na pregled",
"Old articles" => "Stari članci",
"Send a message to" => "Pošalji poruku",
"Random Pages" => "Slučajne strane",
"Register as a new user" => "Registruj se kao novi korisnik",
"Your email could not be validated; make sure you email is correct and click register below." => "Vaš email nismo uspeli da overimo; proverite da li je vaš email u redu i kliknite na register ispod.",
"Your registration code:" => "Vaš registracioni kod:",
"Random Image" => "Random slika",
"Username" => "Korisničko ime",
"Passcode to register (not your user password)" => "Lozinka za registraciju (ne vaša korisnička lozinka)",
"Registration code" => "Registracioni kod",
"Password" => "Lozinka",
"Repeat password" => "Ponovi lozinku",
"Generate a password" => "Generiši lozinku",
"Search" => "Pretraga",
"in:" => "u:",
"Entire Site" => "Ceo sajt",
"Wiki Pages" => "Wiki strane",
"Image Gals" => "Galerije slika",
"Images" => "Slike",
"Blog Posts" => "Blog poruke",
"go" => "idi",
"Search Wiki PageName" => "Pretražuj Wiki ImeStrane",
"Read More" => "Čitaj još",
"Since your last visit on" => "Od vaše poslednje posete dana",
"click to edit" => "Klikni za izmenu",
"Language: " => "Jezik: ",
"Language" => "Jezik",
"Most Active blogs" => "Najaktivniji blogovi",
"Top `\$module_rows` articles" => "Naj `\$module_rows` članaka",
"Top articles" => "Top članci",
"Top `\$module_rows` File Galleries" => "Naj `\$module_rows` fajl galerija",
"Top File Galleries" => "Top galerije fajlova",
"Top `\$module_rows` files" => "Naj `\$module_rows` fajlova",
"Top files" => "Naj fajlovi",
"Top `\$module_rows` games" => "Naj `\$module_rows` igara",
"Top games" => "Top igre",
"Top `\$module_rows` galleries" => "Naj `\$module_rows` galerija",
"Top galleries" => "Glavne galerije",
"Top `\$module_rows` Images" => "Naj `\$module_rows` slika",
"Top Images" => "Naj Slike",
"Top `\$module_rows` Pages" => "Naj `\$module_rows` strana",
"Top Pages" => "Naj Stranice",
"Top `\$module_rows` Quizzes" => "Naj `\$module_rows` kvizova",
"Top Quizzes" => "Top kvizovi",
"Most `\$module_rows` visited blogs" => "Najposećenijih `\$module_rows` blogova",
"Top `\$module_rows` Visited FAQs" => "Najposećenijih `\$module_rows` FAQ",
"Top Visited FAQs" => "Najposećeniji FAQ-ovi",
"Upcoming events" => "Dolazeći događaji",
"My blogs" => "Moji blogovi",
"cache" => "skladište",
"My galleries" => "Moje galerije",
"My Pages" => "Moje strane",
"User tasks" => "Korisnički poslovi",
"done" => "urađeno",
"del" => "obriši",
"Whats related" => "Šta je u vezi",
"online user" => "onlajn korisnik",
"Last `\$module_rows` wiki comments" => "Zadnjih `\$module_rows` wiki komentara",
"Last wiki comments" => "Zadnji wiki komentari",
"vote" => "glasaj",
"Sent editions" => "Poslata izdanja",
"find" => "nađi",
"users" => "korisnici",
"sent" => "poslato",
"use" => "koristi",
"Structures:" => "Strukture:",
"show structures" => "prikaži strukture",
"hide structures" => "sakrij strukture",
"Execution time" => "Vreme izvršavanja",
"secs" => "sekundi",
"Memory usage" => "Korišćena memorija",
"database queries used" => "upita baze podataka",
"Server load" => "Opterećenje servera",
"cached" => "uskladišteno",
"print" => "štampaj",
"create pdf" => "napravi PDF",
"Save to notepad" => "Snimi u notes",
"monitor this page" => "nadgledaj ovu stranu",
"stop monitoring this page" => "prestani sa nadgledanjem ove strane",
"backlinks" => "rekurzivni linkovi",
"Previous page" => "Prošla strana",
"Parent page" => "Nadstrana",
"Next page" => "Sledeća strana",
"First page" => "Prva strana",
"page" => "strana",
"Last page" => "Zadnja strana",
"last modification" => "zadnja izmena",
"To edit the copyright notices" => "Da bi se izmenili podaci o autorskim pravima",
"click here" => "klikni ovde",
"The content on this page is licensed under the terms of the" => "Sadržaj ove strane je licenciram po uslovima od",
"The original document is available at" => "Originalan dokumenat možete naći na",
"rename" => "promeni ime",
"unlock" => "otključaj",
"lock" => "zaključaj",
"perms" => "dozvole",
"history" => "istorija",
"similar" => "slično",
"undo" => "vrati",
"slides" => "slajdovi",
"export" => "izvoz",
"discuss" => "diskutuj",
"add comment" => "dodaj komentar",
"1 comment" => "1 komentar",
"comments" => "komentara",
"attach file" => "dodaj fajl",
"1 file attached" => "1 fajl prikačen",
"{\$atts_cnt} files attached" => "{\$atts_cnt} fajlova prikačeno",
"Page generated in" => "Strana generisana za",
"The newsletter was sent to {\$sent} email addresses" => "Novine su poslate na {\$sent} email adrese",
"This newsletter will be sent to {\$subscribers} email addresses." => "Ove novine će biti poslate na {\$subscribers} email adrese",
"Prepare a newsletter to be sent" => "Pripremi novine za slanje",
"Newsletter" => "Novine",
"Apply template" => "Primeni šablon",
"none" => "nijedan",
"Data" => "Podaci",
"Send Newsletters" => "Šalji novine",
"Made with" => "Napravljeno uz pomoć",
"powered by" => "osnaženo sa",
"This is" => "Ovo je",
"by the" => "od",
"Tiki community" => "Tiki društvo",
"Last Changes" => "Zadnje promene",
"attachments" => "prilog",
"Click" => "Klikni",
"User files" => "Korisnički fajlovi",
"Favorites" => "Omiljene stranice",
"Watches" => "Nadgledanja",
"home" => "glavna strana",
"contact us" => "Kontaktirajte nas",
"stats" => "Statistike",
"categories" => "kategorije",
"last changes" => "zadnje izmene",
"dump" => "ostava",
"rankings" => "rangiranja",
"list pages" => "lista strana",
"orphan pages" => "strane bez roditelja",
"sandbox" => "igraonica",
"received pages" => "primljene strane",
"structures" => "strukture",
"Articles Home" => "Početna strana Članaka",
"Create/Edit Blog" => "Napravi/Izmeni Blog",
"Browse Directory" => "Gledaj direktorijum",
"List Quizzes" => "Lista kvizova",
"List Trackers" => "Lista trakera",
"List Surveys" => "Lista anketa",
"Prefs" => "Podešavanja",
"MyFiles" => "Moji Fajlovi",
"back to homepage" => "nazad na glavnu stranu",
"This page is being edited by" => "Ovu stranu menja",
"Proceed at your own peril" => "Nastavite na vašu sopstvenu odgovornost",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Igraonica je strana na kojoj možete da vežbate vašu umešnost u pravljenju strana i koristite pregled da bi videli krajnji izgled stranice, ali se ništa ne snima za kasnije.",
"Description" => "Opis",
"My Footnotes" => "donje zaglavlje",
"Copyright" => "Autorsko pravo",
"Year:" => "Godina:",
"Authors:" => "Autori:",
"Allow HTML" => "Dozvoli HTML",
"Spellcheck" => "Provera pravopisa",
"Import page" => "Uvezi stranu",
"export all versions" => "izvezi sve verzije",
"Upload picture" => "Upload slike",
"no cache" => "nema skladišta",
"minute" => "minuta",
"hour" => "sat",
"License" => "Licenca",
"Important" => "Važno",
"Minor" => "Manji",
"cancel edit" => "odustani od izmene",
"dls" => "preuzimanja",
"No attachments for this page" => "Nema priloga za ovu stranu",
"My Tiki" => "Moj Tiki",
"User Pages" => "Korisničke strane",
"List pages where I am a creator" => "Izlistaj strane gde sam ja kreator",
"by creator" => "po kreatoru",
"List pages where I am a modificator" => "Izlistaj strane koje sam ja promenio",
"by modificator" => "po osobi koja je menjala",
"User Galleries" => "Korisničke galerije",
"Assigned items" => "Dodeljene stvari",
"at tracker" => "na trakeru",
"Unread Messages" => "Neporčitane poruke",
"User Blogs" => "Korisnički Blogovi",
"left/right" => "levo/desno ",
"Unassign module" => "Nedodeljen modul",
"debugger console" => "debager konzola",
"Mini Calendar" => "Mini Kalendar",
"Edit mapfiles" => "Izmeni map fajlove",
"switch" => "Prekidač",
"on:" => "u:",
"reads" => "čitanja",
"Article image" => "Slika članka",
"Topic image" => "Slika teme",
"Refresh" => "Osveži",
"Find:" => "Nađi:",
"Sort posts by:" => "Sortiraj poruke po:",
"posted by" => "napisao",
"read more" => "čitaj još",
"pages" => "strane",
"referenced by" => "refencirao",
"references" => "referense",
"view comments" => "vidi komentare",
"email this post" => "email-uj ovu poruku",
"Viewing blog post" => "Gledanje blog poruke",
"Return to blog" => "Nazad na blog",
"Trackback pings" => "Trekbek pingovi",
"URI" => "URL",
"Blog name" => "Naziv bloga",
"User Bookmarks" => "Korisničke omiljene strane",
"wiki help" => "wiki pomoć",
"Enlarge area height" => "Povećaj visinu prostora",
"Reduce area height" => "Smanji visinu prostora",
"Features" => "Osobine",
"General" => "Generalno",
"Home Blog" => "Glavni blog",
"Home Blog (main blog)" => "Glavni blog",
"Blog features" => "Osobine bloga",
"Blog level comments" => "Komentari na nivou bloga",
"Post level comments" => "Komentari na nivou poruke",
"Spellchecking" => "Provera pravopisa",
"Default ordering for blog listing" => "Podrazumevano sortiranje za listu blogova",
"Creation date (desc)" => "Datum kreiranja (prvo najnoviji)",
"Last modification date (desc)" => "Datum izmene (prvo najnoviji)",
"Blog title (asc)" => "Naslov bloga (A-Z)",
"Number of posts (desc)" => "Broj poruka (prvo najviše)",
"Visits (desc)" => "Posete (prvo najviše)",
"Activity (desc)" => "Aktivnost (prvo najveća)",
"Change preferences" => "Promeni podešavanja",
"Blog listing configuration (when listing available blogs)" => "Konfiguracija listanja bloga (kada se listaju mogući blogovi)",
"Disabled" => "Onemogućeno",
"Plain text" => "Čist tekst",
"Link to user information" => "Link do korisničkih informacija",
"User avatar" => "Korisnički avatar",
"Blog comments settings" => "Podešavanja komentara blogova",
"Default number of comments per page" => "Podrazumevani broj komentara po strani",
"Comments default ordering" => "Podrazumevani redosled sortiranja komentara",
"Points" => "Poena",
"CMS features" => "CMS osobine",
"Submissions" => "Prilozi",
"Use templates" => "Koristi šablone",
"Maximum number of articles in home" => "Maksimalan broj artikala na glavnoj strani",
"Article comments settings" => "Podešavanja komentara članaka",
"Fields to display on page" => "Polja za prikaz na strani",
"Topic" => "Tema",
"Publish Date" => "Datum objavljivanja",
"Expire Date" => "Datum isticanja",
"Visible" => "Vidljivo",
"Img" => "Slika",
"Country" => "Država",
"Last login" => "Zadnje loginovanje",
"Set features" => "Podesi osobine",
"Number of columns per page when listing categories" => "Broj kolona po strani pri listanju kategorija",
"Links per page" => "Linkova po strani",
"Validate URLs" => "Proveri URLove",
"Method to open directory links" => "Metoda za otvaranje linkova u direktorijumu",
"replace current window" => "zameni trenutan prozor",
"new window" => "novi prozor",
"inline frame" => "unutrašnji frejm",
"Tiki sections and features" => "Tiki sekcije i osobine",
"Featured Help" => "Pomoć u Fokusu",
"Workflow engine" => "",
"Live Support" => "Podrška uživo",
"Live support system" => "Sistem podrške uživo",
"Help System" => "Sistem pomoći",
"Show Category Path" => "Prikaži put do kategorije",
"Show Babelfish Translation URLs" => "Prikaži Babelfish URL za prevođenje",
"Show Category Objects" => "Prikaži objekte u kategoriji",
"Show Babelfish Translation Logo" => "Prikaži Babelfish Logo za prevođenje",
"Show Module Controls" => "Prikaži kontrole modula",
"Tiki Calendar" => "Tiki Kalendar",
"Tiki Template Viewing" => "Tiki gledanje šablona",
"PhpLayers Dynamic menus" => "PhpLayers dinamički meniji",
"Content Features" => "Osobenosti sadržaja",
"Edit Templates" => "Izmeni šablone",
"Hotwords in New Windows" => "Aktivne reči u novom prozoru",
"Edit CSS" => "Izmeni CSS",
"Custom Home" => "Promenjiva glavna strana",
"HTML Pages" => "HTML Strane",
"Dynamic Content System" => "Dinamički sistem sadržaja",
"Allow Smileys" => "Omogući smajlije",
"AutoLinks" => "AutoLinkovi",
"Administration Features" => "Administracione osobine",
"Banning System" => "Sistem zabrane pristupa",
"Banning system" => "Sistem za zabranu pristupa",
"Debugger Console" => "Debugger konzola",
"Communications (send/receive objects)" => "Komunikacija (slanje/primanje objekata)",
"Theme Control" => "Kontrola tema",
"Referer Stats" => "Statistike referenata",
"Contact Us" => "Kontaktirajte nas",
"User Features" => "Korisničke osobine",
"User Preferences Screen" => "Ekran za korisnička podešavanja",
"Users can Configure Modules" => "Korisnici mogu da podešavaju module",
"User Watches" => "Korisnička nadgledanja",
"User Tasks" => "Korisnički poslovi",
"User Messages" => "Korisničke poruke",
"User Files" => "Korisnički fajlovi",
"User Notepad" => "Korisnički notes",
"General Layout options" => "Generalne opcije izgleda",
"Left column" => "Leva kolona",
"Layout per section" => "Raspored po sekciji",
"Right column" => "Desna kolona",
"Admin layout per section" => "Administriraj raspored po sekcijama",
"Top bar" => "Gornja linija",
"Bottom bar" => "Donja linija",
"Home Gallery (main gallery)" => "Glavna galerija",
"Galleries features" => "Osobine galerije",
"Use database to store files" => "Koristi bazu podataka za smeštanje fajlova",
"Use a directory to store files" => "Koristi direktorijum za skladištenje fajlova",
"Directory path" => "Direktorijum",
"Uploaded filenames must match regex" => "Imena uploadovanih fajlova moraju da odgovaraju regex-u",
"Uploaded filenames cannot match regex" => "Imena uploadovanih fajlova moraju da odgovaraju regex-u",
"please read" => "molimo vas da pročitate",
"Gallery listing configuration" => "Konfiguracija liste galerija",
"File galleries comments settings" => "Podešavanja komentara galerija fajlova",
"Home Forum (main forum)" => "Glavni forum",
"Accept wiki syntax" => "Prihvati wiki sintaksu",
"Forum quick jumps" => "Brzi skokovi na forumu",
"Ordering for forums in the forum listing" => "Sortiranje foruma u spisku foruma",
"Creation Date (desc)" => "Datum pravljenja (prvo najnovije)",
"Topics (desc)" => "Poruke (prvo najviše)",
"Threads (desc)" => "Teme (prvo najviše)",
"Last post (desc)" => "Zadnje poruke (prvo najnovije)",
"Name (desc)" => "Ime (Z-A)",
"Name (asc)" => "Ime (A-Z)",
"Forum listing configuration" => "Konfiguracija liste foruma",
"Topics" => "Teme",
"Posts per day" => "Poruka na dan",
"Uses Slideshow" => "Koristi prezentaciju (Slideshow)",
"Use database to store images" => "Koristi bazu podataka za skladištenje slika",
"Use a directory to store images" => "Koristi direktorijum za skladištenje slika",
"Library to use for processing images" => "Biblioteka koja se koristi za procesiranje slika",
"Uploaded image names must match regex" => "Imena uploadovanih slika moraju da odgovaraju regex-u",
"Uploaded image names cannot match regex" => "Imena uploadovanih slika nesmeju da odgovaraju regex-u",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Ukloni slike u sistemskoj galeriji koje se ne koriste u Wiki stranama, člancima ili blog porukama",
"All galleries" => "Sve galerije",
"Move" => "Pomeri",
"images" => "slike",
"Image galleries comments settings" => "Podešavanja komentara galerija slika",
"General Preferences" => "Generalna podešavanja",
"Theme" => "Teme",
"Slideshows theme" => "Slajdšov teme",
"Use group homepages" => "Koristi grupne glavne strane",
"Use URI as Home Page" => "Koristi URL kao glavnu stranu",
"Home page" => "Glavna strana",
"Custom home" => "Custom glavna strana",
"Use database for translation" => "Koristi bazu podataka za prevođenje",
"Record untranslated" => "Zapisa neprevedeno",
"Unknown/Other" => "Nepoznato/Ostalo",
"General Settings" => "Generalna podešavanja",
"Disallow access to the site (except for those with permission)" => "Zabrani pristup sajtu (osim onima koji imaju dozvolu)",
"Message to display when site is closed" => "Poruka za prikaz kada je sajt zatvoren",
"Disallow access when load is above the threshold (except for those with permission)" => "Zabrani pristup sajtu kada je opterećenje iznad odabranog (osim onima koji imaju dozvolu)",
"Max average server load threshold in the last minute" => "Maksimalno prosečno opterećenje servera u prošlom minutu",
"Message to display when server is too busy" => "Poruka za prikaz kada je server previše opterećen",
"Open external links in new window" => "Otvori eksterne linkove u posebnom prozoru",
"Display modules to all groups always" => "Uvek prikaži module svim grupama",
"Use cache for external pages" => "Koristi skladište za spoljne strane",
"Use cache for external images" => "Koristi skladište za spoljne slike",
"Use direct pagination links" => "Koristi linkove sa direktnom paginacijom",
"Display menus as folders" => "Prikaži menije kao direktorijume",
"Tikiwiki.org help" => "Tikiwiki.org pomoć",
"Use gzipped output" => "Koristi gzipovan izlaz",
"Count admin pageviews" => "Broj poglede strana administratora",
"Hide anonymous-only modules from registered users" => "Sakrij module koji su samo za anonimne korisnike od regostrovanih korisnika",
"Server name (for absolute URIs)" => "Naziv servera (za apsolutne URL)",
"No" => "Ne",
"Yes" => "Da",
"Browser title" => "Naslov u browseru",
"Wiki_Tiki_Title" => "Wiki_Tiki_Naslov",
"Temporary directory" => "Privremeni direktorijum",
"Sender Email" => "Email pošiljaoca",
"Contact user" => "Kontaktiraj korisnika",
"contact feature disabled" => "kontaktiranje je onemogućeno",
"Store session data in database" => "Sačuvaj podatke o sesijama u bazi podataka",
"Session lifetime in minutes" => "Trajanje sesija u minutima",
"Use proxy" => "Koristi proxy",
"Maximum number of records in listings" => "Maksimalan broj zapisa u listinzima",
"Date and Time Formats" => "Format datuma i vremena",
"Long date format" => "Dugačak format datuma",
"Short date format" => "Kratak format datuma",
"Long time format" => "Dugačak format vremena",
"Short time format" => "Kratak format vremena",
"Date and Time Format Help" => "Pomoć za format datuma i vremena",
"Register this site at tikiwiki.org" => "Registruj ovaj sajt na tikiwiki.org",
"Click here for more details." => "Klikni ovde za detalje.",
"Change admin password" => "Promeni administratorsku šifru",
"New password" => "Nova lozinka",
"Change password" => "Promeni lozinku",
"Reg users can change language" => "Registrovani korisnici mogu da menjaju jezik",
"Edit or ex/import Languages" => "Izmeni ili izvezi/uvezi jezike",
"path" => "put",
"groups" => "grupe",
"Contact" => "Kontakt",
"Admin groups" => "Administriraj grupe",
"Admin users" => "Admin korisnika",
"User registration and login" => "Korisnička registracija i login",
"Authentication method" => "Metod autentikacije",
"Just Tiki" => "Samo Tiki",
"Tiki and PEAR::Auth" => "Tiki i PEAR::Auth",
"Tiki and HTTP Auth" => "Tiki i HTTP Auth",
"Use WebServer authentication for Tiki" => "Koristi WebServer autentikaciju za Tiki",
"Users can register" => "Korisnici mogu da se registruju",
"Create a group for each user <br />(with the same\nname as the user)" => "Napravi grupu za svakog korisnika <br />(sa istim\nimenom kao korisnik)",
"Request passcode to register" => "Zahtevaj šifru za registraciju",
"Prevent automatic/robot registration" => "Spreči automatsku/robotsku registraciju",
"Validate users by email" => "Potvrdite korisnike preko email-a",
"Store plaintext passwords" => "Snimi lozinke kao običan tekst",
"Reg users can change theme" => "Registrovani korisnici mogu da menjaju teme",
"Use challenge/response authentication" => "Koristi challenge/response autentikaciju",
"Force to use chars and nums in passwords" => "Forsiraj korišćenje karaktera i brojeva u lozinkama",
"Minimum password length" => "Minimalna dužina lozinke",
"Password invalid after days" => "Lozinka ne važi nakon koliko dana",
"Require HTTP Basic authentication" => "Zahtevaj HTTP Basic autentikaciju",
"Allow secure (https) login" => "Dozvoli siguran (https) login",
"Require secure (https) login" => "Zahtevaj siguran (https) login",
"HTTP server name" => "HTTP naziv servera",
"HTTP URL prefix" => "HTTP URL prefiks",
"HTTPS server name" => "HTTPS naziv servera",
"HTTPS URL prefix" => "HTTPS URL prefiks",
"Remember me feature" => "Zapamti me osobenost",
"Only for users" => "Samo za korisnike",
"Users and admins" => "Korisnike i administratore",
"Duration:" => "Trajanje:",
"day" => "dan",
"week" => "nedelja",
"month" => "mesec",
"Remember me domain" => "Domen za Zapamti me",
"Remember me path" => "URL za Zapamti me",
"Create user if not in Tiki?" => "Napravi korisnika ako nije u Tikiju?",
"Create user if not in Auth?" => "Napravi korisnika ako nije u Auth?",
"Just use Tiki auth for admin?" => "Koristi samo Tiki auth za administraciju?",
"LDAP Scope" => "LDAP Okvir",
"LDAP Base DN" => "LDAP Bazni DN",
"LDAP User DN" => "LDAP Korisnički DN",
"LDAP User Attribute" => "LDAP Korisnički atributi",
"LDAP User OC" => "LDAP Korisnički OC",
"LDAP Group DN" => "LDAP Grupni DN",
"LDAP Group Attribute" => "LDAP Grupni atributi",
"LDAP Group OC" => "LDAP Grupni OC",
"LDAP Member Attribute" => "LDAP Atribut člana",
"LDAP Member Is DN" => "LDAP Član je DN",
"LDAP Admin User" => "LDAP Administracija korisnika",
"LDAP Admin Pwd" => "LDAP Administracija lozinki",
"full path to mapfiles" => "puna adresa do map fajlova",
"default mapfile" => "podrazumevani map fajl",
"Wiki Page for Help" => "Wiki strana za pomoć",
"Wiki Page for Comments" => "Wiki strana za komentare",
"Full path to gdaltindex" => "Puna adresa do gdaltindex",
"<b>Feed</b>" => "<b>Izvor</b>",
"<b>enable/disable</b>" => "<b>ukljiči/isključi</b>",
"<b>Max number of items</b>" => "<b>Maksimalan broj stvari</b>",
"Feed for Articles" => "Izvor za članke",
"Feed for Weblogs" => "Izvor za Weblogove",
"Feed for Image Galleries" => "Izvor za galerije slika",
"Feed for File Galleries" => "Izvor za galerije fajlova",
"Feed for the Wiki" => "Izvor za Wiki",
"Feed for individual Image Galleries" => "Izvor za pojedinačne galerije slika",
"Feed for individual File Galleries" => "Izvor za pojedinačne galerije fajlova",
"Feed for individual weblogs" => "Izvor za pojedinačne weblogove",
"Feed for forums" => "Izvor za forume",
"Feed for individual forums" => "Izvor za pojedinačne forume",
"Feed for mapfiles" => "Izvor za mapfajlove",
"Default RDF version" => "Podrazumevana RDF verzija",
"Specification" => "Specifikacija",
"Documentation" => "Dokumentacija",
"Full Text Search" => "Pretraga po celokupnom tekstu",
"SearchStats" => "Statistike pretrage",
"Content" => "Sadržaj",
"Publish" => "Objavi",
"Path" => "Put",
"change" => "promeni",
"Quota (Mb)" => "Kvota (Mb)",
"Use database to store userfiles" => "Koristi bazu podataka za skladištenje korisničkih fajlova",
"Use a directory to store userfiles" => "Koristi direktorijum za skladištenje korisničkih fajlova",
"Allow viewing HTML mails?" => "Dozvoli gledanje HTML emailova",
"Maximum size for each attachment" => "Maksimalna veličina svakog priloga",
"Dumps" => "Ostave",
"Generate dump" => "Napravi ostavu",
"Download last dump" => "Preuzmi najnoviju ostavu",
"restore" => "vrati",
"Export Wiki Pages" => "Izvoz Wiki strana",
"Export" => "Izvoz",
"Remove unused pictures" => "Ukloni nekorišćene slike",
"Wiki Home Page" => "Wiki Glavna Strana",
"Wiki Discussion" => "Wiki diskusija",
"Discuss pages on forums" => "Diskutuj o stranama na forumu",
"complete" => "kompletno",
"Creator" => "Kreator",
"Last version" => "Zadnja verzija",
"Versions" => "Verzije",
"Backlinks" => "Rekurzivni linkovi",
"full" => "puni",
"Wiki Features" => "Wiki osobine",
"Undo" => "Vrati",
"MultiPrint" => "MultiŠtampa",
"PDF generation" => "PDF generisanje",
"mins" => "minuta",
"Pictures" => "Slike",
"Use page description" => "Koristi opise strana",
"Show page title" => "Prikaži naziv strane",
"Cache wiki pages (global)" => "Skladišti wiki strane (globalno)",
"Individual cache" => "Individualno skladište",
"Users can lock pages (if perm)" => "Korisnici mogu da zaključavaju strane (ako imaju dozvolu)",
"Use WikiWords" => "Koristi WikiReči",
"Link plural WikiWords to their singular forms" => "Linkuj WikiWord u množini sa njihovim formama u jednini",
"Automonospaced text" => "Automonorazmaknut tekst",
"Tables syntax" => "Sintaksa tabela",
"|| for rows" => "|| za redove",
"\\n for rows" => "\\n za redova",
"Page creators are admin of their pages" => "Kreatori stranica su administratori tih stranica",
"Import HTML" => "Uvezi HTML",
"Wiki History" => "Wiki istorija",
"Maximum number of versions for history" => "Maksimalan broj verzija za istoriju",
"Never delete versions younger than days" => "Ne briši verzije mlađe od ovoliko dana",
"Copyright Management" => "Menadžment autorskih prava",
"Enable Feature" => "Omogući osobenost",
"License Page" => "Strana za licencama",
"Submit Notice" => "Obaveštenje o predlogu",
"Wiki Watch" => "Wiki Nadgledanje",
"Enable watches on comments" => "Omogući nadgledanje komentara",
"Wiki attachments" => "Wiki prilozi",
"View tpl" => "Vidi šablon",
"admin banning tpl" => "admin izbacivanje tpl",
"Add or edit a rule" => "Dodaj ili izmeni pravilo",
"Rule title" => "Naslov pravila",
"Username regex matching" => "Poklapanje sa regexom korisničkih imena",
"IP regex matching" => "IP regex poređenje",
"Banned from sections" => "Zabrana pristupu sekciji",
"check / uncheck all" => "markiraj / odmarkiraj sve",
"Rule activated by dates" => "Pravila aktivirana po datumu",
"Rule active from" => "Pravilo aktivno od",
"Rule active until" => "Pravilo aktivno do",
"Custom message to the user" => "Promenjiva poruka korisniku",
"Rules" => "Pravila",
"User/IP" => "Korisnik/IP",
"Sections" => "Sekcije",
"Admin Calendars" => "Administriraj kalendare",
"List of Calendars" => "Lista kalendara",
"cat" => "katalog",
"lang" => "jezik",
"permissions" => "dozvole",
"Create/edit Calendars" => "Napravi/izmeni kalendare",
"Custom Locations" => "Promenjive lokacije",
"yes" => "da",
"Custom Categories" => "Promenjive kategorije",
"Custom Languages" => "Promenjivi jezici",
"Custom Priorities" => "Promenjivi prioriteti",
"admin categories" => "administracija kategorija",
"admin categories tpl" => "admin kategorija tpl",
"Current category" => "Trenutne kategorije",
"Child categories" => "Podkategorije",
"Edit this category:" => "Izmeni ovu kategoriju:",
"create new" => "napravi novo",
"Add new category" => "Dodaj novu kategoriju",
"Parent" => "Roditelj",
"Objects in category" => "Objekti u kategoriji",
"type" => "tip",
"Add objects to category" => "Dodaj objekte kategoriji",
"image gal" => "galerija slika",
"file gal" => "galerija fajlova",
"Admin chart items" => "Administriraj jedinke grafika",
"charts" => "grafikoni",
"edit chart" => "izmeni grafik",
"Add or edit an item" => "Dodaj ili promeni stvar",
"update" => "obnovi",
"Chart items" => "Stavke u grafiku",
"No items defined yet" => "Zapisi nisu još definisani",
"Admin charts" => "Admnistriraj grafik",
"Add or edit a chart" => "Dodaj ili izmeni grafik",
"Active" => "Aktivan",
"Users can suggest new items" => "Korisnici mogu da predlažu nove stvari",
"Auto validate user suggestions" => "Automatski odobri korisničke predloge",
"Ranking shows" => "Prikazi ocena",
"All items" => "Sve stvari",
"Top 10 items" => "Top 10 stvari",
"Top 20 items" => "Top 20 stvari",
"Top 40 items" => "Top 40 stvari",
"Top 50 items" => "Top 50 stvari",
"Top 100 items" => "Top 100 stvari",
"Top 250 items" => "Top 250 stvari",
"Voting system" => "sistem glasanja",
"Vote items" => "Glasaj za stvar",
"Rank 1..5" => "Ocena 1..5",
"Rank 1..10" => "Ocena 1..10",
"Ranking frequency" => "Učestalost ocenjivanja",
"Realtime" => "Realno vreme",
"Each 5 minutes" => "Svakih 5 minuta",
"Daily" => "Dnevno",
"Weekly" => "Nedeljno",
"Monthly" => "Mesečno",
"Show Average" => "Prikaži prosek",
"Show Votes" => "Prikaži glasove",
"Use Cookies for unregistered users" => "Koristite kolačiće za neregistrovane korisnike",
"Users can vote again after" => "Korisnici mogu ponovo da glasaju nakon",
"Anytime" => "Bilo kada",
"5 minutes" => "5 minuta",
"1 day" => "1 dan",
"1 week" => "1 nedelja",
"1 month" => "1 mesec",
"Items" => "Stvari",
"Ranks" => "Ocene",
"No charts defined yet" => "Nijedan grafik nije definisan",
"Chat Administration" => "Administracija Chat-a",
"Create/edit channel" => "Napravi/izmeni kanal",
"Refresh rate" => "Vreme osvežavanja",
"second" => "sekunda",
"Chat channels" => "Chat kanali",
"active" => "aktivan",
"Admin templates" => "Administriraj šablone",
"admin content templates" => "administriraj šablone sadržaja",
"Edit this template:" => "Izmeni ovaj šablon:",
"Create new template" => "Napravi novi šablon",
"use in cms" => "koristi u CMS",
"use in wiki" => "koristi u Wiki",
"use in newsletters" => "koristi u novinama",
"use in HTML pages" => "koristi u HTML stranama",
"template" => "šablon",
"Templates" => "Šabloni",
"last modif" => "zadnja izmena",
"sections" => "sekcije",
"Admin cookies" => "Admin kolačiće",
"admin FortuneCookie" => "administriraj Srećne Kolačiće",
"Create/edit cookies" => "Napravi/izmeni kolačiće",
"Cookie" => "Kolačić",
"Upload Cookies from textfile" => "Dodaj kolačiće iz tekstualnog fajla",
"Upload from disk:" => "Upload sa diska:",
"Remove all cookies" => "Ukloni sve kolačiće",
"cookie" => "kolačić",
"admin Drawings tpl" => "admin crteži tpl",
"Available drawings" => "Raspoloživi crteži",
"Ver" => "Ver.",
"Create/edit dsn" => "Napravi/izmeni dsn",
"Admin external wikis" => "Administriraj spoljni Wiki",
"Create/Edit External Wiki" => "Napravi/Izmeni eksterni Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (koristite \$page da se zameni sa nazivom stranice u URL primeru: http://www.example.com/tiki-index.php?page=\$page)",
"extwiki" => "spoljni tiki",
"Admin Forums" => "Administracija foruma",
"Create new forum" => "Napravi novi forum",
"Edit this Forum:" => "Izmeni ovaj forum:",
"Create New Forum" => "Napravi novi forum",
"There are individual permissions set for this forum" => "Individualne dozvole su podešene za ovaj forum",
"Show description" => "Prikaži opis",
"Prevent flooding" => "Spreči poplave poruka",
"Minimum time between posts" => "Minimalno vreme između poruka",
"min" => "minuta",
"Topics per page" => "Poruka po strani",
"Section" => "Sekcija",
"Create new" => "Napravi novi",
"Moderator user" => "Moderator",
"Moderator group" => "Moderatorska grupa",
"Password protected" => "Zaštićeno lozinkom",
"Topics only" => "Samo teme",
"All posts" => "Sve poruke",
"Forum password" => "Šifra foruma",
"Default ordering for topics" => "Podrazumevano sortiranje za poruke",
"Date (desc)" => "Datum (prvo najnovije)",
"Date (asc)" => "Datum (prvo stariji)",
"Score (desc)" => "Ocena (prvo najveće)",
"Replies (desc)" => "Odgovora (prvo najviše)",
"Reads (desc)" => "Čitanja (prvo najviše)",
"Title (desc)" => "Naslov (Z-A)",
"Title (asc)" => "Naslov (A-Z)",
"Default ordering for threads" => "Podrazumevano sortiranje za teme",
"Send this forums posts to this email" => "Pošalji ovu poruku sa foruma na ovu email adresu",
"Prune unreplied messages after" => "Briši neodgovorene poruke nakon",
"Prune old messages after" => "Briši stare poruke nakon",
"Topic list configuration" => "Podešavanje liste tema",
"Replies" => "Odgovora",
"Display last post titles" => "Prikaži naslove zadnjih poruka",
"no display" => "nema prikaza",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Prosledi poruke na ovom forumu na ovu e-mail adresu, u formatu koji može da se koristi za slanje nazad na prihvatnu e-mail adresu ovog foruma",
"Originating e-mail address for mails from this forum" => "Izvorna e-mail adresa za poruke sa ovog foruma",
"Add messages from this email to the forum" => "Dodaj poruke iz ovog emaila forumu",
"Use topic smileys" => "Koristi smajlije za teme",
"Show topic summary" => "Prikaži siže teme",
"User information display" => "Prikaz korisničkih informacija",
"flag" => "zastava",
"online" => "uključen",
"Approval type" => "Tip dozvole",
"All posted" => "Sve napisano",
"Queue anonymous posts" => "Stavi na listu čekanja anonimne poruke",
"Queue all posts" => "Stavi sve poruke na list čekanja",
"Attachments" => "Prilozi",
"No attachments" => "Nema priloga",
"Everybody can attach" => "Svi mogu da dodaju fajlove",
"Only users with attach permission" => "Samo korisnici sa attach dozvolom",
"Moderators and admin can attach" => "Moderatori i administratori mogu da dodaju fajlove",
"Store attachments in:" => "Snimi priloge u:",
"Database" => "Baza podataka",
"Max attachment size (bytes)" => "Maksimalna veličina fajlova za dodavanje (bajtovi)",
"topics" => "teme",
"age" => "godine",
"ppd" => "pnd",
"last post" => "zadnja poruka",
"Admin Hotwords" => "Administriraj aktivne reči",
"admin hotwords" => "administriraj aktivne reči",
"Add Hotword" => "Dodaj aktivnu reč",
"Word" => "Reč",
"Add" => "Dodaj",
"admin HTML page dynamic zones" => "admin dinamičke zone HTML strana",
"Admin HTML pages" => "Administracija HTML strana",
"Edit this page" => "Izmeni ovu stranu",
"View page" => "Vidi stranu",
"Edit zone" => "Izmeni zone",
"Dynamic zones" => "Dinamičke zone",
"content" => "sadržaj",
"Mass update" => "Masovna obnova",
"Create new HTML page" => "Napravi novu HTML stranu",
"Edit this HTML page:" => "Izmeni ovu HTML stranu:",
"Page name" => "Naziv strane",
"Dynamic" => "Dinamička",
"Static" => "Statička",
"Refresh rate (if dynamic) [secs]" => "Vreme osvežavanja (ako je dinamička) [sekundi]",
"Edit Repository:" => "Izmeni repozitoriju:",
"Create New Repository" => "Napravi novu repozitoriju",
"list repositories" => "lista repozitorija",
"new repository" => "nova repozitorija",
"view repository" => "vidi repozitorije",
"Human readable repository name" => "Ime repozitorije čitljivo za ljude",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Adresa repozitorije (lokalni fajlsistem: relativni/apsolutni web root, udaljena: sa 'http://' prefiksom)",
"File name of start page" => "Ime fajla početne strane",
"Start page" => "Početna strana",
"CSS file to load when browse this repository" => "CSS fajl za gledanje ove repozitorije",
"CSS file" => "CSS fajl",
"Is repository visible to users" => "Da li je repozitorija vidljiva korisnicima",
"Can files from repository be cached" => "Da li fajlovi iz repozitorije mogu da budu skladišteni",
"Cacheable" => "Skladišteni",
"Are files from repository can be cached" => "Da li fajlovi iz repozitorije mogu da budu skladišteni",
"Clear all cached pages of this repository" => "Obriši sve uskladištene fajlove u ovoj repozitoriji",
"Clear cache" => "Obriši skladište",
"Seconds count 'till cached page will be expired" => "Sekundi do isticanja uskladištene strane",
"Cache expiration" => "Isticanje skladišta",
"Human readable text description of repository" => "Opis repozitorije čitljiv za ljude",
"Available Repositories" => "Slobodne repozitorije",
"Start" => "Početak",
"CSS File" => "CSS Fajl",
"Edit rules" => "Izmeni pravila",
"Edit Rules for Repository:" => "Izmeni pravila za repozitoriju:",
"configure repositories" => "podesi repozitorije",
"configure this repository" => "podesi ovu repozitoriju",
"view this repository" => "vidi ovu repozitoriju",
"Add new rule" => "Dodaj novo pravilo",
"new rule" => "novo pravilo",
"view/hide copy rules dialog" => "vidi/sakrij dijalog za kopiranje pravila",
"copy rules" => "kopiraj pravila",
"Source repository" => "Izvorna repozitorija",
"Copy" => "Kopiraj",
"According this order rules will be applied ('0' or empty = auto)" => "Pravila će biti primenjena u skladu sa ovim redosledom ('0' ili prazno = automatski)",
"Rule order" => "Redosled pravila",
"Text to search for" => "Tekst za pretragu",
"Text to replace" => "Tekst za zamenu",
"Replace" => "Zameni",
"Is this regular expression or simple search/replacer" => "Da li je ovo regularan izraz (regex) ili jednostavna pretraga/zamena",
"Is case sensitive (for simple replacer)" => "Da li zavisi od velikih/malih slova (za jednostavnu pretragu/zamenu)",
"Case sensitive" => "Zavisi od malih/velikih slova",
"subset of chars: imsxeADSXUu, which is regex modifiers" => " podskup karaktera: imsxeADSXUu, koji su regex modifikatori",
"Human readable text description of rule" => "Tekstualni opis pravila pogodan za čitanje",
"Check to enable this rule" => "Overi da bi omogućio ovo pravilo",
"Enabled" => "Omogućeno",
"Preview options" => "Vidi opcije",
"Apply all rules or just this to generate preview" => "Primeni sva pravila ili samo ovo da bi generisao pregled",
"Apply all rules" => "Primeni sva pravila",
"View source code after rules applied" => "Vidi izvorni kod nakon primene pravila",
"Code preview" => "Pregled koda",
"Generate HTML preview" => "Generiši HTML pregled",
"HTML preview" => "HTML pregled",
"Test file from repository to generate preview for (empty = configured start page)" => "Test fajl iz repozitorije za koji se generiše pregled (prazno = startna strana)",
"Preview Results" => "Rezultati pregleda",
"Rules List" => "Lista pravila",
"Admin layout" => "Administriraj raspored",
"layout options" => "opcije šablona",
"admin featured links" => "administriraj prikazane sajtove",
"Generate positions by hits" => "Generiši poziciju po hitovima",
"List of featured links" => "Lista sajtova na prikazu",
"title" => "naslov",
"position" => "pozicija",
"Add Featured Link" => "Dodaj sajt za prikaz",
"Edit this Featured Link:" => "Izmeni ovaj sajt za prikaz:",
"Create new Featured Link" => "Napravi novi link za sajta za pikaz",
"Position" => "Pozicija",
"disables the link" => "menja link",
"Link type" => "Tip linka",
"replace current page" => "zameni trenutnu stranu",
"framed" => "frejmovano",
"open new window" => "otvori u novom prozoru",
"admin Webmail" => "administriraj Webmail",
"Account name" => "Naziv naloga",
"SMTP requires authentication" => "SMTP zahteva autentikaciju",
"wiki-get" => "wiki-uzmi",
"wiki-put" => "wiki-stavi",
"wiki-append" => "wiki-dodaj",
"List menus" => "Listaj menije",
"Edit this menu" => "Promeni ovaj meni",
"Edit menu options" => "Izmeni opcije menija",
"Some useful URLs" => "Neki korisni linkovi",
"Permissions" => "Dozvole",
"section" => "sekcije",
"option" => "opcije",
"Choose" => "Odaberi",
"Home Page" => "Glavna strana",
"Home Image Gal" => "Glavna galerija slika",
"Home Image Gallery" => "Glavna galerija slika",
"Home File Gal" => "Glavna galerija fajlova",
"Home File Gallery" => "Glavna galerija fajlova",
"User preferences" => "Korisnička podešavanja",
"User prefs" => "Korisnička podešavanja",
"List image galleries" => "Lista galerija slika",
"Upload" => "Uploaduj",
"Gallery Rankings" => "Rangiranje galerija",
"Browse a gallery" => "Razgledaj galeriju",
"All articles" => "Svi članci",
"Submit" => "Pošalji",
"List Blogs" => "Listaj blogove",
"Create blog" => "Napravi blog",
"File galleries" => "Galerije fajlova",
"View a forum" => "Vidi forum",
"View a thread" => "Vidi temu",
"View a FAQ" => "Vidi FAQ",
"Take a quiz" => "Uzmi kviz",
"Stats for a Quiz" => "Statistike kviza",
"Preview menu" => "Pogledaj meni",
"Menu options" => "Opcije menija",
"group" => "grupa",
"Admin Menus" => "Administriraj menije",
"admin menu builder" => "administriraj pravljenje menija",
"Edit this Menu:" => "Izmeni ovaj meni:",
"Create new Menu" => "Napravi novi meni",
"dynamic collapsed" => "dinamički zatvoren",
"dynamic extended" => "dinamički otvoren",
"fixed" => "fiksiran",
"options" => "opcije",
"Admin Modules" => "Admin modula",
"admin modules" => "administracija modula",
"assign module" => "dodeli modul",
"left modules" => "levi moduli",
"right modules" => "desni moduli",
"edit/create" => "izmeni/napravi",
"clear cache" => "obriši skladište",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Napomena 1</b>: ako dozvolite korisnicima da pode avaju module onda dodeljeni module neće raditi dok ih ne podesite iz MyTiki->moduli.<br />\n<b>Napomena 2</b>: Ako dodelite module grupe, budite sigurni da ste isključili opciju 'prikaži sve module svim grupama' iz Admin->Generalno\n",
"User Modules" => "Korisnički moduli",
"assign" => "dodeli",
"Assign new module" => "Dodeli novi modul",
"Edit this assigned module:" => "Izmeni ovaj dodeljeni modul:",
"Module Name" => "Naziv modula",
"left" => "levo",
"right" => "desno",
"Order" => "Redosled",
"Cache Time" => "Vreme keširanja",
"Rows" => "Redova",
"Parameters" => "Parametri",
"Visibility" => "Vidljivost",
"Displayed for the eligible users with no personal assigned modules" => "Prikazano za odgovarajuće korisnike bez lično dodeljenih modula",
"Displayed now for all eligible users even with personal assigned modules" => "Prikazano sada za sve odgovarajuće korisnike čak i ako imaju lično dodeljen module",
"Displayed now, can't be unassigned" => "Prikazano sada, ne može da se isključi",
"Not displayed until a user chooses it" => "Nije prikazano dok korisnik ne odabere da prikaže",
"Assigned Modules" => "Dodeljeni moduli",
"Left Modules" => "Levi moduli",
"order" => "redosled",
"rows" => "redova",
"Right Modules" => "desni moduli",
"Create new user module" => "Napravi novi",
"Edit this user module:" => "Izmeni ovaj korisnički modul:",
"Use wysiwyg editor" => "Koristi wysiwyg editor",
"Use normal editor" => "Koristi normalan editor",
"create/edit" => "napravi/izmeni",
"Objects that can be included" => "Objekti koji mogu da se dodaju",
"Available polls" => "Raspoloživi upitnici",
"use poll" => "koristi upitnik",
"Random image from" => "Slučajna slika iz",
"use gallery" => "koristi galeriju",
"Dynamic content blocks" => "Blokovi sa dinamičkim sadržajem",
"use dynamic  content" => "koristi dinamički sadržaj",
"use rss module" => "koristi rss module",
"use menu" => "koristi meni",
"Banner zones" => "Zone oglasa",
"use banner zone" => "koristi zone oglasa",
"Admin newsletter subscriptions" => "Administriraj prijave novinama",
"list newsletters" => "lista novina",
"admin newsletters" => "administriraj novine",
"send newsletters" => "pošalji novine",
"Add a subscription newsletters" => "Dodaj pretplatne novine",
"Subscriptions" => "Pretplate",
"subscribed" => "pretplaćen",
"Create/edit newsletters" => "Napravi/izmeni novine",
"There are individual permissions set for this newsletter" => "Postoje individualne dozvole podešene za ove novine",
"Users can subscribe/unsubscribe to this list" => "Korisnici mogu da se pretplate/isključe sa ove liste",
"Users can subscribe any email address" => "Korisnici mogu da upišu bilo koju email adresu",
"Add unsubscribe instructions to each newsletter" => "Dodaj informacije o prekidanju pretplate u svake novine",
"Validate email addresses" => "Proveri email adrese",
"editions" => "izdanja",
"last sent" => "zadnje poslate",
"subscriptions" => "pretplate",
"EMail notifications" => "E-Mail obaveštenja",
"admin Email Notifications" => "administriraj E-Mail obaveštenja",
"Add notification" => "Dodaj obaveštenje",
"Event" => "Slučaj",
"A user registers" => "Korisnik se registruje",
"A user submits an article" => "Korisnik je predložio članak",
"Any wiki page is changed" => "Bilo koja strana je promenjena",
"use admin email" => "koristi administratorski email",
"event" => "slučaj",
"object" => "objekat",
"Admin Polls" => "Administriraj upitnike",
"List polls" => "Lista upitnika",
"Edit this poll" => "Izmeni ovaj upitnik",
"Preview poll" => "Pogledaj upitnik",
"Edit or add poll options" => "Izmeni ili dodaj opcije upitnika",
"Option" => "Opcije",
"Poll options" => "Opcije upitika",
"votes" => "glasova",
"admin polls" => "administriraj upitnike",
"Set last poll as current" => "Postavi zadnji upitnik kao trenutni",
"Close all polls but last" => "Zatvori sve upitnike osim poslednje",
"Activate all polls" => "Aktiviraj sve upitnike",
"Create/edit Polls" => "Napravi/izmeni upitnik",
"PublishDate" => "DatumObjavljivanja",
"Admin Quicktags" => "Administriraj Quicktags",
"admin QuickTags" => "administriraj QuickTags",
"Create/Edit QuickTags" => "Napravi/Izmeni QuickTags",
"label" => "naslov",
"Insert (use 'text' for figuring the selection)" => "Ubaci (koristite 'text' da bi pronašli selekciju)",
"Category" => "Kategorija",
"Path to the tag icon" => "Adresa do tag ikone",
"Insert" => "Ubaci",
"Icon" => "Ikonica",
"Admin RSS modules" => "Administriraj RSS module",
"admin RSS modules" => "administracija RSS modula",
"Content for the feed" => "Sadržaj izvora",
"Edit this RSS module:" => "Izmeni ovaj RSS modul:",
"Create new RSS module" => "Napravi novi RSS modul",
"show feed title" => "prikaži naslov izvora",
"show publish date" => "prikaži datum objavljivanja",
"Rss channels" => "RSS kanali",
"Last update" => "Zadnja promena",
"show pubdate" => "prikaži datum objavljivanja",
"Filename" => "Naziv fajla",
"Structure ID" => "ID Strukture",
"export pages" => "izvezi strane",
"dump tree" => "prebaci na ostavu drvo",
"create webhelp" => "napravi webpomoć",
"view webhelp" => "vidi webpomoć",
"Destroy the structure leaving the wiki pages" => "Uništi strukturu ostavljajući strane",
"Destroy the structure and remove the pages" => "Uništi strukturu i ukloni strane",
"Create new structure" => "Napravi nove strukture",
"Use single spaces to indent structure levels" => "Koristi jedan razmak za pravljenje podnivoa",
"Alias" => "Alijas",
"tree" => "drvo",
"create new structure" => "napravi novu strukturu",
"Edit survey questions" => "Izmeni pitanja ankete",
"survey stats" => "Statistike anketa",
"this survey stats" => "Statistike ove ankete",
"edit this survey" => "izmeni ovu anketu",
"admin surveys" => "administracija anketa",
"Create/edit questions for survey" => "Napravi/izmeni pitanja u anketi",
"Question" => "Pitanje",
"One choice" => "Jedan izbor",
"Multiple choices" => "Višestruki izbor",
"Short text" => "Kratak tekst",
"Rate (1..5)" => "Ocena (1..5)",
"Rate (1..10)" => "Ocena (1..10)",
"Options (if apply)" => "Opcije (ako odabere)",
"Questions" => "Pitanja",
"question" => "pitanje",
"list surveys" => "lista anketa",
"Edit this Survey:" => "Izmeni ovu anketu:",
"There are individual permissions set for this survey" => "Individualne dozvole su podešene za ovu anketu",
"questions" => "pitanja",
"files" => "fajlova",
"Admin Topics" => "Admin Teme",
"Create a new topic" => "Napravi novu temu",
"Topic Name" => "Naslov teme",
"Upload Image" => "Dodaj sliku",
"List of topics" => "Lista tema",
"Active?" => "Aktivna?",
"Articles (subs)" => "Članci (prilozi)",
"topic image" => "slika teme",
"Activate" => "Aktiviraj",
"Deactivate" => "Deaktiviraj",
"Admin tracker" => "Administracija trakera",
"Edit this tracker" => "Izmeni ovaj traker",
"View this tracker items" => "Vidi zapise ovog trakera",
"Edit tracker fields" => "Izmeni polja u trakeru",
"Is column visible when listing tracker items?" => "Da li je kolona vidljiva na listi zapisa?",
"Column links to edit/view item?" => "Kolona vodi ka izmeni/pregledu zapisa?",
"Tracker fields" => "Polja trakera",
"isMain" => "je glavni",
"Tbl vis" => "Vidljiva",
"Import" => "Uvezi",
"admin Trackers tpl" => "admin trakeri tpl",
"created" => "napravljen",
"items" => "zapisa",
"fields" => "polja",
"Create/edit trackers" => "Napravi/izmeni traker",
"There are individual permissions set for this tracker" => "Individualne dozvole su podešene za ovaj traker",
"Show creation date when listing tracker items?" => "Prikaži datum pravljenja na spisku zapisa trakera?",
"Show lastModif date when listing tracker items?" => "Prikaži zadnji datum menjanja na spisku zapisa trakera?",
"Tracker items allow comments?" => "Dozvoljeni komentari za zapise trakera?",
"Tracker items allow attachments?" => "Dozvoljeno prikačivanje fajlova za zapise trakera?",
"downloads" => "preuzeto puta",
"version" => "verzija",
"admin groups" => "administriraj grupe",
"Add new group" => "Dodaj novu grupu",
"List" => "Lista",
"List of existing groups" => "Lista postojećih grupa",
"Number of displayed rows" => "Broj prikazanih redova",
"Includes" => "Uključuju",
"Include" => "Uključi",
"Edit item" => "Izmeni zapis",
"admin users" => "administriraj korisnike",
"Add a new user" => "Dodaj novog korisnika",
"Batch Upload Results" => "Rezultati grupnog uploada",
"Added users" => "Dodati korisnici",
"Rejected users" => "Odbijeni korisnici",
"Reason" => "Razlog",
"Never" => "Nikada",
"Pass" => "Propusti",
"Again" => "Ponovo",
"Overwrite" => "Prebrisavanje",
"Admin Article Types" => "Administriraj tipove članaka",
"Article Types tpl" => "Tipovi članak tpl",
"Rate" => "Oceni",
"Show before publish date" => "Prikaži pre datuma objavljivanja",
"Show after expire date" => "Prikaži nakon datuma isticanja",
"Heading only" => "Samo zaglavlje",
"Comment Can Rate Article" => "Komentar može da oceni članak",
"Show image" => "Prikaži sliku",
"Show avatar" => "Prikaži avatara",
"Show author" => "Prikaži autora",
"Show publish date" => "Prikaži datum objavljivanja",
"Show expire date" => "Prikaži datum isticanja",
"Show reads" => "Prikaži broj čitanja",
"Show size" => "Prikaži veličinu",
"Creator can edit" => "Kreator može da menja",
"Delete" => "Obriši",
"List of types" => "Lista tipova",
"Create a new type" => "Napravi novi tip",
"Assign permissions to group" => "Dodeli dozvole grupi",
"Edit Article" => "Izmeni članak",
"edit article tpl" => "izmeni šablon članka",
"Back to groups" => "Nazad na grupu",
"Group Information" => "Informacije o grupi",
"Desc" => "Opis",
"Create level" => "Napravi nivo",
"all permissions in level" => "sve dozvole u nivou",
"all" => "sve",
"level" => "nivo",
"Assign user" => "Dodeli korisnika",
"to groups" => "grupi",
"User Information" => "Korisničke informacije",
"Default Group" => "Podrazumevana grupa",
"to" => "do",
"backlinks to" => "rekurzivni linkovi na",
"No backlinks to this page" => "Nema rekurzivnih linkova do ove stranice",
"admin backups" => "administriraj bekape",
"List of available backups" => "Lista raspoloživih bekapa",
"Restoring a backup" => "Povraćaj bekapa",
"Warning!" => "Upozorenje!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Povraćaj bekapa uništava svepodatke u vašoj Tiki bazi podatraka. Sve vaše tabele će biti zamenjene informacijama u bekapu.",
"Click here to confirm restoring" => "Kliknite ovde da bi potvrdili povraćaj",
"Create new backup" => "Napravi novi bekap",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Pravljenje bekapa može da potraje dosta vremena. Ako se proces ne završi videćete prazan ekran. Ako se to desi, potrebno je da povećate maksimalno vreme izvršavanja skripta u php.ini fajlu",
"Upload a backup" => "Uploaduj bekap",
"Upload backup" => "Uploaduj bekap",
"Browse gallery" => "Gledaj galeriju",
"Upload from disk" => "Dodaj sa hard diska",
"Process" => "Proces",
"Edit Post" => "Izmeni poruku",
"view blog" => "vidi blog",
"list blogs" => "lista blogova",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Napomena: ako želite da koristite slike molimo vas da prvo snimite poruku a posle\nmožete dodate/izmenite slike. Koristite &lt;img&gt; snipet da bi iskoristili uploadovane slike u textarea editoru ili koristite URL slike\nda bi dodali slike koristeći WYSIWYG editor.",
"Use ...page... to separate pages in a multi-page post" => "koristite ...page... da bi razdvojili strane u višestranoj poruci",
"Upload image for this post" => "Uploaduj sliku za ovu poruku",
"Trash" => "Smeće",
"Send trackback pings to:" => "Pošalji trackback pingove na:",
"(comma separated list of URIs)" => "(lista URLova razdvojenih zarezom)",
"save and exit" => "snimi i izađi",
"Image galleries" => "Galerije slike",
"search category" => "kategorija pretrage",
"deep" => "duboko",
"Objects" => "Objekti",
"Browsing Gallery" => "Pregledanje galerije",
"edit gallery" => "izmeni galeriju",
"rebuild thumbnails" => "ponovo napravi smanjene slike",
"upload image" => "dodaj sliku",
"list gallery" => "lista galerija",
"Sort Images by" => "Sortiraj slike po",
"original size" => "orginalna veličina",
"rotate right" => "rotiraj udesno",
"rotate" => "rotiraj",
"Browsing Image" => "Gledanje slika",
"return to gallery" => "vrati se na galeriju",
"edit image" => "izmeni slike",
"first image" => "prva slika",
"smaller" => "manje",
"bigger" => "veće",
"prev image" => "prošla slika",
"Popup window" => "Popup prozor",
"popup window" => "popup prozor",
"next image" => "sledeća slika",
"last image" => "zadnja slika",
"Image Name" => "Naziv Slike",
"Image size" => "Veličina slike",
"imagescale" => "skalaslike",
"Move image" => "Pomeri slike",
"You can view this image in your browser using" => "Ovu sliku možete videti u vašem browseru koristeći",
"Date Selector" => "Odabir datuma",
"click to navigate" => "klikni za navigaciju",
"End" => "Kraj",
"details" => "detalji",
"Hours" => "Sati",
"Group Calendars" => "Grupni kalendari",
"Tools Calendars" => "Kalendari alatki",
"Duration" => "Trajanje",
"Location" => "Lokacija",
"Organized by" => "Organizovano po",
"Participants" => "Učesnici",
"Tentative" => "Probni",
"Confirmed" => "Potvrđen",
"Cancelled" => "Prekinuto",
"Edit Calendar Item" => "Izmeni zapis u kalendaru",
"New Calendar Item" => "Novo u kalendaru",
"or create a new category" => "ili napravite novu kategoriju",
"or create a new location" => "ili napravite novu lokaciju",
"comma separated usernames" => " razmacima razdvojeni korisnička imena",
"comma separated username:role" => "razmacima razdvojeni korisničko ime:uloga",
"with roles" => "sa ulogama",
"Chair" => "Vođa",
"Optional" => "Opciono",
"duplicate" => "napravi kopiju",
"import" => "uvezi",
"permission" => "dozvola",
"No individual permissions global permissions apply" => "Nema individualnih dozvola. Koriste se globalne dozvole.",
"Assign permissions" => "Dodeli dozvole",
"to group" => "grupi",
"Change password enforced" => "Forsirana promena lozinke",
"Old password" => "Stara lozinka",
"Again please" => "Još jednom",
"Welcome to the Tiki Chat Rooms" => "Dobrodošli u Tiki Chat",
"Please select a chat channel" => "Molimo odaberite kanala za chat",
"Nickname" => "Nadimak",
"enter chat room" => "uđi u pričaonicu",
"Chatroom" => "Pričaonica",
"Browser not supported" => "Browser nije podržan",
"Active Channels" => "Aktivni kanali",
"Users in this channel" => "Korisnici u ovom kanalu",
"Channel Information" => "Informacije o kanalu",
"Channel" => "Kanal",
"Ratio" => "Odnos",
"Use :nickname:message for private messages" => "Koristite :nadimak:poruka za privatne poruke",
"Use [URL|description] or [URL] for links" => "Koristite [URL|opis] ili [URL] za linkove",
"Use (:smileyname:) for smileys" => "Koristi (:imesmajlija:) za smajlije",
"Create PDF" => "Napravi PDF",
"PDF Settings" => "PDF podešavanja",
"Textheight" => "VisinaTeksta",
"Height of top Heading" => "Visina gornjeg zaglavlja",
"Height of mid Heading" => "Visina srednjeg zaglavlja",
"Height of inner Heading" => "Visina unutrašnjeg zaglavlja",
"tbheight" => "tbvisina",
"Automatic Page Breaks" => "Automatsko prelamanje stranica",
"Select Wiki Pages" => "Odaberi Wiki stranu",
"add page" => "dodaj stranu",
"remove page" => "obriši stranu",
"reset" => "resetuj",
"Send a message to us" => "Pošaljite nam poruku",
"Contact us by email" => "Kontaktirajte nas emailom",
"Create WebHelp" => "Napravi WebPomoć",
"You can browse the generated WebHelp here" => "Možete da pogledate generisanu WebPomoć ovde",
"Structure" => "Struktura",
"Top page" => "Gornja strana",
"Tiki Debugger Console" => "Tiki debuger konzola",
"Close" => "Zatvori",
"Current URL" => "Trenutni URL:",
"Command" => "Komanda",
"exec" => "pokreni",
"Type <code>help</code> to get list of available commands" => "Kucajte <code>help</code> da bi dobili listu mogućih komandi",
"Add a new site" => "Dodaj novi sajt",
"Site added" => "Sajt dodat",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Sledeći sajt je dopdat i provera od strane administratora je potrebna pre nego što će se pojaviti na listi",
"Add or edit a site" => "Dodaj ili izmeni sajt",
"Name:" => "Ime:",
"Categories:" => "Kategorije:",
"Is valid" => "je ispravna",
"Directory Administration" => "Administracija direktorijuma",
"admin directory tpl" => "admin direktorijumi tpl",
"Statistics" => "Statistike",
"There are" => "Ima",
"invalid sites" => "neispravni sajtovi",
"valid sites" => "ispravni sajtovi",
"Users have visited" => "Korisnici su posetili",
"sites from the directory" => "sajtovi iz direktorijuma",
"Users have searched" => "Korisnici su pretraživali",
"times from the directory" => "puta iz direktorijuma",
"Admin sites" => "Administriraj sajtove",
"Admin category relationships" => "Administriraj odnose između kategorija",
"Validate links" => "Proveri linkove",
"Settings" => "Podešavanja",
"browse" => "gledaj",
"related" => "povezani",
"sites" => "sajtovi",
"validate" => "proveri",
"Admin directory categories" => "Administriraj kategorije direktorijuma",
"admin directory categories tpl" => "admin kategorije direktorijuma tpl",
"Parent category" => "Kategorija roditelj",
"Add a directory category" => "Dodaj kategoriju direktorijuma",
"Edit this directory category" => "Izmeni ovu kategoriju direktorijuma",
"Children type" => "Tip dece",
"Most visited sub-categories" => "Najčešće posećivane pod kategorije",
"Category description" => "Opis kategorije",
"Random sub-categories" => "Slučajne podkategorije",
"Maximum number of children to show" => "Maksimalana broj dece za prikaz",
"Allow sites in this category" => "Dozvoli sajtove u ovoj kategoriji",
"Show number of sites in this category" => "Prikaži broj sajtova u ovoj kategoriji",
"Editor group" => "Grupa urednika",
"Subcategories" => "Podkategorije",
"cType" => "cTip",
"allow" => "dozvoli",
"count" => "broj",
"editor" => "urednik",
"relate" => "srodi",
"Admin related categories" => "Administriraj srodne kategorije",
"Admin Directory Related " => "Administriraj srodne direktorijume ",
"directory admin related tpl" => "direktorijum admin povezanih tpl",
"Add a related category" => "Dodaj srodnu kategoriju",
"Mutual" => "Zajednička",
"Related categories" => "Srodne kategorije",
"Admin Directory Sites" => "Administriraj sajtove u direktorijumu",
"Admin Directory Sites tpl" => "Administriraj sajtove u direktorijumu tpl",
"country" => "država",
"new sites" => "novi sajtovi",
"cool sites" => "cool sajtovi",
"add a site" => "dodaj sajt",
"any" => "bilo koji",
"in entire directory" => "u celom direktorijumu",
"in current category" => "u trenuntoj kategoriji",
"search" => "pretraga",
"Sort by" => "Sortiraj po",
"name (desc)" => "ime (A-Z)",
"name (asc)" => "ime (Z-A)",
"hits (desc)" => "pogleda (prvo najviše)",
"hits (asc)" => "pogleda (prvo najmanje)",
"creation date (desc)" => "datum pravljenja (prvo najnovije)",
"creation date (asc)" => "datum pravljenja (prvo najstarije)",
"last updated (desc)" => "datum izmene (prvo najnovije)",
"last updated (asc)" => "datum izmene (prvo najstarije)",
"sort" => "sortiranje",
"Added" => "Dodato",
"Last updated" => "Zadnji put obnovljeno",
"Total categories" => "Ukupno kategorija",
"Total links" => "Ukupno linkova",
"Links to validate" => "Linkovi za proveru",
"Searches performed" => "Izvršeno pretraga",
"Total links visited" => "Ukupno linkova posećeno",
"Directory ranking" => "Rangiranje direktorijuma",
"Search results" => "Rezultati pretrage",
"Validate sites" => "Proveri sajtove",
"Validate Sites" => "Proveri sajtove",
"directory validate sites tpl" => "direktorijum proveri sajtove tpl",
"list articles" => "lista članaka",
"view articles" => "vidi članke",
"Author Name" => "Ime autora",
"Own Image" => "Sopstvena slika",
"Use own image" => "Koristi sopstvenu slike",
"Float text around image" => "Tekst neka obilazi oko slike",
"Own image size x" => "Širina sopstvene slike",
"Own image size y" => "Visina sopstvene slike",
"Heading" => "Zaglavlje",
"Body" => "Telo",
"Use ...page... to separate pages in a multi-page article" => "koristite ...page... da bi razdvojili strane u višestranom članku",
"Expiration Date" => "Datum isticanja",
"Edit or create banners" => "Izmeni ili napravi oglase",
"List banners" => "Lista oglasa",
"URL to link the banner" => "URL za oglas",
"Client" => "Klijenti",
"Max impressions" => "Maksimalno pogleda",
"create zone" => "napravi zonu",
"Show the banner only between these dates" => "Prikaži baner samo između ovih datuma",
"From date" => "Od dana",
"To date" => "Do dana",
"Use dates" => "Koristi datume",
"Show the banner only in this hours" => "Prikaži baner samo u ovim satima",
"Show the banner only on" => "Prikaži oglas samo na",
"Mon" => "Pon",
"Tue" => "Uto",
"Wed" => "Sre",
"Thu" => "Čet",
"Fri" => "Pet",
"Sat" => "Sub",
"Sun" => "Ned",
"Select ONE method for the banner" => "Odaberi JEDAN od metoda za baner",
"Use HTML" => "Koristi HTML",
"HTML code" => "HTML kod",
"Use image" => "Koristi sliku",
"Image:" => "Slika:",
"Current Image" => "Trenutna slika",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Koristi sliku koju generiše URL (sliku će generisati određeni URL za svaki pogled posebno)",
"Use text" => "Koristi tekst",
"Text" => "Tekst",
"save the banner" => "snimi oglas",
"Remove Zones (you lose entered info for the banner)" => "Ukloni zone (gubiš podatke koje si uneo za baner)",
"Edit Blog" => "Izmeni Blog",
"edit blog tpl" => "izmeni blog tpl",
"Current heading" => "Trenutno zaglavlje",
"There are individual permissions set for this blog" => "Individualne dozvole su podešene za ovaj blog",
"Number of posts to show" => "Broj poruka za prikaz",
"Allow other user to post in this blog" => "Dozvoli ostalim korisnicima da pišu u ovom blogu",
"Use titles in blog posts" => "Koristi naslove u blog porukama",
"Allow search" => "Dozvoli pretragu",
"Allow comments" => "Dozvoli komentare",
"Blog heading" => "Zaglavlje bloga",
"Edit Style Sheet" => "Izmeni stranu sa stilovima",
"Style Sheet" => "Strana sa stilovima",
"Cancel" => "Obustavi",
"choose a stylesheet" => "odaberi stranu sa stilovima",
"try" => "pokušaj",
"display" => "prikaz",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Fajlovi sa imenima koja se završavaju sa -{\$user} se mogu menjati, a ostali se mogu samo kopirati i koristiti kao model.",
"Show Plugins Help" => "Prikaži pomoć za pluginove",
"some text" => "neki tekst",
"Creates a box with the data" => "Pravi okvir sa podacima",
"Box content" => "Sadržaj okvira",
"Title bar" => "Naslov",
"creates a title bar" => "pravi naslovnu liniju",
"Colored text" => "Obojen tekst",
"Lists" => "Liste",
"for bullet lists" => "za obične liste",
"for numbered lists" => "za numerisane liste",
"for definiton lists" => "za liste definicija",
"Wiki References" => "Wiki referense",
"JoinCapitalizedWords or use" => "SpojiteKapitalizovaneReči ili koristite",
"page|desc" => "strana|opis",
"for wiki references" => "za wiki referense",
"SomeName" => "NekoIme",
"prevents referencing" => "isključi referense",
"External links" => "Externi linkovi",
"Tables" => "Tabele",
"creates a table" => "pravi tabelu",
"displays an image" => "prikazuje sliku",
"height width desc link and align are optional" => "visina širina opis link i poravnjanje su opcioni",
"Non cacheable images" => "Slike koje se ne skladište",
"makes a horizontal rule" => "napravi horizontalnu liniju",
"creates the editable drawing foo" => "pravi crtež pod imenom foo koji možete izmeniti",
"Multi-page pages" => "Više-strane strane",
"RSS feeds" => "RSS izvore",
"displays rss feed with id=n maximum=m items" => "prikazuje rss izvore sa id=n maksimalno=m stvari",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Biće zamenjeno stvarnim sadržajem dinamičkog bloka sa id=n",
"Dynamic variables" => "Dinamičke varijable",
"Inserts an editable variable" => "Ubacuje promenjivu",
"Non parsed sections" => "Sekcija koja se ne parsira",
"Misc" => "Ostalo",
"Show Text Formatting Rules" => "Prikaži pravila za formatiranje teksta",
"No description available" => "Nema opisa",
"bold" => "zatamnjena",
"external link" => "spoljni link",
"special chars" => "specijalni karakteri",
"special characters" => "specijalni karakteri",
"Edit Image" => "Izmeni sliku",
"Edit successful!" => "Izmena uspešna",
"The following image was successfully edited" => "Sledeća slika je uspešno izmenjena",
"Image Description" => "Opis Slike",
"Edit and create Languages" => "Izmeni i napravi jezike",
"Im- Export Languages" => "Uvezi/Izvezi jezike",
"Edit and create languages" => "Izmeni i napravi jezike",
"Create Language" => "Napravi jezik",
"Shortname" => "Kratko ime",
"like" => "kao",
"Longname" => "Dugačko ime",
"Select the language to edit" => "Odaberite jezik za izmenu",
"Add a translation" => "Dodaj prevod",
"Edit translations" => "Izmeni prevod",
"Translate recorded" => "Prevedi snimljeno",
"Translation" => "Prevod",
"translate" => "prevedi",
"reset table" => "resetuj tabelu",
"Program dynamic content for block" => "Programiraj dinamički sadržaj za ovaj blok",
"create new block" => "napravi novi blok",
"Return to block listing" => "Nazad na listu blokova",
"Block description: " => "Opis bloka: ",
"Create or edit content" => "Napravi ili izmeni sadržaj",
"You are editing block:" => "Menjate blok:",
"Publishing date" => "Datum objavljivanja",
"Publishing Date" => "Datum objavljivanja",
"Edit question options" => "Izmeni opcije pitanja",
"list quizzes" => "lista kvizova",
"quiz stats" => "Statistike kvizova",
"this quiz stats" => "Statistike ovog kviza",
"edit this quiz" => "izmeni ovaj kviz",
"admin quizzes" => "administracija kvizova",
"Create/edit options for question" => "Napravi/izmeni opcije za pitanja",
"points" => "poena",
"Admin quizzes" => "Administriraj kvizove",
"admin quizzes tpl" => "admin kvizove tpl",
"Create/edit quizzes" => "Napravi/izmeni kvizove",
"There are individual permissions set for this quiz" => "Postoje individualne dozvole za ovaj kviz",
"Quiz can be repeated" => "Kviz može da se ponavlja",
"Store quiz results" => "Snimi rezultate kviza",
"Questions per page" => "Pitanja po strani",
"Quiz is time limited" => "Kviz je vremenski ograničen",
"Maximum time" => "Maksimalno vreme",
"canRepeat" => "može ponoviti",
"timeLimit" => "vremenski limit",
"results" => "rezultati",
"Edit quiz questions" => "Izmeni pitanja u kvizu",
"Create/edit questions for quiz" => "Napravi/izmeni pitanja za kviz",
"maxScore" => "maksimalan broj poena",
"From Points" => "Od poena",
"To Points" => "Do poena",
"Answer" => "Odgovor",
"Results" => "Rezultati",
"answer" => "odgovor",
"Modify Structure" => "Izmeni strukturu",
"You will remove" => "Obrisaćete",
"and its subpages from the structure, now you have two options:" => "i njene podstrane iz strukture, sada imate dve opcije:",
"Remove only from structure" => "Obrišite samo iz strukture",
"Remove from structure and remove page too" => "Obrišite iz strukture i uklonite stranu",
"Current Node" => "Trenutni nod",
"Page alias" => "Alijas strane",
"Promote" => "Unapredi",
"Previous" => "Prošli",
"Demote" => "Demotiraj",
"Add pages to current node" => "Dodaj strane u trenutni nod",
"After page" => "Nakon strane",
"create page" => "napravi stranu",
"Use pre-existing page" => "Koristi postojeću stranu",
"Structure Layout" => "Izgled strukture",
"edit submissions tpl" => "izmeni priloge tpl",
"list submissions" => "lista predloga",
"EditTemplates" => "Izmeni šablone",
"EditTemplates tpl" => "Izmeni Šablone tpl",
"Template listing" => "Lista šablona",
"Available templates" => "Šabloni na raspolaganju",
"Template" => "Šablon",
"Edit a topic" => "Izmeni temu",
"View" => "Vidi",
"Try to convert HTML to wiki" => "Pokušaj da konvertuješ HTML u wiki",
"Admin ephemerides" => "Administriraj efemeride",
"All ephemerides" => "Sve efemeride",
"Browse" => "Traži",
"Admin FAQ" => "Administriraj FAQ",
"View FAQ" => "Vidi FAQ",
"Edit this FAQ" => "Izmeni ovaj FAQ",
"new question" => "novo pitanje",
"Edit FAQ questions" => "Izmeni FAQ pitanja",
"Use a question from another FAQ" => "Koristi pitanje iz drugog FAQ",
"FAQ questions" => "FAQ pitanja",
"Suggested questions" => "Predložena pitanja",
"approve" => "dozvoli",
"No suggested questions" => "Nema predloženog pitanja",
"configure listing" => "konfiguriši_listing",
"Create a file gallery" => "Napravi galeriju fajlova",
"Edit this file gallery:" => "Izmeni ovu galeriju fajlova:",
"create new gallery" => "napravi novu galeriju",
"There are individual permissions set for this file gallery" => "Individualne dozvole su podešene za ovu galeriju fajlova",
"Gallery is visible to non-admin users?" => "Galerija je vidljiva ne admin korisnicima?",
"Listing configuration" => "Konfiguracija listinga",
"icon" => "ikona",
"Name-filename" => "Ime-Ime fajla",
"Filename only" => "Samo imena fajlova",
"Max description display size" => "Maksimalna veličina prikaza opisa",
"Max Rows per page" => "Maksimalno redova po strani",
"Other users can upload files to this gallery" => "Ostali korisnici mogu da šalju fajlove na ovu galeriju",
"You can access the file gallery using the following URL" => "Fajl galeriji možete pristupiti preko sledećeg URL",
"Available File Galleries" => "Slobodne galerije fajlova",
"Message queue for" => "Lista čekanja poruka za",
"back to forum" => "nazad na forum",
"Edit queued message" => "Izmene poruke na čekanju",
"topic" => "tema",
"make this a thread of" => "napravi nit od",
"None, this is a thread message" => "Nema, ovo je poruka u niti",
"summary" => "siže",
"normal" => "normalan",
"announce" => "proglas",
"hot" => "vrelo",
"sticky" => "važno",
"no feeling" => "nema osećanja",
"frown" => "mrk pogled",
"exclaim" => "uzvikni",
"idea" => "ideja",
"neutral" => "neutralan",
"sad" => "žalostan",
"happy" => "radosno",
"wink" => "namigni",
"save and approve" => "snimi i dozvoli",
"convert to topic" => "pretvori u temu",
"List of messages" => "Lista poruka",
"new topic" => "nova tema",
"no summary" => "nema sižea",
"No messages queued yet" => "Nema poruka na čekanju",
"reject" => "odbij",
"Reported messages for" => "Prijavljene poruke za",
"Reported by" => "Prijavio",
"accept" => "prihvati",
"Real Name" => "Pravo ime",
"Activity completed" => "Aktivnost završena",
"Admin process activities" => "Administriraj aktivnosti procesa",
"Add or edit an activity" => "Dodaj ili izmeni aktivnost",
"start" => "počni",
"end" => "kraj",
"activity" => "aktivnost",
"split" => "razdvoj",
"join" => "pridruži se",
"standalone" => "samostalan",
"interactive" => "interaktivan",
"auto routed" => "autorutiran",
"Add transitions" => "Dodaj prelaze",
"Add transition from:" => "Dodaj prelaz iz:",
"Add transition to:" => "Dodaj prelaz na:",
"roles" => "uloge",
"No roles associated to this activity" => "Uloge nisu dodeljene ovoj aktivnosti",
"Add role" => "Dodaj ulogu",
"add new" => "dodaj novo",
"add role" => "dodaj ulogu",
"Process activities" => "Aktivnosti procesa",
"Routing" => "Rutiranje",
"Interactive" => "interaktivan",
"Automatic" => "Automatski",
"Auto routed" => "Autorutiran",
"Manual" => "Uputstvo",
"route" => "rutiraj",
"(no roles)" => "(nema uloga)",
"No activities defined yet" => "Još nisu definisane aktivnosti",
"Process Transitions" => "Tranzicije procesa",
"List of transitions" => "Lista prelaza",
"From:" => "Od:",
"Origin" => "Poreklo",
"No transitions defined yet" => "Još nisu definisane tranzicije",
"Add a transition" => "Dodaj prelaz",
"This process is invalid" => "Ovaj proces je neispravan",
"List of processes" => "Lista procesa",
"Inactive" => "Neaktivan",
"act" => "uloga",
"active process" => "aktivni procesi",
"invalid" => "neispravan",
"invalid process" => "neispravan proces",
"valid process" => "ispravni proves",
"activities" => "aktivnosti",
"graph" => "grafik",
"new minor" => "nova manja",
"new major" => "nova glavna",
"No processes defined yet" => "Procesi nisu još definisani",
"Admin instance" => "Administriraj instance",
"Process:" => "Proces:",
"Instance" => "Instanca",
"Workitems" => "Radne jedinice",
"exception" => "izuzetak",
"completed" => "završeno",
"aborted" => "prekinut",
"Owner" => "Vlasnik",
"Send all to" => "Pošalji sve",
"Don't move" => "Ne pomeraj",
"Activities" => "Aktivnosti",
"Started" => "Počeo",
"Act status" => "Status uloge",
"Properties" => "Osobine",
"Property" => "Osobina",
"Value" => "Vrednost",
"Add property" => "Dodaj osobinu",
"value" => "vrednost",
"run instance" => "pokreni instancu",
"Galaxia Admin Processes" => "Galaxia administracija procesa",
"Galaxia Admin Processes tpl" => "Galaxia Administriraj procese tpl",
"Add or edit a process" => "Dodaj ili izmeni proces",
"Process Name" => "Ime procesa",
"ver:" => "verzija:",
"is active?" => "je aktivno?",
"Or upload a process using this form" => "Ili uploadujte proces koristeći ovu formu",
"Admin process roles" => "Administriraj uloge procesa",
"Add or edit a role" => "Dodaj ili izmeni ulogu",
"Process roles" => "Uloge procesa",
"No roles defined yet" => "Uloge nisu još definisane",
"Map users to roles" => "Mapiraj korisnike sa ulogama",
"Map" => "Mapa",
"Roles" => "Uloge",
"map" => "mapa",
"Map groups to roles" => "Mapiraj grupe sa ulogama",
"Operation" => "Operacija",
"Warning" => "Upozorenje",
"No roles are defined yet so no roles can be mapped" => "Nijedna uloga još nije definisana, i zato se uloge još ne mogu mapirati",
"List of mappings" => "Lista mapiranja",
"No mappings defined yet" => "Mapiranja nisu još definisana",
"Admin process sources" => "Administriraj izvore procesa",
"select source" => "odaberi izvor",
"Shared code" => "Deljeni kod",
"Set next user" => "Postavi sledećeg korisnika",
"Get property" => "Uzmi vrednost",
"Set property" => "Postavi osobinu",
"Complete" => "Završeno",
"Process form" => "Forma procesa",
"Set Next act" => "Postavi sledeću ulogu",
"Switch construct" => "Switch konstrukt",
"Map process roles" => "Mapiraj uloge procesa",
"admin processes" => "administriraj procese",
"admin activities" => "admin aktivnosti",
"admin roles" => "aministriraj uloge",
"edit this process" => "izmeni ovaj proces",
"Galaxia Monitor Activities" => "Galaxia aktivnosti monitora",
"Galaxia Monitor Activities tpl" => "Galaxia prati aktivnosti tpl",
"List of activities" => "Lista aktivnosti",
"routing" => "rutiranje",
"Instances" => "instance",
"run" => "pokreni",
"run activity" => "pokreni aktivnost",
"monitor" => "nadgledaj",
"monitor processes" => "nadgledaj procese",
"monitor activities" => "nadgledaj aktivnosti",
"monitor instances" => "nadgledaj instance",
"monitor workitems" => "nadgledaj radne jedinice",
"Galaxia Monitor Instances" => "Instance Galaksija Monitora",
"Galaxia Monitor Instances tpl" => "Galaxia prati instance tpl",
"List of instances" => "Lista instanci",
"No instances created yet" => "Instance nisu još napravljene",
"Galaxia Monitor Processes" => "Galaxia procesi monitora",
"Galaxia Monitor Processes tpl" => "Galaxia prati procese tpl",
"Valid" => "Ispravan",
"Invalid" => "Neispravan",
"processes" => "procesi",
"being run" => "pokrenuto",
"exceptions" => "izuzetci",
"Monitor workitems" => "Nadgledaj radne jedinice",
"List of workitems" => "Lista radnih jedinica",
"instance" => "instanca",
"exception instance" => "instanca izuzetka",
"exceptions instance" => "instanca izuzetka",
"send instance" => "pošalji instancu",
"abort instance" => "prekini instancu",
"grab instance" => "uhvati instancu",
"release instance" => "objavi instancu",
"activate" => "aktiviraj",
"User Activities" => "Korisničke aktivnosti",
"Galaxia User Activities" => "Galaxia korisničke aktivnosti",
"Galaxia User Activities tpl" => "Galaxia korisničke aktivnosti tpl",
"process" => "proces",
"user processes" => "Korisnički procesi",
"user activities" => "korisničke aktivnosti",
"user instances" => "Korisničke instance",
"Galaxia User Instances" => "Galaxia korisničke instance",
"Galaxia User Instances tpl" => "Galaxia korisničke instance tpl",
"Inst Status" => "Status instance",
"No instances defined yet" => "Instance nisu još definisane",
"Galaxia User Processes" => "Galaxia korisnički procesi",
"Galaxia User Processes tpl" => "Galaxia korisnički procesi tpl",
"Browsing Workitem" => "Gledanje poslovne jedinice",
"Workitem information" => "",
"galleries tpl" => "galerije tpl",
"Create a gallery" => "Napravi galeriju",
"Edit this gallery:" => "Izmeni ovu galeriju:",
"There are individual permissions set for this gallery" => "Individualne dozvole su podešene za ovu galeriju",
"Images per row" => "Slika po redu",
"Thumbnails size X" => "Širina smanjene slike",
"Thumbnails size Y" => "Visina smanjene slike",
"Image ID" => "ID slike",
"Filesize" => "Veličina fajla",
"Available scales" => "Skale na raspolaganju",
"No scales available" => "Nema nijedna skala",
"Other users can upload images to this gallery" => "Ostali korisnici mogu da dodaju slike ovoj galeriji",
"You can access the gallery using the following URL" => "Možete da pristupite galeriji pomoću sledećeg URL",
"Available Galleries" => "Galerije",
"Imgs" => "Slika",
"Im- Export languages" => "Importuj/Eksportuj jezike",
"Select the language to Import" => "Odaberi jezik za importovanje",
"Select the language to Export" => "Odaberi jezik za eksportovanje",
"ImportingPagesPhpWikiPageAdmin" => "Importovanje strana PHP Wiki administracija strana",
"Overwrite existing pages if the name is the same" => "Prebriši postojeće strane ako strana sa istim imenom postoji",
"Previously remove existing page versions" => "Prvo ukloni postojeće verzije strana",
"excerpt" => "isečak",
"result" => "rezultat",
"Clear cached version and refresh cache" => "Obriši uskladištenu verziju i osveži skladište",
"configure rules" => "podesi pravila",
"edit repository" => "promeni repozitoriju",
"Weeks" => "Nedelja",
"Search by Date" => "Traži po datumu",
"Found" => "Nađeno",
"LastChanges" => "ZadnjeIzmene",
"hist" => "istorija",
"rollback" => "vrati",
"source" => "izvor",
"Pages like" => "Strane kao",
"No pages found" => "Nije pronađena nijedna strana",
"List Articles" => "Lista članaka",
"list articles tpl" => "lista članak tpl",
"edit new article" => "izmeni novi članak",
"ExpireDate" => "Datum isticanja",
"AuthorName" => "ImeAutora",
"admin Banners" => "administriraj oglase",
"admin Banners tpl" => "admin banere tpl",
"Create banner" => "Napravi oglas",
"Method" => "Metode",
"Use Dates?" => "Koristi datume?",
"Max Impressions" => "Maskimalno prikaza",
"Impressions" => "Prikaza",
"Clicks" => "Klikova",
"create new blog" => "napravi novi blog",
"Last Modified" => "Zadnji put menjano",
"admin cache" => "administriraj skladište",
"admin cache tpl" => "admin skladište tpl",
"Dynamic content system" => "Sistem dinamičkih sadržaja",
"admin DynamicContent tpl" => "admin Dinamički Sadržaj tpl",
"Create or edit content block" => "Napravi ili izmeni blok sa sadržajem",
"Available content blocks" => "Raspoloživi blokovi sadržaja",
"Current ver" => "Trenutna verzija",
"Next ver" => "Sledeća verzija",
"Old vers" => "Stare verzije",
"Edit this FAQ:" => "Izmeni ovaj FAQ:",
"Create new FAQ" => "Napravi novi FAQ",
"Create New FAQ:" => "Napravi novi FAQ:",
"Users can suggest questions" => "Korisnici mogu da predlažu pitanja",
"Available FAQs" => "Raspoloživi FAQ",
"Listing Gallery" => "Listanje galerija",
"upload file" => "dodaj fajl",
"Edit a file using this form" => "Izmeni fajl koristeći ovu formu",
"Gallery Files" => "Fajlovi u galeriji",
"move selected files" => "pomeri odabrane fajlove",
"delete selected files" => "obriši odabrane fajlove",
"Move to" => "Pomeri",
"Dls" => "Skidanja",
"browse gallery" => "gledaj galeriju",
"Gallery Images" => "Slike u galeriji",
"All games are from" => "Sve igre su iz",
"visit the site for more games and fun" => "posetite sajt za još igara i zabave",
"Upload a game" => "Uploaduj igru",
"Upload a new game" => "Uploaduj novu igru",
"Flash binary (.sqf or .dcr)" => "Flash binarni fajlovi (.sqf or .dcr)",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Smanjene slike (ako se igra zove foo.swf smanjena slika mora da se zove foo.swf.gif ili foo.swf.png ili foo.swf.jpg)",
"Edit game" => "Izmeni igru",
"Played" => "Odigrana",
"times" => "puta",
"If you can't see the game then you need a flash plugin for your browser" => "Ako nemožete da vidite igru potreban vam je flash plugin za vaš browser",
"list posts tpl" => "list poruke tpl",
"edit blog" => "izmeni Blog",
"Blog Title" => "Naslov bloga",
"edit new submission" => "izmeni nove priloge",
"Approve" => "Odobri",
"Survey stats" => "Statistike anketa",
"List Movies" => "Izlistaj Filmove",
"Choose a movie" => "Izaberi film",
"Display" => "Prikaži",
"Last mod" => "Zadnja izmena",
"Last author" => "Zadnji autor",
"Last ver" => "Zadnja verzija",
"Vers" => "Verzija",
"with checked" => "sa označenim",
"admin live support tpl" => "admin podrška uživo tpl",
"Open client window" => "Otvori klijentski prozor",
"Generate HTML" => "Napravi HTML",
"Transcripts" => "Transkripti",
"Support tickets" => "Linije za podršku",
"Online operators" => "Uključeni operatori",
"Accepted requests" => "Prihvaćeni zahtevi",
"transcripts" => "Transkripti",
"Offline operators" => "Isključeni operatori",
"Add an operator to the system" => "Dodaj operatora sistemu",
"Operators must be tiki users" => "Operatori moraju biti tiki korisnici",
"set as operator" => "postavi kao operatora",
"Chat started" => "Započet chat",
"User:" => "Korisnik:",
"Live support:User window" => "Podršak uživo: Korisnički prozor",
"Request live support" => "Zahtevaj podršku uživo",
"Request support" => "Zahtevaj podršku",
"Open a support ticket instead" => "Otvori tiket za podršku",
"Your request is being processed" => "Vaš zahtev se razmatra",
"cancel request and exit" => "prekini zahtev i izađi",
"cancel request and leave a message" => "prekini zahtev i ostavi poruku",
"Live support:Console" => "Podrška uživo: Konzola",
"be online" => "uključi se",
"be offline" => "isključi se",
"Support requests" => "Zahtevi za podrškom",
"Requested" => "Zahtevano",
"Accept" => "Prihvati",
"Join" => "Pridruži se",
"Support chat transcripts" => "Transkript chat-a podrške",
"back to admin" => "nazad na administraciju",
"started" => "započeto",
"reason" => "razlog",
"msgs" => "poruka",
"Transcript" => "Transkript",
"Remove old events" => "Obriši stare događaje",
"duration" => "trajanje",
"Add or edit event" => "Dodaj ili izmeni događaj",
"Mini Calendar: Preferences" => "Mini Kalendar: Podešavanja",
"Calendar Interval in daily view" => "Interval kalendara u dnevnom pogledu",
"Start hour for days" => "Početni sat za dane",
"End hour for days" => "Krajnji sat za dane",
"Reminders" => "Podsetnik",
"no reminders" => "nema podsetnika",
"Import CSV file" => "Uvezi CSV fajl",
"Or enter path or URL" => "ili ukucajte URL ili lokaciju",
"add topic" => "dodaj temu",
"my tiki tpl" => "moj tiki tpl",
"My pages" => "Moje strane",
"My items" => "Moje stvari",
"My tasks" => "Moji poslovi",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Hvala vam na vašem upisivanju. Uskoro će te primiti email za potvrđivanje vašeg pristupa. Nijedne novine vam neće biti poslate dok se vaše upisivanje ne potvrdi.",
"Your email address was removed from the list of subscriptors." => "Vaša email adresa je uklonjena sa liste pretplatnika.",
"Subscription confirmed!" => "Upis potvrđen!",
"Subscribe to newsletter" => "Upišite se na novine",
"Subscribe" => "Upis",
"Select news group" => "Odaberite grupo novosti",
"Back to servers" => "Nazad na servere",
"Msgs" => "Poruka",
"Save position" => "Snimi poziciju",
"Reading article from" => "Čitanje članka sa",
"Back to list of articles" => "Nazad na listu članaka",
"First" => "Prva",
"Newsgroup" => "Grupe novosti",
"Configure news servers" => "Podesi server novosti",
"Configure Newsreader" => "Podesi čitač novina",
"configure newsreader server tpl" => "podesi čitač novina server tpl",
"Select a news server to browse" => "Odaberi server novosti za gledanje",
"Add or edit a news server" => "Dodaj ili izmeni server novosti",
"News server" => "Server novosti",
"Notes" => "Napomene",
"quota" => "kvota",
"Write a note" => "Napiši napomenu",
"No notes yet" => "Nema napomena",
"merge selected notes into" => "spoj odabrane note u",
"Reading note:" => "Čitanje napomene:",
"List notes" => "Listaj napomene",
"Write note" => "Napiši napomenu",
"wiki create" => "wiki napravi",
"wiki overwrite" => "Wiki prebriši",
"Assign permissions to " => "Dodeli dozvole ",
"back" => "nazad",
"Current permissions for this object" => "Trenutne dozvole za ovaj objekat",
"Assign permissions to this object" => "Dodeli dozvole ovom objektu",
"Published" => "Objavljeno",
"Votes" => "Glasova",
"Orphan Pages" => "Strane bez roditelja",
"Assign permissions to page" => "Dodeli dozvole strani",
"Current permissions for this page" => "Trenutne dozvole za ovu stranu",
"remove from this page" => "ukloni sa ove strane",
"remove from this structure" => "ukloni iz ove strukture",
"this page" => "ova strana",
"Send email notifications when this page changes to" => "Pošalji email obaveštenje kada se ova poruka promeni na",
"add email" => "dodaj email",
"Notifications" => "Obaveštenja",
"Pick your avatar" => "Odaberite vaš avatar",
"Your current avatar" => "Vaš trenutni avatar",
"Pick avatar from the library" => "Odaberi avatar iz biblioteke",
"Show all" => "Prikaži sve",
"Avatar Image" => "Slika avatara",
"random" => "slučajni",
"Upload your own avatar" => "Uploadujte vaš sopstveni avatar",
"lastModif" => "zadnja promena",
"Average" => "Prosečno",
"View Results" => "Vidi rezultate",
"Vote poll" => "Glasaj za upitnik",
"Other Polls" => "Ostali upitnici",
"Print multiple pages" => "Štampaj više strana",
"Print Wiki Pages" => "Štampaj Wiki strane",
"clear" => "obriši",
"Quiz result stats" => "Statistike rezultata kviza",
"Quiz" => "Kviz",
"Time" => "Vreme",
"User answers" => "Korisničkih odgovora",
"Stats for quizzes" => "Statistike kvizova",
"taken" => "uzet",
"Av score" => "Prosečan rezultat",
"Av time" => "Prosečno vreme",
"Stats for quiz" => "Statistike za kviz",
"clear stats" => "briši statistike",
"Stats for this quiz Questions " => "Statistike za pitanja iz ovog kviza ",
"Received Articles" => "Primljeni članci",
"received articles tpl" => "primljeni članci tpl",
"Edit received article" => "Izmeni primljene članke",
"Use Image" => "Koristi sliku",
"Image x size" => "Širina slike (X)",
"Image y size" => "Visina slike (Y)",
"Image name" => "Naziv slike",
"Accept Article" => "Prihvati članak",
"Site" => "Sajt",
"received pages tpl" => "primljene strane tpl",
"Edit received page" => "Izmenbu primljenu stranu",
"admin Referer stats" => "administriraj statistike referenata",
"admin Referer stats tpl" => "admin referer statistike tpl",
"last" => "zadnji",
"Tiki site registered" => "Tiki sajt registrovan",
"Read this first!" => "Prvo pročitajte ovo!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Na ovoj strani možete da registrujete svoj sajt na tikiwiki.org. Tamo će biti izlistan na listi poznatih tiki sajtova.",
"Registering is voluntary." => "Registracija je dobrovoljna.",
"Registering does not give you any benefits except one more link to your site." => "Registracija vam ne daje nikakve dodatne prednosti osim još jednog linka do vašeg sajta.",
"You don't get any emails, we don't sell the data about your site." => "Ne dobijate nijedan email, i ne prodajemo informacije o vašem sajtu.",
"Registering is just for us to get an overview of Tiki's usage." => "Registracija služi samo nama da bi imali predleg korišćenja Tikija.",
"If your site is private or inside your intranet, you should not register!" => "Ako je vaš sajt privatan ili unutar intraneta, nemojte da se registrujete!",
"Information about your site" => "Informacije o vašem sajtu",
"I forgot my password" => "Zaboravio sam moju lozinku",
"send me my password" => "pošalji mi moju lozinku",
"Return to HomePage" => "Vrati se na GlavnuStranu",
"Remove page" => "Obriši stranu",
"You are about to remove the page" => "Želite da obrišete stranicu",
"permanently" => "za stalno",
"Remove all versions of this page" => "Obriši sve verzije ove stranice",
"Rename page" => "Promeni naziv strane",
"Rollback page" => "Vrati nazad stranu",
"to_version" => "na_verziju",
"Search Stats" => "Pretražuj statistike",
"search stats tpl" => "pretraga statistika tpl",
"searched" => "pretraženo",
"Search in" => "Traži u",
"galleries" => "galerije",
"blog posts" => "blog poruke",
"articles" => "članci",
"trackers" => "trakeri",
"Simple search" => "Jednostavna pretraga",
"No pages matched the search criteria" => "Nijedna strana ne odgovara kriterijumima pretrage",
"Send blog post" => "Pošalji blog poruku",
"A link to this post was sent to the following addresses:" => "Link na ovu poruku je poslat na sledeće adrese:",
"Send post to this addresses" => "Pošalji poruku na ovu adresu",
"List of email addresses separated by commas" => "Lista email adresa odvojenih zarezom",
"Send objects" => "Pošalji objekte",
"admin send objects tpl" => "admin pošalji objekte tpl",
"Transmission results" => "Rezultati prenosa",
"Send objects to this site" => "Pošalji objekte ovom sajtu",
"site" => "sajt",
"password" => "lozinka",
"Send Wiki Pages" => "Pošalji Wiki strane",
"Send Articles" => "Pošalji članak",
"add article" => "dodaj članak",
"admin Tiki Shoutbox" => "administriraj Tiki ShoutBox",
"Change shoutbox general settings" => "Izmeni shoutbox osnovna podešavanja",
"auto-link urls" => "auto-link URL-ovi",
"Post or edit a message" => "Napiši ili izmeni poruku",
"big grin" => "veliki kez",
"confused" => "zbunjen",
"cry" => "plač",
"evil" => "zao",
"lol" => "LOL",
"mr green" => "mali zeleni",
"redface" => "zacrveneo sam se",
"rolleyes" => "kolutanje",
"smile" => "osmeh",
"surprised" => "iznenađen",
"twisted" => "izopačen",
"arrow" => "strelica",
"Site Stats" => "Statistike sajta",
"Days online" => "Dana onlajn",
"Total pageviews" => "Ukupno pogleda strana",
"Average pageviews per day" => "Prosek pogleda na dan",
"Best day" => "Najbolji dan",
"Worst day" => "Najgori dan",
"Wiki Stats" => "Wiki statistike",
"Size of Wiki Pages" => "Veličina Wiki strana",
"Average page length" => "Porsečna dužina strana",
"bytes" => "bajtova",
"Average versions per page" => "Prosečno verzija po strani",
"Visits to wiki pages" => "Poseta Wiki stranama",
"Average links per page" => "Prosečno linkova po strani",
"Image galleries Stats" => "Statistike galerija slika",
"Average images per gallery" => "Prosečno slika po galeriji",
"Total size of images" => "Ukupna veličina svih slika",
"Average image size" => "Prosečna veličina slika",
"Visits to image galleries" => "Poseta galerijama slika",
"File galleries Stats" => "Statistike galerija fajlova",
"Average files per gallery" => "Prosečno fajlova po galeriji",
"Total size of files" => "Ukupna veličina svih fajlova",
"Average file size" => "Prosečna veličina fajla",
"Visits to file galleries" => "Poseta galerijama fajlova",
"CMS Stats" => "CMS Statistike",
"Total reads" => "Ukupno čitanja",
"Average reads per article" => "Prosečno čitanja po članku",
"Total articles size" => "Ukupna veličina svih članaka",
"Average article size" => "Prosečna veličina članka",
"Forum Stats" => "Statistike foruma",
"Total topics" => "Ukupno tema",
"Average topics per forums" => "Prosečno tema po forumu",
"Total threads" => "Ukupno poruka",
"Average threads per topic" => "Prosečno poruka po temi",
"Visits to forums" => "Poseta forumu",
"Blog Stats" => "Blog statistike",
"Weblogs" => "Weblogovi",
"Total posts" => "Ukupno poruka",
"Average posts per weblog" => "Prosečno poruka po blogu",
"Total size of blog posts" => "Ukupna veličina blog poruka",
"Average posts size" => "Prosečna veličina poruke",
"Visits to weblogs" => "Poseta blogovima",
"Poll Stats" => "Statistike upitnika",
"Total votes" => "Ukupno glasova",
"Average votes per poll" => "Prosečno glasova po upitniku",
"Faq Stats" => "FAQ statistike",
"Total questions" => "Ukupno pitanja",
"Average questions per FAQ" => "Prosečno pitanja po FAQ",
"User Stats" => "Korisničke statistike",
"User bookmarks" => "Korisničke omiljene strane",
"Average bookmarks per user" => "Prosečno omiljenih linkova po korisniku",
"Quiz Stats" => "Statistike kviza",
"Average questions per quiz" => "Prosečno pitanja po kvizu",
"Quizzes taken" => "Urađenih kvizoa",
"Average quiz score" => "Prosečan rezultat na kvizu",
"Average time per quiz" => "Prosečno vreme po kvizu",
"Object" => "Objekti",
"Usage chart" => "grafik upotrebe",
"Usage chart image" => "Grafik korišćenja",
"Stats for surveys" => "Statistike za ankete",
"Survey" => "Anketa",
"Last taken" => "Zadnji put urađena",
"Stats for survey" => "Statistike anketa",
"Stats for this survey Questions " => "Statistike ovog pitanja ankete",
"Time Left" => "Ostalo vremena",
"send answers" => "pošalji odgovore",
"Result" => "Rezultati",
"Theme Control Center: categories" => "Kontrolni centar tema: kategorije",
"ThemeControl" => "Kontrola Tema",
"ThemeControl tpl" => "Kontrola tema tpl",
"Theme is selected as follows" => "Tema je odabrana kao što sledi",
"If a theme is assigned to the individual object that theme is used." => "Ako je tema dodeljena individualnom objektu ta tema se koristi.",
"If not then if a theme is assigned to the object's category that theme is used" => "Ako nema toga, koristi se tema dodeljena kategoriji tog objekta",
"If not then a theme for the section is used" => "Ako nema toga koristi je tema sekcije",
"If none of the above was selected the user theme is used" => "Ako nijedno od gore navedenih stvari nije odabrano, korisnička tema se koristi",
"Finally if the user didn't select a theme the default theme is used" => "Na kraju, ako korisnik nije odabrao temu, koristi se podrazumevana tema",
"Control by Sections" => "Kontrola po sekcijama",
"Assign themes to categories" => "Dodeli teme kategorijama",
"Assigned categories" => "Dodeljne kategorije",
"theme" => "teme",
"Theme Control Center: Objects" => "Controlni centar tema: objekti",
"ThemeControl Objects" => "ThemeControl objekti",
"theme control objects tpl" => "Kontrola tema objekti tpl",
"Control by Categories" => "Kontrola po kategorijama",
"Assign themes to objects" => "Dodeli teme objektima",
"Assigned objects" => "Dodeljeni objekti",
"Theme Control Center: sections" => "Controlni centar tema: sekcije",
"theme control sections tpl" => "Kontrola tema sekcije tpl",
"Assign themes to sections" => "Dodeli teme sekcijama",
"Assigned sections" => "Dodeljene sekcije",
"Upload File" => "Dodaj fajl",
"File Title" => "Naslov fajla",
"Now enter the file URL" => "Sada upišite pun URL",
" or upload a local file from your disk" => " ili odaberite fajl sa vašeg hard diska za uploadovanje",
"Batch upload" => "Grupni upload",
"The following file was successfully uploaded" => "Sledeći fajl je uspešno uploadovan",
"You can download this file using" => "Možete preuzeti ovaj fajl koristeći",
"You can include the file in an HTML/Tiki page using" => "Ovaj fajl možete da uključite u vašoj HTML/Tiki strani koristeći",
"Image Gallery tpl" => "Galerija slika tpl",
"Now enter the image URL" => "Sada ukucajte URL slike",
" or upload a local image from your disk" => " ili uploadujte sliku sa vašeg hard diska",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Smanjena slika (opciono, zamenjuje automatsko generisanje smanjenih slika)",
"Upload successful!" => "Upload uspešan!",
"The following image was successfully uploaded" => "Sledeća slika je uspešno uploadovana",
"Thumbnail" => "Smanjena slika",
"Image ID thumb" => "ID smanjene slike",
"You can include the image in an Wiki page using" => "Sliku možete da dodate u bilo koju stranu uz pomoć",
"User assigned modules" => "Korisnički moduli",
"User Assigned Modules" => "Korisnički dodeljeni moduli",
"User Assigned Modules tpl" => "Korisnički dodati moduli tpl",
"Restore defaults" => "Vrati na podrazumevane vrednosti",
"move to right column" => "pomeri u desnu kolonu",
"unassign" => "oduzmi",
"move to left column" => "pomeri u levu kolonu",
"Assign module" => "Dodeli module",
"Module" => "Moduli",
"Column" => "Kolona",
"User Bookmarks tpl" => "Korisničke omiljene strane tpl",
"Current folder" => "Trenutni direktorijum",
"Folders" => "Direktorijumi",
"Folder in" => "Folder u",
"remove folder" => "obriši direktorijum",
"refresh cache" => "osveži skladište",
"Admin folders and bookmarks" => "Administriraj direktorijume i omiljene strane",
"Add or edit folder" => "Dodaj ili izmeni direktorijum",
"Add or edit a URL" => "Dodaj ili izmeni URL",
"Personal Wiki Page" => "Lična Wiki Strana",
"Displayed time zone" => "Prikazana vremenska zona",
"Send me a message" => "Pošalji mi poruku",
"User Preferences" => "Korisnička podešavanja",
"UserPreferences tpl" => "Korisnička podešavanja tpl",
"Pick user Avatar" => "Odaberite vaš avatar",
"Your personal Wiki Page" => "Tvoja lična Wiki Strana",
"Is email public? (uses scrambling to prevent spam)" => "Email je javan? (koristi se prikrivanje za zaštitu od spama)",
"Number of visited pages to remember" => "Broj posećenih strana da se pamti",
"Local" => "Lokalno",
"User information" => "Korisničke informacije",
"private" => "privatno",
"public" => "javno",
"Messages per page" => "Poruka po strani",
"Allow messages from other users" => "Dozvoli poruke od drugih korisnika",
"Send me an email for messages with priority equal or greater than" => "Pošalji mi email za poruke sa prioritetom jednakim ili većim od",
"Tasks per page" => "Poslova po strani",
"My messages" => "Moje poruke",
"User Tasks tpl" => "Korisnički zadaci tpl",
"Percentage completed" => "Procenata završeno",
"priority" => "prioritet",
"No tasks entered" => "Zadaci nisu upisani",
"May need to refresh twice to see changes" => "Dva osveževanja mogu biti potrebna da bi se videle promene",
"Add top level bookmarks to menu" => "Dodaj omiljene stranice prvog nivoa meniju",
"Pos" => "Pozicija",
"Mode" => "Mod",
"replace window" => "zameni prozor",
"User_versions_for" => "Korisničke verzije za",
"expires:" => "ističe:",
"no comments" => "nema komentara",
"Banner stats" => "Statistike oglasa",
"Create new banner" => "Napravi novi oglas",
"Banner Information" => "Informacije o oglasima",
"Click ratio" => "Odnos klikovi/pogledi",
"Weekdays" => "Radni dani",
"mon" => "pon",
"tue" => "uto",
"wed" => "sre",
"thu" => "čet",
"fri" => "pet",
"sat" => "sub",
"sun" => "ned",
"Banner raw data" => "Sirovi podaci o oglasima",
"Cached" => "Uskladišteno",
"This is a cached version of the page." => "Ovo je uskladištena verzija stranice.",
"Click here to view the Google cache of the page instead." => "Kliknite ovde da bi videli Google cache ove stranice.",
"viewed" => "pogledano",
"edit items" => "izmeni zapise",
"list charts" => "Lista grafika",
"last chart" => "zadnji grafik",
"previous chart" => "prošli grafik",
"Chart created" => "Grafik napravljen",
"next chart" => "sledeći grafik",
"item" => "zapis",
"avg" => "prosek",
"info/vote" => "info/glasaj",
"Next chart will be generated on" => "Sledeći grafik će biti generisan dana",
"View or vote items not listed in the chart" => "Vidi ili glasaj za stvari koje nisu na grafiku",
"Select something to vote on" => "Odaberi za šta ćeš da glasaš",
"Item information" => "Informacije o zapisima",
"Chart" => "Grafik",
"Permanency" => "Stalnost",
"Dif" => "Razlika",
"Best Position" => "Najbolja pozicija",
"Vote this item" => "Glsaj za ovu stvar",
"Highest" => "Najviši",
"view faq" => "vidi faq",
"view faq tpl" => "vidi faq tpl",
"admin menus tpl" => "admin meniji tpl",
"Forum List" => "Lista foruma",
"Edit Forum" => "Izmeni forum",
"monitor this forum" => "nadgledaj ovaj forum",
"stop monitoring this forum" => "prestani sa nadgledanjem ovog foruma",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Vaša poruka je stavljena na listu za čekanje potvrde, a biće objavljena\nnakon što je moderator odobri",
"You have to enter a title and text" => "Morate upisati i naslov i tekst",
"post new comment" => "napiši novi komentar",
"Summary" => "Siže",
"HTML tags are not allowed inside comments" => "HTML nisu dozvoljeni unutar komentara",
"moderator actions" => "moderatorske akcije",
"move selected topics" => "pomeri odabrane teme",
"unlock selected topics" => "odključaj odabrane teme",
"lock selected topics" => "zaključaj odabrane teme",
"delete selected topics" => "obriši odabrane teme",
"merge" => "spoj",
"merge selected topics" => "spoj odabrane teme",
"reported messages:" => "prijavljene poruke:",
"queued messages:" => "poruke na listi čekanja:",
"Merge into topic" => "Spoj u temu",
"pts" => "poena",
"No topics yet" => "Nema još tema",
"topics in this forum" => "tema u ovom forumu",
"Show posts" => "Prikaži poruke",
"Last hour" => "Zadnji sat",
"Last 24 hours" => "Zadnjih 24 sata",
"Last 48 hours" => "Zadnjih 48 sati",
"Jump to forum" => "Skoči na forum",
" unread private messages" => " neproitanih privatnih poruka",
"prev topic" => "prošla poruka",
"next topic" => "sledeća tema",
"monitor this topic" => "nadgledaj ovu temu",
"stop monitoring this topic" => "prestani sa nadgledanjem ove teme",
"Comments below your current threshold" => "Komentara ispod vaše trenutne granice",
"Select" => "Odaberi",
"Show All" => "Prikaži sve",
"Insert new item" => "Ubaci nov zapis",
"View item" => "Vidi zapis",
"Add a comment" => "Dodaj komentar",
"Attach a file to this item" => "Priloži fajl ovom zapisu",
"No attachments for this item" => "Nema priloga na ovom zapisu",
"Webmail Doc" => "Webmail dokumentacija",
"settings" => "podešavanja",
"mailbox" => "poštansko sanduče",
"compose" => "napiši",
"contacts" => "kontakti",
"Contacts" => "Kontakti",
"Add new mail account" => "Dodaj novi email nalog",
"User accounts" => "Korisnički nalozi",
"account" => "nalog",
"View All" => "Vidi sve",
"Msg" => "Poruka",
"clip" => "klip",
"back to mailbox" => "nazad na sanduče",
"full headers" => "sva zaglavlja",
"normal headers" => "normalna zaglavlja",
"reply all" => "odgovori svima",
"forward" => "prosledi",
"Create/edit contacts" => "Napravi/izmeni kontakte",
"First Name" => "Ime",
"Last Name" => "Prezime",
"select from address book" => "odaberi iz adresara",
"Use HTML mail" => "Koristi HTML email",
"The following addresses are not in your address book" => "Sledeće adrese se ne nalaze u vašem adresaru",
"add contacts" => "Dodaj kontakte",
"Attachment 1" => "Prilog 1",
"Attachment 2" => "Prilog 2",
"Attachment 3" => "Prilog 3",
"Address book" => "Adresar",
"General preferences and settings" => "Generalna podešavanja",
"Wiki settings" => "Wiki podešavanja",
"Poll comments settings" => "Podešavanja komentara upitnika",
"Forums settings" => "Podešavanja foruma",
"No chart indicated" => "Grafik nije odabran",
"Upload failed" => "Upload nije uspeo",
"No page indicated" => "Strana nije odabrana",
"The passwords don't match" => "Lozinke se ne podudaraju",
"Password should be at least" => "Lozinka mora da bude bar",
"characters long" => "karaktera dugačka",
"Your admin password has been changed" => "Vaša administratorska lozinka je promenjena",
"DATE-of" => "od",
"All Fields except gdaltindex must be filled" => "Sva polja osim gdaltindex moraju biti popunjena",
"Tag already exists" => "Tag već postoji",
"Tag not found" => "Tag nije nađen",
"Repository name can't be an empty" => "Ime repozitorije ne može biti prazno",
"Requested action is not supported on repository" => "Zahtevana akcija nije podržana nad repozitorijom",
"No repository" => "Nema repozitorije",
"Search is mandatory field" => "Pretraga je obavezno polje",
"File not found " => "Fajl nije pronađen ",
"Requested action in not supported on repository" => "Zahtevana akcija nije podržana nad repozitorijom",
"Non-existent link" => "Nepostojeći link",
"No menu indicated" => "Meni nije odabran",
"No newsletter indicated" => "Nise odabrane novine",
"No poll indicated" => "Upitnik nije odabran",
"You must specify a page name, it will be created if it doesn't exist." => "Morate napisati naziv strane, ako ne postoji ona će biti kreirana.",
"page not added (Exists)" => "strana nije dodata (Postoji)",
"No survey indicated" => "Nije odabrana anketa",
"No tracker indicated" => "Nije odabran traker",
"Group already exists" => "Grupa već postoji",
"No records were found. Check the file please!" => "Nijedan zapis nije pronađen. Molimo vas da proverite fajl!",
"User login is required" => "Korisnički login se zahteva",
"Password is required" => "Lozinka je zahtevana",
"Email is required" => "Email je zahtevan",
"User is duplicated" => "Korisnik je dupliran",
"User already exists" => "Korisnik već postoji",
"The passwords dont match" => "Lozinke nisu iste",
"Password must contain both letters and numbers" => "Lozinka mora da sadrži slova i brojeve",
"Permission denied you cannot view this section" => "Nemate dozvolu da gledate ovu sekciju",
"Unknown group" => "Nepoznata grupa",
"Group doesnt exist" => "Grupa ne postoji",
"Unknown user" => "Nepoznat korisnik",
"User doesnt exist" => "Korisnik ne postoji",
"Permission denied you cannot view backlinks for this page" => "Nemate dozvolu da vidite rekurzivne linkove za ovu stranicu",
"The page cannot be found" => "Strana ne može da se nađe",
"Invalid directory name" => "Neispravno ime direktorijuma",
"Permission denied you cannot post" => "Nemate dozvolu da pišete poruke",
"Permission denied you cannot edit this post" => "Nemate dozvolu da menjate ovu poruku",
"You can't post in any blog maybe you have to create a blog first" => "Nemožete da pišete ni u jednom blogu. Možda prvo treba da napravite blog?",
"Top visited blogs" => "Najposećeniji blogovi",
"Last posts" => "Zadnje poruke",
"Top active blogs" => "Top aktivni blogovi",
"No blogId specified" => "blogId nije specifiran",
"TOP" => "VRH",
"Permission denied you cannot access this gallery" => "Nemate dozvolu da pristupate ovoj galeriji",
"No gallery indicated" => "Galerija nije odabrana",
"Permission denied you cannot view this page" => "Nemate dozvolu da vidite ovu stranu",
"Permission denied you can not view this section" => "Nemate dozvolu da gledate ovu sekciju",
"Permission denied you cannot remove images from this gallery" => "Nemate dozvolu da uklanjate slike iz ove galerije",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Nemate dozvolu da ponovo generišete smanjen prikaz u ovoj galeriji",
"Permission denied you cannot rotate images in this gallery" => "Nemate dozvolu da rotirate slike u ovoj galeriji",
"No image indicated" => "Slika nije odabrana",
"Permission denied you cannot move images from this gallery" => "Nemate dozvolu da pomerate slike iz ove galerije",
"Permission denied you cannot view the calendar" => "Nemate dozvolu da gledate kalendar",
"event without name" => "događaj bez imena",
"You can not use the same password again" => "Nemožete dva puta da koristite istu lozinku",
"Invalid old password" => "Neispravna stara lozinka",
"Permission denied to use this feature" => "Nemate dozvolu da koristite ovu mogućnost",
"No channel indicated" => "Kanal nije odabran",
"No nickname indicated" => "Nadimak nije odabran",
"Top authors" => "Top autori",
"Message sent to" => "Poruke poslate na",
"This feature has been disabled" => "Ova osobenost je isključena",
"Must enter a name to add a site. " => "Morate upisati ime da bi dodali sajt. ",
"Must enter a url to add a site. " => "Morate upisati url da bi dodali sajt. ",
"URL already added to the directory. Duplicate site? " => "URL je već dodat u direktorijum. Duplikat sajta? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Ne može da se pristupi odabranom URL pogrešan URL ili je sajt offline i ne može da se doda u direktorijum. ",
"Must select a category. " => "Morate odabrati kategoriju. ",
"Must enter a name to add a site" => "Morate uneti naziv za unos sajta",
"Must enter a url to add a site" => "Morate uneti URL za unos sajta",
"URL already added to the directory. Duplicate site?" => "URL već postoji u direktorijumu. Napraviti duplikat?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Ne može da se pristupi odabranom URL: pogrešan URL ili je sajt offline i ne može da se doda u direktorijum. ",
"Must select a category" => "Morate odabrati kategoriju",
"No site indicated" => "Nije odabran sajt",
"You can not download files" => "Ne možete da preuzimate fajlove",
"Permission denied you cannot edit this article" => "Nemate dozvolu da menjate ovaj članak",
"You do not have permissions to edit banners" => "Nemate dozvolu da menjate oglase",
"Banner not found" => "Oglas nije nađen",
"You do not have permission to edit this banner" => "Nemate dozvolu da menjate ovaj oglas",
"Permission denied you cannot create or edit blogs" => "Nemate dozvolu da pravite ili menjate blogove",
"Permission denied you cannot edit this blog" => "Nemate dozvolu da menjate ovaj blog",
"You do not have permission to write the style sheet" => "Nemate dozvolu da pravite stranu sa stilovima",
"Invalid request to edit an image" => "Neispravan zathev za izmenom slike",
"Permission denied you cannot edit images" => "Nemate dozvolu za menjanje slika",
"Permission denied you can edit images but not in this gallery" => "Nemate dozvolu da menjate slike u ovoj galeriji iako imate dozvolu u nekoj drugoj galeriji",
"Failed to edit the image" => "Neuspešna izmena slike",
"Shortname must be 2 Characters" => "Kratko ime mora biti 2 karaktera dugačko",
"You must provide a longname" => "Morate upisati dugačko ime",
"Language created" => "Jezik je napravljen",
"No content id indicated" => "Niste odabrali id sadržaja",
"No question indicated" => "Pitanje nije odabrano",
"No quiz indicated" => "Nije odabran kviz",
"No structure indicated" => "Nije odabrana struktura",
"Invalid structure_id or page_ref_id" => "Neispravan structure_id ili  page_ref_id",
"Permission denied you cannot send submissions" => "Nemate dozvolu da šaljete priloge",
"Permission denied you cannot edit submissions" => "Nemate dozvolu da menjate priloge",
"You have to create a topic first" => "Prvo morate da napravite temu",
"You do not have permission to do that" => "NEmate dozvolu da to uradite",
"You do not have permission to read the template" => "Nemate dozvolu da čitate šablone",
"No topic id specified" => "topic_id nije određen",
"Invalid topic id specified" => "Neispravan topic_id",
"Article not found" => "Članak nije pronađen",
"Permission denied you cannot edit this page" => "Nemate dozvolu da menjate ovu stranu",
"page imported" => "strana uvezena",
"created from import" => "napravljeno iz uvoza",
"Can't import remote HTML page" => "Udaljena HTML strana ne može da se uveze",
"Can't parse remote HTML page" => "Udaljena HTML strana ne može da se parsira",
"You cannot edit this page because it is a user personal page" => "Ne možete promeniti ovu stranu jer je ona korisnička strana",
"The SandBox is disabled" => "Igraonica je isključena",
"Cannot edit page because it is locked" => "Ne može da se menja strana jer je zaključana",
"Permission denied you cannot create galleries and so you cant edit them" => "Nemate dozvolu da pravite galerije i zato ne možete ni da ih menjate",
"Permission denied you cannot edit this gallery" => "Nemate dozvolu da menjate ovu galeriju",
"Permission denied you cannot remove this gallery" => "Nemate dozvolu da obrišete ovu galeriju",
"Top visited file galleries" => "Najposećenije fajl galerije",
"Most downloaded files" => "Naj preuzimaniji fajlovi",
"Last files" => "Zadnji fajlovi",
"No galleryId specified" => "galleryId nije određen",
"No forum indicated" => "Forum nije odabran",
"Forum posts" => "Teme foruma",
"No forumId specified" => "forumId nije određen",
"Invalid username" => "Neispravno korisničko ime",
"No process indicated" => "Proces nije odabran",
"Activity name already exists" => "Naziv aktivnosti već postoji",
"indicates if the process is active. Invalid processes cant be active" => "označava da li je proces aktivan. Neispravni procesi ne mogu da se aktiviraju",
"No instance indicated" => "Instanca nije odabrana",
"No activity indicated" => "Aktivnosti nisu odabrane",
"The process name already exists" => "Ime procesa već postoji",
"Process already exists" => "Proces već postoji",
"You cant execute this activity" => "Ne možete da pokrenete ovu aktivnost",
"No user indicated" => "Korisnik nije odabran",
"No item indicated" => "Niste odabrali zapis",
"Top images" => "Naj slike",
"Last images" => "Zadnje slike",
"overwriting old page" => "prebrisavanje starih strana",
"page created" => "strana napravljena",
"No repository given" => "Repozitorija nije određena",
"Permission denied you cannot view pages like this page" => "Nemate dozvolu da vidite strane koje liče ovoj strani",
"Permission denied you cannot remove articles" => "Nemate dozvolu da brišete članke",
"Permission denied you cannot remove banners" => "Nemate dozvolu da uklanjate oglase",
"Permission denied you cannot remove this blog" => "Nemate dozvolu da obrišete ovaj blog",
"Non-existent gallery" => "Nepostojeća galerija",
"Permission denied you cannot remove files from this gallery" => "Nemate dozvolu da brišete fajlove iz ove galerije",
"Permission denied you can't upload files so you can't edit them" => "Nemate dozvolu da uploadujete fajlove, i zato ne možete da ih menjate",
"Permission denied you cannot edit this file" => "Nemate dozvolu da izmenite ovaj fajl",
"The thumbnail name must be" => "Naziv smanjene slike mora biti",
"You cannot admin blogs" => "Ne možete da administrirate blogove",
"Permission denied you cannot remove submissions" => "Nemate dozvolu da brišete priloge",
"Permission denied you cannot approve submissions" => "Nemate dozvolu da dozvoljavate priloge",
"Permission denied you cannot view pages" => "Nemate dozvolu da gledate strane",
"Permission denied you cannot remove pages" => "Nemate dozvolu da obrišete strane",
"changed" => "promenjeno",
"You do not have permissions to view the maps" => "Nemate dozbolu da gledate mape",
"mapfile name incorrect" => "pogrešan naziv map fajla",
"This mapfile already exists" => "Ovaj map fajl već postoji",
"You do not have permission to write to the mapfile" => "Nemate dozvolu da pišete u map fajl",
"You do not have permission to delete the mapfile" => "Nemate dozvolu da obrišete map fajl",
"You do not have permission to read the mapfile" => "Nemate dozvolu da čitate map fajl",
"You do not have permissions to view the layers" => "Nemate dozvolu da vidite slojeve",
"Could not upload the file" => "Upload fajla nije uspeo",
"You do not have permissions to delete a file" => "Nemate dozvolu da obrišete fajl",
"File not found" => "Fajl nije pronađen",
"You do not have permissions to create a directory" => "Nemate dozvolu da napravite direktorijum",
"The Directory is not empty" => "Direktorijum nije prazan",
"You do not have permissions to delete a directory" => "Nemate dozvolu da obrišete direktorijum",
"You do not have permissions to create an index file" => "Nemate dozvolu da napravite indeksni fajl",
"Invalid file name" => "Neispravno ime fajla",
"Invalid files to index" => "Neispravni fajlovi za indeksiranje",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Ne znam gde se nalazi gdaltindex. Ispravno podesite Map osobenost",
"I could not create the index file" => "Ne mogu da napravim indeksni fajl",
"Must be logged to use this feature" => "Morate biti loginovani da bi koristili ovu osobenost",
"Welcome at Hawiki" => "Dobrodošli u Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Ovaj Tikiwiki sajt je spreman za pristup sa velikog broja mobilnih uređaja, npr. WAP telefoni, PDA, i-mode uređaji i mnogi drugi.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "Možete da gledate ovaj sajt na vašem mobilnom uređaju tako što ćete browser na vašem uređaju uputiti na sledeći URL:",
"About" => "O Nama",
"You must log in to use this feature" => "Morate da se loginujete da bi koristili ovu mogućnost",
"You do not have permission to view other users data" => "Nemate dozvolu da vidite podatke o ostalim korisnicima",
"You must be logged in to subscribe to newsletters" => "Morate biti ulogovani da bi se pretplatili na novine",
"No server indicated" => "Server nije odabran",
"Cannot connect to" => "Ne može da se uspostavi veza do",
"Missing information to read news (server,port,username,password,group) required" => "Nedostaju informacije potrebne za čitanje novosti (server, port, korisničko ime, lozinka, grupa) su zahtevani",
"Cannot get messages" => "Ne može da se preuzme poruka",
"No note indicated" => "Nije odabran notes",
"merged note:" => "spojene note:",
"File is too big" => "Fajl je prevelik",
"created from notepad" => "napravljeno iz notesa",
"No name indicated for wiki page" => "Ime nije napisano za wiki stranu",
"Page already exists" => "Strana već postoji",
"Permission denied you cannot assign permissions for this page" => "Nemate dozvolu da dodeljujete dozvole za ovu stranu",
"Not enough information to display this page" => "Nema dovoljno informacija za prikaz strane",
"Permission denied you cannot browse this page history" => "Nemate dozvolu da gledate istoriju ove strane",
"No article indicated" => "Niste odabrali članak",
"Article is not published yet" => "Članak još nije objavljen",
"No post indicated" => "Nije odabrana poruka",
"Blog not found" => "Blog nije nađen",
"No pages indicated" => "Strana nije odabrana",
"No result indicated" => "nema rezultata",
"Permision denied" => "Zabranjeno",
"Wrong registration code" => "Pogrešan registracioni kod",
"Username is too long" => "Korisničko ime je predugačko",
"Username cannot contain whitespace" => "Korisničko ime ne može da sadrži razmak",
"Wrong passcode you need to know the passcode to register in this site" => "Pogrešna šifre. Morate znati odgovarajuću šifru da bi se registrovali na ovom sajtu.",
"Invalid email address. You must enter a valid email address" => "Neispravna email adresa. Morate uneti ispravnu email adresu",
"to the registered email address for" => "na registrovanu email adresu za",
"Invalid or unknown username" => "Neispravno ili nepoznato korisničko ime",
"Permission denied you cannot remove versions from this page" => "Nemate dozvolu da uklanjate verzije ove stranice",
"Cannot rename page maybe new page already exists" => "ne mogu da promenim ime stranice. Možda ste upisali ime postojeće stranice?",
"Non-existent version" => "Nepostojeća verzija",
"Permission denied you cannot rollback this page" => "Nemate dozvolu da vršite povraćaj ove stranice",
"Post recommendation at" => "Preporuka poruke na",
" successfully sent" => " uspeno poslato",
" not sent" => " nije poslato",
"You do not have permission to edit messages" => "Nemate dozvolu da menjate poruke",
"Page must be defined inside a structure to use this feature" => "Strana mora biti definisana van strukture da bi koristili ovu osobenost",
"You cannot take this quiz twice" => "Ne možete dva puta da uradite ovaj kviz",
"Quiz time limit exceeded quiz cannot be computed" => "Vreme za rađenje kviza je prekoračeno. Kviz ne može da bude izračunat",
"You cannot take this survey twice" => "Ne možete dva puta da radite istu anketu",
"Please create a category first" => "Prvo odaberite kategoriju",
"Invalid filename (using filters for filenames)" => "Neispravno ime fajla (koriste se filteri za ime fajla)",
"No permission to upload zipped file packages" => "Nemate dozvolu da uploadujete zipovan fajl paket",
"Cannot read file" => "ne mogu da pročitam fajl",
"Permission denied you cannot upload files" => "Nemate dozvolu da uploadujete fajlove",
"Permission denied you can upload files but not to this file gallery" => "Nemate dozvolu da dodate fajl ovoj galeriji fajlova, iako imate dozvolu za dodavanje fajlova drugim galerijama fajlova",
"Error processing zipped image package" => "Greška pri procesiranju zipovanog paketa sa slikama",
"No permission to upload zipped image packages" => "Nemate dozvolu da uploadujete zipovan paket slika",
"Permission denied you cannot upload images" => "Nemate dozvolu da dodajete slike",
"Permission denied you can upload images but not to this gallery" => "Nemate dozvolu da dodajete slike ovoj galeriji, ali možete dodati sliku nekoj drugoj galeriji",
"Cannot get image from URL" => "Ne mogu da nađem sliku na datom URL",
"cannot process upload" => "ne može da se završi upload",
"No url indicated" => "URL nije odabran",
"You are not logged in and no user indicated" => "Niste looginovani i nijedan korisnik nije odabran",
"The user has chosen to make his information private" => "Korisnik je odabrao da sakrije svoje informacije",
"The passwords did not match" => "Lozinke se ne poklapaju",
"Cannot upload this file not enough quota" => "Fajl ne može da se prihvati jer nije dovoljno velika kvota",
"Non-existent user" => "Nepostojeći korisnik",
"No banner indicated" => "Niste odabrali oglas",
"No blog indicated" => "Niste odabrali blog",
"Permission denied you cannot remove the post" => "Nemate dozvolu da obrišete poruku",
"No cache information available" => "Nema podataka o ovoj stranici u skladištu",
"No faq indicated" => "FAQ nije odabran",
"You are not permitted to remove someone else\\'s post!" => "Nije vam dozvoljeno da uklanjate tuđe poruke!",
"Wrong password. Cannot post comment" => "Pogrešna lozinka",
"Please wait 2 minutes between posts" => "Sačekajte 2 minuta između poruka",
"No thread indicated" => "Tema nije odabrana",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Vaša email adresa je uklonjena sa liste adresa koje nadgledaju ovaj traker",
"Your email address has been added to the list of addresses monitoring this tracker" => "Vaša email adresa je dodata listi adresa koje nadgledaju ovaj traker",
"Cancel monitoring" => "Prekini nadgledanje",
"Monitor" => "Nadgledaj ",
"Your email address has been removed from the list of addresses monitoring this item" => "Vaša email adresa je uklonjena sa liste adresa koje nadgledaju ovu stvar",
"Your email address has been added to the list of addresses monitoring this item" => "Vaša email adresa je dodata listi adresa koje nadgledaju ovu stvar",
"No subject" => "Nema naslova",
"Your email was sent" => "Vaš email je poslat",
"Top pages" => "Top strane",
"Last pages" => "Zadnje strane",
"###end###"=>"###end###");
?>
