/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Frame;
import java.util.Properties;
import javax.swing.JFrame;
import org.jgraph.layout.AnnealingLayoutAlgorithm;
import org.jgraph.layout.AnnealingLayoutController;
import org.jgraph.layout.GEMLayoutAlgorithm;
import org.jgraph.layout.GEMLayoutConfigurationDialog;
import org.jgraph.layout.LayoutAlgorithm;
import org.jgraph.layout.LayoutController;

public class GEMLayoutController
implements LayoutController {
    public static final String KEY_TITLE = "GEM";
    public static final String KEY_CONFIG_NAME = "CONFIG_NAME";
    public static final String KEY_INIT_TEMPERATURE = "init temperature";
    public static final String KEY_MIN_TEMPERATURE = "min temperature";
    public static final String KEY_MAX_TEMPERATURE = "max temperature";
    public static final String KEY_PREF_EDGE_LENGTH = "preferred Edge length";
    public static final String KEY_GRAVITATION = "gravitation to barycenter";
    public static final String KEY_RANDOM_IMPULSE_RANGE = "random impulse range";
    public static final String KEY_COMPUTE_PERMUTATION = "compute permutation";
    public static final String KEY_END_CONDITION_AVERAGE = "end condition average";
    public static final String KEY_AVOID_OVERLAPPING = "avoid overlapping";
    public static final String KEY_OVERLAPPING_DETECTION_WIDTH = "overlapping detection width";
    public static final String KEY_OVERLAPPING_PREF_DISTANCE = "overlapping preferred distance";
    public static final String KEY_ALPHA_OSC = "alpha oscillation";
    public static final String KEY_ALPHA_ROT = "alpha rotation";
    public static final String KEY_SIGMA_OSC = "sigma oscillation";
    public static final String KEY_SIGMA_ROT = "sigma rotation";
    public static final String KEY_OPTIMIZE_ALGORITHM_ENABLED = "optimization algorithm enabled";
    public static final String KEY_OPTIMIZE_ALGORITHM_CONFIG = "optimization algorithm configuration";
    public static final String KEY_LAYOUT_UPDATE_INIT_TEMPERATURE = "Layout Update init temperature";
    public static final String KEY_LAYOUT_UPDATE_MIN_TEMPERATURE = "Layout Update min temperature";
    public static final String KEY_LAYOUT_UPDATE_MAX_TEMPERATURE = "Layout Update max temperature";
    public static final String KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH = "Layout Update preferred Edge length";
    public static final String KEY_LAYOUT_UPDATE_GRAVITATION = "Layout Update gravitation to barycenter";
    public static final String KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE = "Layout Update random impulse range";
    public static final String KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION = "Layout Update compute permutation";
    public static final String KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE = "Layout Update end condition average";
    public static final String KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING = "Layout Update avoid overlapping";
    public static final String KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH = "Layout Update overlapping detection width";
    public static final String KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE = "Layout Update overlapping preferred distance";
    public static final String KEY_LAYOUT_UPDATE_ALPHA_ROT = "Layout Update alpha oscillation";
    public static final String KEY_LAYOUT_UPDATE_ALPHA_OSC = "Layout Update alpha rotation";
    public static final String KEY_LAYOUT_UPDATE_SIGMA_ROT = "Layout Update sigma oscillation";
    public static final String KEY_LAYOUT_UPDATE_SIGMA_OSC = "Layout Update sigma rotation";
    public static final String KEY_LAYOUT_UPDATE_ENABLED = "Layout Update enabled";
    public static final String KEY_LAYOUT_UPDATE_METHOD = "Layout Update method";
    public static final String KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED = "Layout Update optimization algorithm enabled";
    public static final String KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG = "Layout Update optimization algorithm configuration";
    public static final String KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY = "Neighbors only";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETERS = "Perimeter";
    public static final String KEY_LAYOUT_UPDATE_DEPTH = "Layout Update depth";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE = "Layout Update method perimeter initial size";
    public static final String KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC = "Layout Update method perimeter size increase value";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED = "clustering enabled";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE = "cluster init temperature";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR = "clustering force scaling factor";
    public static final String KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR = "cluster size factor";
    protected Properties[] configs;
    protected Properties configuration;
    protected GEMLayoutConfigurationDialog dialog;
    protected AnnealingLayoutController optimizeController = new AnnealingLayoutController(true);
    protected AnnealingLayoutController lu_optimizeController = new AnnealingLayoutController(true);

    public GEMLayoutController() {
        this.configs = new Properties[2];
        int n = 0;
        while (n < this.configs.length) {
            this.configs[n] = new Properties();
            ++n;
        }
        Properties properties = this.optimizeController.getConfiguration();
        properties.put(KEY_CONFIG_NAME, "GEM optimization values");
        properties.put("Costfunction Config", "110111");
        properties.put("Start Temperature", "40.0");
        properties.put("min. Distance", "100.0");
        properties.put("Temperature Scalefactor", "0.85");
        this.optimizeController.setConfiguration(properties);
        Properties properties2 = this.lu_optimizeController.getConfiguration();
        properties2.put(KEY_CONFIG_NAME, "GEM optimization values");
        properties2.put("Costfunction Config", "110111");
        properties2.put("Start Temperature", "40.0");
        properties2.put("min. Distance", "100.0");
        properties2.put("Temperature Scalefactor", "0.85");
        this.lu_optimizeController.setConfiguration(properties2);
        this.configs[0].put(KEY_CONFIG_NAME, "Default Values");
        this.configs[0].put(KEY_INIT_TEMPERATURE, "50.0");
        this.configs[0].put(KEY_MIN_TEMPERATURE, "3.0");
        this.configs[0].put(KEY_MAX_TEMPERATURE, "256.0");
        this.configs[0].put(KEY_PREF_EDGE_LENGTH, "100.0");
        this.configs[0].put(KEY_GRAVITATION, "0.0625");
        this.configs[0].put(KEY_RANDOM_IMPULSE_RANGE, "32.0");
        this.configs[0].put(KEY_COMPUTE_PERMUTATION, "true");
        this.configs[0].put(KEY_END_CONDITION_AVERAGE, "true");
        this.configs[0].put(KEY_AVOID_OVERLAPPING, "false");
        this.configs[0].put(KEY_OVERLAPPING_DETECTION_WIDTH, "40.0");
        this.configs[0].put(KEY_OVERLAPPING_PREF_DISTANCE, "40.0");
        this.configs[0].put(KEY_ALPHA_OSC, String.valueOf(1.5707963267948966));
        this.configs[0].put(KEY_ALPHA_ROT, String.valueOf(1.0471975511965976));
        this.configs[0].put(KEY_SIGMA_OSC, String.valueOf(0.3333333333333333));
        this.configs[0].put(KEY_SIGMA_ROT, String.valueOf(0.5));
        this.configs[0].put(KEY_OPTIMIZE_ALGORITHM_ENABLED, "false");
        this.configs[0].put(KEY_OPTIMIZE_ALGORITHM_CONFIG, properties.clone());
        this.configs[0].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "10.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "3.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, "256.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, "100.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_GRAVITATION, "0.0625");
        this.configs[0].put(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, "32.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        this.configs[0].put(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE, "true");
        this.configs[0].put(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING, "false");
        this.configs[0].put(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, "40.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, "40.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_ALPHA_OSC, String.valueOf(Math.toRadians(90.0)));
        this.configs[0].put(KEY_LAYOUT_UPDATE_ALPHA_ROT, String.valueOf(Math.toRadians(60.0)));
        this.configs[0].put(KEY_LAYOUT_UPDATE_SIGMA_OSC, String.valueOf(0.3333333333333333));
        this.configs[0].put(KEY_LAYOUT_UPDATE_SIGMA_ROT, String.valueOf(0.5));
        this.configs[0].put(KEY_LAYOUT_UPDATE_ENABLED, "false");
        this.configs[0].put(KEY_LAYOUT_UPDATE_DEPTH, "1");
        this.configs[0].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_NEIGHBORS_ONLY);
        this.configs[0].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED, "false");
        this.configs[0].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG, properties2.clone());
        this.configs[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "false");
        this.configs[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, "15.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, "0.1");
        this.configs[0].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "8.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, "100.0");
        this.configs[0].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, "20.0");
        this.configs[1].put(KEY_CONFIG_NAME, "Long running Values");
        this.configs[1].put(KEY_INIT_TEMPERATURE, "250.0");
        this.configs[1].put(KEY_MIN_TEMPERATURE, "0.5");
        this.configs[1].put(KEY_MAX_TEMPERATURE, "256.0");
        this.configs[1].put(KEY_PREF_EDGE_LENGTH, "100.0");
        this.configs[1].put(KEY_GRAVITATION, "0.0625");
        this.configs[1].put(KEY_RANDOM_IMPULSE_RANGE, "32.0");
        this.configs[1].put(KEY_COMPUTE_PERMUTATION, "true");
        this.configs[1].put(KEY_END_CONDITION_AVERAGE, "false");
        this.configs[1].put(KEY_AVOID_OVERLAPPING, "false");
        this.configs[1].put(KEY_OVERLAPPING_DETECTION_WIDTH, "40.0");
        this.configs[1].put(KEY_OVERLAPPING_PREF_DISTANCE, "40.0");
        this.configs[1].put(KEY_ALPHA_OSC, String.valueOf(Math.toRadians(90.0)));
        this.configs[1].put(KEY_ALPHA_ROT, String.valueOf(Math.toRadians(60.0)));
        this.configs[1].put(KEY_SIGMA_OSC, String.valueOf(0.875));
        this.configs[1].put(KEY_SIGMA_ROT, String.valueOf(0.2));
        this.configs[1].put(KEY_OPTIMIZE_ALGORITHM_ENABLED, "false");
        this.configs[1].put(KEY_OPTIMIZE_ALGORITHM_CONFIG, properties.clone());
        this.configs[1].put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, "100.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, "2.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, "256.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, "100.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_GRAVITATION, "0.0625");
        this.configs[1].put(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, "32.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, "true");
        this.configs[1].put(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE, "false");
        this.configs[1].put(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING, "false");
        this.configs[1].put(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, "40.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, "40.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_ALPHA_OSC, String.valueOf(Math.toRadians(90.0)));
        this.configs[1].put(KEY_LAYOUT_UPDATE_ALPHA_ROT, String.valueOf(Math.toRadians(60.0)));
        this.configs[1].put(KEY_LAYOUT_UPDATE_SIGMA_OSC, String.valueOf(0.875));
        this.configs[1].put(KEY_LAYOUT_UPDATE_SIGMA_ROT, String.valueOf(0.2));
        this.configs[1].put(KEY_LAYOUT_UPDATE_ENABLED, "false");
        this.configs[1].put(KEY_LAYOUT_UPDATE_DEPTH, "1");
        this.configs[1].put(KEY_LAYOUT_UPDATE_METHOD, KEY_LAYOUT_UPDATE_METHOD_PERIMETERS);
        this.configs[1].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED, "false");
        this.configs[1].put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG, properties2.clone());
        this.configs[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, "true");
        this.configs[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, "20.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, "0.1");
        this.configs[1].put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, "12.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, "150.0");
        this.configs[1].put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, "30.0");
        this.configuration = (Properties)this.configs[0].clone();
        this.dialog = new GEMLayoutConfigurationDialog((Frame)new JFrame(), this.configs, this.optimizeController, this.lu_optimizeController);
    }

    public String toString() {
        return KEY_TITLE;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure() {
        this.pushConfig();
        this.dialog.setVisible(true);
        if (!this.dialog.isCanceled()) {
            this.pullConfig();
        }
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return new GEMLayoutAlgorithm((AnnealingLayoutAlgorithm)this.optimizeController.getLayoutAlgorithm());
    }

    protected void pushConfig() {
        double d = Double.parseDouble((String)this.configuration.get(KEY_INIT_TEMPERATURE));
        double d2 = Double.parseDouble((String)this.configuration.get(KEY_MIN_TEMPERATURE));
        double d3 = Double.parseDouble((String)this.configuration.get(KEY_MAX_TEMPERATURE));
        double d4 = Double.parseDouble((String)this.configuration.get(KEY_PREF_EDGE_LENGTH));
        double d5 = Double.parseDouble((String)this.configuration.get(KEY_GRAVITATION));
        double d6 = Double.parseDouble((String)this.configuration.get(KEY_RANDOM_IMPULSE_RANGE));
        double d7 = Double.parseDouble((String)this.configuration.get(KEY_OVERLAPPING_DETECTION_WIDTH));
        double d8 = Double.parseDouble((String)this.configuration.get(KEY_OVERLAPPING_PREF_DISTANCE));
        double d9 = Double.parseDouble((String)this.configuration.get(KEY_ALPHA_OSC));
        double d10 = Double.parseDouble((String)this.configuration.get(KEY_ALPHA_ROT));
        double d11 = Double.parseDouble((String)this.configuration.get(KEY_SIGMA_OSC));
        double d12 = Double.parseDouble((String)this.configuration.get(KEY_SIGMA_ROT));
        boolean bl = this.isTrue((String)this.configuration.get(KEY_COMPUTE_PERMUTATION));
        boolean bl2 = this.isTrue((String)this.configuration.get(KEY_END_CONDITION_AVERAGE));
        boolean bl3 = this.isTrue((String)this.configuration.get(KEY_AVOID_OVERLAPPING));
        boolean bl4 = this.isTrue((String)this.configuration.get(KEY_OPTIMIZE_ALGORITHM_ENABLED));
        Properties properties = (Properties)this.configuration.get(KEY_OPTIMIZE_ALGORITHM_CONFIG);
        double d13 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE));
        double d14 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE));
        double d15 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE));
        double d16 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH));
        double d17 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_GRAVITATION));
        double d18 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE));
        double d19 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH));
        double d20 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE));
        double d21 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_ALPHA_OSC));
        double d22 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_ALPHA_ROT));
        double d23 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_SIGMA_OSC));
        double d24 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_SIGMA_ROT));
        double d25 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE));
        double d26 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR));
        double d27 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR));
        int n = Integer.parseInt((String)this.configuration.get(KEY_LAYOUT_UPDATE_DEPTH));
        double d28 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE));
        double d29 = Double.parseDouble((String)this.configuration.get(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC));
        boolean bl5 = this.isTrue((String)this.configuration.get(KEY_LAYOUT_UPDATE_ENABLED));
        boolean bl6 = this.isTrue((String)this.configuration.get(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED));
        boolean bl7 = this.isTrue((String)this.configuration.get(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION));
        boolean bl8 = this.isTrue((String)this.configuration.get(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE));
        boolean bl9 = this.isTrue((String)this.configuration.get(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING));
        boolean bl10 = this.isTrue((String)this.configuration.get(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED));
        Properties properties2 = (Properties)this.configuration.get(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG);
        String string = (String)this.configuration.get(KEY_LAYOUT_UPDATE_METHOD);
        this.dialog.setInitTemperature(d);
        this.dialog.setMinTemperature(d2);
        this.dialog.setMaxTemperature(d3);
        this.dialog.setPreferredEdgeLength(d4);
        this.dialog.setGravitation(d5);
        this.dialog.setRandomImpulseRange(d6);
        this.dialog.setOverlapDetectionWidth(d7);
        this.dialog.setOverlapPreferredDistance(d8);
        this.dialog.setAlphaOsc(d9);
        this.dialog.setAlphaRot(d10);
        this.dialog.setSigmaOsc(d11);
        this.dialog.setSigmaRot(d12);
        this.dialog.setComputePermutation(bl);
        this.dialog.setEndPerAverage(bl2);
        this.dialog.setAvoidOverlapping(bl3);
        this.dialog.setOptimizationAlgorithmEnabled(bl4);
        this.dialog.setOptimizationConfiguration(properties);
        this.dialog.setLayoutUpdateInitTemperature(d13);
        this.dialog.setLayoutUpdateMinTemperature(d14);
        this.dialog.setLayoutUpdateMaxTemperature(d15);
        this.dialog.setLayoutUpdatePreferredEdgeLength(d16);
        this.dialog.setLayoutUpdateGravitation(d17);
        this.dialog.setLayoutUpdateRandomImpulseRange(d18);
        this.dialog.setLayoutUpdateOverlapDetectionWidth(d19);
        this.dialog.setLayoutUpdateOverlapPreferredDistance(d20);
        this.dialog.setLayoutUpdateAlphaOsc(d21);
        this.dialog.setLayoutUpdateAlphaRot(d22);
        this.dialog.setLayoutUpdateSigmaOsc(d23);
        this.dialog.setLayoutUpdateSigmaRot(d24);
        this.dialog.setLayoutUpdateComputePermutation(bl7);
        this.dialog.setLayoutUpdateEndPerAverage(bl8);
        this.dialog.setLayoutUpdateAvoidOverlapping(bl9);
        this.dialog.setLayoutUpdateOptimizationAlgorithmEnabled(bl10);
        this.dialog.setLayoutUpdateOptimizationConfiguration(properties2);
        this.dialog.setLayoutUpdateEnabled(bl5);
        this.dialog.setLayoutUpdateDepth(n);
        this.dialog.setLayoutUpdateMethodPerimeterInitSize(d28);
        this.dialog.setLayoutUpdateMethodPerimeterSizeInc(d29);
        this.dialog.setLayoutUpdateClusteringEnabled(bl6);
        this.dialog.setLayoutUpdateClusteringInitTemperature(d25);
        this.dialog.setLayoutUpdateClusteringForceScalingFactor(d26);
        this.dialog.setLayoutUpdateClusteringFactor(d27);
        this.dialog.setLayoutUpdateMethod(string);
    }

    protected boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    protected void pullConfig() {
        double d = this.dialog.getInitTemperature();
        double d2 = this.dialog.getMinTemperature();
        double d3 = this.dialog.getMaxTemperature();
        double d4 = this.dialog.getPreferredEdgeLength();
        double d5 = this.dialog.getGravitation();
        double d6 = this.dialog.getRandomImpulseRange();
        double d7 = this.dialog.getOverlapDetectionWidth();
        double d8 = this.dialog.getOverlapPreferredDistance();
        double d9 = this.dialog.getAlphaOsc();
        double d10 = this.dialog.getAlphaRot();
        double d11 = this.dialog.getSigmaOsc();
        double d12 = this.dialog.getSigmaRot();
        boolean bl = this.dialog.getComputePermutation();
        boolean bl2 = this.dialog.getEndPerAverage();
        boolean bl3 = this.dialog.getAvoidOverlapping();
        boolean bl4 = this.dialog.getOptimizationAlgorithmEnabled();
        Properties properties = this.dialog.getOptimizationConfiguration();
        double d13 = this.dialog.getLayoutUpdateInitTemperature();
        double d14 = this.dialog.getLayoutUpdateMinTemperature();
        double d15 = this.dialog.getLayoutUpdateMaxTemperature();
        double d16 = this.dialog.getLayoutUpdatePreferredEdgeLength();
        double d17 = this.dialog.getLayoutUpdateGravitation();
        double d18 = this.dialog.getLayoutUpdateRandomImpulseRange();
        double d19 = this.dialog.getLayoutUpdateOverlapDetectionWidth();
        double d20 = this.dialog.getLayoutUpdateOverlapPreferredDistance();
        double d21 = this.dialog.getLayoutUpdateAlphaOsc();
        double d22 = this.dialog.getLayoutUpdateAlphaRot();
        double d23 = this.dialog.getLayoutUpdateSigmaOsc();
        double d24 = this.dialog.getLayoutUpdateSigmaRot();
        boolean bl5 = this.dialog.getLayoutUpdateComputePermutation();
        boolean bl6 = this.dialog.getLayoutUpdateEndPerAverage();
        boolean bl7 = this.dialog.getLayoutUpdateAvoidOverlapping();
        boolean bl8 = this.dialog.getLayoutUpdateOptimizationAlgorithmEnabled();
        boolean bl9 = this.dialog.getLayoutUpdateEnabled();
        String string = this.dialog.getLayoutUpdateMethod();
        int n = this.dialog.getLayoutUpdateDepth();
        double d25 = this.dialog.getLayoutUpdateMethodPerimeterInitSize();
        double d26 = this.dialog.getLayoutUpdateMethodPerimeterSizeInc();
        boolean bl10 = this.dialog.getLayoutUpdateClusteringEnabled();
        double d27 = this.dialog.getLayoutUpdateClusteringInitTemperature();
        double d28 = this.dialog.getLayoutUpdateClusteringForceScalingFactor();
        double d29 = this.dialog.getLayoutUpdateClusteringFactor();
        Properties properties2 = this.dialog.getLayoutUpdateOptimizationConfiguration();
        this.configuration.put(KEY_INIT_TEMPERATURE, String.valueOf(d));
        this.configuration.put(KEY_MIN_TEMPERATURE, String.valueOf(d2));
        this.configuration.put(KEY_MAX_TEMPERATURE, String.valueOf(d3));
        this.configuration.put(KEY_PREF_EDGE_LENGTH, String.valueOf(d4));
        this.configuration.put(KEY_GRAVITATION, String.valueOf(d5));
        this.configuration.put(KEY_RANDOM_IMPULSE_RANGE, String.valueOf(d6));
        this.configuration.put(KEY_OVERLAPPING_DETECTION_WIDTH, String.valueOf(d7));
        this.configuration.put(KEY_OVERLAPPING_PREF_DISTANCE, String.valueOf(d8));
        this.configuration.put(KEY_COMPUTE_PERMUTATION, String.valueOf(bl));
        this.configuration.put(KEY_END_CONDITION_AVERAGE, String.valueOf(bl2));
        this.configuration.put(KEY_AVOID_OVERLAPPING, String.valueOf(bl3));
        this.configuration.put(KEY_ALPHA_OSC, String.valueOf(d9));
        this.configuration.put(KEY_ALPHA_ROT, String.valueOf(d10));
        this.configuration.put(KEY_SIGMA_OSC, String.valueOf(d11));
        this.configuration.put(KEY_SIGMA_ROT, String.valueOf(d12));
        this.configuration.put(KEY_OPTIMIZE_ALGORITHM_ENABLED, String.valueOf(bl4));
        this.configuration.put(KEY_OPTIMIZE_ALGORITHM_CONFIG, properties);
        this.configuration.put(KEY_LAYOUT_UPDATE_INIT_TEMPERATURE, String.valueOf(d13));
        this.configuration.put(KEY_LAYOUT_UPDATE_MIN_TEMPERATURE, String.valueOf(d14));
        this.configuration.put(KEY_LAYOUT_UPDATE_MAX_TEMPERATURE, String.valueOf(d15));
        this.configuration.put(KEY_LAYOUT_UPDATE_PREF_EDGE_LENGTH, String.valueOf(d16));
        this.configuration.put(KEY_LAYOUT_UPDATE_GRAVITATION, String.valueOf(d17));
        this.configuration.put(KEY_LAYOUT_UPDATE_RANDOM_IMPULSE_RANGE, String.valueOf(d18));
        this.configuration.put(KEY_LAYOUT_UPDATE_OVERLAPPING_DETECTION_WIDTH, String.valueOf(d19));
        this.configuration.put(KEY_LAYOUT_UPDATE_OVERLAPPING_PREF_DISTANCE, String.valueOf(d20));
        this.configuration.put(KEY_LAYOUT_UPDATE_COMPUTE_PERMUTATION, String.valueOf(bl5));
        this.configuration.put(KEY_LAYOUT_UPDATE_END_CONDITION_AVERAGE, String.valueOf(bl6));
        this.configuration.put(KEY_LAYOUT_UPDATE_AVOID_OVERLAPPING, String.valueOf(bl7));
        this.configuration.put(KEY_LAYOUT_UPDATE_ALPHA_OSC, String.valueOf(d21));
        this.configuration.put(KEY_LAYOUT_UPDATE_ALPHA_ROT, String.valueOf(d22));
        this.configuration.put(KEY_LAYOUT_UPDATE_SIGMA_OSC, String.valueOf(d23));
        this.configuration.put(KEY_LAYOUT_UPDATE_SIGMA_ROT, String.valueOf(d24));
        this.configuration.put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_ENABLED, String.valueOf(bl8));
        this.configuration.put(KEY_LAYOUT_UPDATE_OPTIMIZE_ALGORITHM_CONFIG, properties2);
        this.configuration.put(KEY_LAYOUT_UPDATE_ENABLED, String.valueOf(bl9));
        this.configuration.put(KEY_LAYOUT_UPDATE_METHOD, string);
        this.configuration.put(KEY_LAYOUT_UPDATE_DEPTH, String.valueOf(n));
        this.configuration.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_INIT_SIZE, String.valueOf(d25));
        this.configuration.put(KEY_LAYOUT_UPDATE_METHOD_PERIMETER_SIZE_INC, String.valueOf(d26));
        this.configuration.put(KEY_LAYOUT_UPDATE_CLUSTERING_ENABLED, String.valueOf(bl10));
        this.configuration.put(KEY_LAYOUT_UPDATE_CLUSTERING_INIT_TEMPERATURE, String.valueOf(d27));
        this.configuration.put(KEY_LAYOUT_UPDATE_CLUSTERING_FORCE_SCALING_FACTOR, String.valueOf(d28));
        this.configuration.put(KEY_LAYOUT_UPDATE_CLUSTERING_FACTOR, String.valueOf(d29));
    }
}

