<?php // -*- coding:utf-8 -*-
// parameters:
// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated
// comments   : generate all comments (equal to close&module)
// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made
// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)
// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer
// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)
// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)
// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate langauage 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate langauage 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"+1d" => "+1n",
"+1m" => "+1p",
"+7d" => "+7n",
"Add all your site users to this newsletter (broadcast)" => "Minden felhasználó hozzáadása a hírlevél előfizetéshez (broadcast)",
"Add or edit a task" => "Feladat hozzáadása vagy szerkesztése",
"Add scaled images size X x Y" => "X x Y méretû, méretarányos képek hozzáadása",
"All tasks" => "Minden feladat",
"assgn" => "csatol",
"Completed" => "Végrehajtva",
"ExtWikis" => "Külső Wikik",
"File gals" => "File gyűjtemények",
"forum topic" => "fórum téma",
"Image gals" => "Kép galériák",
"Import pages from a PHPWiki Dump" => "Lapok importálása a PHPWiki Dump-ból",
"mark as done" => "elvégzettként megjelöl",
"open tasks" => "feladatok megnyitása",
"Packages" => "Csomagok",
"Ranking" => "Rangsor",
"Received Pages" => "Oldalak fogadása",
"Start date" => "Kezdési dátum",
"To create a new translation of a page that has never been translated before, create an initial version of the translation, select the translation language above, enter the page name of the original page below, and hit \"go\"." => "Ha egy új oldalt fordítok le, akkor először létrehozom a lefordított oldalt az eredeti alapján, beállítom a fordítás nyelvét az új oldalon, majd itt ezen az oldalon egymáshoz illesztem az az eredetit és az úja(ka)t egy fordítási halmazba. Ehhez alul a szövegmezőben megadom a lefordított oldal nevét, majd \"hozzáadom a fordítások halmazához\".",
"today" => "ma",
"v=view, b=rollback, c=compare with current, d=diff to current, s=source" => "v=megtekintem, b=visszatérek a korábbihoz, c=összehasonlítom a jelenlegivel, d=különbség a jelenlegihez képest, s=forrás",
"Wiki page" => "Wiki lap",
"Click the :: option on the menu for more options." => "Kattints a menüpontok bal oldalán található szimbólumra, hogy lásd a további opciókat!",
"Please also see" => "Továbbá ajánljuk tekintsd meg a ",
"Admin->Modules" => "Admin->Modulok menüpontban",
"Blog settings" => "Blog beállítások",
"FAQs settings" => "Gyakori kérdések beállításai",
"FAQ comments" => "Gyakori kérdések megjegyzései",
"Remind passwords by email" => "Jelszóemlékeztető küldése e-mail-ben",
"Poll settings" => "Szavazás beállítások",
"Set" => "Beállít",
"Administration" => "Adminisztráció",
"Wiki quick help" => "formázási tanácsok",
"Quicklinks" => "Gyorslinkek",
"Comparing versions" => "Összehasonlítom a változatokat",
"Actual_version" => "Jelen változat",
"Diff to version" => "Különbségek ehhez a változathoz képest",
"Error: This page is being edited by another user." => "Figyelj: ezt az oldalt épp most szerkeszti már egy másik felhasználó.",
"Tiki RSS Feed Error Message" => "Tiki RSS Adagoló Hiba Üzenete",
"You need to supply information for : " => "Kérjük, adja meg a következő adatokat: ",
"Information:" => "Adatok:",
"Please" => "Kérem",
"log in" => "belépek",
"Edit information" => "Szerkesztem az adatokat",
"no description" => "nincs leírás",
"Jukebox" => "Zeneláda",
"Like pages" => "Hasonló oldalak",
"Emphasis" => "Hangsúly",
"italics" => "dőlt",
"both" => "mindkettő",
"use ...page... to separate pages" => "egy oldalon belül különböző oldalak elválasztáshoz használd:  ...page...",
"underlines text" => "aláhúzott szöveg",
"You have to create a gallery first!" => "Először hozz létre egy galériát!",
"You do not have permission to write the template" => "A sablonok szerkesztéséhez több jogosultságra van szükséged.",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "This script cannot be called directly" => "This script cannot be called directly",
// "Re:" => "Re:",
// "The text in RED is" => "The text in RED is",
// "character(s) too long - please edit it." => "character(s) too long - please edit it.",
// "Algeria" => "Algeria",
// "American_Samoa" => "American_Samoa",
// "Angola" => "Angola",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Bermuda" => "Bermuda",
// "Bolivia" => "Bolivia",
// "Brazil" => "Brazil",
// "Brunei" => "Brunei",
// "Canada" => "Canada",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Colombia" => "Colombia",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Dominican_Republic" => "Dominican_Republic",
// "Ecuador" => "Ecuador",
// "El_Salvador" => "El_Salvador",
// "Estonia" => "Estonia",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "French_Polynesia" => "French_Polynesia",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Haiti" => "Haiti",
// "Honduras" => "Honduras",
// "Chile" => "Chile",
// "Iceland" => "Iceland",
// "India" => "India",
// "Ivory_Coast" => "Ivory_Coast",
// "Jamaica" => "Jamaica",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Latvia" => "Latvia",
// "Luxemburg" => "Luxemburg",
// "Malawi" => "Malawi",
// "Marshall_Islands" => "Marshall_Islands",
// "Mauritius" => "Mauritius",
// "Mozambique" => "Mozambique",
// "Nauru" => "Nauru",
// "New_Caledonia" => "New_Caledonia",
// "Nicaragua" => "Nicaragua",
// "Niue" => "Niue",
// "Pakistan" => "Pakistan",
// "Panama" => "Panama",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Phillippines" => "Phillippines",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto_Rico" => "Puerto_Rico",
// "Quatar" => "Quatar",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Samoa" => "Samoa",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon_Islands" => "Solomon_Islands",
// "Somalia" => "Somalia",
// "South_Africa" => "South_Africa",
// "South_Korea" => "South_Korea",
// "Spain" => "Spain",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Surinam" => "Surinam",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Taiwan" => "Taiwan",
// "Thailand" => "Thailand",
// "Tonga" => "Tonga",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Turkey" => "Turkey",
// "Tuvalu" => "Tuvalu",
// "Ukraine" => "Ukraine",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_States" => "United_States",
// "Uruguay" => "Uruguay",
// "Vanuatu" => "Vanuatu",
// "Venezuela" => "Venezuela",
// "Wales" => "Wales",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Bulgaria" => "Bulgaria",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "English British" => "English British",
// "Finnish" => "Finnish",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Pijin Solomon" => "Pijin Solomon",
// "Serbian Latin" => "Serbian Latin",
// "Tuvaluan" => "Tuvaluan",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: cannot execute automatic activity \$activityId" => "Fatal error: cannot execute automatic activity \$activityId",
// "Fatal error: setting next activity to an unexisting activity" => "Fatal error: setting next activity to an unexisting activity",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Fatal error: trying to send an instance to an activity but no transition found" => "Fatal error: trying to send an instance to an activity but no transition found",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// "Process does not have a start activity" => "Process does not have a start activity",
// "Process does not have exactly one end activity" => "Process does not have exactly one end activity",
// "End activity is not reachable from start activity" => "End activity is not reachable from start activity",
// "Activity" => "Activity",
// " is interactive but has no role assigned" => " is interactive but has no role assigned",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is standalone but has transitions" => " is standalone but has transitions",
// "Role" => "Role",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Process %d has been activated" => "Process %d has been activated",
// "Process %d has been deactivated" => "Process %d has been deactivated",
// "Process %s %s imported" => "Process %s %s imported",
// "Process %s removed" => "Process %s removed",
// "Process %s has been updated" => "Process %s has been updated",
// "Process %s has been created" => "Process %s has been created",
// "Administration:" => "Administration:",
// "continued" => "continued",
// "new item in tracker" => "new item in tracker",
// "new subscriptions" => "new subscriptions",
// "blog" => "blog",
// "file gallery" => "file gallery",
// "image gallery" => "image gallery",
// "newsletter" => "newsletter",
// "survey" => "survey",
// "wiki page" => "wiki page",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "Anonymous" => "Anonymous",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "Line:" => "Line:",
// "Lines:" => "Lines:",
// "Newsletter subscription information at " => "Newsletter subscription information at ",
// "There was a problem with your upload." => "There was a problem with your upload.",
// "The file you are trying to upload is too big." => "The file you are trying to upload is too big.",
// "The file you are trying to upload was only partially uploaded." => "The file you are trying to upload was only partially uploaded.",
// "You must select a file for upload." => "You must select a file for upload.",
// "Blog" => "Blog",
// "Continue" => "Continue",
// "Invalid imagename (using filters for filenames)" => "Invalid imagename (using filters for filenames)",
// "Upload was not successful" => "Upload was not successful",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "unknown" => "unknown",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "NONE" => "NONE",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "%s is an empty archive file" => "%s is an empty archive file",
// "Invalid remote file on url %s" => "Invalid remote file on url %s",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "This poll is closed." => "This poll is closed.",
// "Forums last posts" => "Forums last posts",
// "Wiki last files" => "Wiki last files",
// "Wiki top articles" => "Wiki top articles",
// "Most active blogs" => "Most active blogs",
// "Blogs last posts" => "Blogs last posts",
// "Top article authors" => "Top article authors",
// "tikiwiki logo" => "tikiwiki logo",
// "See other user's profile" => "See other user's profile",
// "Have your profile seen" => "Have your profile seen",
// "Make friends" => "Make friends",
// "Receive message" => "Receive message",
// "Read an article" => "Read an article",
// "Publish an article" => "Publish an article",
// "Have your article read" => "Have your article read",
// "Create new file gallery" => "Create new file gallery",
// "Upload new file to gallery" => "Upload new file to gallery",
// "Download other user's file" => "Download other user's file",
// "Have your file downloaded" => "Have your file downloaded",
// "Create a new image gallery" => "Create a new image gallery",
// "Upload new image to gallery" => "Upload new image to gallery",
// "See other user's gallery" => "See other user's gallery",
// "See other user's image" => "See other user's image",
// "Have your gallery seen by other user" => "Have your gallery seen by other user",
// "Have your image seen" => "Have your image seen",
// "Create new blog" => "Create new blog",
// "Post in a blog" => "Post in a blog",
// "Read other user's blog" => "Read other user's blog",
// "Have your blog read" => "Have your blog read",
// "Create a new wiki page" => "Create a new wiki page",
// "Edit an existing page" => "Edit an existing page",
// "Trackeritem" => "Trackeritem",
// "Wiki" => "Wiki",
// "Directory category" => "Directory category",
// "FAQ" => "FAQ",
// "Blog post" => "Blog post",
// "Tracker item" => "Tracker item",
// "Link" => "Link",
// "The text is" => "The text is",
// "Text cut here" => "Text cut here",
// "Task" => "Task",
// "Start date:" => "Start date:",
// "End date:" => "End date:",
// "%A %d of %B, %Y" => "%A %d of %B, %Y",
// "%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d of %B, %Y[%H:%M:%S %Z]",
// "%H:%M:%S %Z" => "%H:%M:%S %Z",
// "%a %d of %b, %Y" => "%a %d of %b, %Y",
// "%a %d of %b, %Y[%H:%M %Z]" => "%a %d of %b, %Y[%H:%M %Z]",
// "%H:%M %Z" => "%H:%M %Z",
// "Friend" => "Friend",
// "km" => "km",
// "Last seen on " => "Last seen on ",
// "(idle for %s seconds)" => "(idle for %s seconds)",
// "User information - Click for more info" => "User information - Click for more info",
// "More info about \$other_user" => "More info about \$other_user",
// "(idle for \$idletime seconds)" => "(idle for \$idletime seconds)",
// "created from structure" => "created from structure",
// "Use this tree to copy the structure" => "Use this tree to copy the structure",
// "An error occured in a database query!" => "An error occured in a database query!",
// "wiki" => "wiki",
// "img-g" => "img-g",
// "file-g" => "file-g",
// "quizzes" => "quizzes",
// "arts" => "arts",
// "Click to edit dynamic variable" => "Click to edit dynamic variable",
// "Update variables" => "Update variables",
// "Altering database table failed" => "Altering database table failed",
// "%d points" => "%d points",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Create page:" => "Create page:",
// "index" => "index",
// "show" => "show",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "Status:" => "Status:",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item" => "Item",
// "Item creation" => "Item creation",
// "Tracker was modified at " => "Tracker was modified at ",
// "field is not numeric" => "field is not numeric",
// "text field" => "text field",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "textarea" => "textarea",
// "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode." => "Textarea options: quicktags,width,height,max,listmax - Use Quicktags is 1 or 0, widthis indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax isthe maximum number of characters that are displayed in list mode.",
// "checkbox" => "checkbox",
// "Checkbox options: put 1 if you need that next field is on the same row." => "Checkbox options: put 1 if you need that next field is on the same row.",
// "numeric field" => "numeric field",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "drop down" => "drop down",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "user selector" => "user selector",
// "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login.",
// "group selector" => "group selector",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "country selector" => "country selector",
// "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag" => "Country Selector options: 1|2 where 1 show only country name and 2 show only country flag. By default show both country name and flag",
// "date and time" => "date and time",
// "jscalendar" => "jscalendar",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "header" => "header",
// "Category options: parentId" => "Category options: parentId",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing" => "Item Link options: trackerId,fieldId,linkToItem links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "email" => "email",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "system" => "system",
// "pending" => "pending",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "(AT)" => "(AT)",
// "(DOT)" => "(DOT)",
// "Include all post in a blog" => "Include all post in a blog",
// "Include a page" => "Include a page",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "one data per line" => "one data per line",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Include an article" => "Include an article",
// "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName,type=>type,categId=>Category parent ID)}{ARTICLES} Insert articles into a wikipage",
// "no such attachment on this page" => "no such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link.",
// "Displays the user Avatar" => "Displays the user Avatar",
// "List all pages which link to specific pages" => "List all pages which link to specific pages",
// "No pages links to" => "No pages links to",
// "One page links to" => "One page links to",
// "pages link to" => "pages link to",
// "Insert theme styled box on wiki page" => "Insert theme styled box on wiki page",
// "text" => "text",
// "Insert list of items for the current/given category into wiki page" => "Insert list of items for the current/given category into wiki page",
// "Categories are disabled" => "Categories are disabled",
// "Display Tiki objects that have not been categorized" => "Display Tiki objects that have not been categorized",
// "Insert the full category path for each category that this wiki page belongs to" => "Insert the full category path for each category that this wiki page belongs to",
// "Centers the plugin content in the wiki page" => "Centers the plugin content in the wiki page",
// "Displays a snippet of code" => "Displays a snippet of code",
// "code" => "code",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Insert copyright notices" => "Insert copyright notices",
// "and" => "and",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Creates a definition list" => "Creates a definition list",
// "one definition per line" => "one definition per line",
// "Displays the data using the Tikiwiki odd/even table style" => "Displays the data using the Tikiwiki odd/even table style",
// "cells" => "cells",
// "heads and cells separated by ~|~" => "heads and cells separated by ~|~",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "Displays a map" => "Displays a map",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Provides a list of plugins on this wiki." => "Provides a list of plugins on this wiki.",
// "No arguments indicated" => "No arguments indicated",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage",
// "Automatically creates a link to the appropriate SourceForge object" => "Automatically creates a link to the appropriate SourceForge object",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "List wiki pages" => "List wiki pages",
// "Last modified by" => "Last modified by",
// "Clickable Skype link" => "Clickable Skype link",
// "Split a page into rows and columns" => "Split a page into rows and columns",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "Run a sql query" => "Run a sql query",
// "sql query" => "sql query",
// "Displays text in subscript." => "Displays text in subscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "No pages found for title search" => "No pages found for title search",
// "One page found for title search" => "One page found for title search",
// " pages found for title search" => " pages found for title search",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "All fields must be from the same tracker" => "All fields must be from the same tracker",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "missing tracker ID for plugin TRACKER" => "missing tracker ID for plugin TRACKER",
// "missing fields list" => "missing fields list",
// "Error in tracker ID" => "Error in tracker ID",
// "No field indicated" => "No field indicated",
// "Links to a translated content" => "Links to a translated content",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored.<br />" => "A wildcard pattern of originating pages to be ignored.<br />",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated.<br />" => "The character, by which ignored patterns are separated.<br />",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list.<br />" => "Whether to include external wikis in the list.<br />",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column.<br />" => "Collect either originating or wanted pages in a cell and display them in the second column.<br />",
// "Switch-on debug output with details about the items.<br />" => "Switch-on debug output with details about the items.<br />",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.<br />",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.<br />",
// "A custom filter for wanted pages to be listed (only used when level=>custom).<br />" => "A custom filter for wanted pages to be listed (only used when level=>custom).<br />",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "External Wiki" => "External Wiki",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Plugin " => "Plugin ",
// "Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Sent box is full. Archive or delete some sent messages first if you want to send more messages.",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "User %s can not receive messages, mailbox is full" => "User %s can not receive messages, mailbox is full",
// "User %s can not receive messages" => "User %s can not receive messages",
// "Invalid user: %s" => "Invalid user: %s",
// "Archive is full. Delete some messages from archive first." => "Archive is full. Delete some messages from archive first.",
// "move %s in %s" => "move %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "Changes" => "Changes",
// "Changes since" => "Changes since",
// "new posts" => "new posts",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "no such file" => "no such file",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Fatal error" => "Fatal error",
// " on " => " on ",
// "RSS feed" => "RSS feed",
// "Edit blog" => "Edit blog",
// "monitor this blog" => "monitor this blog",
// "stop monitoring this blog" => "stop monitoring this blog",
// "Activity=" => "Activity=",
// "attachment" => "attachment",
// "new reply" => "new reply",
// "Editing reply" => "Editing reply",
// "Reply to the selected post" => "Reply to the selected post",
// "Post new message" => "Post new message",
// "Comment on the selected post" => "Comment on the selected post",
// "Reply to parent post" => "Reply to parent post",
// "Rating" => "Rating",
// "Syntax" => "Syntax",
// "Page generation debugging log" => "Page generation debugging log",
// "Features state" => "Features state",
// "features matched" => "features matched",
// "Watchlist" => "Watchlist",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "Create this page" => "Create this page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Last update from CVS" => "Last update from CVS",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Information" => "Information",
// "Hi {\$mail_user} has sent you this link:" => "Hi {\$mail_user} has sent you this link:",
// "Blog post:" => "Blog post:",
// "at:" => "at:",
// "Somebody or you tried to subscribe this email address at our site:" => "Somebody or you tried to subscribe this email address at our site:",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in instructions" => "Tiki mail-in instructions",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "Hi," => "Hi,",
// "A new message was posted to you at {\$mail_machine}" => "A new message was posted to you at {\$mail_machine}",
// "New message arrived from %s" => "New message arrived from %s",
// "Hi" => "Hi",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "has requested an account on" => "has requested an account on",
// "To validate that account, please follow the link:" => "To validate that account, please follow the link:",
// "best regards" => "best regards",
// "your Tikiwiki" => "your Tikiwiki",
// "Tiki User Registration Request" => "Tiki User Registration Request",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "The user" => "The user",
// "registered at your site" => "registered at your site",
// "New user registration" => "New user registration",
// "Bye bye!" => "Bye bye!",
// "This email address has been removed to the list of subscriptors of:" => "This email address has been removed to the list of subscriptors of:",
// "Newsletter:" => "Newsletter:",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Since this is your registered email address we inform that the password for this account is" => "Since this is your registered email address we inform that the password for this account is",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-remind_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "Your Tiki account information for %s" => "Your Tiki account information for %s",
// "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}",
// "You can edit the submission following this link:" => "You can edit the submission following this link:",
// "New article submitted at %s" => "New article submitted at %s",
// "View the tracker item at:" => "View the tracker item at:",
// "Tracker was modified at" => "Tracker was modified at",
// "you or someone registered this email address at" => "you or someone registered this email address at",
// "If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "If you want to be a registered user in this site you will have to use the following link to login for the first time:",
// "Your account request have been stored and will be activated by the admin as soon as possible." => "Your account request have been stored and will be activated by the admin as soon as possible.",
// "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the article at:" => "View the article at:",
// "If you don't want to receive these notifications follow this link:" => "If you don't want to receive these notifications follow this link:",
// "New article post at %s" => "New article post at %s",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "View the blog at:" => "View the blog at:",
// "New blog post at %s" => "New blog post at %s",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "Removed by" => "Removed by",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link:" => "You can view the updated map following this link:",
// "You can edit the map following this link:" => "You can edit the map following this link:",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Comment:" => "Comment:",
// "You can view the page by following this link:" => "You can view the page by following this link:",
// "You can view a diff back to the previous version by following this link:" => "You can view a diff back to the previous version by following this link:",
// "The changes in this version follow below, followed after by the current full page text." => "The changes in this version follow below, followed after by the current full page text.",
// "-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lines: {\$oldd} changed to +Lines: {\$newd}",
// "The new page content follows below." => "The new page content follows below.",
// "Wiki page %s changed" => "Wiki page %s changed",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for you registration. You may log in now." => "Thank you for you registration. You may log in now.",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Scale" => "Scale",
// "Zoom out x4" => "Zoom out x4",
// "Zoom out x3" => "Zoom out x3",
// "Zoom out x2" => "Zoom out x2",
// "Query" => "Query",
// "Pan" => "Pan",
// "Zoom in x2" => "Zoom in x2",
// "Zoom in x3" => "Zoom in x3",
// "Zoom in x4" => "Zoom in x4",
// "Redraw" => "Redraw",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "Go" => "Go",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Click on the map or click redraw" => "Click on the map or click redraw",
// "Last modification date" => "Last modification date",
// "Overview" => "Overview",
// "Layer Manager" => "Layer Manager",
// "Layer" => "Layer",
// "On" => "On",
// "Label" => "Label",
// "Download" => "Download",
// "Download Layer" => "Download Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "you have requested to download the layer:" => "you have requested to download the layer:",
// "from\nthe mapfile:" => "from\nthe mapfile:",
// "Here are the files to download, do not forget to rename them:" => "Here are the files to download, do not forget to rename them:",
// "Mapfile" => "Mapfile",
// "hits last 7 days" => "hits last 7 days",
// "monitor this map" => "monitor this map",
// "stop monitoring this map" => "stop monitoring this map",
// "Create a new mapfile" => "Create a new mapfile",
// "Mapfile listing" => "Mapfile listing",
// "Reload" => "Reload",
// "You can view this map in your browser using" => "You can view this map in your browser using",
// "Mapfile History" => "Mapfile History",
// "Comparing version {\$old.version} with version {\$new.version}" => "Comparing version {\$old.version} with version {\$new.version}",
// "Version:" => "Version:",
// "Legend:" => "Legend:",
// "v=view" => "v=view",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Side-by-side diff" => "Side-by-side diff",
// "Full side-by-side diff" => "Full side-by-side diff",
// "Unified diff" => "Unified diff",
// "Side-by-side view" => "Side-by-side view",
// "Ip" => "Ip",
// "older version" => "older version",
// "back to" => "back to",
// "Upload From Disk:" => "Upload From Disk:",
// "Upload Files" => "Upload Files",
// "Bytes maximum" => "Bytes maximum",
// "Create Directory:" => "Create Directory:",
// "Create" => "Create",
// "index file (.shp):" => "index file (.shp):",
// "files to index (regexp):" => "files to index (regexp):",
// "Message Archive" => "Message Archive",
// "messages" => "messages",
// "Archive is full!" => "Archive is full!",
// "1" => "1",
// "2" => "2",
// "3" => "3",
// "4" => "4",
// "5" => "5",
// "Message Broadcast" => "Message Broadcast",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "CC" => "CC",
// "BCC" => "BCC",
// "No messages to download" => "No messages to download",
// "Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox is full! Delete or archive some messages if you want to receive more messages.",
// "Replied" => "Replied",
// "Not replied" => "Not replied",
// "receiver" => "receiver",
// "replied" => "replied",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "Hide module contents" => "Hide module contents",
// "Move module to opposite side" => "Move module to opposite side",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module?" => "Are you sure you want to unassign this module?",
// "QuickTags" => "QuickTags",
// "Chat" => "Chat",
// "Dynamic content" => "Dynamic content",
// "Mail-in" => "Mail-in",
// "Import PHPWiki Dump" => "Import PHPWiki Dump",
// "phpinfo" => "phpinfo",
// "Security Admin" => "Security Admin",
// "Syntax highlighting" => "Syntax highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number !" => "You forgot your Google ad_client number !",
// "MyMenu" => "MyMenu",
// "Webmail" => "Webmail",
// "WfMenu" => "WfMenu",
// "FriendsMenu" => "FriendsMenu",
// "User list" => "User list",
// "WikiMenu" => "WikiMenu",
// "Dump" => "Dump",
// "GalMenu" => "GalMenu",
// "ForMenu" => "ForMenu",
// "DirMenu" => "DirMenu",
// "FileGalMenu" => "FileGalMenu",
// "List FAQs" => "List FAQs",
// "Layer management" => "Layer management",
// "QuizMenu" => "QuizMenu",
// "ShtMenu" => "ShtMenu",
// "TrkMenu" => "TrkMenu",
// "SrvMenu" => "SrvMenu",
// "Events" => "Events",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "EphMenu" => "EphMenu",
// "ChartMenu" => "ChartMenu",
// "AdmMenu" => "AdmMenu",
// "Debugger console" => "Debugger console",
// "DSN" => "DSN",
// "Mods Admin" => "Mods Admin",
// "UsrMenu" => "UsrMenu",
// "Click the :: options in the Menu for more options." => "Click the :: options in the Menu for more options.",
// "Please, also see" => "Please, also see",
// "Note 1:" => "Note 1:",
// "as well as assign or edit many others." => "as well as assign or edit many others.",
// "Note 2:" => "Note 2:",
// "The menu module installed by default is named" => "The menu module installed by default is named",
// "it is a \"custom module\" which includes menu ID " => "it is a \"custom module\" which includes menu ID ",
// "That menu is stored in database and it can be edited from " => "That menu is stored in database and it can be edited from ",
// "Do not mix this with the original <em>application_menu</em> module" => "Do not mix this with the original <em>application_menu</em> module",
// "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"",
// "November" => "November",
// "December" => "December",
// "Filter" => "Filter",
// "Last `\$module_rows` Sites" => "Last `\$module_rows` Sites",
// "Top \$module_rows Sites" => "Top \$module_rows Sites",
// "Current events" => "Current events",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Last `\$module_rows` forum posts" => "Last `\$module_rows` forum posts",
// "Last forum posts" => "Last forum posts",
// "Last `\$module_rows` forum topics" => "Last `\$module_rows` forum topics",
// "Last `\$module_rows` actions" => "Last `\$module_rows` actions",
// "Last actions" => "Last actions",
// "Last `\$module_rows` articles" => "Last `\$module_rows` articles",
// "Last articles" => "Last articles",
// "Last `\$module_rows` blog posts" => "Last `\$module_rows` blog posts",
// "Last `\$module_rows` Created blogs" => "Last `\$module_rows` Created blogs",
// "Last `\$module_rows` Created FAQs" => "Last `\$module_rows` Created FAQs",
// "Last `\$module_rows` Created Quizzes" => "Last `\$module_rows` Created Quizzes",
// "Last `\$module_rows` modified file galleries" => "Last `\$module_rows` modified file galleries",
// "Last `\$module_rows` Files" => "Last `\$module_rows` Files",
// "Last `\$module_rows` galleries" => "Last `\$module_rows` galleries",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "Last Images" => "Last Images",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "Last modifed events" => "Last modifed events",
// "Last `\$module_rows` changes" => "Last `\$module_rows` changes",
// "Last `\$module_rows` Modified Items" => "Last `\$module_rows` Modified Items",
// "Last `\$module_rows` Modified blogs" => "Last `\$module_rows` Modified blogs",
// "Last `\$module_rows` submissions" => "Last `\$module_rows` submissions",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` Items" => "Last `\$module_rows` Items",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "Last visitors" => "Last visitors",
// "Open operator console" => "Open operator console",
// "Login through CAS" => "Login through CAS",
// "Login as admin" => "Login as admin",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "standard" => "standard",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "Tiki Logo" => "Tiki Logo",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "Your email could not be validated; make sure you email is correct and click register below." => "Your email could not be validated; make sure you email is correct and click register below.",
// "Random Image" => "Random Image",
// "Email" => "Email",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Articles RSS" => "Articles RSS",
// "Image Galleries RSS" => "Image Galleries RSS",
// "File Galleries RSS" => "File Galleries RSS",
// "Forums RSS" => "Forums RSS",
// "Maps RSS" => "Maps RSS",
// "Calendars" => "Calendars",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "Top `\$module_rows` articles" => "Top `\$module_rows` articles",
// "Top `\$module_rows` File Galleries" => "Top `\$module_rows` File Galleries",
// "Top `\$module_rows` files" => "Top `\$module_rows` files",
// "Top files" => "Top files",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` games" => "Top `\$module_rows` games",
// "Top `\$module_rows` galleries" => "Top `\$module_rows` galleries",
// "Top `\$module_rows` Images" => "Top `\$module_rows` Images",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Top `\$module_rows` Pages" => "Top `\$module_rows` Pages",
// "Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzes",
// "Most `\$module_rows` visited blogs" => "Most `\$module_rows` visited blogs",
// "Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` Visited FAQs",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "done" => "done",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "User informations" => "User informations",
// "Group informations" => "Group informations",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "Whats related" => "Whats related",
// "on host" => "on host",
// "Last `\$module_rows` wiki comments" => "Last `\$module_rows` wiki comments",
// "Last wiki comments" => "Last wiki comments",
// " on page " => " on page ",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
// "Sent editions" => "Sent editions",
// "sent" => "sent",
// "use" => "use",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "page id" => "page id",
// "cached" => "cached",
// "pdf" => "pdf",
// "Parent page" => "Parent page",
// "Child" => "Child",
// "based on work by" => "based on work by",
// "To edit the copyright notices" => "To edit the copyright notices",
// "The content on this page is licensed under the terms of the" => "The content on this page is licensed under the terms of the",
// "This newsletter will be sent to {\$subscribers} email addresses." => "This newsletter will be sent to {\$subscribers} email addresses.",
// "Click" => "Click",
// "chat" => "chat",
// "dump" => "dump",
// "logout" => "logout",
// "Edit Summary" => "Edit Summary",
// "Copyright" => "Copyright",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "No attachments for this page" => "No attachments for this page",
// "List pages where I am a creator" => "List pages where I am a creator",
// "by creator" => "by creator",
// "List pages where I am a modificator" => "List pages where I am a modificator",
// "by modificator" => "by modificator",
// "RSS Trackers" => "RSS Trackers",
// "left/right" => "left/right",
// "Unassign module" => "Unassign module",
// "debugger console" => "debugger console",
// "Edit mapfiles" => "Edit mapfiles",
// "switch" => "switch",
// "on:" => "on:",
// "Article image" => "Article image",
// "Topic image" => "Topic image",
// "Location : " => "Location : ",
// "Sort posts by:" => "Sort posts by:",
// "pages" => "pages",
// "Permalink" => "Permalink",
// "referenced by" => "referenced by",
// "references" => "references",
// "view comments" => "view comments",
// "email this post" => "email this post",
// "Viewing blog post" => "Viewing blog post",
// "Return to blog" => "Return to blog",
// "Trackback pings" => "Trackback pings",
// "URI" => "URI",
// "Blog name" => "Blog name",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "Welcome to" => "Welcome to",
// "Click here to create it" => "Click here to create it",
// "Enlarge area height" => "Enlarge area height",
// "Reduce area height" => "Reduce area height",
// "RSS" => "RSS",
// "Meta Tags" => "Meta Tags",
// "Site Identity" => "Site Identity",
// "Site Calendar" => "Site Calendar",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "i18n" => "i18n",
// "Tip" => "Tip",
// "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or",
// "ok" => "ok",
// "Blog features" => "Blog features",
// "Post level trackback pings" => "Post level trackback pings",
// "Not Installed" => "Not Installed",
// "Creation date" => "Creation date",
// "Last modification time" => "Last modification time",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Group calendar sticky popup" => "Group calendar sticky popup",
// "Group calendar item view tab" => "Group calendar item view tab",
// "Calendar manual selection of time/date" => "Calendar manual selection of time/date",
// "JsCalendar" => "JsCalendar",
// "Look under \"Articles\" on the application menu for links to" => "Look under \"Articles\" on the application menu for links to",
// "Print article" => "Print article",
// "Settings for page articles home" => "Settings for page articles home",
// "Fields to display on page" => "Fields to display on page",
// "Publish Date" => "Publish Date",
// "Expire Date" => "Expire Date",
// "User identity features" => "User identity features",
// "Show user's info on mouseover" => "Show user's info on mouseover",
// "Picture" => "Picture",
// "Number of friends" => "Number of friends",
// "E-mail" => "E-mail",
// "Distance" => "Distance",
// "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or",
// "enable cool sites" => "enable cool sites",
// "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or",
// "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site." => "Please see the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://doc.tikiwiki.org/tiki-index.php?page=Features\">evaluation of each feature</a> on Tiki's developer site.",
// "Featured Help" => "Featured Help",
// "Live Support" => "Live Support",
// "tikiwiki.org help" => "tikiwiki.org help",
// "Best language" => "Best language",
// "Show Category Path" => "Show Category Path",
// "Show Babelfish Translation URLs" => "Show Babelfish Translation URLs",
// "Show Category Objects" => "Show Category Objects",
// "Show Babelfish Translation Logo" => "Show Babelfish Translation Logo",
// "Show Module Controls" => "Show Module Controls",
// "Template Viewing" => "Template Viewing",
// "Tiki Template Viewing" => "Tiki Template Viewing",
// "PHPLayers" => "PHPLayers",
// "PhpLayers Dynamic menus" => "PhpLayers Dynamic menus",
// "Use Tabs" => "Use Tabs",
// "Tiki Sheet" => "Tiki Sheet",
// "Site Logo and Identity" => "Site Logo and Identity",
// "Mobile" => "Mobile",
// "Google Maps" => "Google Maps",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Edit Templates" => "Edit Templates",
// "Hotwords in New Windows" => "Hotwords in New Windows",
// "Custom Home" => "Custom Home",
// "HTML Pages" => "HTML Pages",
// "Dynamic Content System" => "Dynamic Content System",
// "Allow Smileys" => "Allow Smileys",
// "AutoLinks" => "AutoLinks",
// "Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;>&rdquo; for quoting",
// "Banning System" => "Banning System",
// "XMLRPC API" => "XMLRPC API",
// "Referer Stats" => "Referer Stats",
// "Contact Us" => "Contact Us",
// "Contact Us (Anonymous)" => "Contact Us (Anonymous)",
// "Redirect On Error" => "Redirect On Error",
// "User Preferences Screen" => "User Preferences Screen",
// "Users can Configure Modules" => "Users can Configure Modules",
// "always" => "always",
// "module decides" => "module decides",
// "never" => "never",
// "Users can Shade Modules" => "Users can Shade Modules",
// "User Watches Translations" => "User Watches Translations",
// "User Notepad" => "User Notepad",
// "Users can Flip Columns" => "Users can Flip Columns",
// "user decides" => "user decides",
// "Admin layout per section" => "Admin layout per section",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "To add/remove file galleries, go to \"File Galleries\" on the application menu, or",
// "Home Gallery" => "Home Gallery",
// "Allow same file to be uploaded more than once" => "Allow same file to be uploaded more than once",
// "Storing files in a directory" => "Storing files in a directory",
// "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "If you decide to store files in a directory you must ensure that the user cannot access directly to the directory.",
// "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>",
// "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/",
// "Change configuration" => "Change configuration",
// "File galleries search indexing" => "File galleries search indexing",
// "Leave command blank to delete handler" => "Leave command blank to delete handler",
// "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)",
// "Enable auto indexing on file upload or change" => "Enable auto indexing on file upload or change",
// "MIME Type" => "MIME Type",
// "System command" => "System command",
// "Reindex all files for search" => "Reindex all files for search",
// "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or",
// "Home Forum" => "Home Forum",
// "Forums features" => "Forums features",
// "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "To add/remove image galleries, go to \"Image Galleries\" on the application menu, or",
// "You can upload images of a size of " => "You can upload images of a size of ",
// "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value",
// "Uses Slideshow" => "Uses Slideshow",
// "Directory Batch Loading" => "Directory Batch Loading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols",
// "Enable directory batch loading" => "Enable directory batch loading",
// "Batch loading directory" => "Batch loading directory",
// "Enable cache images to all galleries" => "Enable cache images to all galleries",
// "Images cache directory" => "Images cache directory",
// "Exterminator" => "Exterminator",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Change style only" => "Change style only",
// "Use group homepages" => "Use group homepages",
// "Go to group homepage only if login from default homepage" => "Go to group homepage only if login from default homepage",
// "Detect browser language" => "Detect browser language",
// "OS" => "OS",
// "Unix" => "Unix",
// "Windows" => "Windows",
// "PHP error reporting level for non-admin:" => "PHP error reporting level for non-admin:",
// "No error reporting" => "No error reporting",
// "Report all PHP errors" => "Report all PHP errors",
// "Report all errors except notices" => "Report all errors except notices",
// "Report PHP errors only for admin" => "Report PHP errors only for admin",
// "Default charset for sending mail:" => "Default charset for sending mail:",
// "Mail end of line:" => "Mail end of line:",
// "(standard)" => "(standard)",
// "(some Unix MTA)" => "(some Unix MTA)",
// "Disallow access to the site (except for those with permission)" => "Disallow access to the site (except for those with permission)",
// "Message to display when site is closed" => "Message to display when site is closed",
// "Disallow access when load is above the threshold (except for those with permission)" => "Disallow access when load is above the threshold (except for those with permission)",
// "Max average server load threshold in the last minute" => "Max average server load threshold in the last minute",
// "Message to display when server is too busy" => "Message to display when server is too busy",
// "Use direct pagination links" => "Use direct pagination links",
// "output compression is active." => "output compression is active.",
// "compression is handled by" => "compression is handled by",
// "Hide anonymous-only modules from registered users" => "Hide anonymous-only modules from registered users",
// "HTTPS Server" => "HTTPS Server",
// "Automatic (uses HTTPS variable)" => "Automatic (uses HTTPS variable)",
// "Allow anonymous users to \"Contact Us\"" => "Allow anonymous users to \"Contact Us\"",
// "Store session data in database" => "Store session data in database",
// "Session lifetime in minutes" => "Session lifetime in minutes",
// "Use proxy" => "Use proxy",
// "Proxy Host" => "Proxy Host",
// "Proxy port" => "Proxy port",
// "Help URL" => "Help URL",
// "Please expect not found help-pages with the default-URL." => "Please expect not found help-pages with the default-URL.",
// "Any help with the documentation is welcome." => "Any help with the documentation is welcome.",
// "Favicon icon file name:" => "Favicon icon file name:",
// "Favicon icon MIME type:" => "Favicon icon MIME type:",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Locations separator" => "Locations separator",
// "Register this site at tikiwiki.org" => "Register this site at tikiwiki.org",
// "Click here for more details." => "Click here for more details.",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Internationalization" => "Internationalization",
// "I18n setup" => "I18n setup",
// "Best Language" => "Best Language",
// "Restrict available languages" => "Restrict available languages",
// "Edit or ex/import Languages" => "Edit or ex/import Languages",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// " as master" => " as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "port" => "port",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "IP" => "IP",
// "Contact" => "Contact",
// "New" => "New",
// "Enable/disable Tiki features in " => "Enable/disable Tiki features in ",
// "Admin->Features" => "Admin->Features",
// ", but configure them elsewhere" => ", but configure them elsewhere",
// "Users &amp; groups" => "Users &amp; groups",
// "Tiki and PAM" => "Tiki and PAM",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "... but need admin validation" => "... but need admin validation",
// "must be turned on and notification is sent to the admin's" => "must be turned on and notification is sent to the admin's",
// "inter-user message inbox" => "inter-user message inbox",
// "Create a group for each user <br />(with the same\nname as the user)" => "Create a group for each user <br />(with the same\nname as the user)",
// "Use tracker for more user information" => "Use tracker for more user information",
// "Use tracker for more group information" => "Use tracker for more group information",
// " - Php GD library required" => " - Php GD library required",
// "Validate email address (may not work)" => "Validate email address (may not work)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email",
// "Reg users can change password" => "Reg users can change password",
// "Restrict available themes" => "Restrict available themes",
// "Available styles:" => "Available styles:",
// "Maximum mailbox size (messages, 0=unlimited)" => "Maximum mailbox size (messages, 0=unlimited)",
// "Maximum mail archive size (messages, 0=unlimited)" => "Maximum mail archive size (messages, 0=unlimited)",
// "Maximum sent box size (messages, 0=unlimited)" => "Maximum sent box size (messages, 0=unlimited)",
// "HTTP port" => "HTTP port",
// "HTTPS port" => "HTTPS port",
// "year" => "year",
// "Remember me name" => "Remember me name",
// "Remember me domain" => "Remember me domain",
// "Remember me path" => "Remember me path",
// "Protect against CSRF with a confirmation step" => "Protect against CSRF with a confirmation step",
// "Protect against CSRF with a ticket" => "Protect against CSRF with a ticket",
// "Highlight Group" => "Highlight Group",
// "choose a group ..." => "choose a group ...",
// "PEAR::Auth" => "PEAR::Auth",
// "LDAP" => "LDAP",
// "Auth Type" => "Auth Type",
// "IMAP/POP3/LDAP Host" => "IMAP/POP3/LDAP Host",
// "IMAP/POP3/LDAP Port" => "IMAP/POP3/LDAP Port",
// "IMAP/POP3 BaseDSN" => "IMAP/POP3 BaseDSN",
// "LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(if set, this will override the Host and Port below)",
// "LDAP Scope" => "LDAP Scope",
// "LDAP Base DN" => "LDAP Base DN",
// "LDAP User DN" => "LDAP User DN",
// "LDAP User Attribute" => "LDAP User Attribute",
// "LDAP User OC" => "LDAP User OC",
// "LDAP Group DN" => "LDAP Group DN",
// "LDAP Group Attribute" => "LDAP Group Attribute",
// "LDAP Group OC" => "LDAP Group OC",
// "LDAP Member Attribute" => "LDAP Member Attribute",
// "LDAP Member Is DN" => "LDAP Member Is DN",
// "LDAP Admin User" => "LDAP Admin User",
// "LDAP Admin Pwd" => "LDAP Admin Pwd",
// "PAM" => "PAM",
// "PAM service" => "PAM service",
// "Currently unused" => "Currently unused",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/.",
// "CAS server version" => "CAS server version",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "CAS server hostname" => "CAS server hostname",
// "CAS server port" => "CAS server port",
// "CAS server path" => "CAS server path",
// "Change CAS preferences" => "Change CAS preferences",
// "full path to mapfiles" => "full path to mapfiles",
// "default mapfile" => "default mapfile",
// "Wiki Page for Help" => "Wiki Page for Help",
// "Wiki Page for Comments" => "Wiki Page for Comments",
// "Full path to gdaltindex" => "Full path to gdaltindex",
// "Full path to ogr2ogr" => "Full path to ogr2ogr",
// "Map Zone" => "Map Zone",
// "Generate User Map" => "Generate User Map",
// "<b>Item</b>" => "<b>Item</b>",
// "<b>Value</b>" => "<b>Value</b>",
// "Meta Keywords" => "Meta Keywords",
// "Meta Description" => "Meta Description",
// "Meta Author" => "Meta Author",
// "Geourl" => "Geourl",
// "geo.position" => "geo.position",
// "geo.region" => "geo.region",
// "geo.placename" => "geo.placename",
// "Robots" => "Robots",
// "meta robots" => "meta robots",
// "revisit after" => "revisit after",
// "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or",
// "Allow Anonymous Poll Voting" => "Allow Anonymous Poll Voting",
// "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or",
// "<b>Feed</b>" => "<b>Feed</b>",
// "Feed for Articles" => "Feed for Articles",
// "Feed for Weblogs" => "Feed for Weblogs",
// "Feed for Image Galleries" => "Feed for Image Galleries",
// "Feed for File Galleries" => "Feed for File Galleries",
// "Feed for the Wiki" => "Feed for the Wiki",
// "Feed for individual Image Galleries" => "Feed for individual Image Galleries",
// "Feed for individual File Galleries" => "Feed for individual File Galleries",
// "Feed for individual weblogs" => "Feed for individual weblogs",
// "Feed for forums" => "Feed for forums",
// "Feed for individual forums" => "Feed for individual forums",
// "Feed for mapfiles" => "Feed for mapfiles",
// "Feed for directories" => "Feed for directories",
// "Feed for individual tracker items" => "Feed for individual tracker items",
// "Feed for tracker items" => "Feed for tracker items",
// "Feed for upcoming calendar events" => "Feed for upcoming calendar events",
// "Default RDF version" => "Default RDF version",
// "Specification" => "Specification",
// "Documentation" => "Documentation",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Caching time :" => "Caching time :",
// "seconds (0 = cache inactive)" => "seconds (0 = cache inactive)",
// "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions.",
// "You can see users rank by score in the module users_rank, for that go to" => "You can see users rank by score in the module users_rank, for that go to",
// "Admin modules" => "Admin modules",
// "Expiration" => "Expiration",
// "Search features" => "Search features",
// "SearchStats" => "SearchStats",
// "Referer Search Highlighting" => "Referer Search Highlighting",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Performance issues" => "Performance issues",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Ignore individual object permissions" => "Ignore individual object permissions",
// "Ignore category viewing restrictions" => "Ignore category viewing restrictions",
// "Settings for searching content" => "Settings for searching content",
// "Search refresh rate" => "Search refresh rate",
// "Minimum length of search word" => "Minimum length of search word",
// "Max. number of words containing a syllable" => "Max. number of words containing a syllable",
// "Max. age in hours of syllable search cache" => "Max. age in hours of syllable search cache",
// "LRU list purging rate" => "LRU list purging rate",
// "LRU list length" => "LRU list length",
// "Don't forget: to use feature you will need to enable it on" => "Don't forget: to use feature you will need to enable it on",
// "Custom Code" => "Custom Code",
// "Custom code" => "Custom code",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Site breadcrumbs" => "Site breadcrumbs",
// "Site location bar" => "Site location bar",
// "at top of page" => "at top of page",
// "at top of center column" => "at top of center column",
// "Prefix breadcrumbs with 'Location:' label?" => "Prefix breadcrumbs with 'Location:' label?",
// "Larger font for" => "Larger font for",
// "entire location" => "entire location",
// "page name" => "page name",
// "Use page description:" => "Use page description:",
// "Site Search" => "Site Search",
// "Site search bar" => "Site search bar",
// "Site Logo" => "Site Logo",
// "Site logo" => "Site logo",
// "Site logo source" => "Site logo source",
// "Site logo background color" => "Site logo background color",
// "Site logo title (on mouse over)" => "Site logo title (on mouse over)",
// "Alt. description (e.g. for text browsers)" => "Alt. description (e.g. for text browsers)",
// "Site Ads and Banners" => "Site Ads and Banners",
// "Site ads and banners" => "Site ads and banners",
// "Site Menu" => "Site Menu",
// "Site menu bar" => "Site menu bar",
// "Note: This feature also requires phplayers to be turned on in Admin->Features" => "Note: This feature also requires phplayers to be turned on in Admin->Features",
// "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or",
// "Trackers attachments preferences" => "Trackers attachments preferences",
// "Path" => "Path",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library\nwill not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Trackers attachments" => "Trackers attachments",
// "Storage" => "Storage",
// "Change all to db" => "Change all to db",
// "Change all to file" => "Change all to file",
// "Unlimited" => "Unlimited",
// "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or",
// "Dumps" => "Dumps",
// "Generate dump" => "Generate dump",
// "Download last dump" => "Download last dump",
// "Create a Tag for the Current Wiki" => "Create a Tag for the Current Wiki",
// "Tag name" => "Tag name",
// "Restore the Wiki" => "Restore the Wiki",
// "Remove a Tag" => "Remove a Tag",
// "Wiki Comments Settings" => "Wiki Comments Settings",
// "Export Wiki Pages" => "Export Wiki Pages",
// "Export" => "Export",
// "Wiki Administration" => "Wiki Administration",
// "Manage attachment preferences" => "Manage attachment preferences",
// "Remove unused pictures" => "Remove unused pictures",
// "Wiki Home Page" => "Wiki Home Page",
// "Wiki Discussion" => "Wiki Discussion",
// "Discuss pages on forums" => "Discuss pages on forums",
// "Wiki Link Format" => "Wiki Link Format",
// "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>.",
// "complete" => "complete",
// "latin" => "latin",
// "english" => "english",
// "Wiki Page List Configuration" => "Wiki Page List Configuration",
// "Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuration",
// "Enable wiki 3D browser" => "Enable wiki 3D browser",
// "Browser width" => "Browser width",
// "Browser height" => "Browser height",
// "Navigation depth" => "Navigation depth",
// "Feed animation interval (milisecs)" => "Feed animation interval (milisecs)",
// "Existing page node color" => "Existing page node color",
// "Missing page node color" => "Missing page node color",
// "Load page on navigation" => "Load page on navigation",
// "Camera distance" => "Camera distance",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Field of view" => "Field of view",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Spring (connection) size" => "Spring (connection) size",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "HTML in Wiki Pages" => "HTML in Wiki Pages",
// "Wiki syntax used when a page contains HTML" => "Wiki syntax used when a page contains HTML",
// "full" => "full",
// "partial" => "partial",
// "Wysiwyg editor" => "Wysiwyg editor",
// "default" => "default",
// "optional" => "optional",
// "Anonymous editors must input anti-bot code" => "Anonymous editors must input anti-bot code",
// "Similar" => "Similar",
// "MultiPrint" => "MultiPrint",
// "Warn on edit conflict" => "Warn on edit conflict",
// "Edit idle timeout" => "Edit idle timeout",
// "Show page ID" => "Show page ID",
// "Cache wiki pages (global)" => "Cache wiki pages (global)",
// "Individual cache" => "Individual cache",
// "Footnotes" => "Footnotes",
// "Accept dashes and underscores in WikiWords" => "Accept dashes and underscores in WikiWords",
// "Link plural WikiWords to their singular forms" => "Link plural WikiWords to their singular forms",
// "Use Wiki paragraph formatting" => "Use Wiki paragraph formatting",
// "Automonospaced text" => "Automonospaced text",
// "|| for rows" => "|| for rows",
// "\\n for rows" => "\\n for rows",
// "Open page as structure" => "Open page as structure",
// "Use external link icons" => "Use external link icons",
// "User's Page" => "User's Page",
// "UserPage prefix" => "UserPage prefix",
// "List authors" => "List authors",
// "as Creator &amp; Last Editor" => "as Creator &amp; Last Editor",
// "Business style" => "Business style",
// "Collaborative style" => "Collaborative style",
// "no (disabled)" => "no (disabled)",
// "Print Page" => "Print Page",
// "Search and replace" => "Search and replace",
// "Wiki History" => "Wiki History",
// "unlimited" => "unlimited",
// "IP not displayed in history" => "IP not displayed in history",
// "Diff style" => "Diff style",
// "Only with last version" => "Only with last version",
// "Any 2 versions" => "Any 2 versions",
// "Wiki Watch" => "Wiki Watch",
// "Create watch for author on page creation" => "Create watch for author on page creation",
// "Enable watch events when I am the editor" => "Enable watch events when I am the editor",
// "Enable watches on comments" => "Enable watches on comments",
// "Wiki attachments preferences" => "Wiki attachments preferences",
// "Wiki attachments" => "Wiki attachments",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Spreadsheet" => "Spreadsheet",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "Look &amp; feel" => "Look &amp; feel",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Help on Banning System" => "Help on Banning System",
// "View tpl" => "View tpl",
// "x" => "x",
// "Configure/Options" => "Configure/Options",
// "ID" => "ID",
// "participants" => "participants",
// "subscription" => "subscription",
// "perso" => "perso",
// "Custom Participants" => "Custom Participants",
// "Custom Subscription List" => "Custom Subscription List",
// "Personal Calendar" => "Personal Calendar",
// "admin categories" => "admin categories",
// "admin categories tpl" => "admin categories tpl",
// "browse the category system" => "browse the category system",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Edit permissions for this category" => "Edit permissions for this category",
// "URL" => "URL",
// "admin charts template" => "admin charts template",
// "Chat Admin" => "Chat Admin",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Half a second" => "Half a second",
// "admin content templates" => "admin content templates",
// "admin content templates template" => "admin content templates template",
// "use in events" => "use in events",
// "admin FortuneCookie" => "admin FortuneCookie",
// "admin FortuneCookie tpl" => "admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Cookie" => "Cookie",
// "cookie" => "cookie",
// "Help on Drawings" => "Help on Drawings",
// "admin Drawings tpl" => "admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Admin DSN" => "Admin DSN",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "dsn" => "dsn",
// "admin External Wikis" => "admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "Create/Edit External Wiki" => "Create/Edit External Wiki",
// "extwiki" => "extwiki",
// "admin forums template" => "admin forums template",
// "Create new forum" => "Create new forum",
// "Edit existing forums" => "Edit existing forums",
// "min" => "min",
// "Display last post titles" => "Display last post titles",
// "no display" => "no display",
// "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address",
// "Send mails even when the post is generated by inbound mail" => "Send mails even when the post is generated by inbound mail",
// "Append a reply link to outbound mails" => "Append a reply link to outbound mails",
// "Originating e-mail address for mails from this forum" => "Originating e-mail address for mails from this forum",
// "flag" => "flag",
// "online" => "online",
// "Edit Existing Forums" => "Edit Existing Forums",
// "coms" => "coms",
// "ppd" => "ppd",
// "Assign Permissions (Active)" => "Assign Permissions (Active)",
// "Click here to delete this forum" => "Click here to delete this forum",
// "admin hotwords" => "admin hotwords",
// "admin hotwords template" => "admin hotwords template",
// "admin HTML page dynamic zones" => "admin HTML page dynamic zones",
// "admin Html Pages" => "admin Html Pages",
// "admin Html Pages template" => "admin Html Pages template",
// "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones" => "Use {literal}{/literal}ed id=name} or {literal}{/literal}ted id=name} to insert dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Edit Repository:" => "Edit Repository:",
// "Create New Repository" => "Create New Repository",
// "list repositories" => "list repositories",
// "new repository" => "new repository",
// "view repository" => "view repository",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "Start page" => "Start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "CSS file" => "CSS file",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Cacheable" => "Cacheable",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Clear cache" => "Clear cache",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Cache expiration" => "Cache expiration",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Available Repositories" => "Available Repositories",
// "Start" => "Start",
// "CSS File" => "CSS File",
// "Edit rules" => "Edit rules",
// "Edit Rules for Repository:" => "Edit Rules for Repository:",
// "configure repositories" => "configure repositories",
// "configure this repository" => "configure this repository",
// "view this repository" => "view this repository",
// "Add new rule" => "Add new rule",
// "new rule" => "new rule",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "copy rules" => "copy rules",
// "Source repository" => "Source repository",
// "Copy" => "Copy",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Rule order" => "Rule order",
// "Text to search for" => "Text to search for",
// "Text to replace" => "Text to replace",
// "Replace" => "Replace",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Enabled" => "Enabled",
// "Preview options" => "Preview options",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "Apply all rules" => "Apply all rules",
// "View source code after rules applied" => "View source code after rules applied",
// "Code preview" => "Code preview",
// "Generate HTML preview" => "Generate HTML preview",
// "HTML preview" => "HTML preview",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Preview Results" => "Preview Results",
// "Rules List" => "Rules List",
// "Case" => "Case",
// "admin featured links" => "admin featured links",
// "admin featured links template" => "admin featured links template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "url" => "url",
// "Mail-in accounts" => "Mail-in accounts",
// "admin mailin template" => "admin mailin template",
// "Account" => "Account",
// "Add new Mail-in account" => "Add new Mail-in account",
// "Edit Mail-in account" => "Edit Mail-in account",
// "Port" => "Port",
// "article-put" => "article-put",
// "Article Topic" => "Article Topic",
// "Article Type" => "Article Type",
// "Allow anonymous acces" => "Allow anonymous acces",
// "Allow attachments" => "Allow attachments",
// "Discard to the end from" => "Discard to the end from",
// "Check Mail-in accounts" => "Check Mail-in accounts",
// "Check automatically" => "Check automatically",
// "mn" => "mn",
// "Show Quick Urls" => "Show Quick Urls",
// "Hide Quick Urls" => "Hide Quick Urls",
// "sorted section" => "sorted section",
// "separator" => "separator",
// "Choose" => "Choose",
// "admin menu builder" => "admin menu builder",
// "admin menus template" => "admin menus template",
// "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use menus in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>, <a class=\"rbox-link\" href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu. To use <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "dynamic collapsed" => "dynamic collapsed",
// "admin modules" => "admin modules",
// "admin modules template" => "admin modules template",
// "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n",
// "Visibility" => "Visibility",
// "Displayed for the eligible users with no personal assigned modules" => "Displayed for the eligible users with no personal assigned modules",
// "Displayed now for all eligible users even with personal assigned modules" => "Displayed now for all eligible users even with personal assigned modules",
// "Displayed now, can't be unassigned" => "Displayed now, can't be unassigned",
// "Not displayed until a user chooses it" => "Not displayed until a user chooses it",
// "parameters" => "parameters",
// "Must be wiki parsed" => "Must be wiki parsed",
// "Random active poll" => "Random active poll",
// "Random current poll" => "Random current poll",
// "phpLayersMenus" => "phpLayersMenus",
// "use phplayermenu" => "use phplayermenu",
// "structure" => "structure",
// "Add email:" => "Add email:",
// "Add user:" => "Add user:",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "admin newsletters template" => "admin newsletters template",
// "Users can subscribe/unsubscribe to this list" => "Users can subscribe/unsubscribe to this list",
// "Add unsubscribe instructions to each newsletter" => "Add unsubscribe instructions to each newsletter",
// "Validate email addresses" => "Validate email addresses",
// "send newsletter" => "send newsletter",
// "archives" => "archives",
// "admin notifications template" => "admin notifications template",
// "Any wiki page is changed" => "Any wiki page is changed",
// "Any wiki page is changed, even minor changes" => "Any wiki page is changed, even minor changes",
// "PHP error" => "PHP error",
// "No records found." => "No records found.",
// "configure polls" => "configure polls",
// "Admin Quicktags" => "Admin Quicktags",
// "admin QuickTags" => "admin QuickTags",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "Create/Edit QuickTags" => "Create/Edit QuickTags",
// "label" => "label",
// "Insert (use 'text' for figuring the selection)" => "Insert (use 'text' for figuring the selection)",
// "Path to the tag icon" => "Path to the tag icon",
// "Insert" => "Insert",
// "Icon" => "Icon",
// "admin RSS modules" => "admin RSS modules",
// "admin RSSmodules template" => "admin RSSmodules template",
// "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "show feed title" => "show feed title",
// "show publish date" => "show publish date",
// "show pubdate" => "show pubdate",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "edit tpl" => "edit tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "PHP settings" => "PHP settings",
// "PHP variable" => "PHP variable",
// "Setting" => "Setting",
// "Risk Factor" => "Risk Factor",
// "Explanation" => "Explanation",
// "Tikiwiki settings" => "Tikiwiki settings",
// "Tiki variable" => "Tiki variable",
// "Check all tiki files" => "Check all tiki files",
// "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Note, that this can take a very long time. You should check your max_execution_time setting in php.ini.",
// "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database.",
// "File checks" => "File checks",
// "State" => "State",
// "admin shoutbox words" => "admin shoutbox words",
// "admin shoutbox words template" => "admin shoutbox words template",
// "Are you sure you want to delete this word?" => "Are you sure you want to delete this word?",
// "admin structures template" => "admin structures template",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "administer surveys template" => "administer surveys template",
// "Create New Survey" => "Create New Survey",
// "active perms" => "active perms",
// "system admin tpl" => "system admin tpl",
// "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be)." => "If your Tiki is acting weird, 1st thing to try it to clear your cache below. Also very important to clear your cache after an upgrade (by FTP/SSH if need be).",
// "Empty" => "Empty",
// "Templates compiler" => "Templates compiler",
// "Compile" => "Compile",
// "Fix UTF-8 Errors in Tables" => "Fix UTF-8 Errors in Tables",
// "Warning: Make a backup of your Database before using this function!" => "Warning: Make a backup of your Database before using this function!",
// "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!",
// "This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "This function converts ISO-8859-1 encoded strings in your tables to UTF-8",
// "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Table" => "Table",
// "Field" => "Field",
// "Investigate" => "Investigate",
// "Fix it" => "Fix it",
// "admin topics template" => "admin topics template",
// "Remove with articles" => "Remove with articles",
// "Admin tracker" => "Admin tracker",
// "Edit this tracker" => "Edit this tracker",
// "View this tracker items" => "View this tracker items",
// "Edit tracker fields" => "Edit tracker fields",
// "Is column visible when listing tracker items?" => "Is column visible when listing tracker items?",
// "Column links to edit/view item?" => "Column links to edit/view item?",
// "Column is searchable?" => "Column is searchable?",
// "Field is public? (for use thru trackerlist plugin)" => "Field is public? (for use thru trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "visible by admin only" => "visible by admin only",
// "editable by admin only" => "editable by admin only",
// "Field is mandatory?" => "Field is mandatory?",
// "Tracker fields" => "Tracker fields",
// "Id" => "Id",
// "isMain" => "isMain",
// "Tbl vis" => "Tbl vis",
// "Searchable" => "Searchable",
// "Public" => "Public",
// "Hidden" => "Hidden",
// "Mandatory" => "Mandatory",
// "Import/export trackers fields" => "Import/export trackers fields",
// "admin Trackers tpl" => "admin Trackers tpl",
// "Edit fields for tracker" => "Edit fields for tracker",
// "Edit tracker" => "Edit tracker",
// "Create trackers" => "Create trackers",
// "Import/export" => "Import/export",
// "active permissions" => "active permissions",
// "There are individual permissions set for this tracker" => "There are individual permissions set for this tracker",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "Show status" => "Show status",
// "Default status displayed in list mode" => "Default status displayed in list mode",
// "Show status to tracker admin only" => "Show status to tracker admin only",
// "Send copies of all activity in this tracker to this e-mail address" => "Send copies of all activity in this tracker to this e-mail address",
// "Use simplified e-mail format" => "Use simplified e-mail format",
// "The tracker needs a text field named Subject" => "The tracker needs a text field named Subject",
// "New items are created with status" => "New items are created with status",
// "Authoritative status for modified items" => "Authoritative status for modified items",
// "No change" => "No change",
// "Item creator can modify his items?" => "Item creator can modify his items?",
// "The tracker needs a user field with the option 1" => "The tracker needs a user field with the option 1",
// "Member of the default group of creator can modify items?" => "Member of the default group of creator can modify items?",
// "The tracker needs a group field with the option 1" => "The tracker needs a group field with the option 1",
// "Show creation date when listing tracker items?" => "Show creation date when listing tracker items?",
// "Show lastModif date when listing tracker items?" => "Show lastModif date when listing tracker items?",
// "What field is used for default sort?" => "What field is used for default sort?",
// "What is default sort order in list?" => "What is default sort order in list?",
// "ascending" => "ascending",
// "descending" => "descending",
// "Tracker items allow ratings?" => "Tracker items allow ratings?",
// "with values" => "with values",
// "and display rating results in listing?" => "and display rating results in listing?",
// "Tracker items allow comments?" => "Tracker items allow comments?",
// "and display comments in listing?" => "and display comments in listing?",
// "Tracker items allow attachments?" => "Tracker items allow attachments?",
// "and display attachments in listing?" => "and display attachments in listing?",
// "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)",
// "filetype" => "filetype",
// "longdesc" => "longdesc",
// "Import/export trackers" => "Import/export trackers",
// "Import/Export CSV Data" => "Import/Export CSV Data",
// "Download CSV export" => "Download CSV export",
// "tracker_{\$trackerId}.csv" => "tracker_{\$trackerId}.csv",
// "Import file" => "Import file",
// "admin groups template" => "admin groups template",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "admin" => "admin",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Edit item" => "Edit item",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "remove from group" => "remove from group",
// "admin users template" => "admin users template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Batch Upload Results" => "Batch Upload Results",
// "Change user preferences" => "Change user preferences",
// "edit account settings" => "edit account settings",
// "edit included group" => "edit included group",
// "Perform action with checked:" => "Perform action with checked:",
// "remove users and their userpages" => "remove users and their userpages",
// "manage group assignments" => "manage group assignments",
// "set default groups" => "set default groups",
// "Assign selected to" => "Assign selected to",
// "Remove selected from" => "Remove selected from",
// "the following groups:" => "the following groups:",
// "Tip: hold down CTRL to select multiple" => "Tip: hold down CTRL to select multiple",
// "Set the default group of the selected users to" => "Set the default group of the selected users to",
// "assign to groups" => "assign to groups",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Batch upload (CSV file<a {popup text='login,password,email,groups<br />user1,password1,email1,&quot;group1,group2&quot;<br />user2, password2,email2'}><img src=\"img/icons/help.gif\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Admin Article Types" => "Admin Article Types",
// "Article Types tpl" => "Article Types tpl",
// "Shows up in the drop down list of article types" => "Shows up in the drop down list of article types",
// "Rate" => "Rate",
// "Allow ratings by the author" => "Allow ratings by the author",
// "Show before publish date" => "Show before publish date",
// "non-admins can view before the publish date" => "non-admins can view before the publish date",
// "Show after expire date" => "Show after expire date",
// "non-admins can view after the expire date" => "non-admins can view after the expire date",
// "Heading only" => "Heading only",
// "No article body, heading only" => "No article body, heading only",
// "Allow comments for this type" => "Allow comments for this type",
// "Comment Can Rate Article" => "Comment Can Rate Article",
// "Allow comments to include a rating value" => "Allow comments to include a rating value",
// "Show image" => "Show image",
// "Show topic or own image" => "Show topic or own image",
// "Show avatar" => "Show avatar",
// "Show author's avatar" => "Show author's avatar",
// "Show author" => "Show author",
// "Show author name" => "Show author name",
// "Show publish date" => "Show publish date",
// "Show reads" => "Show reads",
// "Show the number of times the article was read" => "Show the number of times the article was read",
// "Show size" => "Show size",
// "Show the size of the article" => "Show the size of the article",
// "Show topline" => "Show topline",
// "Show a small title over the title" => "Show a small title over the title",
// "Show subtitle" => "Show subtitle",
// "Show the subtitle" => "Show the subtitle",
// "Show source" => "Show source",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Image Caption" => "Show Image Caption",
// "Show a legend under the image" => "Show a legend under the image",
// "Show Language" => "Show Language",
// "Show the language" => "Show the language",
// "Creator can edit" => "Creator can edit",
// "The person who submits an article of this type can edit it" => "The person who submits an article of this type can edit it",
// "Delete" => "Delete",
// "Delete this type" => "Delete this type",
// "List of types" => "List of types",
// "Show lang" => "Show lang",
// "Review" => "Review",
// "Classified" => "Classified",
// "Create a new type" => "Create a new type",
// "edit article tpl" => "edit article tpl",
// "advanced feature" => "advanced feature",
// "level configuration" => "level configuration",
// "all" => "all",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Default Group" => "Default Group",
// "Available groups" => "Available groups",
// "assign perms to this group" => "assign perms to this group",
// "to" => "to",
// "admin backups" => "admin backups",
// "admin admin tpl" => "admin admin tpl",
// "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead." => "Use of this feature is NOT recommended. Please use phpMyAdmin or mysqldump instead.",
// "List of available backups" => "List of available backups",
// "Restoring a backup" => "Restoring a backup",
// "Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup.",
// "Click here to confirm restoring" => "Click here to confirm restoring",
// "Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file",
// "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP.",
// "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP.",
// "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP.",
// "Directory batch upload" => "Directory batch upload",
// "available images" => "available images",
// "remove file extension from image name" => "remove file extension from image name",
// "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field",
// "convert sub directories to sub galleries" => "convert sub directories to sub galleries",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created",
// "use sub directory names as description" => "use sub directory names as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created",
// "Select a Gallery" => "Select a Gallery",
// "Process" => "Process",
// "Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. " => "Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor. ",
// "Use ...page... to separate pages in a multi-page post" => "Use ...page... to separate pages in a multi-page post",
// "Upload image for this post" => "Upload image for this post",
// "Trash" => "Trash",
// "Mark entry as private:" => "Mark entry as private:",
// "Send trackback pings to:" => "Send trackback pings to:",
// "(comma separated list of URIs)" => "(comma separated list of URIs)",
// "admin the category system" => "admin the category system",
// "Browse in" => "Browse in",
// "Wiki pages" => "Wiki pages",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "Hide subcategories objects" => "Hide subcategories objects",
// "Show subcategories objects" => "Show subcategories objects",
// "Upper level" => "Upper level",
// "Directory batch" => "Directory batch",
// "subgallery" => "subgallery",
// "Subgallery" => "Subgallery",
// "hit" => "hit",
// "slideshow forward" => "slideshow forward",
// "stop" => "stop",
// "Cyclic" => "Cyclic",
// "Direction" => "Direction",
// "Click to zoom" => "Click to zoom",
// "Image size" => "Image size",
// "imagescale" => "imagescale",
// "You can include the image in an HTML page using one of these lines" => "You can include the image in an HTML page using one of these lines",
// "You can include the image in a tiki page using one of these lines" => "You can include the image in a tiki page using one of these lines",
// "add item" => "add item",
// "Edit/Create" => "Edit/Create",
// "Date Selector" => "Date Selector",
// "click to navigate" => "click to navigate",
// "Focus:" => "Focus:",
// "change focus" => "change focus",
// "quarter" => "quarter",
// "semester" => "semester",
// "calendar view" => "calendar view",
// "list view" => "list view",
// "End" => "End",
// "details" => "details",
// "Hours" => "Hours",
// "zoom" => "zoom",
// "+" => "+",
// "Location" => "Location",
// "Organized by" => "Organized by",
// "Participants" => "Participants",
// "Tentative" => "Tentative",
// "Confirmed" => "Confirmed",
// "Cancelled" => "Cancelled",
// "Subscription List" => "Subscription List",
// "New Calendar Item" => "New Calendar Item",
// "or create a new category" => "or create a new category",
// "or create a new location" => "or create a new location",
// "comma separated usernames" => "comma separated usernames",
// "comma separated username:role" => "comma separated username:role",
// "with roles" => "with roles",
// "Chair" => "Chair",
// "Optional" => "Optional",
// "Syntax error" => "Syntax error",
// "Format: mm/dd/yyyy hh:mm<br />..." => "Format: mm/dd/yyyy hh:mm<br />...",
// "See strtotime php function" => "See strtotime php function",
// "Format: mm/dd/yyy hh:mm<br />..." => "Format: mm/dd/yyy hh:mm<br />...",
// "duplicate" => "duplicate",
// "save_to" => "save_to",
// "click to view" => "click to view",
// "Calendar import" => "Calendar import",
// "Calendar has been updated" => "Calendar has been updated",
// "CSV File" => "CSV File",
// "import" => "import",
// "Assign permissions to category" => "Assign permissions to category",
// "Current permissions for this category" => "Current permissions for this category",
// "remove from this category &amp; all its children" => "remove from this category &amp; all its children",
// "remove from this category only" => "remove from this category only",
// "this category &amp; all its children" => "this category &amp; all its children",
// "this category only" => "this category only",
// "Assigning permissions for <b>all children</b> is recommended for best performance." => "Assigning permissions for <b>all children</b> is recommended for best performance.",
// "There are no channels setup, please contact a site admin" => "There are no channels setup, please contact a site admin",
// "Browser not supported" => "Browser not supported",
// "Channel Information" => "Channel Information",
// "Channel" => "Channel",
// "Ratio" => "Ratio",
// "Use :nickname:message for private messages" => "Use :nickname:message for private messages",
// "Use [URL|description] or [URL] for links" => "Use [URL|description] or [URL] for links",
// "Use (:smileyname:) for smileys" => "Use (:smileyname:) for smileys",
// "PDF Settings" => "PDF Settings",
// "Textheight" => "Textheight",
// "Height of top Heading" => "Height of top Heading",
// "Height of mid Heading" => "Height of mid Heading",
// "Height of inner Heading" => "Height of inner Heading",
// "tbheight" => "tbheight",
// "Automatic Page Breaks" => "Automatic Page Breaks",
// "Select Wiki Pages" => "Select Wiki Pages",
// "reset" => "reset",
// "Create WebHelp" => "Create WebHelp",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "Top page" => "Top page",
// "Tiki Debugger Console" => "Tiki Debugger Console",
// "exec" => "exec",
// "You cannot add sites until Directory Categories are setup." => "You cannot add sites until Directory Categories are setup.",
// "Please contact the Site Administrator" => "Please contact the Site Administrator",
// "The following site was added and validation by admin may be needed before appearing on the lists" => "The following site was added and validation by admin may be needed before appearing on the lists",
// "Name:" => "Name:",
// "URL:" => "URL:",
// "Categories:" => "Categories:",
// "Directory Administration" => "Directory Administration",
// "admin directory tpl" => "admin directory tpl",
// "There are" => "There are",
// "invalid sites" => "invalid sites",
// "valid sites" => "valid sites",
// "Users have visited" => "Users have visited",
// "sites from the directory" => "sites from the directory",
// "Users have searched" => "Users have searched",
// "times from the directory" => "times from the directory",
// "Admin category relationships" => "Admin category relationships",
// "Validate links" => "Validate links",
// "validate" => "validate",
// "Admin directory categories" => "Admin directory categories",
// "admin directory categories tpl" => "admin directory categories tpl",
// "Parent category" => "Parent category",
// "Add a directory category" => "Add a directory category",
// "Edit this directory category" => "Edit this directory category",
// "Children type" => "Children type",
// "Most visited sub-categories" => "Most visited sub-categories",
// "Category description" => "Category description",
// "Random sub-categories" => "Random sub-categories",
// "Maximum number of children to show" => "Maximum number of children to show",
// "Allow sites in this category" => "Allow sites in this category",
// "Show number of sites in this category" => "Show number of sites in this category",
// "Editor group" => "Editor group",
// "Subcategories" => "Subcategories",
// "cType" => "cType",
// "allow" => "allow",
// "count" => "count",
// "editor" => "editor",
// "relate" => "relate",
// "Admin related categories" => "Admin related categories",
// "Admin Directory Related " => "Admin Directory Related ",
// "directory admin related tpl" => "directory admin related tpl",
// "Add a related category" => "Add a related category",
// "Mutual" => "Mutual",
// "Related categories" => "Related categories",
// "Admin Directory Sites" => "Admin Directory Sites",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
// "country" => "country",
// "new sites" => "new sites",
// "cool sites" => "cool sites",
// "add a category" => "add a category",
// "any" => "any",
// "in entire directory" => "in entire directory",
// "in current category" => "in current category",
// "search" => "search",
// "Sort by" => "Sort by",
// "name (desc)" => "name (desc)",
// "name (asc)" => "name (asc)",
// "hits (desc)" => "hits (desc)",
// "hits (asc)" => "hits (asc)",
// "creation date (desc)" => "creation date (desc)",
// "creation date (asc)" => "creation date (asc)",
// "last updated (desc)" => "last updated (desc)",
// "last updated (asc)" => "last updated (asc)",
// "sort" => "sort",
// "Added" => "Added",
// "Last updated" => "Last updated",
// "Total categories" => "Total categories",
// "Total links" => "Total links",
// "Links to validate" => "Links to validate",
// "Searches performed" => "Searches performed",
// "Total links visited" => "Total links visited",
// "Directory ranking" => "Directory ranking",
// "Validate sites" => "Validate sites",
// "Validate Sites" => "Validate Sites",
// "directory validate sites tpl" => "directory validate sites tpl",
// "Topline" => "Topline",
// "Own Image" => "Own Image",
// "Use own image" => "Use own image",
// "Float text around image" => "Float text around image",
// "Own image size x" => "Own image size x",
// "pixels" => "pixels",
// "Own image size y" => "Own image size y",
// "Image caption" => "Image caption",
// "Heading" => "Heading",
// "Body" => "Body",
// "Use ...page... to separate pages in a multi-page article" => "Use ...page... to separate pages in a multi-page article",
// "Expiration Date" => "Expiration Date",
// "Edit or create banners" => "Edit or create banners",
// "List banners" => "List banners",
// "URL to link the banner" => "URL to link the banner",
// "Client" => "Client",
// "Max impressions" => "Max impressions",
// "create zone" => "create zone",
// "Show the banner only between these dates" => "Show the banner only between these dates",
// "From date" => "From date",
// "To date" => "To date",
// "Show the banner only in this hours" => "Show the banner only in this hours",
// "Show the banner only on" => "Show the banner only on",
// "Select ONE method for the banner" => "Select ONE method for the banner",
// "Use HTML" => "Use HTML",
// "HTML code" => "HTML code",
// "Use image" => "Use image",
// "Current Image" => "Current Image",
// "Use image generated by URL (the image will be requested at the URL for each impression)" => "Use image generated by URL (the image will be requested at the URL for each impression)",
// "Use text" => "Use text",
// "Text" => "Text",
// "save the banner" => "save the banner",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "There are individual permissions set for this blog" => "There are individual permissions set for this blog",
// "Number of posts to show" => "Number of posts to show",
// "Allow other user to post in this blog" => "Allow other user to post in this blog",
// "Use titles in blog posts" => "Use titles in blog posts",
// "Allow search" => "Allow search",
// "Allow comments" => "Allow comments",
// "Allow trackback pings" => "Allow trackback pings",
// "Show user avatar" => "Show user avatar",
// "Blog heading" => "Blog heading",
// "Edit Style Sheet" => "Edit Style Sheet",
// "Style Sheet" => "Style Sheet",
// "choose a stylesheet" => "choose a stylesheet",
// "try" => "try",
// "display" => "display",
// "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model.",
// "Show Plugins Help" => "Show Plugins Help",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "some text" => "some text",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Creates a box with the data" => "Creates a box with the data",
// "Box content" => "Box content",
// "Title bar" => "Title bar",
// "Colored text" => "Colored text",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Headings" => "Headings",
// "make headings" => "make headings",
// "Show/Hide" => "Show/Hide",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "prevents referencing" => "prevents referencing",
// "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "Tables" => "Tables",
// "row" => "row",
// "col" => "col",
// "creates a table" => "creates a table",
// "height width desc link and align are optional" => "height width desc link and align are optional",
// "Non cacheable images" => "Non cacheable images",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "Horizontal rule" => "Horizontal rule",
// "creates the editable drawing foo" => "creates the editable drawing foo",
// "Multi-page pages" => "Multi-page pages",
// "to separate pages" => "to separate pages",
// "Wiki File Attachments" => "Wiki File Attachments",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "RSS feeds" => "RSS feeds",
// "displays rss feed with id=n maximum=m items" => "displays rss feed with id=n maximum=m items",
// "Will be replaced by the actual value of the dynamic content block with id=n" => "Will be replaced by the actual value of the dynamic content block with id=n",
// "Dynamic variables" => "Dynamic variables",
// "Inserts an editable variable" => "Inserts an editable variable",
// "Non parsed sections" => "Non parsed sections",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "Preformated sections" => "Preformated sections",
// "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).",
// "Square Brackets" => "Square Brackets",
// "Use [[foo] to show [foo]." => "Use [[foo] to show [foo].",
// "Block Preformatting" => "Block Preformatting",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Table of contents" => "Table of contents",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Misc" => "Misc",
// "Show Text Formatting Rules" => "Show Text Formatting Rules",
// "No description available" => "No description available",
// "italic" => "italic",
// "underline" => "underline",
// "table" => "table",
// "table new" => "table new",
// "external link" => "external link",
// "wiki link'" => "wiki link'",
// "heading1" => "heading1",
// "title bar" => "title bar",
// "box" => "box",
// "rss feed" => "rss feed",
// "dynamic content" => "dynamic content",
// "tagline" => "tagline",
// "hr" => "hr",
// "center text" => "center text",
// "colored text" => "colored text",
// "dynamic variable" => "dynamic variable",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Edit Image" => "Edit Image",
// "browse image" => "browse image",
// "Edit successful!" => "Edit successful!",
// "The following image was successfully edited" => "The following image was successfully edited",
// "Edit and create Languages" => "Edit and create Languages",
// "Im- Export Languages" => "Im- Export Languages",
// "Edit and create languages" => "Edit and create languages",
// "Create Language" => "Create Language",
// "Shortname" => "Shortname",
// "like" => "like",
// "Longname" => "Longname",
// "Select the language to edit" => "Select the language to edit",
// "Add a translation" => "Add a translation",
// "Edit translations" => "Edit translations",
// "Translate recorded" => "Translate recorded",
// "Original" => "Original",
// "Translation" => "Translation",
// "translate" => "translate",
// "reset table" => "reset table",
// "Program dynamic content for block" => "Program dynamic content for block",
// "create new block" => "create new block",
// "Return to block listing" => "Return to block listing",
// "Block description: " => "Block description: ",
// "Create or edit content" => "Create or edit content",
// "You are editing block:" => "You are editing block:",
// "Publishing date" => "Publishing date",
// "Publishing Date" => "Publishing Date",
// "Edit question options" => "Edit question options",
// "list quizzes" => "list quizzes",
// "quiz stats" => "quiz stats",
// "this quiz stats" => "this quiz stats",
// "edit this quiz" => "edit this quiz",
// "admin quizzes" => "admin quizzes",
// "Create/edit options for question" => "Create/edit options for question",
// "points" => "points",
// "Admin quizzes" => "Admin quizzes",
// "admin quizzes tpl" => "admin quizzes tpl",
// "Create/edit quizzes" => "Create/edit quizzes",
// "There are individual permissions set for this quiz" => "There are individual permissions set for this quiz",
// "Quiz can be repeated" => "Quiz can be repeated",
// "Store quiz results" => "Store quiz results",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Questions per page" => "Questions per page",
// "Quiz is time limited" => "Quiz is time limited",
// "Maximum time" => "Maximum time",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "canRepeat" => "canRepeat",
// "timeLimit" => "timeLimit",
// "Edit quiz questions" => "Edit quiz questions",
// "edit quiz questions" => "edit quiz questions",
// "edit quiz questions tpl" => "edit quiz questions tpl",
// "Create/edit questions for quiz" => "Create/edit questions for quiz",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "maxScore" => "maxScore",
// "From Points" => "From Points",
// "To Points" => "To Points",
// "Answer" => "Answer",
// "Help on Articles" => "Help on Articles",
// "edit submissions tpl" => "edit submissions tpl",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "EditTemplates" => "EditTemplates",
// "EditTemplates tpl" => "EditTemplates tpl",
// "Template listing" => "Template listing",
// "Available templates" => "Available templates",
// "Template" => "Template",
// "save only in the theme:" => "save only in the theme:",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Edit a topic" => "Edit a topic",
// "View" => "View",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "The object is already in the set of translations" => "The object is already in the set of translations",
// "detach" => "detach",
// "Select the article for which the current article is the translation." => "Select the article for which the current article is the translation.",
// "Use rating" => "Use rating",
// "disable" => "disable",
// "There is no available poll template." => "There is no available poll template.",
// "You should ask an admin to create them." => "You should ask an admin to create them.",
// "an existing poll" => "an existing poll",
// "Search " => "Search ",
// "Case Insensitivity" => "Case Insensitivity",
// "replace" => "replace",
// "Admin ephemerides" => "Admin ephemerides",
// "admin Ephemerides tpl" => "admin Ephemerides tpl",
// "All ephemerides" => "All ephemerides",
// "View FAQ" => "View FAQ",
// "Edit this FAQ" => "Edit this FAQ",
// "new question" => "new question",
// "Edit FAQ questions" => "Edit FAQ questions",
// "Use a question from another FAQ" => "Use a question from another FAQ",
// "FAQ questions" => "FAQ questions",
// "Suggested questions" => "Suggested questions",
// "approve" => "approve",
// "No suggested questions" => "No suggested questions",
// "File Galleries tpl" => "File Galleries tpl",
// "configure listing" => "configure listing",
// "Create a file gallery" => "Create a file gallery",
// "Edit this file gallery:" => "Edit this file gallery:",
// "There are individual permissions set for this file gallery" => "There are individual permissions set for this file gallery",
// "Listing configuration" => "Listing configuration",
// "icon" => "icon",
// "id" => "id",
// "Name-filename" => "Name-filename",
// "Filename only" => "Filename only",
// "Max description display size" => "Max description display size",
// "Other users can upload files to this gallery" => "Other users can upload files to this gallery",
// "You can access the file gallery using the following URL" => "You can access the file gallery using the following URL",
// "Message queue for" => "Message queue for",
// "Edit queued message" => "Edit queued message",
// "make this a thread of" => "make this a thread of",
// "None, this is a thread message" => "None, this is a thread message",
// "summary" => "summary",
// "normal" => "normal",
// "announce" => "announce",
// "hot" => "hot",
// "sticky" => "sticky",
// "no feeling" => "no feeling",
// "frown" => "frown",
// "exclaim" => "exclaim",
// "idea" => "idea",
// "mad" => "mad",
// "neutral" => "neutral",
// "sad" => "sad",
// "happy" => "happy",
// "wink" => "wink",
// "save and approve" => "save and approve",
// "List of messages" => "List of messages",
// "no summary" => "no summary",
// "No messages queued yet" => "No messages queued yet",
// "reject" => "reject",
// "configure forum" => "configure forum",
// "Reported messages for" => "Reported messages for",
// "Reported by" => "Reported by",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Request Time" => "Request Time",
// "Activity completed" => "Activity completed",
// "Admin process activities" => "Admin process activities",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Add or edit an activity" => "Add or edit an activity",
// "start" => "start",
// "end" => "end",
// "split" => "split",
// "join" => "join",
// "standalone" => "standalone",
// "interactive" => "interactive",
// "auto routed" => "auto routed",
// "Expiration Time" => "Expiration Time",
// "Years" => "Years",
// "Months" => "Months",
// "Days" => "Days",
// "Minutes" => "Minutes",
// "Add transitions" => "Add transitions",
// "Add transition from:" => "Add transition from:",
// "Add transition to:" => "Add transition to:",
// "roles" => "roles",
// "No roles associated to this activity" => "No roles associated to this activity",
// "Add role" => "Add role",
// "add new" => "add new",
// "add role" => "add role",
// "Process activities" => "Process activities",
// "Int" => "Int",
// "Routing" => "Routing",
// "Interactive" => "Interactive",
// "Automatic" => "Automatic",
// "Auto routed" => "Auto routed",
// "Manual" => "Manual",
// "#" => "#",
// "inter" => "inter",
// "route" => "route",
// "(no roles)" => "(no roles)",
// "No activities defined yet" => "No activities defined yet",
// "Process Transitions" => "Process Transitions",
// "List of transitions" => "List of transitions",
// "From:" => "From:",
// "Origin" => "Origin",
// "No transitions defined yet" => "No transitions defined yet",
// "Add a transition" => "Add a transition",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "This process is invalid" => "This process is invalid",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "List of processes" => "List of processes",
// "Inactive" => "Inactive",
// "act" => "act",
// "val" => "val",
// "active process" => "active process",
// "invalid" => "invalid",
// "invalid process" => "invalid process",
// "valid process" => "valid process",
// "activities" => "activities",
// "graph" => "graph",
// "new minor" => "new minor",
// "new major" => "new major",
// "No processes defined yet" => "No processes defined yet",
// "Admin instance" => "Admin instance",
// "Process:" => "Process:",
// "Instance" => "Instance",
// "Workitems" => "Workitems",
// "exception" => "exception",
// "aborted" => "aborted",
// "Owner" => "Owner",
// "Send all to" => "Send all to",
// "Don't move" => "Don't move",
// "Activities" => "Activities",
// "Act status" => "Act status",
// "Ended" => "Ended",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Properties" => "Properties",
// "Property" => "Property",
// "Value" => "Value",
// "Add property" => "Add property",
// "value" => "value",
// "run instance" => "run instance",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Add or edit a process" => "Add or edit a process",
// "Process Name" => "Process Name",
// "ver:" => "ver:",
// "is active?" => "is active?",
// "Or upload a process using this form" => "Or upload a process using this form",
// "Admin process roles" => "Admin process roles",
// "Add or edit a role" => "Add or edit a role",
// "Process roles" => "Process roles",
// "No roles defined yet" => "No roles defined yet",
// "Map users to roles" => "Map users to roles",
// "Roles" => "Roles",
// "map" => "map",
// "Map groups to roles" => "Map groups to roles",
// "Operation" => "Operation",
// "Warning" => "Warning",
// "No roles are defined yet so no roles can be mapped" => "No roles are defined yet so no roles can be mapped",
// "List of mappings" => "List of mappings",
// "No mappings defined yet" => "No mappings defined yet",
// "Admin process sources" => "Admin process sources",
// "select source" => "select source",
// "Shared code" => "Shared code",
// "Set next user" => "Set next user",
// "Get property" => "Get property",
// "Set property" => "Set property",
// "Complete" => "Complete",
// "Process form" => "Process form",
// "Set Next act" => "Set Next act",
// "If:SetNextact" => "If:SetNextact",
// "Switch construct" => "Switch construct",
// "Map process roles" => "Map process roles",
// "admin processes" => "admin processes",
// "admin activities" => "admin activities",
// "admin roles" => "admin roles",
// "edit this process" => "edit this process",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "List of activities" => "List of activities",
// "proc" => "proc",
// "auto" => "auto",
// "int" => "int",
// "routing" => "routing",
// "Instances" => "Instances",
// "run" => "run",
// "run activity" => "run activity",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "monitor" => "monitor",
// "monitor processes" => "monitor processes",
// "monitor activities" => "monitor activities",
// "monitor instances" => "monitor instances",
// "monitor workitems" => "monitor workitems",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "List of instances" => "List of instances",
// "Not ended" => "Not ended",
// "No instances created yet" => "No instances created yet",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Valid" => "Valid",
// "Invalid" => "Invalid",
// "processes" => "processes",
// "being run" => "being run",
// "exceptions" => "exceptions",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "instance" => "instance",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "My activities" => "My activities",
// "Current Activity" => "Current Activity",
// "Assigned To" => "Assigned To",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "send instance" => "send instance",
// "abort instance" => "abort instance",
// "grab instance" => "grab instance",
// "release instance" => "release instance",
// "No activities found" => "No activities found",
// "My instances" => "My instances",
// "No instances found" => "No instances found",
// "activate" => "activate",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "process" => "process",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "user processes" => "user processes",
// "user activities" => "user activities",
// "user instances" => "user instances",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Inst Status" => "Inst Status",
// "Not defined" => "Not defined",
// "No instances defined yet" => "No instances defined yet",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
// "galleries tpl" => "galleries tpl",
// "rebuild cache" => "rebuild cache",
// "Geographic" => "Geographic",
// "Default sort order" => "Default sort order",
// "Fields to show during browsing the gallery" => "Fields to show during browsing the gallery",
// "Image ID" => "Image ID",
// "Creation Date" => "Creation Date",
// "XY-Size" => "XY-Size",
// "Gallery Image" => "Gallery Image",
// "Parent gallery" => "Parent gallery",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Original image is default scale" => "Original image is default scale",
// "Add scaled images with bounding box of square size" => "Add scaled images with bounding box of square size",
// "Owner of the gallery" => "Owner of the gallery",
// "Choose a filter" => "Choose a filter",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Landscape" => "Landscape",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Left" => "Left",
// "Right" => "Right",
// "Series" => "Series",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
// "tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "Overwrite existing pages if the name is the same" => "Overwrite existing pages if the name is the same",
// "Previously remove existing page versions" => "Previously remove existing page versions",
// "excerpt" => "excerpt",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "reload" => "reload",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection info" => "Please enter your database connection info",
// "Database type" => "Database type",
// "The type of database you intend to use" => "The type of database you intend to use",
// "Host:" => "Host:",
// "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki" => "Hostname or IP for your MySQL database, example: localhost if running in the same machine as tiki",
// "If you use SQLite, insert the path and filename to your database file" => "If you use SQLite, insert the path and filename to your database file",
// "Database user" => "Database user",
// "Database password" => "Database password",
// "Database name" => "Database name",
// "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names" => "The name of the database where tiki will create tables. You can create the database using mysqladmin, or PHPMyAdmin or ask your\nhosting service to create a MySQL database.  Normally Tiki tables won't conflict with other product names",
// "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above" => "If you use Oracle, you can put your TNS Name here and leave hostname empty\nor you override tnsnames.ora and put your SID here and fill your hostname:port above",
// "Welcome to the installation &amp; upgrade script!" => "Welcome to the installation &amp; upgrade script!",
// "Install" => "Install",
// "Create database (clean install) with profile" => "Create database (clean install) with profile",
// "Descriptions of the available profiles" => "Descriptions of the available profiles",
// "Upgrade" => "Upgrade",
// "backup your database" => "backup your database",
// "with mysqldump or phpmyadmin before you proceed" => "with mysqldump or phpmyadmin before you proceed",
// "Update database using script" => "Update database using script",
// "For database update from 1.8 or later" => "For database update from 1.8 or later",
// "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script" => "If you upgrade from 1.8.x you <b>MUST</b> run tiki_1.8to1.9 and don't need an additional script",
// "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)" => "If you upgrade from a previous 1.9.x version, use tiki_1.8to1.9, too. (ex.: 1.9.2 to 1.9.5)",
// "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions" => "For database update from 1.7.x, please visit <a target=\"help\" href=\"http://tikiwiki.org/UpgradeTo18\">Tiki database 1.7.x to 1.8x instructions",
// "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity" => "For information about tiki-secdb_*.sql files, please see <a target=\"help\" href=\"http://tikiwiki.org/AdminSecurity\">http://tikiwiki.org/AdminSecurity",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please enter your admin password to continue" => "Please enter your admin password to continue",
// "Print operations executed successfully" => "Print operations executed successfully",
// "Print operations failed" => "Print operations failed",
// "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application" => "Your database has been configured and Tiki is ready to run, if\n    \t\tthis is your first install your admin password is 'admin'. You can\n    \t\tnow log in into Tiki as 'admin' - 'admin' and start configuring\n    \t\tthe application",
// "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore" => "Note: This install script may be potentially harmful so we strongly\n    \t\trecommend you to disable the script and then proceed into Tiki. If\n    \t\tyou decide to reuse later, just follow the instructions in\n\t\ttiki-install.php to restore",
// "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!" => "READ THE FOLLOWING NOTES BEFORE ENTERING TIKI USING THE LINKS BELOW!",
// "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!" => "Make sure tiki gets more than 8 MB of memory for script execution. \nSee file php.ini, the relevant key is memory_limit. Use something like memory_limit = 16M and restart your \nwebserver. Too little memory will cause blank pages!",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at only 8 Megs" => "Tiki has detected your PHP memory limit at only 8 Megs",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Note" => "Note",
// "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation" => "If this is a first time installation, go to tiki-admin.php after login to start configuring your new Tiki installation",
// "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system" => "If you did a Tiki upgrade, make sure to clean the caches (templates_c/) manually or by using the feature on admin / system",
// "Now you may proceed by clicking one of these links" => "Now you may proceed by clicking one of these links",
// "Click here to disable the install script and proceed into tiki" => "Click here to disable the install script and proceed into tiki",
// "Click here to proceed into tiki without disabling the script" => "Click here to proceed into tiki without disabling the script",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "do not use your Back button in your browser!" => "do not use your Back button in your browser!",
// "Clear cached version and refresh cache" => "Clear cached version and refresh cache",
// "configure rules" => "configure rules",
// "edit repository" => "edit repository",
// "v" => "v",
// "list articles tpl" => "list articles tpl",
// "ExpireDate" => "ExpireDate",
// "admin Banners" => "admin Banners",
// "admin Banners tpl" => "admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "admin cache" => "admin cache",
// "admin cache tpl" => "admin cache tpl",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "admin DynamicContent tpl" => "admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "Create or edit content block" => "Create or edit content block",
// "Available content blocks" => "Available content blocks",
// "Future vers" => "Future vers",
// "Program" => "Program",
// "list faqs tpl" => "list faqs tpl",
// "Edit this FAQ:" => "Edit this FAQ:",
// "Create new FAQ" => "Create new FAQ",
// "Create New FAQ:" => "Create New FAQ:",
// "Users can suggest questions" => "Users can suggest questions",
// "Edit a file using this form" => "Edit a file using this form",
// "monitor this gallery" => "monitor this gallery",
// "stop monitoring this gallery" => "stop monitoring this gallery",
// "games tpl" => "games tpl",
// "/" => "/",
// "Flash binary (.sqf or .dcr)" => "Flash binary (.sqf or .dcr)",
// "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)",
// "Edit game" => "Edit game",
// "Played" => "Played",
// "times" => "times",
// "If you can't see the game then you need a flash plugin for your browser" => "If you can't see the game then you need a flash plugin for your browser",
// "list posts tpl" => "list posts tpl",
// "list quizzes tpl" => "list quizzes tpl",
// "edit new submission" => "edit new submission",
// "Approve" => "Approve",
// "edit quiz stats tpl" => "edit quiz stats tpl",
// "Survey stats" => "Survey stats",
// "actions" => "actions",
// "take survey" => "take survey",
// "adm" => "adm",
// "list trackers tpl" => "list trackers tpl",
// "users registered" => "users registered",
// "Distance (km)" => "Distance (km)",
// "List Movies" => "List Movies",
// "Choose a movie" => "Choose a movie",
// "Display" => "Display",
// "admin live support tpl" => "admin live support tpl",
// "Open client window" => "Open client window",
// "Generate HTML" => "Generate HTML",
// "Transcripts" => "Transcripts",
// "Support tickets" => "Support tickets",
// "Online operators" => "Online operators",
// "Accepted requests" => "Accepted requests",
// "transcripts" => "transcripts",
// "Offline operators" => "Offline operators",
// "Add an operator to the system" => "Add an operator to the system",
// "Operators must be tiki users" => "Operators must be tiki users",
// "set as operator" => "set as operator",
// "Chat started" => "Chat started",
// "Operator:" => "Operator:",
// "Live support:User window" => "Live support:User window",
// "Request live support" => "Request live support",
// "Request support" => "Request support",
// "Open a support ticket instead" => "Open a support ticket instead",
// "Your request is being processed" => "Your request is being processed",
// "cancel request and exit" => "cancel request and exit",
// "cancel request and leave a message" => "cancel request and leave a message",
// "Live support:Console" => "Live support:Console",
// "be online" => "be online",
// "be offline" => "be offline",
// "Support requests" => "Support requests",
// "Requested" => "Requested",
// "Accept" => "Accept",
// "Join" => "Join",
// "Support chat transcripts" => "Support chat transcripts",
// "back to admin" => "back to admin",
// "operator" => "operator",
// "Transcript" => "Transcript",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "Or enter path or URL" => "Or enter path or URL",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
// "Tikiwiki Mods" => "Tikiwiki Mods",
// "Mods Configuration" => "Mods Configuration",
// "Update remote index" => "Update remote index",
// "Rebuild local list" => "Rebuild local list",
// "Republish all" => "Republish all",
// "Publish all" => "Publish all",
// "Unpublish all" => "Unpublish all",
// "Attention" => "Attention",
// "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or \nupgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \n\"./fixperms.sh fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\")." => "To install, remove or upgrade packages you need to give the apache user the right\nto write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that\npermission (using \"./fixperms.sh fix\").",
// "all types" => "all types",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "install" => "install",
// "Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuration",
// "Enable Mods providing" => "Enable Mods providing",
// "Mods local directory" => "Mods local directory",
// "Mods remote server" => "Mods remote server",
// "Package Config" => "Package Config",
// "my tiki tpl" => "my tiki tpl",
// "Last editor" => "Last editor",
// "Last modification" => "Last modification",
// "y" => "y",
// "subscribe" => "subscribe",
// "Sent edition" => "Sent edition",
// "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed.",
// "Your email address was removed from the list of subscriptors." => "Your email address was removed from the list of subscriptors.",
// "Subscription confirmed!" => "Subscription confirmed!",
// "Subscribe to newsletter" => "Subscribe to newsletter",
// "Email:" => "Email:",
// "Available Newsletters" => "Available Newsletters",
// "Reading article from" => "Reading article from",
// "Back to list of articles" => "Back to list of articles",
// "Configure Newsreader" => "Configure Newsreader",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Read the news" => "Read the news",
// "Orphan Pages" => "Orphan Pages",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "rollback to this version" => "rollback to this version",
// "Source of version" => "Source of version",
// "s=source" => "s=source",
// "b=rollback" => "b=rollback",
// "remove from this page" => "remove from this page",
// "remove from this structure" => "remove from this structure",
// "Pick your avatar" => "Pick your avatar",
// "Your current avatar" => "Your current avatar",
// "no avatar" => "no avatar",
// "Pick avatar from the library" => "Pick avatar from the library",
// "icons" => "icons",
// "Avatar Image" => "Avatar Image",
// "Any" => "Any",
// "lastModif" => "lastModif",
// "Number of voices" => "Number of voices",
// "View Results" => "View Results",
// "Note: Remember that this is only a preview, and has not yet been saved!" => "Note: Remember that this is only a preview, and has not yet been saved!",
// "Print multiple pages" => "Print multiple pages",
// "Print Wiki Pages" => "Print Wiki Pages",
// "add structure" => "add structure",
// "clear" => "clear",
// "Edit quiz" => "Edit quiz",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "Quiz result stats" => "Quiz result stats",
// "Quiz" => "Quiz",
// "Time" => "Time",
// "User answers" => "User answers",
// "Stats for quizzes" => "Stats for quizzes",
// "taken" => "taken",
// "Av score" => "Av score",
// "Av time" => "Av time",
// "Stats for quiz" => "Stats for quiz",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "P" => "P",
// "F" => "F",
// "Stats for this quiz Questions " => "Stats for this quiz Questions ",
// "received articles tpl" => "received articles tpl",
// "Edit received article" => "Edit received article",
// "Use Image" => "Use Image",
// "Image x size" => "Image x size",
// "Image y size" => "Image y size",
// "Image name" => "Image name",
// "Accept Article" => "Accept Article",
// "Help on Communication Center" => "Help on Communication Center",
// "received pages tpl" => "received pages tpl",
// "Edit received page" => "Edit received page",
// "admin Referer stats" => "admin Referer stats",
// "admin Referer stats tpl" => "admin Referer stats tpl",
// "A valid email is mandatory to register" => "A valid email is mandatory to register",
// "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent<br />registration emails being canned by your spam filter!",
// "Tiki site registered" => "Tiki site registered",
// "You don't have permission to use this feature." => "You don't have permission to use this feature.",
// "Please register." => "Please register.",
// "Read this first!" => "Read this first!",
// "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites.",
// "Registering is voluntary." => "Registering is voluntary.",
// "Registering does not give you any benefits except one more link to your site." => "Registering does not give you any benefits except one more link to your site.",
// "You don't get any emails, we don't sell the data about your site." => "You don't get any emails, we don't sell the data about your site.",
// "Registering is just for us to get an overview of Tiki's usage." => "Registering is just for us to get an overview of Tiki's usage.",
// "If your site is private or inside your intranet, you should not register!" => "If your site is private or inside your intranet, you should not register!",
// "tikiwiki.org" => "tikiwiki.org",
// "Information about your site" => "Information about your site",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Change" => "Change",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "Rollback page" => "Rollback page",
// "to_version" => "to_version",
// "Search Stats" => "Search Stats",
// "search stats tpl" => "search stats tpl",
// "searched" => "searched",
// "trackers" => "trackers",
// "entire site" => "entire site",
// "wiki pages" => "wiki pages",
// "Simple search" => "Simple search",
// "No pages matched the search criteria" => "No pages matched the search criteria",
// "Send blog post" => "Send blog post",
// "A link to this post was sent to the following addresses:" => "A link to this post was sent to the following addresses:",
// "Send post to this addresses" => "Send post to this addresses",
// "List of email addresses separated by commas" => "List of email addresses separated by commas",
// "Apply content template" => "Apply content template",
// "admin send objects tpl" => "admin send objects tpl",
// "Transmission results" => "Transmission results",
// "Send objects to this site" => "Send objects to this site",
// "site" => "site",
// "Send Wiki Pages" => "Send Wiki Pages",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "create new sheet" => "create new sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Graph" => "Graph",
// "admin Tiki Shoutbox" => "admin Tiki Shoutbox",
// "admin Tiki Shoutbox tpl" => "admin Tiki Shoutbox tpl",
// "auto-link urls" => "auto-link urls",
// "first" => "first",
// "big grin" => "big grin",
// "confused" => "confused",
// "cool" => "cool",
// "cry" => "cry",
// "eek" => "eek",
// "evil" => "evil",
// "lol" => "lol",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "smile" => "smile",
// "surprised" => "surprised",
// "twisted" => "twisted",
// "arrow" => "arrow",
// "santa" => "santa",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Usage chart" => "Usage chart",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Stats for surveys" => "Stats for surveys",
// "Survey" => "Survey",
// "Last taken" => "Last taken",
// "Stats for survey" => "Stats for survey",
// "Stats for this survey Questions " => "Stats for this survey Questions ",
// "SysLog" => "SysLog",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Time Left" => "Time Left",
// "Result" => "Result",
// "Thank you for your submission" => "Thank you for your submission",
// "Theme Control Center: categories" => "Theme Control Center: categories",
// "ThemeControl" => "ThemeControl",
// "ThemeControl tpl" => "ThemeControl tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "Theme is selected as follows" => "Theme is selected as follows",
// "If a theme is assigned to the individual object that theme is used." => "If a theme is assigned to the individual object that theme is used.",
// "If not then if a theme is assigned to the object's category that theme is used" => "If not then if a theme is assigned to the object's category that theme is used",
// "If not then a theme for the section is used" => "If not then a theme for the section is used",
// "If none of the above was selected the user theme is used" => "If none of the above was selected the user theme is used",
// "Finally if the user didn't select a theme the default theme is used" => "Finally if the user didn't select a theme the default theme is used",
// "Control by Objects" => "Control by Objects",
// "Control by Sections" => "Control by Sections",
// "Assign themes to categories" => "Assign themes to categories",
// "Assigned categories" => "Assigned categories",
// "Theme Control Center: Objects" => "Theme Control Center: Objects",
// "ThemeControl Objects" => "ThemeControl Objects",
// "theme control objects tpl" => "theme control objects tpl",
// "Control by Categories" => "Control by Categories",
// "Assign themes to objects" => "Assign themes to objects",
// "Theme Control Center: sections" => "Theme Control Center: sections",
// "theme control sections tpl" => "theme control sections tpl",
// "Assign themes to sections" => "Assign themes to sections",
// "Assigned sections" => "Assigned sections",
// "Edit File:" => "Edit File:",
// "Upload File" => "Upload File",
// "File Title" => "File Title",
// "Batch upload" => "Batch upload",
// "The following file was successfully uploaded" => "The following file was successfully uploaded",
// "You can download this file using" => "You can download this file using",
// "You can include the file in an HTML/Tiki page using" => "You can include the file in an HTML/Tiki page using",
// "You have to \ncreate a gallery first!" => "You have to \ncreate a gallery first!",
// "Image Gallery tpl" => "Image Gallery tpl",
// "or use filename" => "or use filename",
// "Note: Maximum image size is limited to" => "Note: Maximum image size is limited to",
// "Image ID thumb" => "Image ID thumb",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "User assigned modules" => "User assigned modules",
// "User Assigned Modules" => "User Assigned Modules",
// "User Assigned Modules tpl" => "User Assigned Modules tpl",
// "move to right column" => "move to right column",
// "unassign" => "unassign",
// "move to left column" => "move to left column",
// "Assign module" => "Assign module",
// "Module" => "Module",
// "Column" => "Column",
// "User Bookmarks tpl" => "User Bookmarks tpl",
// "Folder in" => "Folder in",
// "Homepage" => "Homepage",
// "Users HomePage" => "Users HomePage",
// "Personal Wiki Page" => "Personal Wiki Page",
// "Create page" => "Create page",
// "This user is your friend" => "This user is your friend",
// "Request friendship from this user" => "Request friendship from this user",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "UserPreferences tpl" => "UserPreferences tpl",
// "use google map locator" => "use google map locator",
// "View extra information" => "View extra information",
// "Change information" => "Change information",
// "UTC" => "UTC",
// "Change administrative info" => "Change administrative info",
// "My workflow" => "My workflow",
// "User Tasks tpl" => "User Tasks tpl",
// "New task" => "New task",
// "Task list" => "Task list",
// "Admin mode off" => "Admin mode off",
// "Admin mode on" => "Admin mode on",
// "Task help" => "Task help",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "accepted by task user and creator" => "accepted by task user and creator",
// "accepted user and creator" => "accepted user and creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "not accepted by one user" => "not accepted by one user",
// "not accepted user" => "not accepted user",
// "Task is rejected by one user" => "Task is rejected by one user",
// "waiting for me" => "waiting for me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "waiting for other user" => "waiting for other user",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "admin mode" => "admin mode",
// "trash" => "trash",
// "empty trash" => "empty trash",
// "Edit task" => "Edit task",
// "red" => "red",
// "NOT accept" => "NOT accept",
// "remove from trash" => "remove from trash",
// "move into trash" => "move into trash",
// "Task saved" => "Task saved",
// "Edit Task" => "Edit Task",
// "View Task" => "View Task",
// "Open a new task" => "Open a new task",
// "taskId" => "taskId",
// "Task user" => "Task user",
// "Only the creator can delete this task" => "Only the creator can delete this task",
// "use start date and time" => "use start date and time",
// "use end date and time" => "use end date and time",
// "open / in process" => "open / in process",
// "waiting / not started" => "waiting / not started",
// "waiting" => "waiting",
// "shared for group" => "shared for group",
// "accepted by user" => "accepted by user",
// "no / rejected" => "no / rejected",
// "accepted by creator" => "accepted by creator",
// "Info" => "Info",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Send message with changes" => "Send message with changes",
// "Modified by" => "Modified by",
// "Marked as deleted" => "Marked as deleted",
// "Inform task user by email" => "Inform task user by email",
// "You can only view this task" => "You can only view this task",
// "%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
// "select one" => "select one",
// "undo trash" => "undo trash",
// "show:" => "show:",
// "received" => "received",
// "submitted" => "submitted",
// "shared" => "shared",
// "all shared tasks" => "all shared tasks",
// "completed (100%)" => "completed (100%)",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Add Watch" => "Add Watch",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user edited a wiki page" => "A user edited a wiki page",
// "edit user files" => "edit user files",
// "User_versions_for" => "User_versions_for",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "Banner stats" => "Banner stats",
// "Create new banner" => "Create new banner",
// "Banner Information" => "Banner Information",
// "Click ratio" => "Click ratio",
// "Weekdays" => "Weekdays",
// "mon" => "mon",
// "tue" => "tue",
// "wed" => "wed",
// "thu" => "thu",
// "fri" => "fri",
// "sat" => "sat",
// "sun" => "sun",
// "Banner raw data" => "Banner raw data",
// "Cached" => "Cached",
// "This is a cached version of the page." => "This is a cached version of the page.",
// "Click here to view the Google cache of the page instead." => "Click here to view the Google cache of the page instead.",
// "viewed" => "viewed",
// "edit items" => "edit items",
// "list charts" => "list charts",
// "last chart" => "last chart",
// "previous chart" => "previous chart",
// "Chart created" => "Chart created",
// "next chart" => "next chart",
// "pos" => "pos",
// "pre" => "pre",
// "permanency" => "permanency",
// "item" => "item",
// "chg" => "chg",
// "avg" => "avg",
// "info/vote" => "info/vote",
// "Next chart will be generated on" => "Next chart will be generated on",
// "View or vote items not listed in the chart" => "View or vote items not listed in the chart",
// "Select something to vote on" => "Select something to vote on",
// "Item information" => "Item information",
// "Chart" => "Chart",
// "Permanency" => "Permanency",
// "Dif" => "Dif",
// "Best Position" => "Best Position",
// "Vote this item" => "Vote this item",
// "Highest" => "Highest",
// "view faq" => "view faq",
// "view faq tpl" => "view faq tpl",
// "admin menus tpl" => "admin menus tpl",
// "Answers" => "Answers",
// "Q" => "Q",
// "A" => "A",
// "add suggestion" => "add suggestion",
// "1 suggestion" => "1 suggestion",
// "suggestions" => "suggestions",
// "monitor this forum" => "monitor this forum",
// "stop monitoring this forum" => "stop monitoring this forum",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Your message has been queued for approval, the message will be posted after\na moderator approves it.",
// "You have to enter a title and text" => "You have to enter a title and text",
// "merge" => "merge",
// "reported messages:" => "reported messages:",
// "Merge into topic" => "Merge into topic",
// "emot" => "emot",
// "pts" => "pts",
// "topics in this forum" => "topics in this forum",
// " unread private messages" => " unread private messages",
// "posts:" => "posts:",
// "IRC log" => "IRC log",
// "Select" => "Select",
// "Show All" => "Show All",
// "Edit fields" => "Edit fields",
// "Insert new item" => "Insert new item",
// " item found" => " item found",
// " items found" => " items found",
// "list attachments" => "list attachments",
// "View inserted item" => "View inserted item",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Tracker item:" => "Tracker item:",
// "View item" => "View item",
// "Filter Tracker Items" => "Filter Tracker Items",
// "Add a comment" => "Add a comment",
// "Attach a file to this item" => "Attach a file to this item",
// "more info" => "more info",
// "No attachments for this item" => "No attachments for this item",
// "remove image" => "remove image",
// "Special Operations" => "Special Operations",
// "Webmail Doc" => "Webmail Doc",
// "Webmail Doc template" => "Webmail Doc template",
// "settings" => "settings",
// "mailbox" => "mailbox",
// "compose" => "compose",
// "contacts" => "contacts",
// "Contacts" => "Contacts",
// "Edit mail account" => "Edit mail account",
// "pop" => "pop",
// "View All" => "View All",
// "Msg" => "Msg",
// "clip" => "clip",
// "back to mailbox" => "back to mailbox",
// "full headers" => "full headers",
// "normal headers" => "normal headers",
// "reply all" => "reply all",
// "forward" => "forward",
// "Create/edit contacts" => "Create/edit contacts",
// "First Name" => "First Name",
// "Last Name" => "Last Name",
// "select from address book" => "select from address book",
// "cc" => "cc",
// "bcc" => "bcc",
// "Use HTML mail" => "Use HTML mail",
// "The following addresses are not in your address book" => "The following addresses are not in your address book",
// "add contacts" => "add contacts",
// "Attachment 1" => "Attachment 1",
// "Attachment 2" => "Attachment 2",
// "Attachment 3" => "Attachment 3",
// "Address book" => "Address book",
// "%s enabled" => "%s enabled",
// "%s disabled" => "%s disabled",
// "Enable/disable Tiki features here, but configure them elsewhere" => "Enable/disable Tiki features here, but configure them elsewhere",
// "User registration, login and authentication" => "User registration, login and authentication",
// "Wiki Attachments" => "Wiki Attachments",
// "Article/CMS settings" => "Article/CMS settings",
// "Configuration options for all blogs on your site" => "Configuration options for all blogs on your site",
// "FAQ comments settings" => "FAQ comments settings",
// "Trackers settings" => "Trackers settings",
// "RSS settings" => "RSS settings",
// "Directory settings" => "Directory settings",
// "Maps configuration" => "Maps configuration",
// "Meta Tags settings" => "Meta Tags settings",
// "Search settings" => "Search settings",
// "Score settings" => "Score settings",
// "Projects" => "Projects",
// "Projects configuration" => "Projects configuration",
// "Community settings" => "Community settings",
// "Site Identity features" => "Site Identity features",
// "Calendar settings" => "Calendar settings",
// "Intertiki settings" => "Intertiki settings",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Click here to delete this category" => "Click here to delete this category",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Detected, Version:" => "Detected, Version:",
// "Not detected." => "Not detected.",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Your admin password has been changed" => "Your admin password has been changed",
// "All Fields except gdaltindex must be filled" => "All Fields except gdaltindex must be filled",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Repository name can't be an empty" => "Repository name can't be an empty",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "No repository" => "No repository",
// "Search is mandatory field" => "Search is mandatory field",
// "File not found " => "File not found ",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Non-existent link" => "Non-existent link",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "unsafe" => "unsafe",
// "register_globals should be off by default. See the php manual for details." => "register_globals should be off by default. See the php manual for details.",
// "safe" => "safe",
// "session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid should be off by default. See the php manual for details.",
// "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser",
// "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config.",
// "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off.",
// "The Path to store files in the filegallery should be outside the tiki root directory" => "The Path to store files in the filegallery should be outside the tiki root directory",
// "The Path to store files in the imagegallery should be outside the tiki root directory" => "The Path to store files in the imagegallery should be outside the tiki root directory",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code.",
// "installed" => "installed",
// "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html.",
// "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement.",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "File is not readable. Unable to check." => "File is not readable. Unable to check.",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// " or " => " or ",
// "You have to provide a word" => "You have to provide a word",
// "You must specify a page name, it will be created if it doesn't exist." => "You must specify a page name, it will be created if it doesn't exist.",
// "No Errors detected" => "No Errors detected",
// "Created account %s <%s>" => "Created account %s <%s>",
// "Assigned %s in group %s" => "Assigned %s in group %s",
// "User %s already exists" => "User %s already exists",
// "New %s created with %s %s." => "New %s created with %s %s.",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "%s %s successfully deleted." => "%s %s successfully deleted.",
// "%s %s removed from %s %s." => "%s %s removed from %s %s.",
// "%s <b>%s</b> successfully deleted." => "%s <b>%s</b> successfully deleted.",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "%s modified successfully." => "%s modified successfully.",
// "%s modification failed." => "%s modification failed.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "Tiki RSS feed for articles" => "Tiki RSS feed for articles",
// "Last articles." => "Last articles.",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Permission denied you cannot view backlinks for this page" => "Permission denied you cannot view backlinks for this page",
// "Image Galleries Admin Panel" => "Image Galleries Admin Panel",
// "Could not read image %s." => "Could not read image %s.",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Incorrect directory chosen for batch upload of images." => "Incorrect directory chosen for batch upload of images.",
// "Please setup that dir on " => "Please setup that dir on ",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Invalid directory name" => "Invalid directory name",
// "No blogId specified" => "No blogId specified",
// "Tiki RSS feed for blog: " => "Tiki RSS feed for blog: ",
// "Tiki RSS feed for weblogs" => "Tiki RSS feed for weblogs",
// "Last posts to weblogs." => "Last posts to weblogs.",
// "No gallery indicated" => "No gallery indicated",
// "Please login" => "Please login",
// "Permission denied you cannot view the calendar" => "Permission denied you cannot view the calendar",
// "event without name" => "event without name",
// "First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "First day of week: Sunday (its ID is 0) - translators you need to localize this string!",
// "%m/%d" => "%m/%d",
// "Access Denied" => "Access Denied",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "Start:" => "Start:",
// "End:" => "End:",
// "No category indicated" => "No category indicated",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "The passwords didn't match" => "The passwords didn't match",
// "You can not use the same password again" => "You can not use the same password again",
// "Invalid old password" => "Invalid old password",
// "No channel indicated" => "No channel indicated",
// "No nickname indicated" => "No nickname indicated",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "Tiki RSS feed for directory sites" => "Tiki RSS feed for directory sites",
// "Last sites." => "Last sites.",
// "Must enter a name to add a site. " => "Must enter a name to add a site. ",
// "Must enter a url to add a site. " => "Must enter a url to add a site. ",
// "URL already added to the directory. Duplicate site? " => "URL already added to the directory. Duplicate site? ",
// "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. ",
// "Must select a category. " => "Must select a category. ",
// "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory",
// "No site indicated" => "No site indicated",
// "Site No validated yet" => "Site No validated yet",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "You do not have permission to write the style sheet" => "You do not have permission to write the style sheet",
// "Shortname must be 2 Characters" => "Shortname must be 2 Characters",
// "You must provide a longname" => "You must provide a longname",
// "No content id indicated" => "No content id indicated",
// "No quiz indicated" => "No quiz indicated",
// "No structure indicated" => "No structure indicated",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "Permission denied you cannot send submissions" => "Permission denied you cannot send submissions",
// "Permission denied you cannot edit submissions" => "Permission denied you cannot edit submissions",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "No topic id specified" => "No topic id specified",
// "Invalid topic id specified" => "Invalid topic id specified",
// "No object indicated" => "No object indicated",
// "No type indicated" => "No type indicated",
// "page imported" => "page imported",
// "created from import" => "created from import",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "Can't import remote HTML page" => "Can't import remote HTML page",
// "Can't parse remote HTML page" => "Can't parse remote HTML page",
// "unknown error" => "unknown error",
// "cannot be found" => "cannot be found",
// "No permission to view the page" => "No permission to view the page",
// "No questions group indicated" => "No questions group indicated",
// "Last files" => "Last files",
// "Tiki RSS feed for file galleries" => "Tiki RSS feed for file galleries",
// "Last files uploaded to the file galleries." => "Last files uploaded to the file galleries.",
// "No galleryId specified" => "No galleryId specified",
// "Tiki RSS feed for the file gallery: " => "Tiki RSS feed for the file gallery: ",
// "No forumId specified" => "No forumId specified",
// "Tiki RSS feed for forum: " => "Tiki RSS feed for forum: ",
// "Tiki RSS feed for forums" => "Tiki RSS feed for forums",
// "Last topics in forums." => "Last topics in forums.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "Invalid username" => "Invalid username",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request!" => "I have refused your friendship request!",
// "No process indicated" => "No process indicated",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Activity name already exists" => "Activity name already exists",
// "indicates if the process is active. Invalid processes cant be active" => "indicates if the process is active. Invalid processes cant be active",
// "No instance indicated" => "No instance indicated",
// "No activity indicated" => "No activity indicated",
// "The process name already exists" => "The process name already exists",
// "Process already exists" => "Process already exists",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You cant execute this activity" => "You cant execute this activity",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "No title indicated" => "No title indicated",
// "No comment indicated" => "No comment indicated",
// "No date indicated" => "No date indicated",
// "No item indicated" => "No item indicated",
// "first uploaded image" => "first uploaded image",
// "last uploaded image" => "last uploaded image",
// "random image" => "random image",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Tiki RSS feed for image galleries" => "Tiki RSS feed for image galleries",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Tiki RSS feed for the image gallery: " => "Tiki RSS feed for the image gallery: ",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "No repository given" => "No repository given",
// "Permission denied you cannot view pages like this page" => "Permission denied you cannot view pages like this page",
// "Non-existent gallery" => "Non-existent gallery",
// "Permission denied you cannot remove files from this gallery" => "Permission denied you cannot remove files from this gallery",
// "Permission denied you can't upload files so you can't edit them" => "Permission denied you can't upload files so you can't edit them",
// "Permission denied you cannot edit this file" => "Permission denied you cannot edit this file",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "The thumbnail name must be" => "The thumbnail name must be",
// "Please supply both files" => "Please supply both files",
// "Permission denied you cannot remove submissions" => "Permission denied you cannot remove submissions",
// "Permission denied you cannot approve submissions" => "Permission denied you cannot approve submissions",
// "Permission denied you cannot remove pages" => "Permission denied you cannot remove pages",
// "You have to enable cookies to be able to login to this site" => "You have to enable cookies to be able to login to this site",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Sorry, you can't use this feature." => "Sorry, you can't use this feature.",
// "You do not have permissions to view the maps" => "You do not have permissions to view the maps",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "Please create a directory named \$map_path to hold your map files." => "Please create a directory named \$map_path to hold your map files.",
// "mapfile name incorrect" => "mapfile name incorrect",
// "This mapfile already exists" => "This mapfile already exists",
// "You do not have permission to write to the mapfile" => "You do not have permission to write to the mapfile",
// "You do not have permission to delete the mapfile" => "You do not have permission to delete the mapfile",
// "I could not make a copy" => "I could not make a copy",
// "You do not have permission to read the mapfile" => "You do not have permission to read the mapfile",
// "You dont have permission to do that" => "You dont have permission to do that",
// "Tiki RSS feed for maps" => "Tiki RSS feed for maps",
// "List of maps available." => "List of maps available.",
// "You do not have permissions to view the layers" => "You do not have permissions to view the layers",
// "Could not upload the file" => "Could not upload the file",
// "You do not have permissions to delete a file" => "You do not have permissions to delete a file",
// "File not found" => "File not found",
// "You do not have permissions to create a directory" => "You do not have permissions to create a directory",
// "The Directory is not empty" => "The Directory is not empty",
// "You do not have permissions to delete a directory" => "You do not have permissions to delete a directory",
// "You do not have permissions to create an index file" => "You do not have permissions to create an index file",
// "Invalid file name" => "Invalid file name",
// "Invalid files to index" => "Invalid files to index",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "I could not create the index file" => "I could not create the index file",
// "Welcome at Hawiki" => "Welcome at Hawiki",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more.",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:",
// "tiki-mobile.php" => "tiki-mobile.php",
// "About" => "About",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "Your PHP installation does not have zlib enabled." => "Your PHP installation does not have zlib enabled.",
// "Missing information to read news (server,port,username,password,group) required" => "Missing information to read news (server,port,username,password,group) required",
// "No note indicated" => "No note indicated",
// "merged note:" => "merged note:",
// "created from notepad" => "created from notepad",
// "No name indicated for wiki page" => "No name indicated for wiki page",
// "Page already exists" => "Page already exists",
// "Permission denied you cannot assign permissions for this page" => "Permission denied you cannot assign permissions for this page",
// "Not enough information to display this page" => "Not enough information to display this page",
// "Permission denied you cannot browse this page history" => "Permission denied you cannot browse this page history",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "No result indicated" => "No result indicated",
// "Registered" => "Registered",
// "Wrong registration code" => "Wrong registration code",
// "Username is too long" => "Username is too long",
// "Username cannot contain whitespace" => "Username cannot contain whitespace",
// "Wrong passcode you need to know the passcode to register in this site" => "Wrong passcode you need to know the passcode to register in this site",
// "Invalid email address. You must enter a valid email address" => "Invalid email address. You must enter a valid email address",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "A password and your IP address reminder email has been sent " => "A password and your IP address reminder email has been sent ",
// "A new (and temporary) password and your IP address has been sent " => "A new (and temporary) password and your IP address has been sent ",
// "to the registered email address for" => "to the registered email address for",
// "Invalid or unknown username" => "Invalid or unknown username",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Non-existent version" => "Non-existent version",
// "Permission denied you cannot rollback this page" => "Permission denied you cannot rollback this page",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "Post recommendation at" => "Post recommendation at",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "No newsletters available." => "No newsletters available.",
// "Error: " => "Error: ",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "An error occurred." => "An error occurred.",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "This feature is for admins only" => "This feature is for admins only",
// "Quiz time limit exceeded quiz cannot be computed" => "Quiz time limit exceeded quiz cannot be computed",
// "You cannot take this survey twice" => "You cannot take this survey twice",
// "No trackerId specified" => "No trackerId specified",
// "Tiki RSS feed for individual trackers: " => "Tiki RSS feed for individual trackers: ",
// "Invalid filename (using filters for filenames)" => "Invalid filename (using filters for filenames)",
// "No permission to upload zipped file packages" => "No permission to upload zipped file packages",
// "Cannot read file" => "Cannot read file",
// "File update was successful" => "File update was successful",
// "Permission denied you cannot upload files" => "Permission denied you cannot upload files",
// "Could not find the file requested" => "Could not find the file requested",
// "Permission denied you can upload files but not to this file gallery" => "Permission denied you can upload files but not to this file gallery",
// "Error processing zipped image package" => "Error processing zipped image package",
// "No permission to upload zipped image packages" => "No permission to upload zipped image packages",
// "The uploaded file ist not recognized as a image" => "The uploaded file ist not recognized as a image",
// "Permission denied you cannot upload images" => "Permission denied you cannot upload images",
// "Permission denied you can upload images but not to this gallery" => "Permission denied you can upload images but not to this gallery",
// "Cannot get image from URL" => "Cannot get image from URL",
// "That is not an image (or you have php < 4.0.5)" => "That is not an image (or you have php < 4.0.5)",
// "cannot process upload" => "cannot process upload",
// "Usage" => "Usage",
// "No url indicated" => "No url indicated",
// "You are not logged in and no user indicated" => "You are not logged in and no user indicated",
// "The user has chosen to make his information private" => "The user has chosen to make his information private",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "Email is set to %s" => "Email is set to %s",
// "The passwords did not match" => "The passwords did not match",
// "unicode" => "unicode",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Changes:" => "Changes:",
// "Info message" => "Info message",
// "NEW Task" => "NEW Task",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "Changes on Task" => "Changes on Task",
// "You received a new task" => "You received a new task",
// "The priority is" => "The priority is",
// "very low" => "very low",
// "low" => "low",
// "high" => "high",
// "very high" => "very high",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Cannot upload this file not enough quota" => "Cannot upload this file not enough quota",
// "Non-existent user" => "Non-existent user",
// "No banner indicated" => "No banner indicated",
// "Permission denied you cannot remove trackbacks" => "Permission denied you cannot remove trackbacks",
// "No faq indicated" => "No faq indicated",
// "You are not permitted to remove someone else\\'s post!" => "You are not permitted to remove someone else\\'s post!",
// "A SheetId is required." => "A SheetId is required.",
// "Your email address has been removed from the list of addresses monitoring this tracker" => "Your email address has been removed from the list of addresses monitoring this tracker",
// "Your email address has been added to the list of addresses monitoring this tracker" => "Your email address has been added to the list of addresses monitoring this tracker",
// "Cancel monitoring" => "Cancel monitoring",
// "Monitor" => "Monitor",
// "Your email address has been removed from the list of addresses monitoring this item" => "Your email address has been removed from the list of addresses monitoring this item",
// "Your email address has been added to the list of addresses monitoring this item" => "Your email address has been added to the list of addresses monitoring this item",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "No subject" => "No subject",
// "Your email was sent" => "Your email was sent",
// "Tiki RSS feed for the wiki pages" => "Tiki RSS feed for the wiki pages",
// "Last modifications to the Wiki." => "Last modifications to the Wiki.",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Cc" => "Cc",
"Admin" => "Admin",
"creates a title bar" => "creates a title bar",
"Mb" => "Mb",
// ###
// ### end of possibly untranslated words
// ###

"Missing title or body when trying to post a comment" => "Hiányzó cím vagy test megjegyzés postázásakor",
"The copyright management feature is not enabled." => "A szerzői jogok kezelése funkció nincs bekapcsolva.",
"You do not have permission to use this feature." => "Nincs jogod e funkció használatára.",
"You must supply all the information, including title and year." => "Minden információt meg kell adnod, különösen címet és az évet is.",
"You do not have permission to use this feature" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt megtekintsd.",
"This feature is disabled" => "Ez a funkció most nincs bekapcsolva",
"Croatia" => "Horvátország",
"Cuba" => "Kuba",
"Cyprus" => "Ciprus",
"Czech_Republic" => "Csehország",
"Denmark" => "Dánia",
"Egypt" => "Egyiptom",
"France" => "Franciaország",
"Germany" => "Németország",
"Greece" => "Görögország",
"Hungary" => "Magyarország",
"China" => "Kína",
"Indonesia" => "Indonézia",
"Iran" => "Irán",
"Iraq" => "Irák",
"Ireland" => "Írország",
"Israel" => "Izrael",
"Italy" => "Olaszország",
"Japan" => "Japán",
"Lebanon" => "Libanon",
"Lithuania" => "Litvánia",
"Malaysia" => "Malájzia",
"Malta" => "Málta",
"Mexico" => "Mexikó",
"Morocco" => "Marokkó",
"Nepal" => "Nepál",
"Netherlands" => "Hollandia",
"New_Zealand" => "Új-Zéland",
"Nigeria" => "Nigéria",
"None" => "Nincs",
"Norway" => "Norvégia",
"Other" => "egyéb",
"Simplified Chinese" => "egyszerűsített kínai",
"Chinese" => "kínai",
"Czech" => "cseh",
"Danish" => "dán",
"German" => "német",
"English" => "angol",
"Spanish" => "spanyol",
"Greek" => "görög",
"French" => "francia",
"Hebrew" => "jiddis",
"Croatian" => "horvát",
"Italian" => "olasz",
"Japanese" => "japán",
"Korean" => "koreai",
"Hungarian" => "magyar",
"Dutch" => "holland",
"Norwegian" => "norvég",
"Polish" => "lengyel",
"Português" => "portugál",
"Russian" => "orosz",
"Slovak" => "szlovák",
"Serbian" => "szerb",
"Swedish" => "svéd",
"Traditional Chinese" => "hagyományos kínai",
"Ukrainian" => "Ukrajna",
"by" => "szerző",
"refresh" => "frissít",
"locked" => "lezárva",
"locked by" => "lezárta:",
"in" => "itt",
"new image uploaded by" => "Az új képet feltöltötte:",
"uploaded by" => "Feltöltötte:",
"not specified" => "nincs meghatározva",
"The file is not a CSV file or has not a correct syntax" => "Ez vagy nem egy vesszővel elválasztott (CSV) fájl, vagy rossz a fájl belső formátuma",
"article" => "hír",
"directory" => "könytár",
"faq" => "gyik",
"forum" => "fórum",
"poll" => "szavazás",
"quiz" => "kvíz",
"tracker" => "űrlap",
"image" => "kép",
"calendar" => "naptár",
"Cannot upload this file maximum upload size exceeded" => "Túl nagy a fájl, nem tudom feltölteni",
"Cannot write to this file:" => "Nem tudok írni ebbe a fájlba:",
"Wiki Home" => "Wiki főoldal",
"Home" => "Főoldal",
"Blogs" => "Naplók",
"previous page" => "előző oldal",
"next page" => "következő oldal",
"posted on" => "beküldés időpontja:",
"Articles" => "Hírek",
"By:" => "Készítette:",
"Read" => "Olvasott",
"List articles" => "Hírek listázása",
"Forums" => "Fórumok",
"Last post" => "Utolsó küldés",
"Errors detected" => "Hiba lépett fel...",
"No image yet, sorry." => "Még nincs kép, bocsi...",
"Wiki top pages" => "Kitűnő wiki oldalak",
"Hits" => "Látogatók",
"Most relevant pages" => "Legrelevánsabb oldalak",
"Relevance" => "Relevancia",
"Wiki last pages" => "Legújabb wiki oldalak",
"Modified" => "Módosítva",
"Forums last topics" => "A legújabb üzenetek a fórumon:",
"Topic date" => "Téma dátuma",
"Forums most read topics" => "A legolvasottabb fórum topic-ok",
"Reads" => "Olvasták",
"Forums best topics" => "A legjobb topic-ok",
"Score" => "Pontszám",
"Forums most visited forums" => "A leglátogatottabb fórumok",
"Visits" => "Látogatások",
"Forums with most posts" => "A legtöbb üzenettel rendelkező fórumok",
"Posts" => "Küldések",
"Wiki top galleries" => "Wiki legjobb galériák",
"Wiki top file galleries" => "Wiki legjobb fájlgyûjtemények",
"Wiki top images" => "Wiki legjobb képek",
"Wiki top files" => "Wiki legjobb fájlok",
"Downloads" => "Letöltések",
"Wiki last images" => "Wiki utóbbi képek",
"Upload date" => "Feltöltés dátuma",
"Most visited blogs" => "Legtöbbet látogatott blog",
"Post date" => "Beküldés időpontja:",
"Wiki top authors" => "A wiki oldalak kiemelkedő szerzői",
"Pages" => "Oldalak",
"Login" => "Belépek",
"Send message" => "Üzenet küldése",
"Attach file" => "Fájl csatolása",
"Tracker" => "Űrlap",
"Unknown" => "Ismeretlen",
"Image Gallery" => "Kép galéria",
"Image" => "Kép",
"Article" => "Cikk",
"Directory" => "Könytár",
"Forum" => "Fórum",
"File Gallery" => "Fájl gyüjtemény",
"Gallery" => "Galéria",
"File" => "fájl",
"help" => "tanácsok",
"from" => "feladó",
"for" => "",
"Priority" => "Fontosság",
"unlocked" => "zár levéve",
"Help" => "Használati útmutató",
"You are banned from" => "Kitiltottak innen:",
"faqs" => "gyakran intézett kérdések",
"blogs" => "naplók",
"forums" => "fórumok",
"games" => "játékok",
"picture not found" => "a kép nem található",
"drawing not found" => "a rajz nem található",
"Removed" => "törölve",
"Created" => "létrejött",
"new" => "új",
"hide" => "elrejtem",
"Updated" => "módosult",
"Unknown language" => "Ismeretlen nyelv",
"Click here to confirm your action" => "Biztosan törlöm ezt az elemet",
"size" => "méret",
"action" => "művelet",
"category" => "kategória",
"open" => "nyitva",
"closed" => "zárva",
"message" => "üzenet",
"child categories" => "gyermek kategóriák",
"objects in category" => "elemek ebben a kategóriában",
"Date" => "Dátum",
"Title" => "Cím",
"Author" => "Szerzö",
"data" => "adat",
"comment" => "hozzászólás",
"username" => "felhasználónév",
"Page cannot be found" => "Ez az oldal nem található!",
"Example" => "Példa",
"days" => "nap",
"hours" => "óra",
"minutes" => "perc",
"seconds" => "másodpercek",
"term" => "fogalom",
"definition" => "definíció",
"Displays a graphical GAUGE" => "Grafikus mérőt mutat",
"description" => "leirás",
"Feature disabled" => "A szolgáltatás ki van kapcsolva",
"Please choose a module" => "Kérem válasszon egy modult",
"to be used as argument" => "amit használni fog paraméterként",
"Displays a module inlined in page" => "A modult a lapon belül jeleníti meg",
"Sorry no such module" => "Sajnálom nincs ilyen modul",
"Displays the data using a monospace font" => "Az adatot monospace betûtípus használatával jeleníti meg",
"No version indicated" => "Nincs verzió feltüntetve",
"Sorts the plugin content in the wiki page" => "A plugin tartalmának wiki lapba sorolása",
"Missing db param" => "Hiányzó db paraméter",
"Save" => "mentem",
"Fields marked with a * are mandatory." => "A csillaggal (*) jelölt mezők kitöltése kötelező.",
"at" => "ekkor",
"valid" => "érvényes",
"failed" => "sikertelen",
"You are not logged in" => "Először <a href=\"tiki-login_scr.php\">jelentkezz be</a> ehhez!",
"Permission denied" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt megtekintsd",
"ERROR: Either the subject or body must be non-empty" => "Írj valamit az üzenet tárgyába és az üzenet tartalmi részébe is!",
"ERROR: No valid users to send the message" => "HIBA: Nincs érvényes felhasználó akinek elküldhetnéd az üzeneted",
"Invalid user" => "Érvénytelen felhasználó",
"Message will be sent to: " => "Az üzenetet neki küldöm: ",
"No more messages" => "Nincs több üzenet",
"edit" => "szerkesztem",
"Quick edit a Wiki page" => "Wiki oldal gyorsszerkesztés",
"Since your last visit" => "Utolsó látogatásod óta",
"since" => "óta",
"new comments" => "új hozzászólás",
"wiki pages changed" => "wiki lap változott",
"new articles" => "új cikk",
"new image galleries" => "új képgaléria",
"new images" => "új kép",
"new files" => "új fájl",
"new users" => "új felhasználó",
"Error" => "Figyelem",
"Invalid username or password" => "Nem megfelelő felhasználónév vagy jelszó",
"List of attached files" => "Csatolt fájlok listája",
"name" => "név",
"desc" => "csökk",
"uploaded" => "feltöltve",
"delete" => "törlöm",
"Remove" => "Eltávolit",
"Upload file" => "Fájl feltöltése",
"attach" => "csatol",
"debug" => "hibakereső",
"Description:" => "Leírás:",
"Created by" => "Készítette",
"Last modified" => "Utolsó módositás",
"Post" => "Bejegyzés",
"post" => "elküldöm",
"posts" => "üzenetek",
"visits" => "látogatások",
"Categorize" => "Kategorizálom",
"show categories" => "megnézem a kategóriákat",
"hide categories" => "elrejtem a kategóriákat",
"Tip: hold down CTRL to select multiple categories" => "Javaslat: a CTRL gomb megnyomásával egyszerre több kategória is kiválasztható",
"categorize this object" => "az objektum kategorizálása",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Tudom: itt jelölöm, hogy tényleg szeretném kategorizálni ezt az oldalt/elemet",
"No categories defined" => "Először magukat a kategóriákat határozzuk meg",
"Admin categories" => "Beállítom a kategóriákat",
"browse category" => "kategória átlapozása",
"author" => "szerző",
"stars" => "sztárok",
"user level" => "felhasználói szint",
"private message" => "magán üzenet",
"send email to user" => "e-mail küldése a felhasználónak",
"user online" => "felhasználó online",
"user offline" => "felhasználó offline",
"on" => "Dátum",
"score" => "pontszám",
"Vote" => "Szavaz",
"Edit" => "Szerkesztem",
"reply" => "válasz",
"Moderator actions" => "Moderátor beavatkozás",
"delete selected" => "kijelöltek törlése",
"Move to topic:" => "Mozgasd ebbe a témába:",
"move" => "mozgatás",
"reported:" => "jelentve:",
"queued:" => "sorban áll:",
"Posted messages" => "Az elküldött hozzászólások",
"Messages" => "Üzeneteid",
"All" => "Összes",
"Style" => "Megjelenítés módja",
"Plain" => "Normál",
"Threaded" => "Hierarhikus",
"Headers Only" => "Csak a fejlécek látszanak",
"Sort" => "Sorrend",
"Newest first" => "Időben csökkenő",
"Oldest first" => "Időben növekvő",
"Threshold" => "Küszöb",
"Find" => "Kutatom",
"set" => "beállít",
"Top" => "forrás",
"Hide all" => "Mindet rejti",
"replies" => "válasz",
"below your current threshold" => "van a küszöbérték alatt",
"prev" => "előző",
"Page" => "Oldal",
"next" => "következő",
"Editing comment" => "Hozzászólás szerkesztése",
"Post new comment" => "Új hozzászólás",
"Preview" => "előnézet",
"Post new reply" => "Új hozzászólás küldése",
"preview" => "előnézet",
"cancel" => "mégsem",
"Required" => "Szükséges",
"Smileys" => "Mosolyok",
"Reply" => "Hozzászólás",
"Comment" => "Hozzászólás",
"Posting replies" => " Általános tudnivalók",
"Posting comments" => "Hozzászólások elküldése",
"Use" => "Használ",
"or" => "vagy",
"for links" => "linkekhez",
"HTML tags are not allowed inside posts" => "HTML tag-ek nem szerepelhetnek az üzenetekben",
"Go back" => "Vissza",
"Return to home page" => "Vissza a honlaphoz",
"Copyrights" => "Szerzöi jogok",
"Year" => "Év",
"Authors" => "Szerzö",
"up" => "fel",
"down" => "le",
"add" => "hozzáadom",
"Total" => "Összesen",
"To the newsletter:" => "Ehhez a hírlevélhez:",
"In order to confirm your subscription you must access the following URL:" => "A feliratkozás tényének megerősítésére meglátogatom a következő címet:",
"A new message was posted to forum" => "Új üzenet van a fórumban",
"New topic:" => "Új téma:",
"Topic:" => "Téma:",
"Message" => "Üzenet",
"Page not found:" => "Nem található ez az oldal:",
"From" => "Feladó",
"Subject" => "Tárgy",
"Enjoy the site!" => "Élvezd a honlapot!",
"You can unsubscribe from this newsletter following this link" => "Erre a linkre kattintva iratkozhatsz le erről a hírlevélről",
"Welcome to our newsletter!" => "Feliratkoztál a hírlevelünkre!",
"This email address has been added to the list of subscriptors of:" => "Az emailcím bekerült a feliratkozottak közé ebben a hírlevélben:",
"You can always cancel your subscription using:" => "Megszüntetheted előfizetésed azzal, hogy ezt használod:",
"Tiki email notification" => "Tiki email-értesítls",
"Title:" => "Cím:",
"Heading:" => "Címsor:",
"Body:" => "Törzs:",
"Your Tiki information registration" => "Regisztrációs adataim",
"You will receive an email with information to login for the first time into this site" => "A megadott emailcímre kapok bővebb információt arról, hogy miként lehet belépni a honlapra",
"Name" => "név",
"File Name" => "Fájlnév",
"Posted by" => "Üzeni",
"File Description" => "Fájl leírása",
"Type" => "Típus",
"Size" => "Méret",
"New name" => "Új neve mától",
"Comments" => "Hozzászólások",
"Legend" => "Rövidítések értelmezése",
"Mapfiles" => "Térkép fájlok",
"Available mapfiles" => "Jelenlegi térképfájlok",
"Actions" => "műveletek",
"hits" => "találat",
"No records found" => "Ebben a felsorolásban nincsenek elemek",
"create" => "készít",
"History" => "Változások",
"save" => "mentem",
"of" => "sorrendje",
"Version" => "Változat",
"compare" => "összehasonlítom ezzel",
"current" => "jelenlegi",
"Versions are identical" => "A verziók megegyeznek!",
"User" => "Felhasználó",
"Action" => "művelet",
"view" => "megtekintem",
"diff" => "megtekintem e változat különbségeit",
"Directories" => "Könyvtárak",
"Files" => "Fájlok",
"Edit template" => "Sablon szerkesztése",
"Unread" => "Nem olvasott",
"Flagged" => "Jelölt",
"Unflagged" => "Nem jelölt",
"Containing" => "tartalmazza",
"filter" => "szűröm",
"download" => "letöltés",
"sender" => "küldő",
"subject" => "tárgy",
"date" => "dátum",
"flagged" => "jelölve",
"No messages to display" => "Nincs megjelenithetö üzenet",
"Broadcast message" => "Körüzenet",
"edit template" => "szerkesztem a sablont",
"Group" => "Csoport",
"All users" => "Minden felhasználó",
"Lowest" => "legalacsonyabb",
"Low" => "Alacsony",
"Normal" => "Közepes",
"High" => "Magas",
"Very High" => "Legmagasabb",
"send" => "elküldöm",
"Compose message" => "Üzenet szerkesztése",
"Compose Message" => "Üzenet szerkesztése",
"To" => "Cimzett",
"move to archive" => "archívumba mozgatom",
"Mark as read" => "Olvasottként jelöl",
"Mark as unread" => "Olvasatlanként jelöl",
"Mark as flagged" => "flagged-ként jelöl",
"Mark as unflagged" => "unflagged-ként jelöl",
"mark" => "jelöl",
"reply to" => "válasz",
"find replied message" => "megválaszolt üzeneteket keresem",
"Mailbox" => "Postaláda",
"Compose" => "Szerkeszt",
"Broadcast" => "Körüzenet",
"Sent" => "Elküldött",
"Archive" => "Archívum",
"Auto-archive age for read messages:" => "Hány naponta archiválja a rendszer automatikusan az üzeneteket:",
"Read message" => "Üzenet olvasása",
"Prev" => "Előző",
"Next" => "Következő",
"Return to mailbox" => "Visszatérek a postafiókhoz",
"replyall" => "válasz mindenkinek",
"Unflag" => "jelölés törlése",
"Flag this message" => "Üzenet megjelölése",
"Return to archive" => "Vissza az archívumba",
"Return to outbox" => "Vissza az elküldöttek mappájába",
"Sent Messages" => "Elküldött üzenetek",
"no" => "nem",
"Move module up" => "Felfelé mozgatom a modult",
"Move module down" => "Lefelé mozgatom a modult",
"remove" => "törlöm",
"Admin Menu" => "Menü Adminisztráció",
"Live support" => "Élő támogatás",
"Banning" => "Kitiltások",
"Users" => "Felhasználók",
"Groups" => "Csoportok",
"Cache" => "Gyorsítótár",
"Modules" => "Modulok",
"Links" => "Kapcsolatok",
"Hotwords" => "Kapcsolódó kulcsszavak",
"RSS modules" => "RSS modulok",
"Menus" => "Menük",
"Polls" => "Szavazások",
"Backups" => "Adatmentések",
"Mail notifications" => "Levél értesítések",
"Search stats" => "Keresési statisztika",
"Categories" => "Kategóriák",
"Banners" => "Bannerek",
"Edit templates" => "Sablonok szerkesztése",
"Admin drawings" => "Rajzok adminisztrációja",
"Cookies" => "Cookie-k",
"Content templates" => "Tartalom sablonok",
"HTML pages" => "HTML oldalak",
"Shoutbox" => "Üzenőfal",
"Shoutbox Words" => "Üzenőfal szóhasználata",
"Referer stats" => "Hivatkozási statisztika",
"Admin dsn" => "DSN adatbáziskapcsolatok beállítása",
"External wikis" => "Külső wikik",
"System Admin" => "Rendszer adminisztrátor",
"Menu" => "Menü",
"Contact us" => "Kapcsolat",
"Stats" => "Statisztikák",
"Games" => "Játékok",
"Calendar" => "Naptár",
"MyTiki" => "Saját Tikim",
"MyTiki home" => "személyes főoldal",
"Preferences" => "beállítások",
"Tasks" => "Feladatok",
"Bookmarks" => "Könyvjelzők",
"Newsreader" => "Hírolvasó",
"Notepad" => "Jegyzettömb",
"My files" => "Fájljaim",
"User menu" => "Menüim",
"Mini calendar" => "Mini naptár",
"My watches" => "Követéseim",
"Workflow" => "Munkafolyamatok",
"Admin processes" => "Folyamatok beállítása",
"Monitor processes" => "Folyamatok követése",
"Monitor activities" => "Műveletek követése",
"Monitor instances" => "Események követése",
"User processes" => "Folyamatok",
"User activities" => "Műveletek",
"User instances" => "Események",
"Community" => "Társaság",
"Friendship Network" => "Baráti körök",
"Last changes" => "Legújabb változások",
"Rankings" => "Rangsor",
"List pages" => "Oldalak listázása",
"Orphan pages" => "Forrás oldalak",
"Sandbox" => "Homokozó",
"Print" => "Kinyomtatom",
"Send pages" => "Oldalak kiküldése",
"Received pages" => "Oldalak fogadása",
"Structures" => "Struktúrák",
"Image Galleries" => "Kép galériák",
"Galleries" => "Galériák",
"Upload image" => "Kép feltöltése",
"System gallery" => "Főgaléria",
"Articles home" => "Hírek főoldala",
"Submit article" => "Hírek beküldése",
"View submissions" => "Beküldött hírek megtekintése",
"Edit article" => "Hír szerkesztése",
"Send articles" => "Hírek kiküldése",
"Received articles" => "Hírek fogadása",
"Admin topics" => "Hírek témáinak beállítása",
"Admin types" => "Hírek típusainak beállítása",
"List blogs" => "Naplók listázása",
"Create/Edit blog" => "Napló szerkesztése",
"Admin posts" => "Bejegyzések beállítása",
"List forums" => "Fórumok listázása",
"Admin forums" => "Fórum adminisztráció",
"Submit a new link" => "Új link elküldése",
"Browse directory" => "Könyvtár lapozása",
"Admin directory" => "Könyvtár adminisztráció",
"File Galleries" => "Fájl gyűjtemények",
"List galleries" => "Galériák listázása",
"FAQs" => "Gyakori kérdések",
"Admin FAQs" => "Gyakori kérdések beállítása",
"Maps" => "Térképek",
"Quizzes" => "Kvíz",
"List quizzes" => "Kvízek listázása",
"Quiz stats" => "Kvíz statisztikák",
"Admin quiz" => "Kvíz adminisztráció",
"Trackers" => "Űrlapok",
"List trackers" => "Űrlapok listázása",
"Admin trackers" => "Űrlapok beállítása",
"Surveys" => "Kérdőívek",
"List surveys" => "Kérdőívek listázása",
"Admin surveys" => "Kérdőív adminisztráció",
"Newsletters" => "Hírlevelek",
"Send newsletters" => "Hírlevél kiküldése",
"Admin newsletters" => "Hírlevelek beállítása",
"Ephemerides" => "Napi idézetek",
"Ephemerides Admin" => "Napi idézetek beállítása",
"Charts" => "Slágerek",
"Charts Admin" => "Slágerek beállítása",
"Admin home" => "Adminisztrációs főoldal",
"Theme control" => "Stílus vezérlés",
"Drawings" => "Rajzok",
"Edit languages" => "Nyelvek szerkesztése",
"Integrator" => "Integrátor",
"Click here to manage your personal menu" => "Innen szerkeszthetem a saját menüm",
"User Menu" => "Felhasználói menü",
"Tikiwiki Assistant" => "Tikiwiki Asszisztens",
"Thank you for installing Tikiwiki" => "Köszönjük hogy a Tikiwiki-t választottad!",
"for more setup details." => "részt mert segítséget nyújt az oldal beállításához.",
"You can remove this module in" => "Ezt a modult kikapcsolhatod az ",
"Recently visited pages" => "Mostanában látogatott lapok",
"January" => "Január",
"February" => "Február",
"March" => "Március",
"April" => "Április",
"May" => "Május",
"June" => "Június",
"July" => "Július",
"August" => "Augusztus",
"September" => "Szeptember",
"October" => "Október",
"Monday" => "Hétfő",
"Tuesday" => "Kedd",
"Wednesday" => "Szerda",
"Thursday" => "Csütörtök",
"Friday" => "Péntek",
"Saturday" => "Szombat",
"Sunday" => "Vasárnap",
"Today" => "mai",
"top" => "felülre",
"Received objects" => "Érkezett objektumok",
"Pages:" => "Lapok:",
"Last Sites" => "Utolsó helyek",
"Directory Stats" => "Könyvtár statisztika",
"Sites" => "Honlapok",
"Sites to validate" => "Érvényesítendő oldalcímek",
"Searches" => "Keresések",
"Visited links" => "Látogatott linkek",
"Top Sites" => "Top helyek",
"Featured links" => "Kiemelt linkek",
"Top topics" => "Top témák",
"Last forum topics" => "utolsó fórum témák",
"Most commented forums" => "Legtöbb fórum hozzászólás",
"Most read topics" => "legtöbbet olvasott témák",
"Most visited forums" => "Leglátogatottabb fórumok",
"Google Search" => "Google keresés",
"Last blog posts" => "Utolsó blog elküldve",
"Last" => "utolsó",
"Last Created blogs" => "Utoljára készült blog",
"Last Created FAQs" => "Utoljára készült Gyakori kérdések",
"Last Created Quizzes" => "Utoljára készült kvíz",
"Last modified file galleries" => "Utoljára módosított fájlgyûjtemények",
"Last Files" => "Utolsó fájlok",
"Last galleries" => "Utolsó galériák",
"Last Modified Items" => "Utolsó módosított elemek",
"Last Modified blogs" => "Utolsó módosított blog",
"Last submissions" => "Utolsó hozzászólások",
"Last Items" => "Utolsó elemek",
"Online users" => "Online felhasználók",
"We have" => "Itt van",
"online users" => "online felhasználó",
"logged as" => "bejelentkezve:",
"Logout" => "lecsatlakozom",
"user" => "Nevem",
"pass" => "Jelszavam",
"login" => "Belépek",
"Remember me" => "Emlékezz rám",
"register" => "Regisztrálok",
"I forgot my pass" => "Elfelejtettem a jelszót",
"secure" => "biztonságos",
"stay in ssl mode" => "maradok titkosított módban",
"You have" => "",
"new messages" => "új üzeneted van",
"new message" => "új üzeneted van",
"You have 0 new messages" => "Nincs új üzeneted",
"Waiting Submissions" => "Várakozó beadványok",
"submissions waiting to be examined" => "megvizsgálásra váró beadványok",
"Old articles" => "Régi hírek",
"Send a message to" => "Üzenet küldése:",
"Random Pages" => "Véletlenszerû lapok",
"Register as a new user" => "Új felhasználóként regisztrálni",
"Your registration code:" => "A regisztrációs kódja:",
"Username" => "Felhasználónév",
"Passcode to register (not your user password)" => "Regisztrációs továbbmenőkód(nem jelszó)",
"Registration code" => "Regisztrációs kód",
"Password" => "Jelszó",
"Repeat password" => "Jelszó ismét",
"Generate a password" => "Jelszó kreálása",
"Search" => "Keresés",
"in:" => "ebben:",
"Entire Site" => "az egész honlapon",
"Wiki Pages" => "Wiki oldalak száma",
"Image Gals" => "Kép galériák",
"Images" => "Képek",
"Blog Posts" => "Blog üzenetek",
"go" => "beállítom",
"Search Wiki PageName" => "Wiki PageName keresése",
"Read More" => "Bővebben",
"Since your last visit on" => "Utolsó látogatásod óta a",
"click to edit" => "Kattints ha szerkeszteni akarod!",
"Language: " => "Nyelv: ",
"Language" => "Nyelv",
"Most Active blogs" => "Legaktívabb blog",
"Top articles" => "Legjobb hírek",
"Top File Galleries" => "Legjobb fájlgyûjtemények",
"Top games" => "Legjobb játékok",
"Top galleries" => "Legjobb galériák",
"Top Images" => "Legjobb képek",
"Top Pages" => "Legjobb lapok",
"Top Quizzes" => "Legjobb kvízek",
"Top Visited FAQs" => "Legtöbbet látogatott Gyakori kérdések",
"Upcoming events" => "Jövőbeli események",
"My blogs" => "Naplóim",
"cache" => "gyorsítótár",
"My galleries" => "Galériáim",
"My Pages" => "Lapjaim",
"User tasks" => "Felhasználói feladatok",
"del" => "törlöm",
"online user" => "online felhasználó",
"vote" => "szavazok",
"find" => "keresem",
"users" => "felhasználók",
"Structures:" => "Struktúrák:",
"show structures" => "megnézem a struktúrákat",
"hide structures" => "elrejtem a struktúrákat",
"Manage structures" => "Beállítom a struktúrákat",
"Execution time" => "Végrehajtás ideje",
"secs" => "másodperc",
"Memory usage" => "Felhasznált memória",
"database queries used" => "számú adatbázis lekérdezés",
"Server load" => "Szerver terheltsége",
"3d browser" => "3d böngésző",
"print" => "kinyomtatom",
"create pdf" => "pdf készítés",
"Save to notepad" => "Az oldal tartalmát mentem a jegyzettömbe",
"monitor this page" => "figyelemmel követem az oldal változásait",
"stop monitoring this page" => "nem követem mostantól az oldal változásait",
"backlinks" => "hivatkozások",
"Previous page" => "előző oldal",
"Next page" => "következő oldal",
"Add Page" => "Oldal hozzáadása",
"First page" => "kezdő oldal",
"page" => "oldal",
"Last page" => "utolsó oldal",
"Last edited by" => "Utolsó szerkesztő",
"Page last modified on" => "Az oldalt ekkor módosították utoljára:",
"Contributors to this page" => "Ezt az oldalt szerkesztette",
"last modification" => "utolsó módosítás",
"click here" => "klikkeljen ide",
"The original document is available at" => "A dokumentum eredetije megtalálható itt:",
"rename" => "átnevezem",
"unlock" => "megnyitom",
"lock" => "zárom",
"perms" => "jogok",
"history" => "változatok",
"similar" => "hasonló oldalak",
"undo" => "visszacsinál",
"slides" => "bemutató",
"export" => "exportálom",
"discuss" => "megbeszél",
"add comment" => "hozzáfűzök egy megjegyzést",
"1 comment" => "egy megjegyzés",
"comments" => "megjegyzések",
"attach file" => "fájl csatolása",
"1 file attached" => "1 csatolt fájl",
"{\$atts_cnt} files attached" => "{\$atts_cnt} csatolt fájl",
"translation" => "nyelvek",
"Page generated in" => "A lap elkészült",
"The newsletter was sent to {\$sent} email addresses" => "A hírlevelet kiküldtük {\$sent} email címre",
"Prepare a newsletter to be sent" => "Hírlevelek küldésre előkészítése",
"Newsletter" => "Hírlevél",
"Apply template" => "Téma alkalmazása",
"none" => "egyik sem",
"Data" => "Adat",
"Send Newsletters" => "Hírlevelek küldése",
"Made with" => "Készült",
"powered by" => "alaprendszere:",
"This is" => "Ez a",
"by the" => "fejleszti a",
"Tiki community" => "Tiki közösség",
"User List" => "A felhasználók társasága",
"Homework" => "Házifeladat",
"Assignments" => "Feladatok",
"Last Changes" => "Utolsó változások",
"attachments" => "csatolmányok",
"User files" => "Saját fájlok",
"Favorites" => "Kedvencek",
"Watches" => "Követések",
"Show/Hide Left Menus" => "BalMenü",
"Show/Hide Right Menus" => "JobbMenü",
"home" => "főoldal",
"contact us" => "kapcsolat teremtés",
"stats" => "statisztika",
"categories" => "kategóriák",
"Member list" => "Tagok listája",
"last changes" => "utolsó változtatások",
"rankings" => "rangok",
"list pages" => "lapok listázása",
"orphan pages" => "árva lapok",
"sandbox" => "homokozó",
"received pages" => "érkezett lapok",
"structures" => "struktúrák",
"Articles Home" => "Hírek kezdőlapja",
"Create/Edit Blog" => "Napló szerkesztése",
"Browse Directory" => "Könyvtár tallózása",
"List Quizzes" => "Kvízek listázása",
"List Trackers" => "Űrlapok listázása",
"List Surveys" => "Kérdőívek listázása",
"Prefs" => "Beállítások",
"MyFiles" => "Fájljaim",
"back to homepage" => "vissza a főoldalra",
"This page is being edited by" => "Ezt az oldalt most szerkeszti",
"Proceed at your own peril" => "Csak saját felelősségedre szerkeztheted, nem javasoljuk...",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "A Homokozóban gyakorolhatom wiki formázási készségeimet. Az előnézet gombbal megtekinthetem szerkesztési munkám eredményét. A Homokozónak nincsenek tárolt változatai.",
"Description" => "leírás",
"My Footnotes" => "Lábjegyzetek",
"Year:" => "Év:",
"Authors:" => "Szerző:",
"Allow HTML" => "HTML engedélyezése",
"Spellcheck" => "Helyesírás ellenőrzés",
"Import page" => "Lap import",
"export all versions" => "minden verzió exportja",
"Upload picture" => "Kép feltöltése",
"no cache" => "frissen készült",
"minute" => "perc",
"hour" => "óra",
"License" => "Licensz",
"Important" => "Fontos",
"Minor" => "apró módosítás",
"cancel edit" => "szerkesztés megszakítása",
"dls" => "letöltések",
"My Tiki" => "Saját Tikim",
"User Pages" => "Felhasználói lapok",
"User Galleries" => "Felhasználói galériák",
"Assigned items" => "Hozzárendelt elemek",
"at tracker" => "űrlapon",
"Unread Messages" => "Új üzenetek",
"User Blogs" => "Naplóim",
"Mini Calendar" => "Mini Naptár",
"reads" => "hányan olvasták",
"Refresh" => "Frissít",
"Find:" => "Keresem:",
"posted by" => "küldte",
"read more" => "Bővebben",
"User Bookmarks" => "Felhasználói könyvjelzők",
"wiki help" => "wiki segítség",
"Features" => "Funkciók",
"General" => "Általános",
"Home Blog" => "Fő Napló",
"Home Blog (main blog)" => "Home Blog (fö blog)",
"Blog level comments" => "Blog szint megjegyzések",
"Post level comments" => "Post szint megjegyzések",
"Spellchecking" => "Helyesírás ellenőrzés",
"Default ordering for blog listing" => "Blog listázás alapértelmezett sorrendje",
"Creation date (desc)" => " dátum (csökk)",
"Last modification date (desc)" => "Utolsó módositás dátuma (csökk)",
"Blog title (asc)" => "Blog cime (növ)",
"Number of posts (desc)" => "Küldések száma (csökk)",
"Visits (desc)" => "Látogatottság (csökk)",
"Activity (desc)" => "Aktivitás (csökk)",
"Change preferences" => "Beállítások megváltoztatása",
"Blog listing configuration (when listing available blogs)" => "Blog listázás beállítása (ha blog listák rendelkezésre állnak)",
"Disabled" => "Letiltva",
"Plain text" => "Sima szöveg",
"Link to user information" => "A felhasználói információhoz kapcsolja",
"User avatar" => "Saját avatárom",
"Blog comments settings" => "Blog megjegyzés beállítások",
"Default number of comments per page" => "A megjegyzések száma az laponként (alapbeállítás)",
"Comments default ordering" => "Megjegyzések rendezése (alapbeállítás)",
"Points" => "Pontok",
"Change settings" => "Beállítások megváltoztatása",
"CMS features" => "CMS tulajdonságok",
"Submissions" => "Beküldött hírek",
"Use templates" => "Sablon használata",
"Maximum number of articles in home" => "A hírek számának felső határértéke főoldalon",
"Article comments settings" => "Hírek megjegyzéseinek beállítása",
"Topic" => "Téma",
"Visible" => "Látható",
"Img" => "kép",
"Country" => "Ország",
"Last login" => "Utolsó bejelentkezés",
"Set features" => "Tulajdonságok beállítása",
"Number of columns per page when listing categories" => "A laponkénti oszlopok száma a kategóriák megtekintésénél",
"Links per page" => "Laponkénti hivatkozások (linkek)",
"Validate URLs" => "URL-ek hitelesitése",
"Method to open directory links" => "A könytár hivatkozások megnyitási módszere",
"replace current window" => "cserélje le a jelenlegi ablakot",
"new window" => "új ablak",
"inline frame" => "belsö keret",
"Tiki sections and features" => "Tikiwiki alkatrészek és funkciók",
"Workflow engine" => "Munkafolyamatok",
"Live support system" => "Élő támogatási rendszer",
"Help System" => "Segítségnyújtás",
"Multilingual" => "Többnyelvűség",
"Tiki Calendar" => "Tiki Naptár",
"Content Features" => "Tartalomszerkesztési funkciók",
"Edit CSS" => "CSS szerkesztése",
"Administration Features" => "Adminisztrációs eszközök",
"Banning system" => "Kitiltások rendszere",
"Debugger Console" => "Debug konzol",
"Communications (send/receive objects)" => "Kommunikáció (objektum küldése/fogadás)",
"Theme Control" => "Vizuális Témák Adminisztrációja",
"User Features" => "Felhasználói eszközök",
"User Watches" => "Felhasználói figyelők",
"User Tasks" => "Felhasználói feladatok",
"User Messages" => "Felhasználói üzenetek",
"User Files" => "Felhasználói fájlok",
"General Layout options" => "Általános szerkezet beállításai",
"Left column" => "Bal oszlop",
"Layout per section" => "Szekciónkénti szerkezetek",
"Right column" => "Jobb oszlop",
"Top bar" => "Felső sáv",
"Bottom bar" => "Alsó sáv",
"Home Gallery (main gallery)" => "Home galéria (fö galéria)",
"Galleries features" => "Galériák beállításai",
"Use database to store files" => "Adatbázis használata a fájlok tárolásához",
"Use a directory to store files" => "Könyvtár használata a fájlok tárolásához",
"Directory path" => "Könyvtár útvonala",
"Uploaded filenames must match regex" => "A feltöltött fájl nevének egyeznie kell a kifejezéssel",
"Uploaded filenames cannot match regex" => "A feltöltött fájl neve nem egyezhet a kifejezéssel",
"please read" => "kérem olvassa",
"Gallery listing configuration" => "Galériák listázásának beállítása",
"File galleries comments settings" => "Fájl gyüjtemények megjegyzéseinek beállítása",
"Home Forum (main forum)" => "Home fórum (fö fórum)",
"Accept wiki syntax" => "Wiki szintakszis elfogadása",
"Forum quick jumps" => "Fórum gyors ugrások",
"Ordering for forums in the forum listing" => "A fórumok listázásának beállítása",
"Creation Date (desc)" => "Keletkezés dátuma (csökk)",
"Topics (desc)" => "Témák (csökk)",
"Threads (desc)" => "Szálak (csökk)",
"Last post (desc)" => "Utolsó hozzászólás (csökk)",
"Name (desc)" => "Név (csökk)",
"Name (asc)" => "Név (növ)",
"Forum listing configuration" => "Fórumok listázásának tulajdonságai",
"Topics" => "Témák",
"Posts per day" => "Napi küldések",
"Use database to store images" => "Adatbázisban tárolja a képeket",
"Use a directory to store images" => "Könyvtárban tárolja a képeket",
"Library to use for processing images" => "A képek átalakitásához használt programkönyvtár",
"Uploaded image names must match regex" => "A feltöltött kép nevének egyezni kell a kifejezéssel",
"Uploaded image names cannot match regex" => "A feltöltött kép neve nem egyezhet a kifejezéssel",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "A Wiki, blog, fórum, cikkek által nem használt képek eltávolitása a rendszergalériából",
"All galleries" => "Minden galéria",
"Move" => "Mozgatom",
"images" => "képek",
"Image galleries comments settings" => "Képgalériák megjegyzéseinek beállítása",
"General Preferences" => "Általános beállítások",
"Theme" => "Alaptéma",
"Slideshows theme" => "Bemutató téma",
"Use URI as Home Page" => "URI használata Honlapként",
"Home page" => "Honlapom",
"Custom home" => "Egyedi home",
"Use database for translation" => "Adatbázis használata a forditáshoz",
"Record untranslated" => "Nem leforditott rekord",
"Unknown/Other" => "Ismeretlen/Más",
"General Settings" => "Általános beállítások",
"Open external links in new window" => "Külső linkeket új ablakban nyissa meg",
"Display modules to all groups always" => "Minden modult mindig mutasson minden csoportnak",
"Use cache for external pages" => "Cache használata a külső lapokhoz",
"Use cache for external images" => "Cache használata a külső képekhez",
"Display menus as folders" => "A menüket könyvtárként jelenitse meg",
"Tikiwiki.org help" => "doc.tikiwiki.org felhasználói kézikönyv",
"Use gzipped output" => "Gzippelt kimenet használata",
"Count admin pageviews" => "Admin lapnézés számolása",
"Server name (for absolute URIs)" => "Szerver név (Az abszolút URI-hoz)",
"No" => "Nem",
"Yes" => "Igen",
"Browser title" => "Böngészö neve",
"Wiki_Tiki_Title" => "Wiki_Tiki_Név",
"Temporary directory" => "Ideiglenes könyvtár",
"Sender Email" => "Küldési e-mail cim",
"Contact user" => "Kapcsolattartó felhasználó",
"contact feature disabled" => "kapcsolattartás kikapcsolva",
"Maximum number of records in listings" => "A rekordok maximum száma listázásnál",
"Date and Time Formats" => "Dátum és idő formátumok",
"Long date format" => "Hosszú dátum formátum",
"Short date format" => "Rövid dátum formátum",
"Long time format" => "Hosszú időformátum",
"Short time format" => "Rövid időformátum",
"Date and Time Format Help" => "Dátum és idő formátum segítség",
"Change admin password" => "Admin jelszó megváltoztatása",
"New password" => "Új jelszó",
"Change password" => "Jelszó megváltoztatása",
"Reg users can change language" => "Regisztrált felhasználók nyelvet változtathatnak",
"Available languages:" => "Jelenlegi nyelvek:",
"path" => "útvonal",
"groups" => "csoportok",
"Admin groups" => "Csoportadminisztráció",
"Admin users" => "Felhasználók adminisztrációja",
"User registration and login" => "Felhasználói bejelentkezés és regisztráció",
"Authentication method" => "Azonosítási módszer",
"Just Tiki" => "Csak Tiki",
"Web Server" => "Webszerver",
"Tiki and PEAR::Auth" => "Tiki és PEAR::Auth",
"Tiki and HTTP Auth" => "Tiki és HTTP Auth",
"Use WebServer authentication for Tiki" => "Webszerver azonosítás használata a Tiki-hez",
"Users can register" => "A felhasználók regisztrálhatnak",
"Request passcode to register" => "Továbbmenőkód kérése regisztrációnál",
"Prevent automatic/robot registration" => "Automata/robot regisztráció megelőzése",
"Validate users by email" => "Felhasználók ellenőrzése e-mail-en",
"Store plaintext passwords" => "Sima szövegként tárolt jelszó",
"Reg users can change theme" => "Regisztrált felhasználók megváltoztathatják az alaptémát",
"Use challenge/response authentication" => "Hívás/válasz azonosítás használata",
"Force to use chars and nums in passwords" => "Betûk és számok is kötelezőek a jelszóban",
"Minimum password length" => "Legrövidebb jelszó",
"Password invalid after days" => "Jelszó elévülési ideje",
"Require HTTP Basic authentication" => "Alapvető HTTP azonosítás igénylése",
"Allow secure (https) login" => "Biztonságos (https) bejelentkezés engedélyezése",
"Require secure (https) login" => "Biztonságos (https) bejelentkezés igénylése",
"HTTP server name" => "HTTP szerver neve",
"HTTP URL prefix" => "HTTP URL előtag",
"HTTPS server name" => "HTTPS szerver neve",
"HTTPS URL prefix" => "HTTPS URL előtag",
"Remember me feature" => "Emlékezz rám szolgáltatás",
"Only for users" => "Csak felhasználóknak",
"Users and admins" => "Felhasználóknak és adminoknak is",
"Duration:" => "Időtartam:",
"day" => "nap",
"week" => "hét",
"month" => "hónap",
"Create user if not in Tiki?" => "Felhasználó létrehozása, ha nincs a Tikiben?",
"Create user if not in Auth?" => "Felhasználó létrehozása ha nincs az Auth-ban?",
"Just use Tiki auth for admin?" => "Csak Tiki azonosítást használjunk az Adminnak?",
"<b>enable/disable</b>" => "<b>engedélyez/letilt</b>",
"<b>Max number of items</b>" => "<b>Az item-ek maximum száma</b>",
"Full Text Search" => "Teljes szövegkeresés",
"Content" => "Tartalom",
"Publish" => "kiadás",
"change" => "változtat",
"Quota (Mb)" => "Limit (Mb)",
"Use database to store userfiles" => "Adatbázis használata a felhasználói fájlok tárolásához",
"Use a directory to store userfiles" => "Könyvtár használata a felhasználói fájlok tárolásához",
"Allow viewing HTML mails?" => "Megengedjük a HTML levelek megnézését?",
"Maximum size for each attachment" => "Csatolt állomány maximum mérete",
"restore" => "visszaállít",
"Creator" => "Alkotta",
"Last version" => "Legújabb változat",
"Status" => "Státusz",
"Versions" => "Változatok",
"Backlinks" => "Hivatkozások",
"Wiki Features" => "Wiki szolgáltatások",
"Undo" => "Visszacsinál",
"PDF generation" => "PDF készítés",
"mins" => "percek",
"Pictures" => "Képek",
"Use page description" => "Oldalak leírását használom",
"Show page title" => "Oldalcímeket megjelenítem",
"Users can lock pages (if perm)" => "Felhasználók zárolhatják a lapokat (engedéllyel)",
"Use WikiWords" => "WikiWords használata",
"Tables syntax" => "Táblázat szintaxis",
"Page creators are admin of their pages" => "A lap készítője saját lapjának adminisztrátora",
"Import HTML" => "HTML beolvasása",
"Maximum number of versions for history" => "A történelemben max nyilvántortott verziók száma",
"Never delete versions younger than days" => "Soha ne törölj olyan verziót ami fiatalabb ennyi napnál",
"Copyright Management" => "Copyright menedzsment",
"Enable Feature" => "Elérhető szolgáltatás",
"License Page" => "Licensz lap",
"Submit Notice" => "Megjegyzés küldése",
"admin banning tpl" => "kitiltások ",
"Add or edit a rule" => "Szabály hozzáadása vagy szerkesztése",
"Rule title" => "Szabály neve",
"Username regex matching" => "Felhasználói név egyezik a kifejezéssel",
"IP regex matching" => "IP egyezik a kifejezéssel",
"Banned from sections" => "Az alábbi szekciókból van kitiltva",
"check / uncheck all" => "megjelöli / nem jelöli mindet",
"Rule activated by dates" => "Ez adott időponttól kezdve érvényes",
"Rule active from" => "Érvényesség kezdete",
"Rule active until" => "Érvényesség vége",
"Custom message to the user" => "Egyedi üzenet a felhasználónak",
"Rules" => "Szabályok",
"User/IP" => "Felhasználó/IP",
"Sections" => "Szekciók",
"Admin Calendars" => "Naptárak beállítása",
"List of Calendars" => "Naptárak listája",
"loc" => "hely",
"cat" => "kat",
"lang" => "nyelv",
"prio" => "font",
"permissions" => "engedélyek",
"Create/edit Calendars" => "Naptárak létrehozása/szerkesztése",
"Custom Locations" => "Egyedi hely",
"yes" => "igen",
"Custom Categories" => "Egyedi kategória",
"Custom Languages" => "Egyedi nyelv",
"Custom Priorities" => "Egyedi prioritás",
"Current category" => "Jelenlegi kategória",
"Child categories" => "kategória fa levelei",
"Edit this category:" => "Szerkeszd ezt a kategóriát:",
"create new" => "új létrehozása",
"Add new category" => "Új kategória hozzáadása",
"Parent" => "Szülő",
"Assign permissions automatically" => "A rendszer automatikusan osszon jogosultságokat",
"recommended for best performance" => "ajánlott a legjobb teljesítményhez",
"Objects in category" => "Kategória elemek",
"type" => "típus",
"Add objects to category" => "Elemek hozzáadása a kategóriához",
"image gal" => "kép galéria",
"file gal" => "fájl galéria",
"Admin chart items" => "Slágerlista elemek adminisztrációja",
"charts" => "slágerlisták",
"edit chart" => "slágerlista szerkesztése",
"Add or edit an item" => "Elem hozzáadása/szerkesztése",
"update" => "hozzáadom",
"Chart items" => "Slágerlista elemek",
"No items defined yet" => "Nincsenek elemek definiálva",
"Admin charts" => "Sláger témák adminisztrációja",
"View template" => "Sablon megtekintése",
"Add or edit a chart" => "Sláger téma hozzáadása/szerkesztése",
"Active" => "Aktív",
"Users can vote for only one item from this chart per period" => "Időszakonként a felhasználók csak egy elemre szavazhatnak",
"Prevent users from voting for the same item more than once" => "Alkalmanként a felhasználók ugyanarra az elemre csak egyszer adhatják le szavazatukat",
"Users can suggest new items" => "A felhasználók javasolhatnak új slágereket",
"Auto validate user suggestions" => "Automatikusan jóváhagyja a felhasználói javaslatokat",
"Ranking shows" => "Rang mutatása",
"All items" => "Minden elem",
"Top 10 items" => "Top 10 elem",
"Top 20 items" => "Top 20 elem",
"Top 40 items" => "Top 40 elem",
"Top 50 items" => "Top 50 elem",
"Top 100 items" => "Top 100 elem",
"Top 250 items" => "Top 250 elem",
"Voting system" => "Szavazási rendszer",
"Vote items" => "Elemre szavazás",
"Rank 1..5" => "Rang 1..5",
"Rank 1..10" => "Rang 1..10",
"Ranking frequency" => "Időszak",
"Realtime" => "Valós idő",
"Each 5 minutes" => "Minden 5 percben",
"Daily" => "Naponta",
"Weekly" => "Hetente",
"Monthly" => "Havonta",
"Show Average" => "Mutass átlagot",
"Show Votes" => "Mutass szavazatokat",
"Use Cookies for unregistered users" => "Cookie használata a nem regisztrált felhasználóknál",
"Users can vote again after" => "Ennyi idő múlva szavazhatunk újra:",
"Anytime" => "Bármikor",
"5 minutes" => "5 perc",
"1 day" => "1 nap",
"1 week" => "1 hét",
"1 month" => "1 hónap",
"Items" => "Elemek",
"Ranks" => "Rangok",
"No charts defined yet" => "Nincsenek még sláger témák",
"Chat Administration" => "Chat adminisztráció",
"Create/edit channel" => "Csatorna létrehozása/szerkesztése",
"Refresh rate" => "Frissítési idő",
"second" => "másodperc",
"Chat channels" => "Chat csatornák",
"active" => "aktív",
"Admin templates" => "Alaptémák adminisztrációja",
"Edit this template:" => "Ezt az alaptémát szerkesztem:",
"Create new template" => "Új alaptéma készítése",
"use in cms" => "használja cms-ben",
"use in wiki" => "használja wiki-ben",
"use in newsletters" => "használja újságokban",
"use in HTML pages" => "használja HTML lapokon",
"template" => "alaptéma",
"Templates" => "Alaptémák",
"last modif" => "utolsó módosítás",
"sections" => "szekciók",
"Admin cookies" => "Cookie adminisztráció",
"Create/edit cookies" => "Cookie készítése/szerkesztése",
"Upload Cookies from textfile" => "Cookie feltöltése textfájlból",
"Upload from disk:" => "Feltöltés a lemezről",
"upload" => "feltöltöm",
"Remove all cookies" => "Minden cookie eltávolítása",
"Available drawings" => "Rendelkezésre álló rajzok",
"Ver" => "Változat",
"Create/edit dsn" => "dsn készítése/szerkesztése",
"Admin external wikis" => "Külső wiki-k adminisztrációja",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (használjon \$lap kifejezést a lap nevével, mint az alábbi példában: http://www.example.com/tiki-index.php?page=\$page)",
"Admin Forums" => "Fórumok beállítása",
"Edit this Forum:" => "Ezt a fórumot szerkesztem:",
"Create New Forum" => "Új fórum létrehozása",
"There are individual permissions set for this forum" => "Egyéni engedélyek vannak ehhez a fórumhoz",
"Show description" => "Mutass leírást",
"Prevent flooding" => "Flood megakadályozása",
"Minimum time between posts" => "Hozzászólások közti minimum idő",
"Topics per page" => "Témák száma laponként",
"Section" => "Szekció",
"Create new" => "Új készítése",
"Moderator user" => "Moderátor felhasználó",
"Moderator group" => "Moderátor csoport",
"Password protected" => "Jelszóval védett",
"Topics only" => "Csak témák",
"All posts" => "Minden üzenet",
"Forum password" => "Fórum jelszó",
"Default ordering for topics" => "Témák rendezésének alapbeállítása",
"Date (desc)" => "Dátum (csökk)",
"Date (asc)" => "Dátum (növ)",
"Score (desc)" => "Pontszám (csökk)",
"Replies (desc)" => "Válaszok (csökk)",
"Reads (desc)" => "Olvasottság (csökk)",
"Title (desc)" => "cím (csökk)",
"Title (asc)" => "cím (növ)",
"Default ordering for threads" => "A szálak alap rendezési beállítása",
"Send this forums posts to this email" => "Ezt a fórum üzenetet küldje az alábbi e-mailre",
"Prune unreplied messages after" => "Meg nem válszolt üzenetek eltávolítása ez után",
"Prune old messages after" => "Régi üzenetek eltávolítása ezután",
"Topic list configuration" => "Témalista beállítása",
"Replies" => "Válaszok",
"Posts can be rated" => "A hozzászólásokat pontozni lehessen",
"Add messages from this email to the forum" => "Az alábbi e-mail üzeneteket adja a fórumhoz",
"POP3 server" => "POP3 szerver",
"Use topic smileys" => "Mosolyok használata a témákban is legyen engedélyezett",
"Show topic summary" => "Témaösszesítő",
"User information display" => "Felhasználói információs képernyő",
"avatar" => "avatár",
"Approval type" => "Folyamodvány típusa",
"All posted" => "Minden üzenet",
"Queue anonymous posts" => "Állítsa sorba a névtelen hozzászólásokat",
"Queue all posts" => "Minden hozzászólást állítson sorba",
"Attachments" => "Csatolások",
"No attachments" => "Nincsenek csatolások",
"Everybody can attach" => "Mindenki csatolhat",
"Only users with attach permission" => "Csak csatolási engedéllyel rendelkezők",
"Moderators and admin can attach" => "Moderátorok és adminok csatolhatnak",
"Store attachments in:" => "A csatolásokat itt tárolja:",
"Database" => "Adatbázis",
"Max attachment size (bytes)" => "Maximum csatolás mérete (bájt)",
"topics" => "témák",
"age" => "kor",
"last post" => "utolsó hozzászólás",
"Assign Permissions" => "Jogosultságokat adok",
"Admin Hotwords" => "Hotword adminisztráció",
"Add Hotword" => "Hotword hozzáadása",
"Word" => "Szó",
"Add" => "Hozzáad",
"Admin HTML pages" => "HTML lapok adminisztrációja",
"Edit this page" => "Ezt a lapot szerkesztem",
"View page" => "Lap megtekintése",
"Edit zone" => "Zóna szerkesztése",
"Zone" => "Zóna",
"Dynamic zones" => "Dinamikus zónák",
"zone" => "zóna",
"content" => "tartalom",
"Mass update" => "Mindent frissít",
"Create new HTML page" => "Új HTML lap létrehozása",
"Edit this HTML page:" => "Ezt a HTML lapot szerkesztem:",
"Page name" => "Lap neve",
"Dynamic" => "Dinamikus",
"Static" => "Statikus",
"Refresh rate (if dynamic) [secs]" => "Frissítési ráta (ha dinamikus) [másodperc]",
"Admin layout" => "Kinézet adminisztráció",
"layout options" => "kinézet beállítások",
"Generate positions by hits" => "A helyeket a találatok alapján alakítsa ki",
"List of featured links" => "Kiemelt linkek listája",
"title" => "cím",
"position" => "helye",
"Add Featured Link" => "Kiemelt link hozzáadása",
"Edit this Featured Link:" => "Szerkeszd ezt a kiemelt linket:",
"Create new Featured Link" => "Új kiemelt link készítése",
"Position" => "sorrend",
"disables the link" => "link letiltása",
"Link type" => "Link típusa",
"replace current page" => "A jelenlegi lap lecserélése",
"framed" => "frame-ben",
"open new window" => "új ablak nyitása",
"admin Webmail" => "Webmail adminisztráció",
"Account name" => "Postaláda neve",
"POP server" => "POP szerver",
"SMTP server" => "SMTP szerver",
"SMTP requires authentication" => "SMTP felhasználóazonosítást igényel",
"wiki-get" => "wiki-leszed",
"wiki-put" => "wiki-felrak",
"wiki-append" => "wiki-hozzáfûz",
"Frequency" => "Gyakoriság",
"List menus" => "Menük listázása",
"Edit this menu" => "Szerkeszd ezt a menüt",
"Edit menu options" => "Menü beállításainak szerkesztése",
"Some useful URLs" => "Néhány hasznos URL",
"Permissions" => "Engedélyek",
"section" => "szakasz",
"option" => "opció",
"Home Page" => "Főoldal",
"Home Image Gal" => "Fő Képgaléria",
"Home Image Gallery" => "Fő Képgaléria",
"Home File Gal" => "Fő Fájlgyűjtemény",
"Home File Gallery" => "Fő Fájlgyűjtemény",
"User preferences" => "Felhasználói beállítások",
"User prefs" => "Felhasználói beáll.",
"List image galleries" => "Képgalériák listázása",
"Upload" => "Feltöltés",
"Gallery Rankings" => "Galéria rangok",
"Browse a gallery" => "Galéria",
"All articles" => "Összes hír",
"Submit" => "Elküld",
"List Blogs" => "Naplók főoldala",
"Create blog" => "Napló szerkesztése",
"File galleries" => "Fájl gyűjtemények",
"View a forum" => "Fórum megtekintése",
"View a thread" => "Egy thread megtekintése",
"View a FAQ" => "Gyakori kérdések megtekintése",
"Take a quiz" => "Kvíz kitöltése",
"Stats for a Quiz" => "Statisztikák a kvízekhez",
"Preview menu" => "Menü előnézet",
"Menu options" => "Menü opciók",
"group" => "csoport",
"Admin Menus" => "Menü adminisztráció",
"Edit this Menu:" => "Szerkeszd ezt a menüt:",
"Create new Menu" => "Új menü készítése",
"dynamic extended" => "dinamikusan bővülő",
"fixed" => "rögzített",
"options" => "opciók",
"Admin Modules" => "Modul adminisztráció",
"assign module" => "modul hozzárendelése",
"left modules" => "bal modulok",
"right modules" => "jobb modulok",
"edit/create" => "szerkeszt/készít",
"clear cache" => "gyorsítótár törlése",
"User Modules" => "Felhasználói modulok",
"assign" => "hozzárendelem",
"Assign new module" => "Új modul hozzárendelése",
"Edit this assigned module:" => "Szerkeszd ezt a hozzárendelt modult:",
"Module Name" => "Module neve",
"left" => "bal",
"right" => "jobb",
"Order" => "Sorrend",
"Cache Time" => "Gyorsítótár idő",
"Rows" => "Sorok",
"Parameters" => "Paraméterek",
"Assigned Modules" => "Hozzárendelt modulok",
"Left Modules" => "Bal modulok",
"order" => "sorrend",
"rows" => "sorok",
"Right Modules" => "Jobb modulok",
"Create new user module" => "Új felhasználói modul készítése",
"Edit this user module:" => "Szerkeszd ezt a felhasználói modult:",
"Use wysiwyg editor" => "Wysiwyg szerkesztő használata",
"Use normal editor" => "Normál szerkesztő használata",
"create/edit" => "készít/szerkeszt",
"Objects that can be included" => "A felhasználható objektumok",
"Available polls" => "Rendelkezésre álló szavazások",
"use poll" => "szavazás használata",
"Random image from" => "Véletlenszerû kép innen:",
"use gallery" => "galéria használata",
"Dynamic content blocks" => "Dinamikus tartalmú rész",
"use dynamic  content" => "dinamikus tartalom használata",
"use rss module" => "rss modul használata",
"use menu" => "menü használata",
"Banner zones" => "Banner zónák",
"use banner zone" => "banner zónák használata",
"Admin newsletter subscriptions" => "Hírlevél előfizetés adminisztráció",
"list newsletters" => "hírlevelek listázása",
"admin newsletters" => "hírlevelek adminisztrációja",
"send newsletters" => "hírlevelek küldése",
"Add a subscription newsletters" => "Hírlevél előfizetés hozzáadása",
"Subscriptions" => "Előfizetések",
"subscribed" => "előfizetve",
"Create/edit newsletters" => "Hírlevelek készítése/szerkesztése",
"There are individual permissions set for this newsletter" => "Ennél a hírlevélnél egyéni engedélyek vannak beállítva",
"Users can subscribe any email address" => "A felhasználók bármely e-mail címre előfizethetnek",
"editions" => "változatok",
"last sent" => "Utoljára elküldve",
"subscriptions" => "előfizetések",
"EMail notifications" => "E-Mail értesítések",
"admin Email Notifications" => "E-mail Értesítések adminisztrációja",
"Add notification" => "Értesítás hozzáadása",
"Event" => "Esemény",
"A user registers" => "Egy felhasználó regisztrál",
"A user submits an article" => "Egy felhasználó cikket küld",
"use admin email" => "adminisztrátor levelének használata",
"event" => "esemény",
"object" => "objektum",
"Admin Polls" => "Szavazás adminisztráció",
"List polls" => "Szavazások listázása",
"Edit this poll" => "Ezt a szavazást szerkeszti",
"Preview poll" => "Szavazás előnézet",
"Edit or add poll options" => "Szavazás opciók hozzáadása/szerkesztése",
"Option" => "Opció",
"Poll options" => "Szavazás opciók",
"votes" => "szavazat",
"admin polls" => "beállítom a szavazásokat",
"admin polls template" => "szavazások sablonját szerkesztem",
"Set last poll as current" => "Az utolsó szavazás jelenlegivé tétele",
"Close all polls but last" => "Minden szavazás bezárása az utolsó kivételével",
"Activate all polls" => "Minden szavazás aktiválása",
"Create/edit Polls" => "Szavazás készítése/szerkesztése",
"PublishDate" => "Kiadás dátuma",
"Category" => "Kategória",
"Admin RSS modules" => "RSS modulok adminisztrációja",
"Content for the feed" => "Az adatfolyam tartalma",
"Edit this RSS module:" => "Ezt az RSS modult szerkeszti:",
"Create new RSS module" => "Új RSS modul készítése",
"Rss channels" => "Rss csatornák",
"Last update" => "Utolsó frissítés",
"Score System" => "Pontozás Rendszer",
"Filename" => "Fájlnév",
"Admin Shoutbox Words" => "Az üzenőfal szóhasználatának beállításai",
"Add Banned Word" => "Tiltott szó hozzáadása",
"Structure ID" => "Struktúra neve",
"export pages" => "lementem az oldalakat",
"dump tree" => "lementem az oldalak fastruktúráját",
"create webhelp" => "létrehozom a statikus változat",
"view webhelp" => "megtekintem a statikus változatot",
"Destroy the structure leaving the wiki pages" => "A struktúra megsemmisítése a wiki lap elhagyásakor",
"Destroy the structure and remove the pages" => "A struktúra megsemmisítése és a lapok eltávolítása",
"Create new structure" => "Új struktúra létrehozása",
"Use single spaces to indent structure levels" => "Az alábbi fa struktúra beviteléhez szóközöket használok  minden egyes elem sorának kezdetén, ha az elem struktúrán belüli mélységét is jelölni kívánom",
"Alias" => "Megjelenített neve",
"tree" => "fa",
"create new structure" => "létrehozom az új struktúrát",
"Edit survey questions" => "Kérdőív kérdések szerkesztése",
"survey stats" => "kérdőív statisztika",
"this survey stats" => "ennek a kérdőívnek a statisztikája",
"edit this survey" => "kérdőív szerkesztése",
"admin surveys" => "kérdőív adminisztráció",
"Create/edit questions for survey" => "Kérdőív kérdések készítése/szerkesztése",
"Question" => "Kérdés",
"One choice" => "Egy válasz",
"Multiple choices" => "Több válasz",
"Short text" => "Rövid szöveg",
"Rate (1..5)" => "Súlyozás (1..5)",
"Rate (1..10)" => "Súlyozás (1..10)",
"Options (if apply)" => "Beállítások (ha kéri)",
"Questions" => "Kérdések",
"question" => "kérdés",
"list surveys" => "kérdőívek listázása",
"Edit this Survey:" => "Ezt a kérdőívet szerkeszd:",
"There are individual permissions set for this survey" => "Ehhez a kérdőívhez egyéni engedélyek vannak beállítva",
"status" => "állapot",
"questions" => "kérdések",
"system admin" => "rendszer adminisztrátor",
"files" => "fájlok",
"Admin Topics" => "Témák beállításai",
"Create a new topic" => "Új téma létrehozása",
"Topic Name" => "Téma neve",
"Upload Image" => "Kép feltöltése",
"List of topics" => "Témák listája",
"Active?" => "aktív",
"Articles (subs)" => "Hírek (beküldöttek)",
"topic image" => "téma kép",
"Activate" => "Aktivál",
"Deactivate" => "Inaktív",
"Import" => "Importálás",
"created" => "készült",
"items" => "elemek",
"fields" => "mező",
"Create/edit trackers" => "Űrlapok készítése/módosítása",
"filename" => "fájlnév",
"downloads" => "letöltések",
"filesize" => "fájlméret",
"version" => "változat",
"admin groups" => "Csoportok adminisztrációjq",
"Add new group" => "Új csoport hozzáadása",
"List" => "Lista",
"Edit group" => "Szerkesztem a csoportot",
"Members" => "Tagok",
"Add a new group" => "Új csoport hozzáadása",
"List of existing groups" => "Létező csoportok listája",
"Number of displayed rows" => "Megjelenített sorok száma",
"Includes" => "tartalmazza",
"assign permissions" => "jogosultságokat adok",
"Include" => "Tartalmazza",
"Group Homepage" => "Csoport honlapja",
"Use wiki page name or full URL" => "Egy Wiki oldal nevét vagy teljes elérési utat adjál meg",
"Members List" => "Taglista",
"users in group" => "felhasználók ebben a csoportban",
"List all members" => "A tagok kilistázása",
"admin users" => "felhasználók adminisztrációja",
"Add a new user" => "Új felhasználó hozzáadása",
"Added users" => "Hozzáadott felhasználók",
"Rejected users" => "Elutasított felhasználók",
"Reason" => "Ok",
"Edit user" => "Felhasználó adatainak szerkesztése",
"Never" => "Soha",
"Assign Group" => "Csoporthoz rendelem",
"select all" => "mindet kijelölöm",
"Pass" => "Jelszó",
"Again" => "Mégegyszer",
"Registration" => "Regisztráció",
"Overwrite" => "Felülír",
"Show expire date" => "Mutasd mikor jár le",
"Assign permissions to group" => "Jogosultságokat adok csoportoknak",
"Edit Article" => "Szerkesztem e hírt",
"Back to groups" => "Vissza a csoportokhoz",
"Group Information" => "Csoport információ",
"Desc" => "Csökkenő",
"Create level" => "Szint készítése",
"all permissions in level" => "minden jogosultságot e szinten",
"level" => "szint",
"Assign user" => "Felhasználó csatolása",
"to groups" => "csoportok",
"User Information" => "Felhasználói információ",
"backlinks to" => "hivatkozások a",
"No backlinks to this page" => "Erre az oldalra nem hivatkozik másik oldal",
"Warning!" => "Óvakodj!",
"Create new backup" => "Új biztonsági mentés készítése",
"Upload a backup" => "Egy mentés feltöltése",
"Upload backup" => "Mentés feltöltése",
"Browse gallery" => "Galéria tallózása",
"Upload from disk" => "Feltöltés lemezről",
"width" => "szélesség",
"height" => "magasság",
"Edit Post" => "Üzenet szerkesztése",
"view blog" => "blog nézése",
"list blogs" => "megtekintem a meglévő naplókat",
"save and exit" => "ment és kilép",
"admin category" => "beállítom e kategóriát",
"Image galleries" => "Kép galériák",
"search category" => "Kategória felkutatása",
"deep" => "mélyen",
"Objects" => "Elemek",
"Browsing Gallery" => "Galéria tallózása",
"list galleries" => "galériák listája",
"edit gallery" => "galéria szerkesztése",
"rebuild thumbnails" => "előnézeti képek újraépítése",
"upload image" => "kép feltöltése",
"list gallery" => "galéria listázása",
"Sort Images by" => "A képek rendezése",
"original size" => "eredeti méret",
"rotate right" => "jobbra forgatás",
"rotate" => "forgatás",
"popup" => "előugró",
"Browsing Image" => "Képek tallózása",
"return to gallery" => "vissza a galériához",
"edit image" => "kép szerkesztése",
"first image" => "első kép",
"smaller" => "kisebb",
"bigger" => "nagyobb",
"prev image" => "előző kép",
"Popup window" => "Előugró ablak",
"popup window" => "előugró ablak",
"next image" => "következő kép",
"last image" => "utolsó kép",
"Image Name" => "Kép neve",
"Latitude (WGS84/decimal degrees)" => "Szélességi fokom (WGS84/decimális fokokban kifejezve)",
"Longitude (WGS84/decimal degrees)" => "Hosszúsági fokom (WGS84/decimális fokokban kifejezve)",
"Move image" => "Kép mozgatása",
"You can view this image in your browser using" => "Ezt a a képet meg tudod nézni a böngésződből, ha ezt használod:",
"h" => "ó",
"Group Calendars" => "Naptár csoportok",
"Tools Calendars" => "Naptár eszközök",
"Duration" => "Időtartam",
"Edit Calendar Item" => "Naptár elem szerkesztése",
"close" => "csukom",
"permission" => "jogosultság",
"No individual permissions global permissions apply" => "Nincsenek egyéni engedélyek, a globális engedélyek érvényesek",
"Assign permissions" => "Jogosultságokat adok",
"to group" => "csoporthoz",
"Change password enforced" => "Jelszócsere kötelező",
"Old password" => "Régi jelszó",
"Again please" => "Mégegyszer",
"Welcome to the Tiki Chat Rooms" => "Isten hozta a Tiki Chat szobákban",
"Please select a chat channel" => "Kérem válasszon chat szobát",
"Nickname" => "Nick",
"enter chat room" => "chatszoba megadása",
"Chatroom" => "Chatszoba",
"Active Channels" => "Aktív szobák",
"Users in this channel" => "Felhasználók ebben a szobában",
"Create PDF" => "PDF készítése",
"Font" => "Betűtípus",
"add page" => "oldal hozzáadása",
"remove page" => "oldalak törlése",
"Send a message to us" => "Küldj nekünk üzenetet!",
"Contact us by email" => "Küldj nekünk e-mail-t!",
"click here to send us an email" => "Küldj nekünk email-t",
"Structure" => "Struktúra",
"Close" => "Bezár",
"Current URL" => "Jelenlegi URL",
"Command" => "Parancs",
"Type <code>help</code> to get list of available commands" => "Írd be <code>help</code> a rendelkezésre álló parancsok listázásához",
"Add a new site" => "Új site hozzáadása",
"Site added" => "Honlap hozzáadva",
"Add or edit a site" => "Site hozzáadása/szerkesztése",
"Is valid" => "Ellenőrzött",
"Statistics" => "Statisztikák",
"Admin sites" => "Site adminisztráció",
"Settings" => "Beállítások",
"browse" => "tallóz",
"related" => "kapcsolódó",
"sites" => "site",
"add a site" => "honlap hozzáadása",
"Search results" => "Keresésem eredménye",
"list articles" => "hírek listázása",
"view articles" => "hírek főoldala",
"Subtitle" => "Alcím",
"Source" => "Forrás",
"Author Name" => "Szerző",
"Use dates" => "Dátumok használata",
"Mon" => "Hétfő",
"Tue" => "Kedd",
"Wed" => "Szerda",
"Thu" => "Csütörtök",
"Fri" => "Péntek",
"Sat" => "Szombat",
"Sun" => "Vasárnap",
"Image:" => "Kép:",
"Edit Blog" => "Naplóm szerkesztem",
"Create Blog" => "Nyitok egy naplót",
"edit blog tpl" => "napló sablonjának szerkesztése",
"Current heading" => "A jelenlegi címe",
"Cancel" => "Mégsem",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Itt bővebb leírást olvashatok a <a href=\"{\$helpurl}WikiSyntax\">Wiki formázásról</a>",
"Lists" => "Felsorolások",
"for bullet lists" => "pontozott felsorolásokhoz",
"for numbered lists" => "számozott felsorolásokhoz",
"for definiton lists" => "meghatározások listájához",
"Wiki References" => "Wiki hivatkozások",
"JoinCapitalizedWords or use" => "ÍrdSzófejtőÍrásban vagy használd az",
"page|desc" => "oldalnév|megjelenő leírás",
"for wiki references" => "formátumot wiki hivatkozásokhoz",
"SomeName" => "ValamilyenFogalom",
"External links" => "Külső kapcsolatok",
"displays an image" => "megjelenít egy képet",
"makes a horizontal rule" => "vízszintes vonalat húz",
"Quicktags" => "Gyors elérés",
"bold" => "vastag",
"special chars" => "különleges karakterek",
"special characters" => "különleges karakterek",
"admin quicktags" => "gyors elérések beállítása",
"Image Description" => "Kép leírása",
"results" => "eredmények",
"Results" => "Eredmények",
"answer" => "válasz",
"Modify Structure" => "Struktúra szerkesztése",
"You will remove" => "Most törölném a",
"and its subpages from the structure, now you have two options:" => "oldalt és aloldalait e struktúrából, de előtte van még választási lehetőségem:",
"Remove only from structure" => "Vagy csak kiveszem az oldalt ebből a struktúrából, vagy",
"Remove from structure and remove page too" => "Törlöm az oldalt és ebből a struktúrából is kiveszem",
"Current Node" => "Megnyitott ág",
"Page alias" => "Megjelenített neve:",
"Promote" => "Szinttel feljebb",
"Previous" => "Előző",
"Demote" => "Szinttel lejjebb",
"Add pages to current node" => "Hozzáadom ehhez az ághoz",
"After page" => "e meglévő levél (oldal) után",
"create page" => "létrehozom az új oldalt",
"Use pre-existing page" => "meglévő fogalmat választok",
"Structure Layout" => "A kitárulkozó fastruktúra",
"list submissions" => "Beküldött hírek listázása",
"Edit Translation:" => "Nyelvi fordítások szerkesztése:",
"edit translations" => "hogyan szerkesztem a nyelvi fordításokat?",
"edit translations template" => "nyelvi fordítások sablonjának szerkesztése",
"Use this section to set the language of the version you are currently working on." => "Itt is beállíthatod az oldal jelenleg szerkesztett változatának nyelvét.",
"Set of Translations" => "Fordítások halmazai",
"add to the set" => "hozzáadom a fordítások halmazához",
"Translation of:" => "Fordítása ennek:",
"Enter the name of the page for which the current page is the translation." => "Megadom azon oldal nevét, amelynek ez az oldal a fordítása:",
"Try to convert HTML to wiki" => "HTML-t wiki formátumba konvertálok",
"Browse" => "Tallóz",
"Admin FAQ" => "Gyakori kérdések beállításai",
"create new gallery" => "új galéria létrehozása",
"Gallery is visible to non-admin users?" => "A galéria látható a nem admin felhasználók számára?",
"Max Rows per page" => "Sorok max száma oldalanként",
"Available File Galleries" => "Jelenlegi fájlgyûjtemények",
"back to forum" => "vissza a fórumba",
"topic" => "téma",
"convert to topic" => "témává konvertálás",
"new topic" => "új téma",
"accept" => "elfogadom",
"refuse" => "visszautasaítom",
"Waiting requests" => "Függő kéréseid",
"Your friends" => "Barátaim",
"Real Name" => "Polgári név",
"break friendship" => "megszakítom a barátságot vele",
"activity" => "aktivitás",
"completed" => "elvégezve",
"Started" => "Indulás",
"Map" => "Térkép",
"User Activities" => "Műveletek",
"Create a gallery" => "Galéria készítése",
"Edit this gallery:" => "Szerkeszd ezt a galériát:",
"There are individual permissions set for this gallery" => "Ehhez a galériához egyéni engedélyek vannak beállítva",
"Images per row" => "Soronkénti képek",
"Thumbnails size X" => "Előnézet X mérete",
"Thumbnails size Y" => "Előnézet Y mérete",
"Filesize" => "Fájlméret",
"Available scales" => "Elérhető méretarányok",
"No scales available" => "Nincs elérhető méretarány",
"Other users can upload images to this gallery" => "Más felhasználók is tölthetnek fel képet ebbe a galériába",
"You can access the gallery using the following URL" => "A galériát a következő URL-en érheted el:",
"Available Galleries" => "Jelenlegi galériák",
"Imgs" => "Képek",
"Im- Export languages" => "Nyelv im- export ",
"Select the language to Import" => "Válassza ki az importálandó nyelvet",
"Select the language to Export" => "Válassza ki az exportálandó nyelvet",
"result" => "eredmény",
"Weeks" => "hét",
"Search by Date" => "Keresés dátum szerint",
"Found" => "találat",
"LastChanges" => "UtolsóVáltozások",
"hist" => "változatok",
"rollback" => "visszatérek ehhez",
"source" => "megtekintem e változat forrását",
"Pages like" => "Hasonló nevű oldalak",
"No pages found" => "Nem találtam lapokat",
"List Articles" => "Hírek listázása",
"edit new article" => "új hír szerkesztése",
"AuthorName" => "Szerzőév",
"Create banner" => "Banner készítése",
"Method" => "Metódus",
"Use Dates?" => "Használjak dátumokat?",
"Max Impressions" => "Max nézőszám",
"Impressions" => "Nézőszám",
"Clicks" => "Klikkek",
"create new blog" => "létrehozok egy új naplót",
"Last Modified" => "Utoljára módosított",
"Dynamic content system" => "Dinamikus tartalom rendszer",
"Current ver" => "Jelenlegi verzió",
"Next ver" => "Következő verzió",
"Old vers" => "Régi verzió",
"Available FAQs" => "Jelenlegi GYIK-ek",
"Listing Gallery" => "Galéria",
"upload file" => "fájl feltöltése",
"Gallery Files" => "Fájlok",
"move selected files" => "a kijelölt fájlok mozgatása",
"delete selected files" => "kijelölt fájlok törlése",
"Move to" => "Mozgatás ide",
"Dls" => "letöltések",
"browse gallery" => "galéria tallózása",
"Gallery Images" => "Galéria képek",
"All games are from" => "A játékok származási helye",
"visit the site for more games and fun" => "látogasd meg több játékért és szórakozásért",
"Upload a game" => "Játék feltöltése",
"Upload a new game" => "Új játék feltöltése",
"edit blog" => "szerkesztem a blogot",
"Blog Title" => "Napló címe",
"Last mod" => "Utolsó módosítás",
"Last author" => "Utolsó szerző",
"Last ver" => "Összes változat",
"Com" => "Üzenet",
"Vers" => "Változatok",
"with checked" => "a kijelöltek",
"Operator" => "Operátor",
"User:" => "Felhasználó:",
"started" => "kezdve",
"reason" => "ok",
"msgs" => "üzenetek",
"Remove old events" => "Régi események eltávolítása",
"duration" => "időtartam",
"Add or edit event" => "Esemény hozzáadása vagy szerkesztése",
"Mini Calendar: Preferences" => "Mini Naptár: Beállítások",
"Calendar Interval in daily view" => "Naptár intervallum napi nézetben",
"Start hour for days" => "A nap kezdőórája",
"End hour for days" => "A nap utolsó órája",
"Reminders" => "Emlékeztető",
"no reminders" => "nincs emlékeztető",
"Import CSV file" => "CSV fájl importja",
"add topic" => "téma hozzáadása",
"My pages" => "Lapjaim",
"My items" => "Dolgaim",
"My tasks" => "Feladataim",
"Subscribe" => "Előfizet",
"Select news group" => "Hírcsoport választása",
"Back to servers" => "Vissza a szerverekhez",
"Msgs" => "Üzenetek",
"News from" => "Hírek feladója",
"Save position" => "Pozíció mentése",
"First" => "Első",
"Newsgroup" => "Hírcsoport",
"Configure news servers" => "Hírszerver konfigurálása",
"Select a news server to browse" => "Egy hír(news) szerver választása böngészésre:",
"server" => "szerver",
"Add or edit a news server" => "Hír(news)szerver hozzáadása vagy szerkesztése",
"News server" => "Hír(news) szerver",
"Notes" => "Feljegyzések",
"quota" => "Limit",
"Write a note" => "Jegyzet írása",
"No notes yet" => "Nincsenek még jegyzeteim",
"merge selected notes into" => "A kiválasztott jegyzeteket egyesítésem ebben:",
"Reading note:" => "Jegyzet olvasása:",
"List notes" => "Jegyzetek listázása",
"Write note" => "Jegyzet írása",
"wiki create" => "wiki készítése",
"wiki overwrite" => "wiki felülírása",
"Assign permissions to " => "Engedélyek adása ennek: ",
"back" => "vissza",
"Current permissions for this object" => "Az objektum jelenlegi engedélyei",
"Assign permissions to this object" => "Engedélyek hozzárendelése ehhez az objektumhoz",
"Published" => "Kiadott",
"Votes" => "szavazatok",
"Assign permissions to page" => "Kiosztom a jogokat az oldalra",
"Current permissions for this page" => "Meglévő jogosultságok ezen az oldalon",
"No individual permissions; category or global permissions apply" => "Nincs erre az oldalra beállított egyedi jogosultság. Kategória vagy Globális jogosultságok érvényesek.",
"this page" => "erre az oldalra",
"this structure" => "erre a struktúrára",
"Current permissions for categories that this page belongs to" => "Aktuális jogosultságok az oldal Kategória-jogosultságai alapján",
"No category permissions; global permissions apply" => "Nincs beállított Kategória-jogosultság; Globális jogosultságok érvényesek",
"Send email notifications when this page changes to" => "Amikor változik az oldal erre a címre küld értesítést",
"add email" => "emailcím",
"Notifications" => "Értesítések",
"Show all" => "Mindet mutat",
"random" => "véletlenszerû",
"Upload your own avatar" => "Saját avatár feltöltése",
"atts" => "fájlok",
"Average" => "Átlag",
"List Attachments" => "Csatolt fájlok felsorolása",
"Vote poll" => "Szavazz rá",
"Other Polls" => "Egyéb szavazások",
"Current Version" => "Jelen változat",
"General Options" => "Általános beállítások",
"Publication Date" => "Megjelenés napja",
"clear stats" => "statisztika törlése",
"Top 10" => "Első 10",
"Top 20" => "Első 20",
"Top 50" => "Első 50",
"Top 100" => "Első 100",
"Received Articles" => "Hírek fogadása",
"Site" => "Honlap",
"last" => "utolsó",
"I forgot my password" => "Jelszó emlékeztető",
"send me my password" => "küldd el a jelszóm",
"Return to HomePage" => "Vissza a főoldara",
"Remove page" => "Törlöm ezt az oldalt",
"last version" => "jelenlegi változat",
"You are about to remove the page" => "Értem, hogy végérvényesen törlöm a",
"permanently" => "oldalt",
"Remove all versions of this page" => "Sőt, az összes változattal együtt törlöm!",
"Rename page" => "Átnevezem",
"Search in" => "Szűkítem",
"galleries" => "galériák",
"blog posts" => "napló bejegyzések",
"articles" => "hírek",
"Send objects" => "Objektumok küldése",
"password" => "jelszó",
"Send Articles" => "Hír küldése",
"add article" => "új hír szerkesztése",
"Tiki Shoutbox" => "Tiki Üzenőfal",
"Change shoutbox general settings" => "Az üzenőfal általános beállításai",
"Post or edit a message" => "Üzenet szerkesztése",
"CMS" => "Hírek",
"Site Stats" => "Általános honlap statisztika",
"Days online" => "Működési napok száma",
"Total pageviews" => "Összesen ennyiszer tekintették be az oldalakat",
"Average pageviews per day" => "Naponta átlagosan ennyiszer tekintették be az oldalakat",
"Best day" => "Leglátogatottabb nap",
"pvs" => "az oldal betekintések száma",
"Worst day" => "Legkevésbé látogatott nap",
"Wiki Stats" => "Wiki oldalak statisztikai kimutatásai",
"Size of Wiki Pages" => "Wiki oldalak összes mérete (forrásban)",
"Average page length" => "Wiki oldalak átlagos mérete (forrásban)",
"bytes" => "bájtok",
"Average versions per page" => "Az oldalaknak átlagosan ennyi változatuk van",
"Visits to wiki pages" => "Látogatások a Wiki oldalakban",
"Average links per page" => "Wiki oldalak átlagos hivatkozásainak száma",
"Image galleries Stats" => "Kép galériák statisztikai kimutatásai",
"Average images per gallery" => "Képek átlagos száma galériánként",
"Total size of images" => "Képek összes mérete",
"Average image size" => "Egy kép átlagos mérete",
"Visits to image galleries" => "Látogatások a Kép galériákban",
"File galleries Stats" => "Fájl gyűjtemények statisztikai kimutatásai",
"Average files per gallery" => "Fájlok átlagos száma gyűjteményeként",
"Total size of files" => "Fájlok összes mérete",
"Average file size" => "Egy fájl átlagos mérete",
"Visits to file galleries" => "Látogatások a Fájl gyűjteményekben",
"CMS Stats" => "Hírek statisztikai kimutatásai",
"Total reads" => "Az elolvasott hírek száma összesen",
"Average reads per article" => "Átlagos olvasottság hírenként",
"Total articles size" => "Hírek összes mérete (forrásban)",
"Average article size" => "Egy hír átlagos mérete (forrásban)",
"Forum Stats" => "Fórumok statisztikai kimutatásai",
"Total topics" => "Összes téma",
"Average topics per forums" => "Átlagos témák száma fórumonként",
"Total threads" => "Eszemecserék száma",
"Average threads per topic" => "Átlagos eszmecserék száma témánként",
"Visits to forums" => "Látogatások a Fórumokon",
"Blog Stats" => "Naplók statisztikai kimutatásai",
"Weblogs" => "Naplók",
"Total posts" => "Összes bejegyzés száma",
"Average posts per weblog" => "Átlagos bejegyzések száma naplónként",
"Total size of blog posts" => "Naplóbejegyzések összes mérete (forrásban)",
"Average posts size" => "Bejegyzések átlagos mérete",
"Visits to weblogs" => "Látogatások a Naplókban",
"Poll Stats" => "Szavazások statisztikai kimutatásai",
"Total votes" => "Összes szavazat",
"Average votes per poll" => "Átlagos szavazatok száma szavazásonként",
"Faq Stats" => "Gyakran Intézett Kérdések statisztikai kimutatásai",
"Total questions" => "Összes kérdés",
"Average questions per FAQ" => "Átlagos kérdések száma témánként",
"User Stats" => "Felhasználói társaság statisztikai kimutatásai",
"User bookmarks" => "Felhasználói könyvjelzök",
"Average bookmarks per user" => "Átlagos könyvjelzők száma felhasználónként",
"Quiz Stats" => "Kvíz statisztikai kimutatásai",
"Average questions per quiz" => " Átlagos kérdések száma kvízenként",
"Quizzes taken" => "Kitöltött kvízek száma",
"Average quiz score" => "A kvízek átlagos eredménye",
"Average time per quiz" => "Átlagos idő kvízenként",
"Object" => "Elem",
"send answers" => "elküldöm",
"theme" => "vizuális téma",
"Assigned objects" => "Kijelölt elemek",
"Now enter the file URL" => "Add meg a fájl URL-jét",
" or upload a local file from your disk" => " vagy tölts fel egy helyi fájlt merevlemezéről",
"Now enter the image URL" => "Írja be a kép URL-jét",
" or upload a local image from your disk" => " vagy töltsön fel egy helyi képet a merevlemezéről",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Előnézeti kép (opcionális, felülírja az automatikusan generáltat)",
"Upload successful!" => "A feltöltés sikeres!",
"The following image was successfully uploaded" => "Az alábbi kép sikeresen feltöltve",
"Thumbnail" => "Előnézet",
"Restore defaults" => "Alapértékek visszaállítása",
"Current folder" => "Jelenlegi mappa",
"Folders" => "Mappák",
"remove folder" => "mappa eltávolítása",
"refresh cache" => "cache frissítése",
"Admin folders and bookmarks" => "Mappák és könyvjelzők beállítása",
"Add or edit folder" => "Mappa hozzáadása/szerkesztése",
"Add or edit a URL" => "URL hozzáadása/szerkesztése",
"Avatar" => "Avatár",
"Displayed time zone" => "Használt időzóna",
"Send me a message" => "Üzenj nekem!",
"User Preferences" => "Felhasználói beállítások",
"Personal Information" => "személyes adataim",
"General preferences" => "általános beállításaim",
"Other preferences" => "egyéb",
"Pick user Avatar" => "Kiválasztom az avatáromat",
"HomePage" => "Honlap",
"Your personal Wiki Page" => "Személyes Wiki oldalam",
"Your personal tracker information" => "Személyes űrlap adataim",
"Is email public? (uses scrambling to prevent spam)" => "E-mail nyilvános (spamvédelem van)",
"Unavailable - please set your e-mail below" => "először meg kell adni az emailcímet alul",
"Does your mail reader need a special charset" => "Beállítom a levelező programom karakter-enkódolását",
"Number of visited pages to remember" => "A nyilvántartott látogatott lapok száma",
"Local" => "Helyi",
"User information" => "Felhasználói információ",
"private" => "privát",
"public" => "publikus",
"Use double-click to edit pages" => "Dubla-klikkre szerkesztem az oldalakat",
"Account Information" => "Belépési adatok",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Üresen hagyom az \"Új jelszó\" és \"Megismétlem az új jelszavat\" mezőket, hogy a jelenlegi jelszavam megmaradjon",
"Email address" => "Email cím",
"Confirm new password" => "Megismétlem az új jelszavat",
"Current password (required)" => "A jelenlegi jelszó megadása is szükséges",
"Messages per page" => "Listákban a laponkénti elemek száma",
"Allow messages from other users" => "Más felhasználók üzenhetnek nekem",
"Note author when reading his mail" => "Jelzem a feladónak, hogy elolvastam a levelét",
"Send me an email for messages with priority equal or greater than" => "Küldj egy e-mailt azokról az üzenetekről aminek a prioritása legalább:",
"Auto-archive read messages after x days" => "Automatikusan archiválja az x napnál régebbi leveleket",
"Tasks per page" => "Laponkénti feladatok",
"My messages" => "Üzeneteim",
"Percentage completed" => "Százalékban végrehajtva",
"priority" => "fontosság",
"No tasks entered" => "Nincs bevitt feladat",
"May need to refresh twice to see changes" => "Lehet, hogy újra kell frissítened az oldalt, hogy a változásokat lásd",
"Add top level bookmarks to menu" => "Hozzáadom a felsőszintű könyvjelzőket a személyes menümhöz",
"Pos" => "Sorrend",
"Mode" => "Mód",
"replace window" => "ablak lecserélése",
"expires:" => "elévül:",
"no comments" => "nincs megjegyzés",
"Forum List" => "Fórum lista",
"Edit Forum" => "Fórum szerkesztése",
"post new comment" => "új hozzászólás",
"Summary" => "Összefoglalás",
"HTML tags are not allowed inside comments" => "HTML tag használata nem megengedett a hozzászólásokban",
"moderator actions" => "moderátor akciók",
"move selected topics" => "a kiválasztott téma mozgatása",
"unlock selected topics" => "a kiválasztott téma megnyitása",
"lock selected topics" => "a kiválasztott téma lezárása",
"delete selected topics" => "a kiválasztott téma törlése",
"merge selected topics" => "a kiválasztott témák egyesitése",
"queued messages:" => "sorbanálló üzenetek:",
"No topics yet" => "Még nincsenek témák",
"Show posts" => "Bejegyzések megjelenítése",
"Last hour" => "Utóbbi óra",
"Last 24 hours" => "Utóbbi 24 óra",
"Last 48 hours" => "Utóbbi 48 óra",
"Jump to forum" => "Ugorj a fórumra",
"prev topic" => "előző téma",
"next topic" => "következő téma",
"monitor this topic" => "kövesd ezt a témát",
"stop monitoring this topic" => "ne kövesd ezt a témát",
"Comments below your current threshold" => "küszöbérték alatti hozzászólás",
"Details" => "Részletek",
"Add new mail account" => "Új postaláda hozzáadása",
"User accounts" => "Felhasználói fiókok",
"account" => "fiók",
"General preferences and settings" => "Általános tulajdonságok és beállítások",
"Wiki settings" => "Wiki beállítások",
"Poll comments settings" => "Szavazás megjegyzéseinek beállítása",
"Forums settings" => "Fórumok beállítása",
"No chart indicated" => "Nincs megjeleníthető sláger",
"Upload failed" => "Sikertelen feltöltés",
"No page indicated" => "Pontosan melyik oldara vagy kiváncsi? Add meg!",
"The passwords don't match" => "Figyelem, hogy egyezzenenek a megadott jelszavak!",
"Password should be at least" => "A jelszónak legalább",
"characters long" => "karakter hosszúnak kell lennie",
"DATE-of" => "sorrendje",
"Tag already exists" => "A tag már létezik ",
"Tag not found" => "nem találom a tag-ot",
"No menu indicated" => "Nincs megjeleníthető menü",
"No newsletter indicated" => "Nincs megjeleníthető hírlevél",
"No poll indicated" => "Nincs megjeleníthető szavazás",
"page not added (Exists)" => "a lap nincs hozzáadva (létezik)",
"No survey indicated" => "Nincs megjeleníthető kérdőív",
"You don't have permission to use this feature" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt megtekintsd.",
"No tracker indicated" => "Nincs megjeleníthető űrlap",
"Group already exists" => "A csoport már létezik",
"No records were found. Check the file please!" => "Nem találtam elemeket! Kérlek ellenőrizd a forrásfájlt!",
"User login is required" => "Ehhez felhasználói bejelentkezés kéretik",
"Password is required" => "Jelszó megadása kéretik",
"Email is required" => "E-mail cím megadása kéretik",
"User is duplicated" => "A felhasználó többször létezik",
"User already exists" => "Ez felhasználónév már létezik ebben a rendszerben",
"The passwords dont match" => "A megadott jelszavak nem egyeznek",
"Password must contain both letters and numbers" => "A jelszónak betűket és számjegyeket is tartalmaznia kell!",
"rss feed disabled" => "az rss adagoló ki van kapcsolva",
"Permission denied you cannot view this section" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt megtekintsd.",
"Unknown group" => "Ismeretlen csoport",
"Group doesnt exist" => "A csoport nem létezik",
"Unknown user" => "Ismeretlen felhasználó",
"User doesnt exist" => "A felhasználó nem létezik",
"The page cannot be found" => "A lap nem található",
"Permission denied you cannot post" => "Az üzenet beküldéséhez több jogosultságra van szükséged.",
"Permission denied you cannot edit this post" => "Az üzenet szerkesztéséhez több jogosultságra van szükséged.",
"You can't post in any blog maybe you have to create a blog first" => "Készíts egy új naplót, amibe írod bejegyzéseidet! <br /><a title=\"létrehozok egy új naplót\" href=\"tiki-edit_blog.php\">Napló létrehozása/szerkesztése</a>",
"Top visited blogs" => "Leglátogatottabb naplók",
"Last posts" => "Legújabb bejegyzések",
"Top active blogs" => "Kiemelkedő aktivitású naplók",
"TOP" => "Forrás",
"Permission denied you cannot access this gallery" => "Ehhez a galériához nem férhetsz hozzá! Hozzáférés megtagadva...",
"Permission denied you cannot view this page" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt az oldalt megtekintsd.",
"Permission denied you can not view this section" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt megtekintsd.",
"Permission denied you cannot remove images from this gallery" => "Te nem távolíthatsz el képet ebből a galériából! Hozzáférés megtagadva...",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Nem tudod újra-kreálni a miniatűröket! Hozzáférés megtagadva...",
"Permission denied you cannot rotate images in this gallery" => "Nem forgathatod a képeket ebben a galériában! Hozzáférés megtagadva...",
"No image indicated" => "Nincs kép feltüntetve",
"Permission denied you cannot move images from this gallery" => "Nincs jogod átmozgatni képeket ebből a galériából! Hozzáférés megtagadva...",
"Permission denied to use this feature" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt a funkciót használhasd",
"Top authors" => "Remeklő szerzők",
"ERROR: you must include a subject or a message at least" => "FIGYELJ: add meg legalább a üzenet tárgyát vagy a tartamát",
"Message sent to" => "Az üzeneted elküldted. Címzettje:",
"This feature has been disabled" => "Ez a szolgáltatás ki van kapcsolva",
"Must enter a name to add a site" => "Meg kell adnod egy nevet hogy új oldalt vehess fel",
"Must enter a url to add a site" => "Meg kell adnod egy URL-t hogy új oldalt vehess fel",
"URL already added to the directory. Duplicate site?" => "Ez az URL már egyszer fel lett véve! Akarod hogy kétszer is szerepeljen?",
"Must select a category" => "Ki kell választanod egy kategóriát",
"You can not download files" => "Magasabb csoportszintű jogosultágra van szükséged, hogy letölts fájlokat",
"Permission denied you cannot edit this article" => "Nincs jogod ezt a cikket szerkeszteni! Hozzáférés megtagadva...",
"You do not have permissions to edit banners" => "Nincs jogod a banner-eket szerkeszteni!",
"Banner not found" => "Nem találom a banner-t...",
"You do not have permission to edit this banner" => "Nincs jogod ezt a banner-t szerkeszteni!",
"Permission denied you cannot create or edit blogs" => "Nincs jogod blog-ot létrehozni vagy szerkeszteni! Hozzáférés megtagadva...",
"Permission denied you cannot edit this blog" => "Nincs jogod ezt a blog-ot szerkeszteni! Hozzáférés megtagadva...",
"Invalid request to edit an image" => "A kép szerkesztéséhez érvénytelen kérés érkezett",
"Permission denied you cannot edit images" => "Képek szerkesztéséhez több jogosultságra van szükséged.",
"Permission denied you can edit images but not in this gallery" => "Általában szerkesztheted a képeket, kivéve ebben a galériában. Ehhez több jogosultságra van szükséged.",
"Failed to edit the image" => "A kép módosítási kísérlete sikertelen",
"Language created" => "Az új nyelv létre lett hozva",
"No question indicated" => "Nincs kérdés feltüntetve",
"You have to create a topic first" => "Először témát kell létrehoznod",
"You do not have permission to do that" => "Ehhez több jogosultságra van szükséged.",
"You do not have permission to read the template" => "A sablonok megtekintéséhez több jogosultságra van szükséged.",
"Article not found" => "Nincs ilyen hír",
"Permission denied you cannot edit this page" => "Ezt az oldalt nem szerkesztheted! Hozzáférés megtagadva...",
"You cannot edit this page because it is a user personal page" => "Ez egy felhasználó személyes oldala, Te nem szerkesztheted",
"The SandBox is disabled" => "A Homokozó ki van kapcsolva",
"Cannot edit page because it is locked" => "Ez az oldal le van zárva, így nem szerkesztheted",
"Permission denied you cannot create galleries and so you cant edit them" => "Magasabb csoportszintű jogosultágra van szükséged, hogy létrehozz majd szerkessz galériát.",
"Permission denied you cannot edit this gallery" => "Magasabb csoportszintű jogosultágra van szükséged, hogy szerkeszd a galériát.",
"Permission denied you cannot remove this gallery" => "Magasabb csoportszintű jogosultágra van szükséged, hogy törölj galériát.",
"Top visited file galleries" => "Leglátogatottabb fájlgyűjtemények",
"Most downloaded files" => "Legtöbbször letöltött fájlok",
"No forum indicated" => "Nincs fórum feltüntetve",
"Forum posts" => "Fórum hozzászólások",
"You must be logged in to use this feature" => "Először <a href=\"tiki-login_scr.php\" alt=\"Login\">jelentkezz be</a> a társasághoz.",
"No user indicated" => "Nincs felhasználó feltüntetve",
"Top images" => "Legjobb képek",
"Last images" => "Új képek",
"overwriting old page" => "régi lap felülírása",
"page created" => "létrejött az oldal",
"Permission denied you cannot remove articles" => "Magasabb csoportszintű jogosultágra van szükséged, hogy törölj híreket.",
"Permission denied you cannot remove banners" => "Nem távolíthatsz el banner-eket! Hozzáférés megtagadva...",
"Permission denied you cannot remove this blog" => "Nem törölheted ezt a naplót! Hozzáférés megtagadva...",
"You cannot admin blogs" => "Nincs adminisztrációs jogod a blog-okhoz!",
"Permission denied you cannot view pages" => "Magasabb csoportszintű jogosultágra van szükséged, hogy ezt megtekintsd.",
"Account validated successfully." => "A regisztrációs adatok érvényesek.",
"changed" => "változott",
"Must be logged to use this feature" => "Jelentkezz be hogy ezt a szolgáltatást használni tudd!",
"You must log in to use this feature" => "Először <a href=\"tiki-login_scr.php\">jelentkezz be</a> ehhez!",
"You do not have permission to view other users data" => "Nincs jogod más felhasználók adatainak a megtekintéséhez!",
"You must be logged in to subscribe to newsletters" => "Először <a href=\"tiki-login_scr.php\" alt=\"Login\">jelentkezz be</a>, hogy feliratkozz hírlevekre.",
"No server indicated" => "Nincs szerver feltüntetve",
"Cannot connect to" => "Nem tudok ide csatlakozni:",
"Cannot get messages" => "Nem tudom letölteni az üzeneteket",
"File is too big" => "A megadott fájl túl nagy!",
"No article indicated" => "Add meg a keresett hírt",
"Article is not published yet" => "E hír nem jelent még meg",
"No post indicated" => "Nincs hozzászólás feltüntetve",
"Blog not found" => "Nem találtam meg a naplót",
"No pages indicated" => "Nincs oldal feltüntetve",
"Permision denied" => "Hozzáférés megtagadva...",
"Permission denied you cannot remove versions from this page" => "Az oldal változatainak eltávolításához több jogosultságra van szükséged.",
"Cannot rename page maybe new page already exists" => "Nem tudtam átnevezni az oldalt, mert valószínűleg ilyen néven már létezik egy másik oldal",
"Error Message" => "Hiba üzenet",
" successfully sent" => " sikeresen el lett küldve",
" not sent" => " nem lett elküldve",
"You do not have permission to edit messages" => "Nincs jogod ezt az oldalt szerkeszteni",
"Page must be defined inside a structure to use this feature" => "Az oldalt egy struktúrán belül kell elhelyezned ahhoz, hogy ezt szolgáltatást használni tudd",
"You cannot take this quiz twice" => "Ezt a kvízt már kitöltötted!",
"Please create a category first" => "Kérlek előbb hozz létre egy kategóriát",
"empty" => "üres",
"No blog indicated" => "Nincs blog feltüntetve",
"Permission denied you cannot remove the post" => "Nincs jogod törölni ezt a hozzászólást! Hozzáférés megtagadva...",
"No cache information available" => "Nincs cache-információ",
"Wrong password. Cannot post comment" => "Rossz jelszó! A megjegyzésed nem lett elküldve.",
"Please wait 2 minutes between posts" => "Kérlek várj 2 percet a hozzászólások küldése között!",
"No thread indicated" => "Nincs thread feltüntetve",
"Top pages" => "Leglátogatottabb oldalak",
"Last pages" => "Legújabb oldalak",
"###end###"=>"###end###");
?>
