/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CompoundEdit;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.pad.GPGraph;

public class GPExplorer
extends JPanel
implements GraphSelectionListener,
ChangeListener {
    protected transient Object lastSelectionCell;
    protected transient GPGraph graph;
    protected transient JCheckBox exploreMode = new JCheckBox("Explore", true);
    protected transient JCheckBox autoArrange = new JCheckBox("Arrange", true);
    protected transient SpinnerNumberModel model = new SpinnerNumberModel(2, 1, 50, 1);
    protected transient JSpinner levelSpinner = new JSpinner(this.model);
    protected transient JLabel statusBar = new JLabel("Ready");

    public GPExplorer(GPGraph gPGraph) {
        this.setLayout(new BorderLayout());
        this.graph = new GPGraph(gPGraph.getModel());
        this.graph.setGraphLayoutCache(new StatefulGraphLayoutCache(this.graph.getModel(), this.graph, false, true));
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GPExplorer.this.reset();
            }
        });
        jPanel.add(jButton);
        jPanel.add(this.exploreMode);
        jPanel.add(this.autoArrange);
        jPanel.add(this.levelSpinner);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.graph), "Center");
        this.add((Component)this.statusBar, "South");
        this.graph.addGraphSelectionListener(this);
        this.levelSpinner.addChangeListener(this);
        this.reset();
        this.executeLayout();
    }

    public void reset() {
        this.graph.getGraphLayoutCache().setVisible(this.graph.getAll(), true);
        this.graph.clearSelection();
        this.executeLayout();
    }

    public void execute() {
        if (this.exploreMode.isSelected() && this.graph.getSelectionCount() == 1 && !this.graph.getModel().isEdge(this.graph.getSelectionCell())) {
            this.graph.setCursor(new Cursor(3));
            GraphLayoutCache graphLayoutCache = this.graph.getGraphLayoutCache();
            Object[] objectArray = graphLayoutCache.getCells(graphLayoutCache.getAllDescendants(graphLayoutCache.getRoots()));
            graphLayoutCache.setVisible(objectArray, false);
            int n = this.model.getNumber().intValue();
            Object[] objectArray2 = this.graph.getSelectionCells();
            HashSet hashSet = new HashSet();
            int n2 = 0;
            while (n2 < n) {
                hashSet.addAll(DefaultGraphModel.getEdges(this.graph.getModel(), objectArray2));
                objectArray2 = GPExplorer.getVerticesForEdges(this.graph, hashSet).toArray();
                ++n2;
            }
            this.graph.getGraphLayoutCache().setVisible(hashSet.toArray(), true);
            this.graph.getGraphLayoutCache().toBack(hashSet.toArray());
            if (this.autoArrange.isSelected()) {
                this.executeLayout();
            }
            this.graph.setCursor(new Cursor(0));
            CellView[] cellViewArray = graphLayoutCache.getAllDescendants(graphLayoutCache.getRoots());
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < cellViewArray.length) {
                if (!cellViewArray[n7].isLeaf()) {
                    ++n6;
                } else if (cellViewArray[n7] instanceof EdgeView) {
                    ++n3;
                } else if (cellViewArray[n7] instanceof PortView) {
                    ++n4;
                } else {
                    ++n5;
                }
                ++n7;
            }
            objectArray2 = this.graph.getDescendants(this.graph.getRoots());
            this.statusBar.setText(n5 + " vertice(s) " + n3 + " edges(s) " + n4 + " port(s) in " + n6 + " group(s) visible out of " + objectArray2.length + " cell(s)");
        }
    }

    public static Set getVerticesForEdges(GPGraph gPGraph, Set set) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashSet.add(gPGraph.getSourceVertex(e));
            hashSet.add(gPGraph.getTargetVertex(e));
        }
        return hashSet;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.execute();
    }

    public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
        if (this.graph.getSelectionCount() == 1 && this.graph.getSelectionCell() == this.lastSelectionCell && !this.graph.isEditing()) {
            this.graph.startEditingAtCell(this.lastSelectionCell);
        } else {
            this.execute();
        }
        this.lastSelectionCell = this.graph.getSelectionCell();
    }

    public void executeLayout() {
        this.executeCircleLayout();
        this.executeCircleLayout();
    }

    protected void executeCircleLayout() {
        Object object;
        Object object2;
        Dimension dimension = this.graph.getPreferredSize();
        CellView[] cellViewArray = this.graph.getGraphLayoutCache().getRoots();
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        int n = 0;
        int n2 = 0;
        while (n2 < cellViewArray.length) {
            if (cellViewArray[n2] instanceof VertexView && !this.graph.isCellSelected(cellViewArray[n2].getCell())) {
                arrayList.add(cellViewArray[n2]);
                Rectangle rectangle = cellViewArray[n2].getBounds();
                if (rectangle != null) {
                    n = Math.max(Math.max(rectangle.width, rectangle.height), n);
                }
            }
            ++n2;
        }
        int n3 = (int)Math.max((double)(arrayList.size() * n) / Math.PI / 2.5, 200.0);
        int n4 = Math.max(n3, dimension.width / 2);
        int n5 = Math.max(n3, dimension.height / 2);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        double d = Math.PI * 2 / (double)arrayList.size();
        int n6 = 0;
        while (n6 < arrayList.size()) {
            object2 = (CellView)arrayList.get(n6);
            Rectangle rectangle = new Rectangle(object2.getBounds());
            if (rectangle != null) {
                rectangle.setLocation(n4 + (int)((double)n3 * Math.sin((double)n6 * d)), n5 + (int)((double)n3 * Math.cos((double)n6 * d)));
                object = GraphConstants.createMap();
                GraphConstants.setBounds((Map)object, rectangle);
                hashtable.put(object2.getCell(), object);
            }
            ++n6;
        }
        object2 = this.graph.getSelectionCells();
        int n7 = 0;
        while (n7 < ((Object)object2).length) {
            if (this.graph.getGraphLayoutCache().isVisible(object2[n7]) && (object = this.graph.getCellBounds(object2[n7])) != null) {
                ((Rectangle)object).setLocation(n4, n5);
                Map map = GraphConstants.createMap();
                GraphConstants.setBounds(map, (Rectangle)object);
                hashtable.put(object2[n7], map);
            }
            ++n7;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public class StatefulGraphLayoutCache
    extends GraphLayoutCache {
        public static final boolean showNewGroups = false;
        protected boolean askLocalAttribute = true;
        protected Set localAttributes = new HashSet();

        public StatefulGraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl, boolean bl2) {
            super(graphModel, cellViewFactory, bl, bl2);
            this.localAttributes.add("bounds");
            this.localAttributes.add("points");
            this.localAttributes.add("labelposition");
            this.localAttributes.add("routing");
        }

        public Set getLocalAttributes() {
            return new HashSet(this.localAttributes);
        }

        public void setLocalAttributes(Set set) {
            this.localAttributes = set;
        }

        protected GraphLayoutCache.GraphViewEdit createLocalEdit(Map map, Object[] objectArray, Object[] objectArray2) {
            if (map != null && !map.isEmpty() && this.askLocalAttribute) {
                Object object;
                Hashtable hashtable = new Hashtable();
                Hashtable hashtable2 = new Hashtable();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map map2 = GraphConstants.createMap();
                    object = iterator.next();
                    Object k = object.getKey();
                    Map map3 = (Map)object.getValue();
                    CellView cellView = this.getMapping(k, false);
                    if (cellView != null) {
                        map3 = this.diffMap(cellView.getAllAttributes(), map3);
                    }
                    Iterator iterator2 = map3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Object v;
                        Map.Entry entry = iterator2.next();
                        Object k2 = entry.getKey();
                        if (!this.isLocalAttribute(k, k2, v = entry.getValue()) && !this.isControlAttribute(k, k2, v)) continue;
                        map2.put(k2, v);
                        if (this.isControlAttribute(k, k2, v)) continue;
                        iterator2.remove();
                    }
                    if (!map2.isEmpty()) {
                        hashtable2.put(k, map2);
                    }
                    if (map3.isEmpty()) continue;
                    hashtable.put(k, map3);
                }
                map.clear();
                map.putAll(hashtable);
                object = new GraphLayoutCache.GraphViewEdit(this, new Hashtable(hashtable2), objectArray, objectArray2);
                ((CompoundEdit)object).end();
                return object;
            }
            return super.createLocalEdit(map, objectArray, objectArray2);
        }

        public Map diffMap(Map map, Map map2) {
            Hashtable hashtable = new Hashtable();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object v2 = map.get(k);
                if (v2 != null && v2.equals(v)) continue;
                hashtable.put(k, v);
            }
            return hashtable;
        }

        protected boolean isLocalAttribute(Object object, Object object2, Object object3) {
            return this.localAttributes.contains(object2);
        }

        protected boolean isControlAttribute(Object object, Object object2, Object object3) {
            return "removeAll".equals(object2) || "removeAttributes".equals(object2);
        }
    }
}

