/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class RfbProto {
    final String versionMsg = "RFB 003.003\n";
    static final int ConnFailed = 0;
    static final int NoAuth = 1;
    static final int VncAuth = 2;
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    final int SetPixelFormat = 0;
    final int FixColourMapEntries = 1;
    final int SetEncodings = 2;
    final int FramebufferUpdateRequest = 3;
    final int KeyboardEvent = 4;
    final int PointerEvent = 5;
    final int ClientCutText = 6;
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    final int HextileRaw = 1;
    final int HextileBackgroundSpecified = 2;
    final int HextileForegroundSpecified = 4;
    final int HextileAnySubrects = 8;
    final int HextileSubrectsColoured = 16;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    static final int TightMinToCompress = 12;
    String host;
    int port;
    Socket sock;
    DataInputStream is;
    OutputStream os;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    int serverMajor;
    int serverMinor;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    RfbProto(String string, int n, VncViewer vncViewer) throws IOException {
        this.viewer = vncViewer;
        this.host = string;
        this.port = n;
        this.sock = new Socket(this.host, this.port);
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
    }

    void close() {
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    int readAuthScheme() throws IOException {
        int n = this.is.readInt();
        switch (n) {
            case 0: {
                int n2 = this.is.readInt();
                byte[] byArray = new byte[n2];
                this.is.readFully(byArray);
                throw new IOException(new String(byArray));
            }
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new IOException("Unknown authentication scheme from RFB server " + n);
    }

    int readCompactLen() throws IOException {
        int n = this.is.readUnsignedByte();
        int n2 = n & 0x7F;
        if ((n & 0x80) != 0) {
            n = this.is.readUnsignedByte();
            n2 |= (n & 0x7F) << 7;
            if ((n & 0x80) != 0) {
                n = this.is.readUnsignedByte();
                n2 |= (n & 0xFF) << 14;
            }
        }
        return n2;
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.is.readUnsignedShort();
        this.copyRectSrcY = this.is.readUnsignedShort();
    }

    void readFramebufferUpdate() throws IOException {
        this.is.readByte();
        this.updateNRects = this.is.readUnsignedShort();
    }

    void readFramebufferUpdateRectHdr() throws IOException {
        this.updateRectX = this.is.readUnsignedShort();
        this.updateRectY = this.is.readUnsignedShort();
        this.updateRectW = this.is.readUnsignedShort();
        this.updateRectH = this.is.readUnsignedShort();
        this.updateRectEncoding = this.is.readInt();
        if (this.updateRectEncoding == -224 || this.updateRectEncoding == -223) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new IOException("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    String readServerCutText() throws IOException {
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        return new String(byArray2);
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.is.readUnsignedShort();
        this.framebufferHeight = this.is.readUnsignedShort();
        this.bitsPerPixel = this.is.readUnsignedByte();
        this.depth = this.is.readUnsignedByte();
        this.bigEndian = this.is.readUnsignedByte() != 0;
        this.trueColour = this.is.readUnsignedByte() != 0;
        this.redMax = this.is.readUnsignedShort();
        this.greenMax = this.is.readUnsignedShort();
        this.blueMax = this.is.readUnsignedShort();
        this.redShift = this.is.readUnsignedByte();
        this.greenShift = this.is.readUnsignedByte();
        this.blueShift = this.is.readUnsignedByte();
        byte[] byArray = new byte[3];
        this.is.readFully(byArray);
        int n = this.is.readInt();
        byte[] byArray2 = new byte[n];
        this.is.readFully(byArray2);
        this.desktopName = new String(byArray2);
        this.inNormalProtocol = true;
    }

    int readServerMessageType() throws IOException {
        return this.is.readUnsignedByte();
    }

    void readVersionMsg() throws IOException {
        byte[] byArray = new byte[12];
        this.is.readFully(byArray);
        if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
            throw new IOException("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.serverMinor = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
    }

    void setFramebufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    void writeClientCutText(String string) throws IOException {
        byte[] byArray = new byte[8 + string.length()];
        byArray[0] = 6;
        byArray[4] = (byte)(string.length() >> 24 & 0xFF);
        byArray[5] = (byte)(string.length() >> 16 & 0xFF);
        byArray[6] = (byte)(string.length() >> 8 & 0xFF);
        byArray[7] = (byte)(string.length() & 0xFF);
        System.arraycopy(string.getBytes(), 0, byArray, 8, string.length());
        this.os.write(byArray);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void writeFixColourMapEntries(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        byte[] byArray = new byte[6 + n2 * 6];
        byArray[0] = 1;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        byArray[4] = (byte)(n2 >> 8 & 0xFF);
        byArray[5] = (byte)(n2 & 0xFF);
        int n3 = 0;
        while (n3 < n2) {
            byArray[6 + n3 * 6] = (byte)(nArray[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 1] = (byte)(nArray[n3] & 0xFF);
            byArray[6 + n3 * 6 + 2] = (byte)(nArray2[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 3] = (byte)(nArray2[n3] & 0xFF);
            byArray[6 + n3 * 6 + 4] = (byte)(nArray3[n3] >> 8 & 0xFF);
            byArray[6 + n3 * 6 + 5] = (byte)(nArray3[n3] & 0xFF);
            ++n3;
        }
        this.os.write(byArray);
    }

    void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) throws IOException {
        byte[] byArray = new byte[]{3, (byte)(bl ? 1 : 0), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)};
        this.os.write(byArray);
    }

    void writeKeyEvent(int n, boolean bl) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(bl ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n & 0xFF);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void writeKeyEvent(KeyEvent var1_1) throws IOException {
        block34: {
            block35: {
                block33: {
                    var2_2 = var1_1.getKeyChar();
                    if (var2_2 == 0) {
                        var2_2 = 65535;
                    }
                    if (var2_2 == 65535 && ((var3_3 = var1_1.getKeyCode()) == 17 != 0 || var3_3 == 16 != 0 || var3_3 == 157 != 0 || var3_3 == 18 != 0)) {
                        return;
                    }
                    v0 = var3_3 = var1_1.getID() == 401;
                    if (!var1_1.isActionKey()) break block33;
                    switch (var1_1.getKeyCode()) {
                        case 36: {
                            var4_4 = 65360;
                            break block34;
                        }
                        case 37: {
                            var4_4 = 65361;
                            break block34;
                        }
                        case 38: {
                            var4_4 = 65362;
                            break block34;
                        }
                        case 39: {
                            var4_4 = 65363;
                            break block34;
                        }
                        case 40: {
                            var4_4 = 65364;
                            break block34;
                        }
                        case 33: {
                            var4_4 = 65365;
                            break block34;
                        }
                        case 34: {
                            var4_4 = 65366;
                            break block34;
                        }
                        case 35: {
                            var4_4 = 65367;
                            break block34;
                        }
                        case 155: {
                            var4_4 = 65379;
                            break block34;
                        }
                        case 112: {
                            var4_4 = 65470;
                            break block34;
                        }
                        case 113: {
                            var4_4 = 65471;
                            break block34;
                        }
                        case 114: {
                            var4_4 = 65472;
                            break block34;
                        }
                        case 115: {
                            var4_4 = 65473;
                            break block34;
                        }
                        case 116: {
                            var4_4 = 65474;
                            break block34;
                        }
                        case 117: {
                            var4_4 = 65475;
                            break block34;
                        }
                        case 118: {
                            var4_4 = 65476;
                            break block34;
                        }
                        case 119: {
                            var4_4 = 65477;
                            break block34;
                        }
                        case 120: {
                            var4_4 = 65478;
                            break block34;
                        }
                        case 121: {
                            var4_4 = 65479;
                            break block34;
                        }
                        case 122: {
                            var4_4 = 65480;
                            break block34;
                        }
                        case 123: {
                            var4_4 = 65481;
                            break block34;
                        }
                        default: {
                            return;
                        }
                    }
                }
                var4_4 = var2_2;
                if (var4_4 >= 32) ** GOTO lbl94
                if (!var1_1.isControlDown()) break block35;
                var4_4 += 96;
                break block34;
            }
            switch (var4_4) {
                case 8: {
                    var4_4 = 65288;
                    break;
                }
                case 9: {
                    var4_4 = 65289;
                    break;
                }
                case 10: {
                    var4_4 = 65293;
                    break;
                }
                case 27: {
                    var4_4 = 65307;
                    break;
                }
lbl94:
                // 1 sources

                if (var4_4 < 127) break;
                if (var4_4 == 127) {
                    var4_4 = 65535;
                    break;
                }
                if (var4_4 >= 65280 && var4_4 <= 65535) break;
                return;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(var1_1.getModifiers());
        this.writeKeyEvent(var4_4, var3_3);
        if (!var3_3) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeModifierKeyEvents(int n) {
        if ((n & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (n & 2) != 0);
        }
        if ((n & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (n & 1) != 0);
        }
        if ((n & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (n & 4) != 0);
        }
        if ((n & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (n & 8) != 0);
        }
        this.oldModifiers = n;
    }

    void writePointerEvent(MouseEvent mouseEvent) throws IOException {
        int n = mouseEvent.getModifiers();
        int n2 = 2;
        int n3 = 4;
        if (this.viewer.options.reverseMouseButtons2And3) {
            n2 = 4;
            n3 = 2;
        }
        if (mouseEvent.getID() == 501) {
            if ((n & 8) != 0) {
                this.pointerMask = n2;
                n &= 0xFFFFFFF7;
            } else if ((n & 4) != 0) {
                this.pointerMask = n3;
                n &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (mouseEvent.getID() == 502) {
            this.pointerMask = 0;
            if ((n & 8) != 0) {
                n &= 0xFFFFFFF7;
            } else if ((n & 4) != 0) {
                n &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(n);
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(n4 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n4 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n5 >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(n5 & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeSetEncodings(int[] nArray, int n) throws IOException {
        byte[] byArray = new byte[4 + 4 * n];
        byArray[0] = 2;
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
        int n2 = 0;
        while (n2 < n) {
            byArray[4 + 4 * n2] = (byte)(nArray[n2] >> 24 & 0xFF);
            byArray[5 + 4 * n2] = (byte)(nArray[n2] >> 16 & 0xFF);
            byArray[6 + 4 * n2] = (byte)(nArray[n2] >> 8 & 0xFF);
            byArray[7 + 4 * n2] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        this.os.write(byArray);
    }

    void writeSetPixelFormat(int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) throws IOException {
        byte[] byArray = new byte[20];
        byArray[0] = 0;
        byArray[4] = (byte)n;
        byArray[5] = (byte)n2;
        byArray[6] = (byte)(bl ? 1 : 0);
        byArray[7] = (byte)(bl2 ? 1 : 0);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n3 & 0xFF);
        byArray[10] = (byte)(n4 >> 8 & 0xFF);
        byArray[11] = (byte)(n4 & 0xFF);
        byArray[12] = (byte)(n5 >> 8 & 0xFF);
        byArray[13] = (byte)(n5 & 0xFF);
        byArray[14] = (byte)n6;
        byArray[15] = (byte)n7;
        byArray[16] = (byte)n8;
        this.os.write(byArray);
    }

    void writeVersionMsg() throws IOException {
        this.os.write("RFB 003.003\n".getBytes());
    }
}

