/*
 * its 2001-05-03, this is quick _dirty_ code.
 * gamma called me..doiong some wvlan-riding now..
 * wrote this lame stuff to brute force BOOTP replies
 * on wlan access points with mac-authentification.
 * sends BOOTP requests with different macs...thats all.
 *
 *
 * anonymous@segfault.net
 * err..let me fix the bugs later. ideas:
 * - ARP whohas does not work with switched network and
 *   PortSecurity enabled. send out some arp-have first!
 *   Its nice to use src mac ff:ff:ff:ff:ff:ff...works for the 
 *   switch but not OSes answer on it. only ONE (the first?) 
 *   Interface of VMWAREs NIC answers (hahahahah)
 *   Another nice idea to determine the OS of a host...
 * - multicast
 * - rarp RFC 903, skip it, bootp is newer...and dhcp also.
 * - ?! what else can be used if you dont know the network-address 
 *   and access is only granted from specific (unknown) mac's ?
 *   With BOOTP we only need to brute force the src-mac..hmm..ok.
 * + icmp address mask request ..FIXME: dst-mac if ff:ff:ff:ff:ff:ff wont work.
 * + ping 255.255.255.255
 * + request all arp's on the lan
 * - Resource Location Protocol RFC 887
 * + DHCP 1541 + 1497 (optoins) + 1533 + 1542 (clarification + extensions
 *   for bootstrap protocol)
 *   and RFC2131
 * - BOOTP RFC 951
 * - ICMP-router discovery RFC 1256 (need to verify; 224.0.0.[12]) 
 * - DRARP by sun ? MIT ? ("Dynamic Reverse Address Resolution Protocol")
 * - BOOTPARAMS by sun
 * + mac-vendor name
 * - statefull / retransmit packet if no response...
 * + limit packets/second
 * - SOCK_RAW for ppl on ppp-dialups and local cable modem hacking [no ethernet]
 *   -> arpg wont work and arp on an entire network also not.anyway..icmp + dhcp
 * -------- info ---------
 * 00:40:96:47xxxx cisco access point
 * 00:02:2D:08:2A:54 lucent wvlan
 * 00:02:2D:04:C7:18 lucent wvlan
 * 00:02:2D:02:91:73 lucent wvlan
 * 00:02:2D:0E:99:52 lucent wvlan orinoco silver
 * 00:60:1D:23:21:9B lucent wvlan
 * 00:60:1d:21:9f:32 lucent wvlan
 * 08:00:0E AT&T Wavelan (standard) & DEC RpamAbout
 * 08:00:6A AT&T Wavelan (alternate)
 * 00:00:E1 Hitachi Wavelan
 * 00:60:1D Lucent Wavelan
 * The networkname of a rg1000 are always the last 3 digits of the AP-mac
 * (without the ':' signs, rg1000 by lucent)
 *
 * problems:
 * - we dont know the destination mac . we use ff:ff:ff:ff:ff:ff: in all cases
 *   ..this most often works for icmp (except for windows2k)
 *
 * thnx to scut for dcd_icmp.h and the bscan development team :]
 * thnx to oxigen for bootp samples late late in the night.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <sys/types.h>
#ifdef HAVE_CONFIG_H
# if HAVE_SYS_WAIT_H
#  include <sys/wait.h>
# endif
# ifndef WEXITSTATUS
#  define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
# endif
# ifndef WIFEXITED
#  define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
# endif
#else
# include <sys/wait.h>
#endif
#include <libnet.h>
#include <thcrut/common.h>
#include <thcrut/network_raw.h>
#include <thcrut/dcd_icmp.h>
#include <thcrut/arpg.h>
#include <thcrut/dhcp.h>
#include <thcrut/macvendor.h>
#include <thcrut/schedule.h>
#include <thcrut/range.h>
#ifdef WITH_README
#include "../README"
#endif

u_char spfdstmac[ETH_ALEN];
struct _spfip srcip;
struct _opt opt;
struct _lnet lnet;
struct _bip bip;
struct _bmac bmac;
static struct _dhcpset ds;
static unsigned char dsbuf[1024];

void fini_libnet();

void
init_vars()
{
	memset(lnet.payload, 0, MAX_PAYLOAD_SIZE);
	opt.device = NULL;
	opt.dlt_len = ETHDLTLEN;
	opt.flags = 0;
    opt.vendorlen = 30;
	opt.handle_ip = handle_ip;
    opt.handle_arp = handle_arp;
    opt.pps = 100;
	/* vendor: lucent oricion 2000 */
    memcpy(spfdstmac, ETHBCAST, ETH_ALEN);
	srcip.addr = 0;
    srand(time(NULL));

	signal(SIGTERM, do_signal);
	signal(SIGINT, do_signal);
	signal(SIGQUIT, do_signal);
}

void
do_signal(int s)
{
	switch (s)
	{
		case SIGINT:
		case SIGQUIT:
		case SIGTERM:
			die(0, NULL);
			break;
	}
}

void
die(int code, char *fmt, ...)
{
	va_list ap;
	char buf[1024];

	if (fmt != NULL)
	{
		va_start(ap, fmt);
		vsnprintf (buf, sizeof(buf)-1, fmt, ap);
		va_end(ap);	
		fprintf(stderr, "ERROR: %s\n", buf);
	}

	if (opt.arpdpid)
		kill(opt.arpdpid, SIGTERM);

	fini_libnet();

	exit(code);
}

void
show_readme()
{
#ifdef WITH_README
    printf("%s\n", README);
#endif
}


void
usage (int code, char *str)
{

	if (str != NULL)
		fprintf(stderr, "%s\n", str);

	fprintf(stderr, 
    "thcrut [Types] [Options] [[macX[-macY]:]ipA[-ipB]] ...\n"
    "       where ipA-ipB are destination ip adresses\n"
    "       and macX-macY are source mac adresses.\n"
	"Types:\n"
	"    -b           : BOOTP requests\n"
	"    -d           : DHCP requests\n"
    "    -a           : ICMP address mask request [255.255.255.255]\n"
    "    -p           : ICMP echo request [255.255.255.255]\n"
    "    -r           : ICMP router solicitation\n"
    "    -m           : ARP 'whohas' on dst-range\n"
	"Options:\n"
#ifdef WITH_README
    "    -R              : Show README\n"
#endif
    "    -n              : Don't respond to arp-requests for srcip\n"
    "    -D <val1[,val2]>: Request this DHCP option, 0=List DHCP options\n"
    "    -l <value>      : limit packets per second to value [default=100]\n"
    "    -v <len>        : Length of vendor information [default=30]\n"
	"    -i <device>     : network device\n"
	"    -s <src-ip>     : srcIP [default 0.0.0.0]\n"
	"    -M <dst-mac>    : destination mac [usefull for ICMP requests,\n"
    "                      default ff:ff:ff:ff:ff:ff]\n"
#ifdef WITH_README
    "    Example: see README (-R)\n"
#endif
    );

	exit (code);
}

void
init_libnet()
{

	if (opt.device == NULL)
	{
		struct sockaddr_in sin;

		if (libnet_select_device (&sin, &opt.device,lnet.err_buf) == -1)
			libnet_error(LIBNET_ERR_FATAL
                        , "libnet_select_device failed: %s\n", lnet.err_buf);

	}

	opt.network = libnet_open_link_interface(opt.device, lnet.err_buf);
    if (opt.network == NULL)
		libnet_error (LIBNET_ERR_FATAL
                     , "libnet_open_link_interface: %s\n", lnet.err_buf);
}

void
fini_libnet()
{
	if (libnet_close_link_interface(opt.network) == -1)
		libnet_error(LIBNET_ERR_WARNING, "libnet_close_link_interface\n");

	libnet_destroy_packet(&lnet.packet);

}

int
do_getopt(int argc, char *argv[])
{
	extern char *optarg;
	extern int	optind, opterr, optopt;
    char *ptr;
	int c;
    unsigned short int m[6] = {0,0,0,0,0,0};

	while ((c = getopt (argc, argv, "D:i:M:s:v:l:hbdrpamR")) != -1)
	{
		switch(c)
		{
        case 'D':
            if (atoi(optarg) == 0)
            {
                list_dhcp();
                exit(0);
            } else {
                while ( (ptr = strchr(optarg, ',')) != NULL)
                {
                    *ptr++ = '\0';
                    dhcp_add_suboption(&ds, atoi(optarg));
                    optarg = ptr;
                }
                if (strlen(optarg) > 0) /* if someone gives 1, */
                    dhcp_add_suboption(&ds, atoi(optarg));
            }
            break;
        case 'l':
            opt.pps = atoi(optarg);
            break;
        case 'R':
            show_readme();
            exit(0);
            break;
        case 'v':
            opt.vendorlen = atoi(optarg);
            break;
        case 'm':
            opt.flags |= (OPT_BARP | OPT_ARPD);
            break;
		case 'a':
			opt.flags |= (OPT_ICMPADDR | OPT_ARPD);
			break;
		case 'p':
			opt.flags |= (OPT_ICMPPING | OPT_ARPD);
			break;
		case 's':
			srcip.addr = inet_addr(optarg);
			break;
		case 'r':
			opt.flags |= (OPT_ICMPRS | OPT_ARPD);   /* router solicitation */
			break;
		case 'b':
			opt.flags |= (OPT_BOOTP | OPT_ARPD);
			break;
		case 'd':
			opt.flags |= (OPT_DHCP | OPT_ARPD);
			break;
		case 'i':
			opt.device = optarg;
			break;
		case 'M':
			sscanf(optarg, "%hx:%hx:%hx:%hx:%hx:%hx", &m[0], &m[1], &m[2]
                                                    , &m[3], &m[4], &m[5]);
			for (c = 0; c < 6; c++)
				spfdstmac[c] = (u_char) m[c];
			break;
		case 'h':
			usage(0, NULL);
			break;
		default:
			break;
		}
	}

    opt.argvlist = &argv[optind];

    if (opt.argvlist[0] == NULL)
        usage(0, "You must specify a destinatioin [255.255.255.255]");

	if (opt.flags == 0)
		usage(0, "You must specify a type [-r, -b, -l, -d, ...]");

	return 0;
}

/*
 * init/split mac-mac:ip-ip
 * you _always_ have to specify at least ONE ip.
 * mac is optional.
 */
int
init_next_macip(char *str, struct _bmac *bmac, struct _bip *bip
                                                    , char *defaultmac)
{
    char *str2;

    if ( (str2 = strrchr(str, ':')) == NULL)
    {
        str2 = str;
        str = defaultmac;
    } else {
        *str2++ = '\0';
    }

    if (init_next_mac(str, bmac) != 0)
        return -1;

    if (init_next_ip(str2, bip) != 0)
        return -2;

    return 0;
}

int
list_dhcp()
{
    struct _dhcpnfoset *dfs;

    getdhcpnfoset(&dfs);
    printf("DHCP Option list, RFC 1497,1533,1541,1542\n"); 
    while ((++dfs)->name != NULL)
        printf("%4d %s\n", dfs->tag, dfs->name);


    return 0;
}

/* 
 * return != 0 on error
 * -1 = cannot malloc
 */
int
handle_arp(u_char *packet, int len)
{
    struct Arpnfo arp;
    static char *buf = NULL;

    if ((buf == NULL) && (opt.vendorlen > 0))
        if ( (buf = malloc(opt.vendorlen)) == NULL)
            return -1;

    arp.ar_op =  *(unsigned short *)(packet+6);
    memcpy(&arp.ar_sip, packet + 14, 4);
    memcpy(&arp.ar_tip, packet + 24, 4);
    arp.ar_sha = packet + 8;
    arp.ar_tha = packet + 18;

    /* FIXME: we send the first mac back. better to use */
    /* ETH_BCAST if more then just one mac              */
    if (opt.flags & OPT_ARPD)
        if ( (arp.ar_tip == srcip.addr) && (ntohs(arp.ar_op) == ARPOP_REQUEST))
        {
            if (bmac.count == 1)
                send_arp(ARPOP_REPLY, arp.ar_tip, bmac.current, arp.ar_sip
                        , arp.ar_sha);
            else
                send_arp(ARPOP_REPLY, arp.ar_tip, ETHBCAST, arp.ar_sip
                        , arp.ar_sha);
        }

    if ( (ntohs(arp.ar_op) == ARPOP_REPLY) && (opt.flags & OPT_BARP) )
    {
        printf("%-15s ", int_ntoa(arp.ar_sip));
        printf("%-15s %s", int_ntoa(arp.ar_tip),  val2mac(arp.ar_sha));
        if (opt.vendorlen > 0)
        {
            if (mac2vendor(buf, arp.ar_sha, opt.vendorlen+1) == NULL)
                snprintf(buf, opt.vendorlen, "<unknown>");
            printf(":%-*s", MIN(opt.vendorlen, 30), buf);
        }

        printf("\n"); /*, val2mac(arp.ar_tha)); */
    }

    return 0;
}

/*
 * called by handle_ip
 * ilen = icmp-header + payload size
 */
int
handle_icmp(u_char *packet, int len, struct ip *ip, struct icmp *icmp, int ilen)
{

    if (vrfy_icmp(icmp, ilen) != 0)
		return -3;	/* shorten icmp header */

    switch (icmp->icmp_type)
    {
    case ICMP_MASKREPLY:
        if (icmp->icmp_code != 0)
            return 0;
	    printf("%-15s- ", int_ntoa(ip->ip_src));
        printf("%-15s %s: ", inet_ntoa(ip->ip_dst), icmp_str(ICMP_MASKREPLY, 0));
        printf("%s\n", int_ntoa(icmp->icmp_dun.id_mask));
        break;
    case ICMP_ECHOREPLY:
        if (icmp->icmp_code != 0)
            return 0;
        printf("%-15s- ", inet_ntoa(ip->ip_src));
        printf("%-15s ", inet_ntoa(ip->ip_dst));
        printf("%s\n", icmp_str(ICMP_ECHOREPLY, 0));
        break;
    case ICMP_ROUTERADVERT:
        if (icmp->icmp_code != 0)
            return 0;
            printf("%-15s- ", inet_ntoa(ip->ip_src));
            printf("%-15s ", inet_ntoa(ip->ip_dst));
            printf("%s\n", icmp_str(ICMP_ROUTERADVERT, 0));
        break;
    case ICMP_ECHO:
        break;  /* dont show echo requests */
    default:
        printf("%-15s- ", inet_ntoa(ip->ip_src));
        printf("%-15s %s\n", inet_ntoa(ip->ip_dst), 
                            icmp_str(icmp->icmp_type, icmp->icmp_code));
    }

    return 0;
}

/*
 * called by handle_ip
 * ilen = length (udp-header + payload)
 */
int
handle_udp(u_char *packet, int len, struct ip *ip, struct udphdr *udp, int ilen)
{
    struct _bootp *bp = (struct _bootp *)(((char *)(udp))+8);
    int dpoplen, c;
    u_char dptype;
    u_char dplen;
    u_char *ptr;
    char buf[512];

    if (vrfy_udp(udp, ilen) != 0)
        return -3;

    if (udp->uh_dport != htons(68))
        return 0;

    if (bp->op != BOOTP_REPLY)
        return 0;

    if (ilen > ntohs(udp->uh_ulen))     /* short read */
        ilen = ntohs(udp->uh_ulen);
    dpoplen = ilen - 8 - sizeof(struct _bootp);


    printf("BOOTP reply from %s -> ", int_ntoa(ip->ip_src));
    printf("%s\n", int_ntoa(ip->ip_dst));
    printf("  Server      : %s\n", int_ntoa(bp->siaddr));
    printf("  Client      : %s\n", int_ntoa(bp->yiaddr));
    printf("  Relay Agent : %s\n", int_ntoa(bp->giaddr));
    printf("  ServerName  : %s\n", bp->sname);
    printf("  BootFile    : %s\n", bp->file);
    
    ptr = (u_char *)( ((char *)(bp))+sizeof(struct _bootp));
    c = 4; /* magic cookie */

    while (c + 2 < dpoplen)   /* 3 chars at least ..*/
    {
        if ( (dptype = *(ptr + c++)) == DHCP_END)
            break;
        if ( (dplen = *(ptr + c)) > dpoplen - c)
            break;

        dhcp_val2str(buf, sizeof(buf), dptype, dplen, ptr + c + 1);
        printf("  %s\n", buf);
        c += *(ptr + c) + 1;    /* the len + where len is saved */

    }

    return 0;
}

/* 
 * return 0 on success, != 0 on error [short ip headers also]
 */
int
handle_ip(u_char *packet, int len)
{
	u_short ip_options;
	struct ip *ip = (struct ip *)packet;

	if (vrfy_ip(ip, len, &ip_options) != 0)
		return -2;	/* shorten ip header */

	if (ip->ip_p == IPPROTO_ICMP)
        handle_icmp(packet, len, ip, (struct icmp *)(packet + 20 + ip_options)
                    , len - 20 - ip_options);

	if (ip->ip_p == IPPROTO_UDP)
        handle_udp(packet, len, ip, (struct udphdr *)(packet + 20 + ip_options)
                    , len - 20 - ip_options);

	return 0;
}

/*
 * build link layer + ip header 
 */
int
build_llip(u_char *mac, u_char proto, int iplen, u_long saddr, u_long daddr)
{
    libnet_build_ethernet(spfdstmac,
            mac,
            ETHERTYPE_IP,
            NULL,
            0,
            lnet.packet);

    libnet_build_ip(iplen,
            0,                      /* IP tos */
            2342,                   /* IP ID */
            0,                      /* Frag */
            128,                    /* TTL */
            proto,            /* Transport protocol */
            saddr,                 		/* Source IP */
            daddr,                 	/* Destination IP */
            NULL,                   /* Pointer to payload (none) */
            0,
            lnet.packet + LIBNET_ETH_H); /* Packet header memory */

    return 0;
}

/*
 * send packet
 * return 0 on success.
 * exit on failur!
 * FIXME: UDP checksum wrong..
 */
int
do_libnetsend(int proto, unsigned short size)
{
    int c;
    
    if (proto != 0)
        if (libnet_do_checksum(lnet.packet + LIBNET_ETH_H, proto, size) == -1)
            libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum IP failed\n");

	if (libnet_do_checksum(lnet.packet + LIBNET_ETH_H, IPPROTO_IP
                            , LIBNET_IP_H) == -1)
		libnet_error(LIBNET_ERR_FATAL, "libnet_do_checksum failed\n");

    lnet.packet_size = LIBNET_ETH_H + LIBNET_IP_H + size;
    c = libnet_write_link_layer(opt.network, opt.device, lnet.packet
                                , lnet.packet_size);
    if (c < lnet.packet_size)
        libnet_error(LIBNET_ERR_WARNING
                    , "libnet_write_link_layer, only %d bytes\n", c);

    return 0;
}


int
do_bootp(u_char *mac, u_long saddr, u_long daddr)
{

    build_llip( mac,
                IPPROTO_UDP,
                LIBNET_UDP_H + sizeof(struct _bootp) + BOOTPVENEXT_H,
                saddr,
                daddr);

	libnet_build_udp(68,           /* source port */
                    67,                  /* dest. port */
                    lnet.payload,                /* payload */
                    sizeof(struct _bootp) + BOOTPVENEXT_H,           /* payload length */
                    lnet.packet + LIBNET_ETH_H + LIBNET_IP_H);

    lnet.packet_size = LIBNET_ETH_H + LIBNET_IP_H + LIBNET_UDP_H;
	build_bootp(lnet.packet + lnet.packet_size, mac, ETH_ALEN);

    do_libnetsend(0 , LIBNET_UDP_H + sizeof(struct _bootp) + BOOTPVENEXT_H);

	return 0;
}

/*
 * daddr is NBO
 */
int
do_rarp(u_char *mac, u_long daddr)
{

    /* we will never support it. rarp processes bootp requests also. */
    fprintf(stderr, "not supported yet. use dhcp\n");
	return 0;
}

/*
 * daddr is NBO
 * do_dhcp expects a filled but unterminated DHCP request in "ds".
 * do_dhcp terminates with DHCP_END
 */
int
do_dhcp(u_char *mac, u_long saddr, u_long daddr)
{

    build_llip( mac,
                IPPROTO_UDP,
                LIBNET_UDP_H + sizeof(struct _bootp) + DHCP_MIN_OPT,
                saddr, 
                daddr);

	libnet_build_udp(68,           /* source port */
                     67,                  /* dest. port */
                     lnet.payload,                /* payload */
                     sizeof(struct _bootp) + DHCP_MIN_OPT,           /* payload length */
                     lnet.packet + LIBNET_ETH_H + LIBNET_IP_H);

    lnet.packet_size = LIBNET_ETH_H + LIBNET_IP_H + LIBNET_UDP_H;
	build_bootp(lnet.packet + lnet.packet_size, mac, ETH_ALEN);

    dhcp_add_option(&ds, DHCP_END, 0, NULL);
    memcpy(lnet.packet + lnet.packet_size + sizeof(struct _bootp)
            , dsbuf, ds.lsize);
    
    do_libnetsend(0 , LIBNET_UDP_H + sizeof(struct _bootp) + DHCP_MIN_OPT);
	
	return 0;
}

/*
 * everything in NBO
 */
int
do_icmpaddr(u_char *mac, u_long saddr, u_long daddr)
{

    build_llip(mac, IPPROTO_ICMP, LIBNET_ICMP_MASK_H, saddr, daddr);

    libnet_build_icmp_mask(ICMP_MASKREQ,           /* type */
    	0,                                  /* code */
        244,                                /* id */
        0,                                  /* seq */
        0,
        NULL,                               /* pointer to payload */
        0,                                  /* payload length */
        lnet.packet + LIBNET_ETH_H + LIBNET_IP_H);        /* packet header memory */

    do_libnetsend(IPPROTO_ICMP, LIBNET_ICMP_MASK_H);

	return 0;
}

/*
 * everything in NBO
 */
int
do_icmpping(char *mac, u_long saddr, u_long daddr)
{

    build_llip(mac, IPPROTO_ICMP, LIBNET_ICMP_ECHO_H, saddr, daddr);

    libnet_build_icmp_echo(ICMP_ECHO,           /* type */
    	0,                                  /* code */
        242,                                /* id */
        0,                                  /* seq */
        NULL,                               /* pointer to payload */
        0,                                  /* payload length */
        lnet.packet + LIBNET_ETH_H + LIBNET_IP_H);        /* packet header memory */

    do_libnetsend(IPPROTO_ICMP, LIBNET_ICMP_ECHO_H + 56);

	return 0;
}

/*
 * everything in NBO
 */
int
do_icmproutersol(char *mac, u_long saddr, u_long daddr)
{

    build_llip(mac, IPPROTO_ICMP, LIBNET_ICMP_ECHO_H, saddr, daddr);

    libnet_build_icmp_echo(ICMP_ROUTERSOLICIT,           /* type */
    	0,                                  /* code */
        0,                                /* id */
        0,                                  /* seq */
        NULL,                               /* pointer to payload */
        0,                                  /* payload length */
        lnet.packet + LIBNET_ETH_H + LIBNET_IP_H);  /* packet header memory */

    do_libnetsend(IPPROTO_ICMP, LIBNET_ICMP_ECHO_H);

    return 0;
}

/*
 * input is NBO
 */
int
do_barp(char *smac, u_long daddr)
{
    send_arp(ARPOP_REQUEST, srcip.addr, bmac.current, daddr, spfdstmac);

    return 0;
}

/*
 * print our the last subtoptions (one:value two:value, ...)
 * We trust our input.
 */
void
dhcp_print_lastsub(struct _dhcpset *ds)
{
    unsigned char len;    /* number of suboptions */
    unsigned char *ptr;
    unsigned char i=0;
    unsigned char value;

    if (ds->lastsub == NULL)
        return;

    len = *(ds->lastsub + 1);
    ptr = ds->lastsub + 2;
    for (i=0; i < len; i++)
    {
        value = *ptr++;
        fprintf(stderr, "%s(%u) ", dhcp_str(value), value);
    }

    fprintf(stderr, "\n");

}

int
main(int argc, char *argv[])
{
    u_long targetip[1];
    u_char *srcmac;
    struct _schedule sd;

	init_vars();			/* set default values 	*/
    /* setting magic cookie, 4 bytes */
    init_dhcpset(&ds, dsbuf, DHCP_MIN_OPT);
    /* MSGTYPE, 3 bytes */
    dhcp_add_option(&ds, DHCP_MSGTYPE, 1, "\x01");
    /* DHCP Paramreq, 2 bytes */
    dhcp_add_option(&ds, DHCP_PARAMREQ, 0, NULL);
	do_getopt(argc, argv);	/* process arguements	*/
    /* if noone added some suboptions with -D <option>... */
    /* if the user didnt added options with -D, use our defaults */
    if ( (opt.flags & OPT_DHCP ) && (ds.lsize <= 9))
    {
        dhcp_add_suboption(&ds, DHCP_SUBMASK);
        dhcp_add_suboption(&ds, DHCP_TIMEOFF);
        dhcp_add_suboption(&ds, DHCP_ROUTER);
        dhcp_add_suboption(&ds, DHCP_DNS);
        dhcp_add_suboption(&ds, DHCP_HOSTNAME);
        dhcp_add_suboption(&ds, DHCP_DOMAIN);
        dhcp_add_suboption(&ds, DHCP_BCAST);
        dhcp_add_suboption(&ds, DHCP_MASKDISC);
        dhcp_add_suboption(&ds, DHCP_ROUTDISC);
        dhcp_add_suboption(&ds, DHCP_STATROUTES);
        dhcp_add_suboption(&ds, DHCP_NISDOM);
        dhcp_add_suboption(&ds, DHCP_NISSERV);
        dhcp_add_suboption(&ds, DHCP_NTP);
        dhcp_add_suboption(&ds, DHCP_NBNS);
        dhcp_add_suboption(&ds, DHCP_NBDD);
        /* 2BC: we dont need to terminate them ? */
    }

    readvendornames(NULL);  /* read in mac<->vendor database */
	init_libnet();			/* init libnet stuff	*/

    if (init_next_macip(opt.argvlist[0], &bmac, &bip, DEFAULTMACSTR) != 0)
        die(-1, "Wrong mac/ip range: %s", opt.argvlist[0]);

	fprintf(stderr, "Device      : %s\n", opt.device);
	fprintf(stderr, "srcMAC      : %s", val2mac(bmac.start_mac));
    fprintf(stderr, "-%s\n", val2mac(bmac.end_mac));
    fprintf(stderr, "dstMAC      : %s\n", val2mac(spfdstmac));
    fprintf(stderr, "srcIP       : %s\n", int_ntoa(srcip.addr));
    fprintf(stderr, "packets/sec : %d\n", opt.pps);
    /*
     * we only use ONE suboption field. so we only need to printout
     * starting from the last suboption field 
     */
    if (opt.flags & OPT_DHCP)
    {
        fprintf(stderr, "DHCP Opts   : ");
        dhcp_print_lastsub(&ds);    /* print last suboptions */
    }

	if (libnet_init_packet(MAX_PAYLOAD_SIZE, &lnet.packet) == -1)
		libnet_error (LIBNET_ERR_FATAL, "libnet_init_packet failed\n");

	printf("starting capture process...\n");
	start_arpd();
    usleep(500*1000);   /* FIXME: use ipc or signal/kill */
    init_schedule(&sd, opt.pps);

    /* 
     * with each ip and ANY mac do ...
     */
    while (1)
    {
        if ( (next_ip(&bip, targetip)) == NULL)
        {
            if ((++opt.argvlist)[0] == NULL)
                break;
            if (init_next_macip(opt.argvlist[0], &bmac, &bip, DEFAULTMACSTR) != 0)
                break;

            continue;   /* the while loop...*/
        }
        reset_next_mac(&bmac);

        *targetip = htonl(*targetip);

        while (1)
        {
            if ( (srcmac = next_mac(&bmac)) == NULL)
                break;

            if (opt.flags & OPT_BARP)       /* this for EVERY arp ..hui..*/
            {
                do_barp(srcmac, *targetip);
                wait_schedule(&sd);
            }
		    if (opt.flags & OPT_RARP)
		    {
			    do_rarp(srcmac, *targetip);
			    wait_schedule(&sd);
		    }
		    if (opt.flags & OPT_BOOTP)
		    {
			    do_bootp(srcmac, srcip.addr, *targetip);
			    wait_schedule(&sd);
		    }
		    if (opt.flags & OPT_DHCP)
		    {
			    do_dhcp(srcmac, srcip.addr, *targetip);
			    wait_schedule(&sd);
		    }
		    if (opt.flags & OPT_ICMPADDR)
		    {
			    do_icmpaddr(srcmac, srcip.addr, *targetip);
			    wait_schedule(&sd);
		    }
		    if (opt.flags & OPT_ICMPPING)
		    {
			    do_icmpping(srcmac, srcip.addr, *targetip);
			    wait_schedule(&sd);
		    }
		    if (opt.flags & OPT_ICMPRS)
		    {
			    do_icmproutersol(srcmac, srcip.addr, *targetip);
			    wait_schedule(&sd);
            }
	    }   /* eo while loop next mac */
    }   /* eo while loop next ip */

	sleep(3);
	printf("d0ne\n");

	die(0, NULL);
	return 0;
}
