/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/special.e,v 4.20 2000/08/04 13:39:22 william Exp $
 */

#ifndef _SPECIAL_E_
#define _SPECIAL_E_

extern int	placingTopObj;
extern int	connectingPortsByWire;
extern int	connectingPortsFromInternalCommand;

#ifdef _INCLUDE_FROM_SPECIAL_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_SPECIAL_C_*/

extern struct ObjRec	* ReadSymbol ARGS_DECL((FILE *, int FileType));
extern struct ObjRec	* GetObjRepresentation ARGS_DECL((char *PathName,
			                                  char *SymName,
			                                  int FileType));
extern unsigned int	PlaceTopObj ARGS_DECL((struct ObjRec *));
extern void	Instantiate ARGS_DECL((void));
extern int	ObjIsAPort ARGS_DECL((struct ObjRec *));
extern void	ConnectTwoPortsByAWire ARGS_DECL((void));
extern void	RenameSignalNameForAPort ARGS_DECL((void));
extern void	ClearSignalNameForAPort ARGS_DECL((void));
extern void	MakeSymbolic ARGS_DECL((void));
extern void	UnMakeSymbolic ARGS_DECL((void));
extern int	MakeIconic ARGS_DECL((char *SymPath, int record_cmd));
extern void	UnMakeIconic ARGS_DECL((void));
extern void	ImportAttrs ARGS_DECL((void));
extern void	ExportAttrs ARGS_DECL((void));
extern void	MergeWithTable ARGS_DECL((void));
extern void	ExportToTable ARGS_DECL((void));
extern void     ToggleShowWireSignalName ARGS_DECL((void));
extern int      RefreshPortMenu ARGS_DECL((TgMenu*));
extern TgMenu   *CreatePortMenu ARGS_DECL((TgMenu*, int X, int Y, TgMenuInfo*,
		                           int status_str_xlated));
extern void	RefreshSpecialMenu ARGS_DECL((TgMenu*));
extern int	SpecialMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern void	CleanUpSpecial ARGS_DECL((void));
extern int	InitSpecial ARGS_DECL((void));

#ifdef _INCLUDE_FROM_SPECIAL_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_SPECIAL_C_*/

#endif /*_SPECIAL_E_*/
