/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/navigate.e,v 4.10 2000/01/15 22:24:55 william Exp $
 */

#ifndef _NAVIGATE_E_
#define _NAVIGATE_E_

extern int	navigatingBackAndForth;
extern int	inHyperSpace;
extern int	inSlideShow;
extern int	visibleGridInSlideShow;
extern int	slideShowInfoValid;
extern char	* slideShowBorderColor;
extern int	slideShowXOffset;
extern int	slideShowYOffset;
extern int	autoHyperSpaceOnRemote;
extern int	allowLaunchInHyperSpace;
extern int	navigateRefresh;
extern int	goHyperSpaceInSlideShow;

#ifdef _INCLUDE_FROM_NAVIGATE_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_NAVIGATE_C_*/

extern int	ParseXYSpec ARGS_DECL((char *spec, int *pnx, int *pny));
extern int	ParseWHSpec ARGS_DECL((char *spec, int *pnw, int *pnh));
extern void	CleanUpSlideShowInfo ARGS_DECL((void));
extern void	CleanUpNavigate ARGS_DECL((void));
extern void	InitNavigate ARGS_DECL((void));

extern void	UpdateLRU ARGS_DECL((struct URLCacheRec *url_cache));
extern struct URLCacheRec	*FindURLCache ARGS_DECL((char *psz_url,
				                         int update_lru));
extern void	UpdateURLCache ARGS_DECL((char *psz_url, char *psz_remote_buf,
		                          char *psz_content_type,
		                          int remote_buf_sz, int is_html));

extern void	BeforeNavigate ARGS_DECL((void));
extern void	CommitNavigate ARGS_DECL((void));

extern void	NavigateBack ARGS_DECL((void));
extern void	NavigateForward ARGS_DECL((void));
extern void	AdjustNavigate ARGS_DECL((void));
extern void	NavigateRefresh ARGS_DECL((void));
extern void	NavigateHotList ARGS_DECL((void));
extern void	NavigateAddToHotList ARGS_DECL((void));
extern void	NavigateSessionHistory ARGS_DECL((void));
extern void	ToggleHyperSpace ARGS_DECL((int KeepSelected));
extern void	ToggleSlideShow ARGS_DECL((void));
extern void	SetSlideShowBorderColor ARGS_DECL((void));
extern void	SetSlideShowWindowOffsets ARGS_DECL((void));
extern void	ToggleVisibleGridInSlideShow ARGS_DECL((void));
extern void	GoHyperSpaceInSlideShow ARGS_DECL((void));
extern void	FreehandModeInSlideShow ARGS_DECL((void));
extern int	RefreshSlideShowModeMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateSlideShowModeMenu ARGS_DECL((TgMenu*, int X, int Y,
		                                    TgMenuInfo*,
		                                    int status_str_xlated));
extern int	SlideShowModeMenu ARGS_DECL((int X, int Y, int TrackMenubar));
extern int	RefreshSlideShowMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateSlideShowMenu ARGS_DECL((TgMenu*, int X, int Y,
		                                TgMenuInfo*,
		                                int status_str_xlated));
extern int	ReadSlideShowInfo ARGS_DECL((char*));

extern void	RefreshNavigateMenu ARGS_DECL((TgMenu*));
extern TgMenu	*CreateNavigateMenu ARGS_DECL((TgMenu*, int X, int Y,
		                               TgMenuInfo*,
		                               int status_str_xlated));
extern int	NavigateMenu ARGS_DECL((int X, int Y, int TrackMenubar));

#ifdef _INCLUDE_FROM_NAVIGATE_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_NAVIGATE_C_*/

#endif /*_NAVIGATE_E_*/
