/*
 * Author:      William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990-2000, William Chia-Wei Cheng.
 *
 * Permission limited to the use, copy, display, distribute without
 * charging for a fee, and produce derivative works of "tgif" and
 * its documentation for not-for-profit purpose is hereby granted by
 * the Author, provided that the above copyright notice appears in
 * all copies made of "tgif" and that both the copyright notice
 * and this permission notice appear in supporting documentation,
 * and that the name of the Author not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.  All other rights (including, but not limited to, the
 * right to sell "tgif", the right to sell or distribute derivative
 * works of "tgif", the right to distribute "tgif" for a fee, and
 * the right to include "tgif" or derivative works of "tgif" in a
 * for-sale product or service) are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/mainmenu.e,v 4.7 2000/01/15 22:24:50 william Exp $
 */

#ifndef _MAINMENU_E_
#define _MAINMENU_E_

typedef int (ENUMPOPUPMENUFN)ARGS_DECL((int, Window, void*));

extern int	pinnedMainMenu;
extern int	mainMenuPinDistance;
extern Window	mainMenuWindow;

extern int	numStacking;
extern Window	* stackingWins;

extern int	titledPinnedMenu;
extern int	btn3PopupModeMenu;

#ifdef _INCLUDE_FROM_MAINMENU_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_MAINMENU_C_*/

extern void	InitMainMenu ARGS_DECL((void));
extern void	CleanUpMainMenu ARGS_DECL((void));
extern void	SaveMainWinPosition ARGS_DECL((unsigned int X, unsigned int Y));
extern void	MoveMainMenuWindow ARGS_DECL((unsigned int X, unsigned int Y));
extern void	GetPopupXY ARGS_DECL((Window, int *px, int *py));
extern void	GetPopupWH ARGS_DECL((Window, int *pw, int *ph));
extern void	SaveStackingOrder ARGS_DECL((void));
extern Window	TgRealizePinnedMenuWindow ARGS_DECL((TgMenu*, int X, int Y,
		                                     int W, int H));
extern int	TgWindowIsPinnedMenu ARGS_DECL((Window, int Index));
extern int	TgHandlePinnedMenuEvent ARGS_DECL((Window, int Index, XEvent*));
extern void	UpdatePinnedMenu ARGS_DECL((int Index));
extern void	UpdateAllPinnedMenus ARGS_DECL((void));
extern void	DestroyPinnedMenu ARGS_DECL((int Index));
extern void	HidePopupMenusForSlideShow ARGS_DECL((void));
extern void	ShowPopupMenusForSlideShow ARGS_DECL((void));
extern void	EnumPopupMenuWindow ARGS_DECL((ENUMPOPUPMENUFN*, void*));

#ifdef _INCLUDE_FROM_MAINMENU_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_MAINMENU_C_*/

#endif /*_MAINMENU_E_*/
