/***************************************************************************
 *   copyright            : (C) 2004 by Pascal Brachet & Joel Amblard      *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEBPUBLISHDIALOG_H
#define WEBPUBLISHDIALOG_H

#include <qvariant.h>
#include <qpixmap.h>
#include <qprocess.h>
#include <qmap.h>
#include <qvaluevector.h> 
#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class QFrame;
class QGroupBox;
class QLabel;
class QSpinBox;
class QLineEdit;
class QComboBox;
class QTextEdit;
class QPushButton;

typedef  QMap<QString, QString> LinkMap;

class webpublishdialog : public QDialog  {
   Q_OBJECT
public:
	webpublishdialog(QWidget *parent=0, const char *name=0);
	~webpublishdialog();
    QString PROGRAMDIR, DVIOPT, ADDRESS, ALIGN, CONTENTNAME, COLORLINK, DEPTH, BASE, TITLE, WORKDIR, HTMLDIR, BROWSER, LASTDIR;
    int NAVIGATION, COMPIL, MAXWIDTH, USERWIDTH, STARTINDEX, COLORDEPTH, TOCDEPTH, nb_pages, nb_content_pages, id_page, x1, y1, x2, y2;
    bool NOINDEX, NOINTERLACE, FINPROCESS, ERROR;
    QFrame* frame3;
    QPushButton* LaunchButton;
    QLabel* inputfileLabel;
    QGroupBox* htmlgroupBox;
    QLabel* alignmentLabel;
    QLabel* titleLabel;
    QLabel* indexLabel;
    QLabel* footnoteLabel;
    QLabel* navigationLabel;
    QComboBox* indexcomboBox;
    QComboBox* alignmentcomboBox;
    QComboBox* navigationBox;
    QLineEdit* titleEdit;
    QLineEdit* footnoteEdit;
    QGroupBox* groupBox3;
    QLabel* colordepthLabel;
    QLabel* widthLabel;
    QSpinBox* widthspinBox;
    QComboBox* interlacecomboBox;
    QComboBox* colordepthcomboBox;
    QLabel* interlaceLabel;
    QGroupBox* groupBox4;
    QTextEdit* messagetextEdit;
    QLabel* browserLabel;
    QLineEdit* browserEdit;
    QPushButton* inputfileButton;
    QLineEdit* inputfileEdit;
    QGroupBox* latexgroupBox;
    QLabel* contentLabel;
    QSpinBox* compilationspinBox;
    QSpinBox* tocdepthspinBox;
    QSpinBox* startindexspinBox;
    QLabel* startindexLabel;
    QLabel* tocdepthLabel;
    QLabel* compilationLabel;
    QLineEdit* contentEdit;
    QPushButton* aboutButton;
    QPushButton* quitButton;
    
protected:
    void closeEvent( QCloseEvent* );

private slots:
    void init();
    void convert( const QString &fileName );
    void RunCommand(QString comd,bool waitendprocess);
    void SlotEndProcess();
    void copyFile(QString from_file, QString to_file);
    void removeFile(QString file);
    void ps2gif(QString input,QString output,int id_page,int w,int h,int maxw);
    void writepages(QString mode);
    void fatalerror(QString msg);
    void latexerror(QString logfile);
    void clean();
    void aboutSlot();
    void proceedSlot();
    void browseSlot();
    void writesettings();
    void readsettings();
    void applyusersettings();

private:
    QString filename;
    QProcess *proc;
    int nbpagesps(QString psfile);
    QString header();
    QString footer();
    QString content_navigation(int page,int numpages,QString up_page);
    QString codepic(QString pic_name, QString map_name);
    LinkMap loc;
    QValueVector<int> x1box, y1box, x2box, y2box;
};


#endif

