/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QTEXMAKER_H
#define QTEXMAKER_H

#include <qmainwindow.h>
#include <qmap.h>
#include <qsplitter.h>
#include <qwidget.h>
#include <qstrlist.h>
#include <qstringlist.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qcombobox.h>
#include <qguardedptr.h>
#include <qlayout.h>
#include <qframe.h>
#include <qstring.h>
#include <qcolor.h>
#include <qprocess.h>
#include <qlabel.h>

#include "latexeditorview.h"
#include "latexeditor.h"
#include "messagewidget.h"
#include "structdialog.h"
#include "quickdocumentdialog.h"
#include "letterdialog.h"
#include "tabdialog.h"
#include "arraydialog.h"
#include "tabbingdialog.h"
#include "usermenudialog.h"
#include "usertooldialog.h"
#include "gotolinedialog.h"
#include "replacedialog.h"
#include "finddialog.h"
#include "toolsoptionsdialog.h"
#include "filechooser.h"
#include "symbolview.h"
#include "kmultiverttabbar.h"
#include "refdialog.h"
#include "metapostview.h"
#include "helpwidget.h"
#include "webpublishdialog.h"

#define ID_HINTTEXT 301
#define ID_LINE_COLUMN 302
#define ID_MODE 303
#define ID_VIEW_OUTPUTVIEW 304
#define ID_VIEW_STRUCTVIEW 305

typedef  QMap<LatexEditorView*, QString> FilesMap;
typedef  QString Userlist[10];
typedef  QString UserCd[5];

class Texmaker : public QMainWindow
{
    Q_OBJECT

public:
    Texmaker( QWidget *parent = 0, const char *name = 0 );
    ~Texmaker();
    QString getName();
    QFont EditorFont;

public slots:
    void load( const QString &f );
    void setLine( const QString &line );
private:
    void setupActions();
    void closeEvent(QCloseEvent *e);
    LatexEditorView *currentEditorView() const;
    void doConnections( LatexEditor *e );
    bool FileAlreadyOpen(QString f);

    KMultiVertTabBar *ButtonBar;
    structdialog *stDlg;
    quickdocumentdialog *startDlg;
    refdialog *refDlg;
    letterdialog *ltDlg;
    tabdialog *quickDlg;
    arraydialog *arrayDlg;
    tabbingdialog *tabDlg;
    usermenudialog *umDlg;
    usertooldialog *utDlg;
    QGuardedPtr<FindDialog> findDialog;
    QGuardedPtr<ReplaceDialog> replaceDialog;
    QGuardedPtr<GotoLineDialog> gotoLineDialog;
    toolsoptionsdialog *toDlg;
    webpublishdialog *ttwpDlg;
    FileChooser *sfDlg;
    SymbolView *symbol_view;
    QString document_class, typeface_size, paper_size, document_encoding, author;
    bool ams_packages, makeidx_package;
    QString latex_command, viewdvi_command, dvips_command, dvipdf_command, metapost_command;
    QString viewps_command, ps2pdf_command, makeindex_command, bibtex_command, pdflatex_command, viewpdf_command;
    QString lastDocument,MasterName, input_encoding;
    QString struct_level1, struct_level2, struct_level3, struct_level4, struct_level5;
    QStrList *recentFilesList;
    Userlist UserMenuName, UserMenuTag;
    UserCd UserToolName, UserToolCommand;
    bool logpresent, singlemode, showstructview,showoutputview, wordwrap, parenmatch, FINPROCESS;
    bool htmlpresent,pspresent, dvipresent, symbol_present, watchfile, showline;
    int split1_right, split1_left, split2_top, split2_bottom, quickmode, lastvtab;
    QTabWidget *tabWidget, *Outputview;
    QFrame *Structview;
    QHBoxLayout *Structview_layout;
    QWidgetStack *topWidgetStack;
    QSplitter *splitter1, *splitter2 ;
    QListView* outstruct;
    QListViewItem *parent_level[5],*lastChild, *Child;
    metapostview *mpview;
    MessageWidget* OutputWidget;
    QStrList *errorlist;
    QStringList structlist, labelitem, structitem, userClassList, userPaperList, userEncodingList, userOptionsList;
    FilesMap filenames;
    QProcess *proc;
    QPopupMenu *recent, *usermenu1, *usermenu2 ,*view, *options, *menuhelp;
    QGuardedPtr<HelpWidget> help_widget;
    QLabel *stat1, *stat2, *stat3;

private slots:
    void fileNew();
    void fileOpen();
    void fileOpenRecent(int id);
    void fileSave();
    void fileSaveAll();
    void fileSaveAs();
    void filePrint();
    void fileClose();
    void fileCloseAll();
    void fileExit();
    void AddRecentFile(const QString &f);
    
    void editUndo();
    void editRedo();
    void editCut();
    void editCopy();
    void editPaste();
    void editSelectAll();
    void editFind();
    void editFindNext();
    void editReplace();
    void editGotoLine();
    void editComment();
    void editUncomment();
    void editIndent();

    void InsertTag(QString Entity, int dx, int dy);
    void UpdateLineColStatus();
    void UpdateCaption();
    void NewDocumentStatus(bool m);
    void gotoNextDocument();
    void gotoPrevDocument();

    void ReadSettings();
    void SaveSettings();
    void GeneralOptions();

    void QuickBuild();

    void RunCommand(QString comd,bool waitendprocess);
    void readFromStderr();
    void SlotEndProcess();
    void Latex();
    void ViewDvi();
    void DviToPS();
    void ViewPS();
    void PDFLatex();
    void ViewPDF();
    void CleanAll();
    void MakeBib();
    void MakeIndex();
    void PStoPDF();
    void DVItoPDF();
    void MetaPost();
    void UserTool1();
    void UserTool2();
    void UserTool3();
    void UserTool4();
    void UserTool5();
    void WebPublish();

   void UpdateStructure();
   void ShowStructure();
   void ClickedOnStructure(QListViewItem *);
   void DoubleClickedOnStructure(QListViewItem *);

   void ViewLog();
   void ClickedOnOutput(int parag, int index);
   void QuickLatexError();
   void LatexError();
   void NextError();
   void PreviousError();

   void QuickTabular();
   void QuickArray();
   void QuickTabbing();
   void QuickLetter();
   void QuickDocument();
   void Insert1();
   void Insert1bis();
   void Insert1ter();
   void Insert2();
   void Insert3();
   void Insert4();
   void Insert5();
   void Insert6();
   void Insert6bis();
   void Insert7();
   void Insert8();
   void Insert9();
   void Insert10();
   void Insert11();
   void Insert12();
   void Insert13();
   void Insert14();
   void Insert15();
   void Insert16();
   void Insert17();
   void Insert18();
   void Insert19();
   void Insert20();
   void Insert21();
   void Insert22();
   void Insert23();
   void Insert24();
   void Insert25();
   void Insert26();
   void Insert27();
   void Insert28();
   void Insert29();
   void Insert30();
   void Insert31();
   void Insert32();
   void Insert33();
   void Insert34();
   void Insert35();
   void Insert36();
   void Insert37();
   void Insert37bis();
   void Insert37ter();
   void Insert38();
   void Insert39();
   void Insert40();
   void Insert41();
   void Insert42();
   void Insert43();
   void Insert44();
   void Insert45();
   void Insert46();
   void Insert47();
   void Insert48();
   void Insert49();
   void Insert50();
   void Insert51();
   void Insert52();
   void SizeCommand(const QString& text);
   void SectionCommand(const QString& text);
   void OtherCommand(const QString& text);
   void NewLine();

   void InsertMath1();
   void InsertMath2();
   void InsertMath3();
   void InsertMath4();
   void InsertMath5();
   void InsertMath6();
   void InsertMath7();
   void InsertMath8();
   void InsertMath9();
   void InsertMath10();
   void InsertMath16();
   void InsertMath66();
   void InsertMath67();
   void InsertMath68();
   void InsertMath69();
   void InsertMath70();
   void InsertMath71();
   void InsertMath72();
   void InsertMath73();
   void InsertMath74();
   void InsertMath75();
   void InsertMath76();
   void InsertMath77();
   void InsertMath78();
   void InsertMath79();
   void InsertMath80();
   void InsertMath81();
   void InsertMath82();
   void InsertMath83();
   void InsertMath84();
   void InsertMath85();
   void InsertMath86();
   void InsertMath87();
   void InsertMath88();
   void InsertMath89();
   void InsertMath90();
   void LeftDelimiter(const QString& text);
   void RightDelimiter(const QString& text);
   void InsertSymbol();
   void InsertMetaPost(QListBoxItem *);


   void InsertBib1();
   void InsertBib2();
   void InsertBib3();
   void InsertBib4();
   void InsertBib5();
   void InsertBib6();
   void InsertBib7();
   void InsertBib8();
   void InsertBib9();
   void InsertBib10();
   void InsertBib11();
   void InsertBib12();
   void InsertBib13();

   void InsertUserTag1();
   void InsertUserTag2();
   void InsertUserTag3();
   void InsertUserTag4();
   void InsertUserTag5();
   void InsertUserTag6();
   void InsertUserTag7();
   void InsertUserTag8();
   void InsertUserTag9();
   void InsertUserTag10();
   void EditUserMenu();
   void EditUserTool();

   void ToggleMode();
   void ToggleStructView();
   void ToggleOutputView();
   void ShowStructView(bool change);
   void ShowOutputView(bool change);

   void LatexHelp();
   void UserManualHelp();
   void HelpAbout();
   
   void showVertPage(int page);
   //void changeInputEncoding();

   QString DetectEpsSize(const QString &epsfile);
   void CleanBib();

};


#endif

