/***************************************************************************
 *   copyright            : (C) 2003 by Pascal Brachet                     *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "syntaxlatex.h"
#include <qcolor.h>
#include <qregexp.h>

SyntaxLatex::SyntaxLatex(QTextEdit * textEdit,QFont & efont) : QSyntaxHighlighter(textEdit)
{
	FontStandard=efont;
	ColorStandard = QColor(0x00, 0x00, 0x00);
	ColorComment = QColor(0x83, 0x81, 0x83);
	ColorMath = QColor(0x00,0x80, 0x00);
	ColorCommand=QColor(0x80, 0x00, 0x00);
	ColorKeyword=QColor(0x00, 0x00, 0xCC);
	KeyWords= QStringList::split("," ,"section{,subsection{,subsubsection{,chapter{,part{,paragraph{,subparagraph{,section*{,subsection*{,subsubsection*{,chapter*{,part*{,paragraph*{,subparagraph*{,label{,includegraphics{,includegraphics[,includegraphics*{,includegraphics*[,include{,input{,begin{,end{");
};



int SyntaxLatex::highlightParagraph(const QString & text, int endStateOfLastPara)
{
uint i = 0;
int state = endStateOfLastPara;
if (state==-2) state=0;
QChar last, next ,ch;
QString buffer;
const int StateStandard = 0;
const int StateComment = 1;
const int StateMath = 2;
const int StateCommand=3;

while (i < text.length())
	{
        ch = text.at( i ).latin1();
	buffer += ch;
	if ( i < text.length()-1 ) next = text.at( i+1 ).latin1();

        switch (state) {
	
	case StateStandard: {
		switch (ch) {
		case '\\' :{
			setFormat( i, 1,FontStandard, ColorCommand );
			state=StateCommand;
		}break;
		case '$' : {
			setFormat( i, 1,FontStandard, ColorMath);
			state=StateMath;
			if (next=='$')
				{
				i++;
				setFormat( i, 1,FontStandard, ColorMath);
				}
		}break;
		case '%' : {
			setFormat( i, 1,FontStandard, ColorComment);
			state=StateComment;
		} break;
		default: {
			setFormat( i, 1,FontStandard, ColorStandard);
			state=StateStandard;
		} break;
		}
	buffer = QString::null;
	} break;
	
	case StateComment: {
	setFormat( i, 1,FontStandard, ColorComment);
	state=StateComment;
	buffer = QString::null;
	} break;

	case StateMath: {
		switch (ch) {
		case '$' : {
			setFormat( i, 1,FontStandard, ColorMath);
			state=StateStandard;
			if (next=='$')
				{
				i++;
				setFormat( i, 1,FontStandard, ColorMath);
				}
		}break;
		default: {
			setFormat( i, 1,FontStandard, ColorMath);
			state=StateMath;
		} break;
		}
	buffer = QString::null;
	} break;

	case StateCommand:{
		switch (ch) {
		case '$' : {
			if (last=='\\')
				{
				setFormat( i, 1,FontStandard, ColorCommand);
				state=StateStandard;
				}
			else
				{
				setFormat( i, 1,FontStandard, ColorMath);
				state=StateMath;
				}
		}break;
		case '%' : {
			if (last=='\\')
				{
				setFormat( i, 1,FontStandard, ColorStandard);
				state=StateStandard;
				}
			else
				{
				setFormat( i, 1,FontStandard, ColorComment);
				state=StateComment;
         			}
		} break;
		case ' ':{
         		setFormat( i, 1,FontStandard, ColorStandard);
         		state=StateStandard;
		} break;
		case '(': case '[': case '{': case ')': case ']': case '}':{
			setFormat( i, 1,FontStandard, ColorStandard);
			state=StateStandard;
			if ( buffer.length() > 0 )
				{
				for ( QStringList::Iterator it = KeyWords.begin(); it != KeyWords.end(); ++it ) 
					{
        				if (( *it ).find( buffer )!=-1) setFormat( i - buffer.length(), buffer.length(),FontStandard,ColorKeyword);
					}
				}
		} break;
		case '\\' : case ',' : case ';': case '\'': case '\"' : case '`': case '^': case '~': {
			if (last=='\\')
			{
				setFormat( i, 1,FontStandard, ColorCommand);
				state=StateStandard;
			}
			else
			{
				setFormat( i, 1,FontStandard, ColorCommand);
				state=StateCommand;
			}
		}break;
	     	default: {
         		setFormat( i, 1,FontStandard, ColorCommand);
         		state=StateCommand;
		} break;
		}
	} break;
	}
	last = ch;
	i++;
	}
if ( state == StateComment ) 
 	{
	return StateStandard ;
    	} 
else if ( state == StateMath ) 
	{
	return StateMath ;
    	} 
else 
	{
	return StateStandard ;
    	}
    
};

void SyntaxLatex::setFont(QFont & new_font)
{
FontStandard=new_font;
}

