/*
 * Copyright (c) 2002, 2003, The Tendra Project <http://www.tendra.org/>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *  		 Crown Copyright (c) 1997
 *  
 *  This TenDRA(r) Computer Program is subject to Copyright
 *  owned by the United Kingdom Secretary of State for Defence
 *  acting through the Defence Evaluation and Research Agency
 *  (DERA).  It is made available to Recipients with a
 *  royalty-free licence for its use, reproduction, transfer
 *  to other parties and amendment for any purpose not excluding
 *  product development provided that any such use et cetera
 *  shall be deemed to be acceptance of the following conditions:-
 *  
 *      (1) Its Recipients shall ensure that this Notice is
 *      reproduced upon any copies or amended versions of it;
 *  
 *      (2) Any amended version of it shall be clearly marked to
 *      show both the nature of and the organisation responsible
 *      for the relevant amendment or amendments;
 *  
 *      (3) Its onward transfer from a recipient to another
 *      party shall be deemed to be that party's acceptance of
 *      these conditions;
 *  
 *      (4) DERA gives no warranty or assurance as to its
 *      quality or suitability for any purpose and DERA accepts
 *      no liability whatsoever in relation to any use to which
 *      it may be put.
 *
 * $TenDRA: tendra/src/utilities/lexi/lexer.h,v 1.4 2003/05/13 02:31:57 nonce Exp $
 */

/*
 *    AUTOMATICALLY GENERATED BY lexi VERSION 1.2
 */


/* LOOKUP TABLE */

typedef unsigned char lookup_type;

static lookup_type lookup_tab [257] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x01, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
    0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x0a,
    0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
    0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00
};

#ifndef LEX_EOF
#define LEX_EOF			256
#endif

#define lookup_char(C)	(lookup_tab [ (C) ])
#define is_white(T)		((T) & 0x01)
#define is_alpha(T)		((T) & 0x02)
#define is_digit(T)		((T) & 0x04)
#define is_alphanum(T)	((T) & 0x08)

/*#ifndef PROTO_Z
#ifdef __STDC__
#define PROTO_Z()		(void)
#else
#define PROTO_Z()		()
#endif
#endif*/


/* MAIN PASS ANALYSER */

int
read_token()
{
    start : {
		lookup_type t0;
		int c0 = read_char ();
		t0 = lookup_char (c0);
		if (is_white (t0)) goto start;
		switch (c0) {
	    case '"' : {
			return (get_string (c0));
	    }
	    case '$' : {
			int t1, c1;
			c1 = read_char ();
			t1 = lookup_char (c1);
			if (is_alpha (t1)) {
				return (get_sid_ident (c0, c1));
			}
			unread_char (c1);
			break;
	    }
	    case '(' : {
			return (lex_open);
	    }
	    case ')' : {
			return (lex_close);
	    }
	    case '+' : {
			return (lex_plus);
	    }
	    case '-' : {
			int c1 = read_char ();
			if (c1 == '>') {
				return (lex_arrow);
			}
			unread_char (c1);
			break;
	    }
	    case '/' : {
			int c1 = read_char ();
			if (c1 == '*') {
				return (get_comment (c0, c1));
			}
			unread_char (c1);
			break;
	    }
	    case ';' : {
			return (lex_semicolon);
	    }
	    case '=' : {
			return (lex_equal);
	    }
	    case '{' : {
			int c1 = read_char ();
			if (c1 == '0') {
				int c2 = read_char ();
				if (c2 == '-') {
					int c3 = read_char ();
					if (c3 == '9') {
						int c4 = read_char ();
						if (c4 == '}') {
							return (lex_digit);
						}
						unread_char (c4);
					}
					unread_char (c3);
				}
				unread_char (c2);
			} else if (c1 == 'A') {
				int c2 = read_char ();
				if (c2 == '-') {
					int c3 = read_char ();
					if (c3 == 'Z') {
						int c4 = read_char ();
						if (c4 == '}') {
							return (lex_upper);
						}
						unread_char (c4);
					}
					unread_char (c3);
				}
				unread_char (c2);
			} else if (c1 == 'a') {
				int c2 = read_char ();
				if (c2 == '-') {
					int c3 = read_char ();
					if (c3 == 'z') {
						int c4 = read_char ();
						if (c4 == '}') {
							return (lex_lower);
						}
						unread_char (c4);
					}
					unread_char (c3);
				}
				unread_char (c2);
			}
			unread_char (c1);
			return (lex_open_Hbrace);
	    }
	    case '}' : {
			return (lex_close_Hbrace);
	    }
	    case LEX_EOF : {
			return (lex_eof);
	    }
		}
		if (is_alpha (t0)) {
			return (get_identifier (c0));
		}
		return (unknown_token (c0));
    }
}
