/*
 * Copyright (c) 2002, The Tendra Project <http://www.tendra.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *    		 Crown Copyright (c) 1997
 *    
 *    This TenDRA(r) Computer Program is subject to Copyright
 *    owned by the United Kingdom Secretary of State for Defence
 *    acting through the Defence Evaluation and Research Agency
 *    (DERA).  It is made available to Recipients with a
 *    royalty-free licence for its use, reproduction, transfer
 *    to other parties and amendment for any purpose not excluding
 *    product development provided that any such use et cetera
 *    shall be deemed to be acceptance of the following conditions:-
 *    
 *        (1) Its Recipients shall ensure that this Notice is
 *        reproduced upon any copies or amended versions of it;
 *    
 *        (2) Any amended version of it shall be clearly marked to
 *        show both the nature of and the organisation responsible
 *        for the relevant amendment or amendments;
 *    
 *        (3) Its onward transfer from a recipient to another
 *        party shall be deemed to be that party's acceptance of
 *        these conditions;
 *    
 *        (4) DERA gives no warranty or assurance as to its
 *        quality or suitability for any purpose and DERA accepts
 *        no liability whatsoever in relation to any use to which
 *        it may be put.
 *
 * $TenDRA: tendra/src/tools/disp/sort.h,v 1.2 2002/11/21 22:31:22 nonce Exp $
 */


#ifndef SORT_INCLUDED
#define SORT_INCLUDED


/*
 *    AUXILIARY TDF SORT DECODING ROUTINES
 *
 *    Each TDF sort has an associated decoding routine.  Most of the
 *    routines are straightforward, and so have been automatically
 *    generated directly from the TDF specification.  This module deals
 *    with the few tricky cases.
 */

extern object *de_token_aux(sortname, char *) ;
extern void de_tdfstring_format(void) ;
extern void de_make_label(long) ;
void de_case_fn(char *, char *, char *) ;
void de_mk_proc_fn(char *, char *, char *, char *) ;
void de_solve_fn(char *, char *, char *, char *, int) ;
extern int warn_undeclared;

#define de_case(X)		de_case_fn (X, "bx", "ss")
#define de_labelled(X)	de_solve_fn (X, "l", "x", "x", 1)
#define de_sequence(X)	format (VERT_BRACKETS, "sequence", "+[x]")
#define de_make_proc(X)	de_mk_proc_fn (X, "S", "S?[u]t", "?[t?[u]]x")
#define de_make_string(X)	de_tdfstring_format ();

#define de_make_nat(X)\
	char *num = tdf_int_str () ;\
	out_signed (num, 0)

#define de_make_signed_nat(X)\
	long neg = tdf_bool () ;\
	char *num = tdf_int_str () ;\
	out_signed (num, (int) neg)


#endif
