/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-user-set-presence.h:
 * Dialog for the Presence() method on
 * [...].Telepathy.Connection.Interface.SimplePresence interface.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_USER_PRESENCE_H__
#define __TI_DLG_USER_PRESENCE_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgUserPresence TIDlgUserPresence;
typedef struct _TIDlgUserPresenceClass TIDlgUserPresenceClass;

#define TI_TYPE_DLG_USER_PRESENCE               ti_dlg_user_presence_get_type()
#define TI_DLG_USER_PRESENCE(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_USER_PRESENCE, TIDlgUserPresence))
#define TI_DLG_USER_PRESENCE_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_USER_PRESENCE, TIDlgUserPresenceClass))
#define TI_IS_DLG_USER_PRESENCE(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_USER_PRESENCE))
#define TI_IS_DLG_USER_PRESENCE_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_USER_PRESENCE))
#define TI_DLG_USER_PRESENCE_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_USER_PRESENCE, TIDlgUserPresenceClass))

struct _TIDlgUserPresence
{
    GObject parent;
};

struct _TIDlgUserPresenceClass
{
    GObjectClass parent;
};

GType ti_dlg_user_presence_get_type (void);

TIDlgUserPresence *ti_dlg_user_presence_new (GtkWindow *parent,
    GtkTreeModel *tree_model, guint column);

/**
 * Shows the "Set Presence" dialog.
 *
 * @param status Chosen status. Must be freed after use.
 * @param message Chosen message. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_user_presence_run (TIDlgUserPresence *dlg_user_presence,
    gchar **status, gchar **message);

#endif
