/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-request-conn.h:
 * Request Connection Dialog
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_REQUEST_CONN_H__
#define __TI_DLG_REQUEST_CONN_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgRequestConn TIDlgRequestConn;
typedef struct _TIDlgRequestConnClass TIDlgRequestConnClass;

#define TI_TYPE_DLG_REQUEST_CONN               ti_dlg_request_conn_get_type()
#define TI_DLG_REQUEST_CONN(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_REQUEST_CONN, TIDlgRequestConn))
#define TI_DLG_REQUEST_CONN_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_REQUEST_CONN, TIDlgRequestConnClass))
#define TI_IS_DLG_REQUEST_CONN(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_REQUEST_CONN))
#define TI_IS_DLG_REQUEST_CONN_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_REQUEST_CONN))
#define TI_DLG_REQUEST_CONN_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_REQUEST_CONN, TIDlgRequestConnClass))

struct _TIDlgRequestConn {
  GObject parent;
  /* instance members */
};

struct _TIDlgRequestConnClass {
  GObjectClass parent;
  /* class members */
};

GType ti_dlg_request_conn_get_type (void);

TIDlgRequestConn *ti_dlg_request_conn_new (GtkWindow *parent);

/**
 * Shows the Request Connetion dialog.
 *
 * The strings that receives the parameters must be freed after use.
 *
 * @param (in) tree_model Parameter descriptions. It should have four columns, with each row
               describing a parameter according to the following format:
               (name, flags, type signature, default value) - All being regular strings (G_TYPE_STRING).
 * @param (out) param_values Will be set to a hashtable mapping a parameter name (a string) with its value (a GValue).
                             Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_request_conn_run (TIDlgRequestConn *dlg_request_conn,
    const gchar *protocol_name, GtkTreeModel *tree_model,
    GHashTable **param_values);

#endif
