/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-about.c:
 * Classical About Dialog
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "config.h"

#include "dlg-about.h"

#include <glade/glade.h>

#include "about.h"

G_DEFINE_TYPE (TIDlgAbout, ti_dlg_about, G_TYPE_OBJECT);

struct _TIDlgAboutPrivate {
    gboolean disposed;

    GtkWindow *parent;

    GtkWidget *dialog;
};


static void _ti_dlg_about_setup (TIDlgAbout *dlg_about);

static void
ti_dlg_about_dispose (GObject *object)
{
  TIDlgAbout *self = TI_DLG_ABOUT (object);

  if (self->priv->disposed)
    return;

  self->priv->disposed = TRUE;

  G_OBJECT_CLASS (ti_dlg_about_parent_class)->dispose (object);
}

static void
ti_dlg_about_class_init (TIDlgAboutClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->dispose = ti_dlg_about_dispose;
  g_type_class_add_private (klass, sizeof (TIDlgAboutPrivate));
}

static void
ti_dlg_about_init (TIDlgAbout *self)
{
  self->priv = G_TYPE_INSTANCE_GET_PRIVATE (self, TI_TYPE_DLG_ABOUT,
      TIDlgAboutPrivate);
  self->priv->disposed = FALSE;
}

TIDlgAbout *
ti_dlg_about_new (GtkWindow *parent)
{
  TIDlgAbout *self = NULL;
  gchar *glade_file_path = NULL;

  self = g_object_new (TI_TYPE_DLG_ABOUT, NULL);

  self->priv->parent = parent;

  self->priv->dialog = gtk_about_dialog_new ();
  g_assert (GTK_IS_DIALOG (self->priv->dialog));

  gtk_window_set_transient_for (GTK_WINDOW (self->priv->dialog), parent);
  gtk_window_set_position (GTK_WINDOW (self->priv->dialog),
      GTK_WIN_POS_CENTER_ON_PARENT);

  _ti_dlg_about_setup (self);

  g_free (glade_file_path);

  return self;
}

void
ti_dlg_about_run (TIDlgAbout *self)
{
  gtk_widget_show_all (self->priv->dialog);
  gtk_dialog_run (GTK_DIALOG (self->priv->dialog));
  gtk_widget_hide_all (self->priv->dialog);
}

static void
_ti_dlg_about_setup (TIDlgAbout *self)
{
  GtkAboutDialog *dialog = GTK_ABOUT_DIALOG (self->priv->dialog);

  gtk_about_dialog_set_version (dialog, VERSION);
  gtk_about_dialog_set_copyright (dialog, ti_about_copyright);
  gtk_about_dialog_set_license (dialog, ti_about_license);
  gtk_about_dialog_set_authors (dialog, ti_about_authors);

  gtk_about_dialog_set_comments (dialog, ti_about_comments);

  gtk_about_dialog_set_website (dialog, ti_about_website);
}
